/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.validation.client.impl;

import com.google.gwt.validation.client.impl.NodeImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.validation.Path;

public final class PathImpl
implements Path,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Path.Node> nodes = new ArrayList<Path.Node>();

    public PathImpl() {
        this.nodes.add(NodeImpl.ROOT_NODE);
    }

    private PathImpl(PathImpl originalPath, Path.Node node) {
        if (!originalPath.isRoot()) {
            this.nodes.addAll(originalPath.nodes);
        }
        this.nodes.add(node);
    }

    private PathImpl(List<Path.Node> nodes) {
        this.nodes.addAll(nodes);
    }

    public PathImpl append(String name) {
        return new PathImpl(this, NodeImpl.createNode(name));
    }

    public PathImpl appendIndex(String name, int index) {
        return new PathImpl(this, NodeImpl.createIndexedNode(name, index));
    }

    public PathImpl appendIterable(String name) {
        return new PathImpl(this, NodeImpl.createIterableNode(name));
    }

    public PathImpl appendKey(String name, Object key) {
        return new PathImpl(this, NodeImpl.createKeyedNode(name, key));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PathImpl)) {
            return false;
        }
        PathImpl that = (PathImpl)obj;
        return this.nodes.equals(that.nodes);
    }

    public Path.Node getLeafNode() {
        return this.nodes.get(this.nodes.size() - 1);
    }

    public PathImpl getPathWithoutLeafNode() {
        ArrayList<Path.Node> nodesCopy = new ArrayList<Path.Node>(this.nodes);
        PathImpl path = this;
        if (!nodesCopy.isEmpty()) {
            nodesCopy.remove(nodesCopy.size() - 1);
            path = new PathImpl(nodesCopy);
        }
        return path;
    }

    public int hashCode() {
        return this.nodes.hashCode();
    }

    public Iterator<Path.Node> iterator() {
        return this.nodes.iterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Path.Node n : this.nodes) {
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(n);
        }
        return sb.toString();
    }

    private boolean isRoot() {
        return this.nodes.size() == 1 && this.nodes.get(0) == NodeImpl.ROOT_NODE;
    }
}

