/*
 * Decompiled with CFR 0.152.
 */
package biweekly.util;

import java.util.Collection;

public final class StringUtils {
    public static final String NEWLINE = System.getProperty("line.separator");

    public static String afterPrefixIgnoreCase(String string, String prefix) {
        if (string.length() < prefix.length()) {
            return null;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            char b;
            char a = Character.toUpperCase(prefix.charAt(i));
            if (a == (b = Character.toUpperCase(string.charAt(i)))) continue;
            return null;
        }
        return string.substring(prefix.length());
    }

    public static void repeat(char c, int count, StringBuilder sb) {
        for (int i = 0; i < count; ++i) {
            sb.append(c);
        }
    }

    public static <T> String join(Collection<T> collection, String delimiter) {
        StringBuilder sb = new StringBuilder();
        StringUtils.join(collection, delimiter, sb);
        return sb.toString();
    }

    public static <T> void join(Collection<T> collection, String delimiter, StringBuilder sb) {
        StringUtils.join(collection, delimiter, sb, new JoinCallback<T>(){

            @Override
            public void handle(StringBuilder sb, T value) {
                sb.append(value);
            }
        });
    }

    public static <T> String join(Collection<T> collection, String delimiter, JoinCallback<T> join) {
        StringBuilder sb = new StringBuilder();
        StringUtils.join(collection, delimiter, sb, join);
        return sb.toString();
    }

    public static <T> void join(Collection<T> collection, String delimiter, StringBuilder sb, JoinCallback<T> join) {
        boolean first = true;
        for (T element : collection) {
            if (!first) {
                sb.append(delimiter);
            }
            join.handle(sb, element);
            first = false;
        }
    }

    private StringUtils() {
    }

    public static interface JoinCallback<T> {
        public void handle(StringBuilder var1, T var2);
    }
}

