/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.curricula;

import java.util.Collection;
import java.util.Hashtable;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;
import org.unitime.timetable.model.CurriculumProjectionRule;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.solver.curricula.LastLikeStudentCourseDemands;

public class ProjectedStudentCourseDemands
extends LastLikeStudentCourseDemands {
    private Hashtable<String, Hashtable<String, Hashtable<String, Float>>> iAreaClasfMajor2Proj = new Hashtable();

    public ProjectedStudentCourseDemands(DataProperties properties) {
        super(properties);
    }

    @Override
    public void init(org.hibernate.Session hibSession, Progress progress, Session session, Collection<InstructionalOffering> offerings) {
        super.init(hibSession, progress, session, offerings);
        progress.setPhase("Loading curriculum projections", 1L);
        for (CurriculumProjectionRule rule : hibSession.createQuery("select r from CurriculumProjectionRule r where r.academicArea.session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).setCacheable(true).list()) {
            Hashtable<String, Float> major2proj;
            String areaAbbv = rule.getAcademicArea().getAcademicAreaAbbreviation();
            String majorCode = rule.getMajor() == null ? "" : rule.getMajor().getCode();
            String clasfCode = rule.getAcademicClassification().getCode();
            Float projection = rule.getProjection();
            Hashtable<String, Hashtable<String, Float>> clasf2major2proj = this.iAreaClasfMajor2Proj.get(areaAbbv);
            if (clasf2major2proj == null) {
                clasf2major2proj = new Hashtable();
                this.iAreaClasfMajor2Proj.put(areaAbbv, clasf2major2proj);
            }
            if ((major2proj = clasf2major2proj.get(clasfCode)) == null) {
                major2proj = new Hashtable();
                clasf2major2proj.put(clasfCode, major2proj);
            }
            major2proj.put(majorCode, projection);
        }
        progress.incProgress();
    }

    @Override
    public float getProjection(String areaAbbv, String clasfCode, String majorCode) {
        Float projection;
        Hashtable<String, Float> major2proj;
        Hashtable<String, Hashtable<String, Float>> clasf2major2proj;
        if (this.iAreaClasfMajor2Proj.isEmpty()) {
            return 1.0f;
        }
        Hashtable<String, Hashtable<String, Float>> hashtable = clasf2major2proj = areaAbbv == null ? null : this.iAreaClasfMajor2Proj.get(areaAbbv);
        if (clasf2major2proj == null || clasf2major2proj.isEmpty()) {
            return 1.0f;
        }
        Hashtable<String, Float> hashtable2 = major2proj = clasfCode == null ? null : clasf2major2proj.get(clasfCode);
        if (major2proj == null) {
            return 1.0f;
        }
        Float f = projection = majorCode == null ? null : major2proj.get(majorCode);
        if (projection == null) {
            projection = major2proj.get("");
        }
        return projection == null ? 1.0f : projection.floatValue();
    }
}

