/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.pointintimedata;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.TreeSet;
import org.hibernate.Session;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.PitClass;
import org.unitime.timetable.model.PointInTimeData;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.reports.pointintimedata.WSCHByDayOfWeekAndHourOfDay;

public class WSCHByDepartmentDayOfWeekHourOfDay
extends WSCHByDayOfWeekAndHourOfDay {
    TreeSet<Department> depts = new TreeSet();

    @Override
    public String reportName() {
        return MSG.wseByDeptDayOfWeekAndHourOfDayReport();
    }

    @Override
    public String reportDescription() {
        return MSG.wseByDeptDayOfWeekAndHourOfDayReportNote();
    }

    @Override
    protected void intializeHeader() {
        ArrayList<String> hdr = new ArrayList<String>();
        hdr.add(MSG.columnDepartmentCode());
        hdr.add(MSG.columnDepartmentAbbreviation());
        hdr.add(MSG.columnDepartmentName());
        hdr.add(MSG.columnDayOfWeek());
        this.addTimeColumns(hdr);
        this.setHeader(hdr);
    }

    @Override
    public void createRoomUtilizationReportFor(PointInTimeData pointInTimeData, Session hibSession) {
        this.calculatePeriodsWithEnrollments(pointInTimeData, hibSession);
        int minute = this.startOnHalfHour ? 30 : 0;
        for (Department department : this.depts) {
            for (int dayOfWeek = 1; dayOfWeek < 8; ++dayOfWeek) {
                ArrayList<String> row = new ArrayList<String>();
                row.add(department.getDeptCode());
                row.add(department.getAbbreviation());
                row.add(department.getName());
                row.add(this.getDayOfWeekLabel(this.periodDayOfWeek(dayOfWeek)));
                for (int hourOfDay = 0; hourOfDay < 24; ++hourOfDay) {
                    String key = this.getPeriodTag(department.getUniqueId().toString(), dayOfWeek, hourOfDay, minute);
                    row.add(this.periodEnrollmentMap.get(key) == null ? "0" : "" + ((WSCHByDayOfWeekAndHourOfDay.PeriodEnrollment)this.periodEnrollmentMap.get(key)).getWeeklyStudentEnrollment());
                }
                this.addDataRow(row);
            }
        }
    }

    private void calculatePeriodsWithEnrollments(PointInTimeData pointInTimeData, Session hibSession) {
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct pco.subjectArea.department, pc").append("\tfrom PitClass pc").append(" inner join pc.pitClassEvents as pce").append(" inner join pce.pitClassMeetings as pcm").append(" inner join pcm.pitClassMeetingUtilPeriods as pcmup").append("\tinner join pc.pitSchedulingSubpart.pitInstrOfferingConfig.pitInstructionalOffering.pitCourseOfferings as pco").append("\twhere pc.pitSchedulingSubpart.pitInstrOfferingConfig.pitInstructionalOffering.pointInTimeData.uniqueId = :sessId").append(" and pco.subjectArea.uniqueId = :saId").append("\tand pco.isControl = true").append(" and  pc.pitSchedulingSubpart.itype.organized = true");
        HashSet<Long> processedClasses = new HashSet<Long>();
        for (SubjectArea subjectArea : pointInTimeData.getSession().getSubjectAreas()) {
            for (Object[] result : hibSession.createQuery(sb.toString()).setLong("sessId", pointInTimeData.getUniqueId().longValue()).setLong("saId", subjectArea.getUniqueId().longValue()).setCacheable(true).list()) {
                Department department = (Department)result[0];
                PitClass pc = (PitClass)result[1];
                if (processedClasses.contains(pc.getUniqueId())) continue;
                processedClasses.add(pc.getUniqueId());
                this.depts.add(department);
                for (Date meetingPeriod : pc.getUniquePeriods()) {
                    String label = this.getPeriodTag(department.getUniqueId().toString(), meetingPeriod);
                    WSCHByDayOfWeekAndHourOfDay.PeriodEnrollment pe = (WSCHByDayOfWeekAndHourOfDay.PeriodEnrollment)this.periodEnrollmentMap.get(label);
                    if (pe == null) {
                        pe = new WSCHByDayOfWeekAndHourOfDay.PeriodEnrollment(label, this.getStandardMinutesInReportingHour(), this.getStandardWeeksInReportingTerm());
                        this.periodEnrollmentMap.put(label, pe);
                    }
                    pe.addEnrollment(pc.getEnrollment());
                }
            }
        }
    }
}

