/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.unitime.timetable.reports.CsvReportWriter;
import org.unitime.timetable.reports.PdfLegacyReport;
import org.unitime.timetable.reports.PdfReportWriter;
import org.unitime.timetable.reports.ReportWriter;
import org.unitime.timetable.reports.XlsReportWriter;

public abstract class AbstractReport
implements ReportWriter.Listener {
    protected ReportWriter iWriter;
    protected Mode iMode;
    protected static Cell NULL = new Cell("").withColSpan(0).withSeparator("");

    public AbstractReport(Mode mode, OutputStream out, String title, String title2, String subject, String session) throws IOException, DocumentException {
        this.iMode = mode;
        switch (mode) {
            case LegacyPdfLetter: {
                this.iWriter = new PdfLegacyReport(0, out, title, title2, subject, session);
                break;
            }
            case LegacyPdfLedger: {
                this.iWriter = new PdfLegacyReport(1, out, title, title2, subject, session);
                break;
            }
            case LegacyText: {
                this.iWriter = new PdfLegacyReport(2, out, title, title2, subject, session);
                break;
            }
            case CSV: {
                this.iWriter = new CsvReportWriter(out, title, title2, subject, session);
                break;
            }
            case PDF: {
                this.iWriter = new PdfReportWriter(out, title, title2, subject, session);
                break;
            }
            case XLS: {
                this.iWriter = new XlsReportWriter(out, title, title2, subject, session);
            }
        }
        this.iWriter.setListener(this);
    }

    public AbstractReport(int mode, File file, String title, String title2, String subject, String session) throws IOException, DocumentException {
        this(Mode.values()[mode], new FileOutputStream(file), title, title2, subject, session);
    }

    public ReportWriter getWriter() {
        return this.iWriter;
    }

    protected void setFooter(String footer) {
        this.getWriter().setFooter(footer);
    }

    protected void setHeaderLine(Line ... line) {
        this.getWriter().setHeader(line);
    }

    protected Line[] getHeader() {
        return this.getWriter().getHeader();
    }

    protected void setPageName(String pageName) {
        this.getWriter().setPageName(pageName);
    }

    protected void setCont(String cont) {
        this.getWriter().setCont(cont);
    }

    protected Cell lpad(String s, int len) {
        return new Cell(s, Alignment.Right, len);
    }

    protected Cell lpad(String s, char c, int len) {
        return new Cell(s, Alignment.Right, len).withPadding(c);
    }

    protected Cell mpad(String s, int len) {
        return new Cell(s, Alignment.Center, len);
    }

    protected Cell mpad(String s, char c, int len) {
        return new Cell(s, Alignment.Center, len).withPadding(c);
    }

    protected Cell rpad(String s, int len) {
        return new Cell(s, Alignment.Left, len);
    }

    protected Cell rpad(String s, char c, int len) {
        return new Cell(s, Alignment.Left, len).withPadding(c);
    }

    protected Cell rpad(Cell c, int len) {
        return new Cell(c).withAlignment(Alignment.Left).withLength(len);
    }

    public void printHeader() throws DocumentException {
        this.printHeader(true);
    }

    public void printHeader(boolean newPage) throws DocumentException {
        this.getWriter().printHeader(newPage);
    }

    @Override
    public void headerPrinted() {
    }

    protected void newPage() throws DocumentException {
        this.getWriter().newPage();
    }

    public void lastPage() throws DocumentException {
        this.getWriter().lastPage();
    }

    public void open(File file) throws DocumentException, IOException {
        this.open(new FileOutputStream(file));
    }

    public void open(OutputStream out) throws DocumentException, IOException {
        this.getWriter().open(out);
    }

    public void close() throws IOException, DocumentException {
        this.getWriter().close();
    }

    protected int getLineNumber() {
        return this.getWriter().getLineNumber();
    }

    protected int getNrLinesPerPage() {
        return this.getWriter().getNrLinesPerPage();
    }

    protected int getNrCharsPerLine() {
        return this.getWriter().getNrCharsPerLine();
    }

    protected int getSeparatorNrLines() {
        return this.getWriter().getSeparatorNrLines();
    }

    protected boolean isSkipRepeating() {
        return this.getWriter().isSkipRepeating();
    }

    public static String getExtension(Mode mode) {
        switch (mode) {
            case LegacyPdfLetter: 
            case LegacyPdfLedger: 
            case PDF: {
                return ".pdf";
            }
            case LegacyText: {
                return ".txt";
            }
            case CSV: {
                return ".csv";
            }
            case XLS: {
                return ".xls";
            }
        }
        return ".pdf";
    }

    public static String getExtension(int mode) {
        return AbstractReport.getExtension(Mode.values()[mode]);
    }

    public String getExtension() {
        return AbstractReport.getExtension(this.iMode);
    }

    protected void println() throws DocumentException {
        this.printLine(new Line());
    }

    protected void printSeparator(Cell ... cells) throws DocumentException {
        if (cells.length == 0) {
            this.getWriter().printSeparator(null);
        } else {
            this.getWriter().printSeparator(new Line(cells));
        }
    }

    protected void println(Line ... line) throws DocumentException {
        if (line.length == 0) {
            this.printLine(null);
        } else if (line.length == 1) {
            this.printLine(line[0]);
        } else {
            this.printLine(new Line(line));
        }
    }

    protected void println(Cell ... cells) throws DocumentException {
        this.printLine(new Line(cells));
    }

    protected void printLine(Line line) throws DocumentException {
        this.getWriter().printLine(line);
    }

    protected static class Line {
        private Cell[] iCells;
        private Line[] iLines;
        private String iLineSeparator = "| ";
        private Alignment iAlignment = Alignment.Left;
        private int iLength = 0;

        public Line() {
            this.iCells = new Cell[0];
        }

        public Line(Cell ... cells) {
            this.iCells = cells;
            if (this.iCells.length == 1) {
                this.iAlignment = this.iCells[0].getAlignment();
            }
        }

        public Line(String ... cells) {
            this.iCells = new Cell[cells.length];
            for (int i = 0; i < cells.length; ++i) {
                this.iCells[i] = new Cell(cells[i].trim(), Alignment.Left, cells[i].length());
            }
        }

        public Line(Line ... lines) {
            this.iLines = lines;
        }

        public boolean isEmpty() {
            if (this.iCells != null) {
                for (Cell cell : this.iCells) {
                    if (cell.isEmpty()) continue;
                    return false;
                }
            }
            if (this.iLines != null) {
                for (Line line : this.iLines) {
                    if (line.isEmpty()) continue;
                    return false;
                }
            }
            return true;
        }

        public Cell[] getCells() {
            return this.iCells;
        }

        public Line[] getLines() {
            return this.iLines;
        }

        public String getLineSeparator() {
            return this.iLineSeparator;
        }

        public Line withLineSeparator(String sep) {
            this.iLineSeparator = sep;
            return this;
        }

        public int getLength() {
            return this.iLength;
        }

        public Alignment getAlignment() {
            return this.iAlignment;
        }

        public Line withAlignment(Alignment alignment) {
            this.iAlignment = alignment;
            return this;
        }

        public Line withLength(int length) {
            this.iLength = length;
            return this;
        }

        public String render() {
            if (this.getLines() != null) {
                StringBuffer ret = new StringBuffer();
                for (int i = 0; i < this.getLines().length; ++i) {
                    if (i > 0) {
                        ret.append(this.getLines()[i - 1].getLineSeparator());
                    }
                    ret.append(this.getLines()[i].render());
                }
                if (this.getLength() > 0) {
                    switch (this.getAlignment()) {
                        case Left: {
                            return Cell.rpad(ret.toString(), this.getLength());
                        }
                        case Right: {
                            return Cell.lpad(ret.toString(), this.getLength());
                        }
                        case Center: {
                            return Cell.mpad(ret.toString(), this.getLength());
                        }
                    }
                    return Cell.rpad(ret.toString(), this.getLength());
                }
                return ret.toString();
            }
            if (this.getCells() != null) {
                StringBuffer ret = new StringBuffer();
                for (int i = 0; i < this.getCells().length; ++i) {
                    if (i > 0) {
                        ret.append(this.getCells()[i - 1].getCellSeparator());
                    }
                    ret.append(this.getCells()[i].render());
                }
                if (this.getLength() > 0) {
                    switch (this.getAlignment()) {
                        case Left: {
                            return Cell.rpad(ret.toString(), this.getLength());
                        }
                        case Right: {
                            return Cell.lpad(ret.toString(), this.getLength());
                        }
                        case Center: {
                            return Cell.mpad(ret.toString(), this.getLength());
                        }
                    }
                    return Cell.rpad(ret.toString(), this.getLength());
                }
                return ret.toString();
            }
            return "";
        }

        public String toString() {
            return this.render();
        }
    }

    protected static class Cell {
        private String iText;
        private Alignment iAlignment;
        private int iLength = 0;
        private int iColSpan = 1;
        private char iPadding = (char)32;
        private Cell[] iCells = null;
        private String iCellSeparator = " ";

        public Cell(String text, Alignment alignment, int length) {
            this.iText = text;
            this.iAlignment = alignment;
            this.iLength = length;
        }

        public Cell(String text) {
            this(text, Alignment.Left, text.length());
        }

        public Cell(Cell ... cells) {
            this.iCells = cells;
            this.iAlignment = Alignment.Left;
        }

        public boolean isEmpty() {
            if (this.iText != null && !this.iText.isEmpty()) {
                return false;
            }
            if (this.iCells != null) {
                for (Cell cell : this.iCells) {
                    if (cell.isEmpty()) continue;
                    return false;
                }
            }
            return true;
        }

        public String getText() {
            return this.iText;
        }

        public Cell[] getCells() {
            return this.iCells;
        }

        public int getLength() {
            return this.iLength;
        }

        public int getColSpan() {
            return this.iColSpan;
        }

        public Alignment getAlignment() {
            return this.iAlignment;
        }

        public char getPadding() {
            return this.iPadding;
        }

        public String getCellSeparator() {
            return this.iCellSeparator;
        }

        public Cell withAlignment(Alignment alignment) {
            this.iAlignment = alignment;
            return this;
        }

        public Cell withLength(int length) {
            this.iLength = length;
            return this;
        }

        public Cell withColSpan(int colSpan) {
            this.iColSpan = colSpan;
            return this;
        }

        public Cell withPadding(char padding) {
            this.iPadding = padding;
            return this;
        }

        public Cell withSeparator(String separator) {
            this.iCellSeparator = separator;
            return this;
        }

        public String render() {
            StringBuffer ret = new StringBuffer();
            StringBuffer text = new StringBuffer();
            if (this.getText() != null) {
                text.append(this.getText());
            }
            if (this.getCells() != null) {
                if (this.getText() != null) {
                    text.append(this.getCellSeparator());
                }
                for (int i = 0; i < this.getCells().length; ++i) {
                    if (i > 0) {
                        text.append(this.getCells()[i - 1].getCellSeparator());
                    }
                    text.append(this.getCells()[i].render());
                }
            }
            if (this.getLength() > 0) {
                switch (this.getAlignment()) {
                    case Left: {
                        ret.append(Cell.rpad(text.toString(), this.getPadding(), this.getLength()));
                        break;
                    }
                    case Right: {
                        ret.append(Cell.lpad(text.toString(), this.getPadding(), this.getLength()));
                        break;
                    }
                    case Center: {
                        ret.append(Cell.mpad(text.toString(), this.getPadding(), this.getLength()));
                        break;
                    }
                    default: {
                        ret.append(Cell.rpad(text.toString(), this.getPadding(), this.getLength()));
                        break;
                    }
                }
            } else {
                ret.append(text.toString());
            }
            return ret.toString();
        }

        public String toString() {
            return this.render();
        }

        public boolean equals(Object o) {
            return this.toString().equals(o.toString());
        }

        public static String lpad(String s, char ch, int len) {
            if (s == null) {
                s = "";
            }
            if (s.length() > len) {
                return s.substring(0, len);
            }
            while (s.length() < len) {
                s = ch + s;
            }
            return s;
        }

        public static String lpad(String s, int len) {
            if (s == null) {
                s = "";
            }
            if (s.length() > len) {
                return s.substring(0, len);
            }
            return Cell.lpad(s, ' ', len);
        }

        protected static String rpad(String s, char ch, int len) {
            if (s == null) {
                s = "";
            }
            if (s.length() > len) {
                return s.substring(0, len);
            }
            while (s.length() < len) {
                s = s + ch;
            }
            return s;
        }

        public static String rpad(String s, int len) {
            if (s == null) {
                s = "";
            }
            if (s.length() > len) {
                return s.substring(0, len);
            }
            return Cell.rpad(s, ' ', len);
        }

        protected static String mpad(String s, char ch, int len) {
            if (s == null) {
                s = "";
            }
            if (s.length() > len) {
                return s.substring(0, len);
            }
            while (s.length() < len) {
                if (s.length() % 2 == 0) {
                    s = s + ch;
                    continue;
                }
                s = ch + s;
            }
            return s;
        }

        public static String mpad(String s, int len) {
            return Cell.mpad(s, ' ', len);
        }

        protected static String mpad(String s1, String s2, char ch, int len) {
            String m = "";
            while ((s1 + m + s2).length() < len) {
                m = m + ch;
            }
            return s1 + m + s2;
        }
    }

    protected static enum Alignment {
        Left,
        Center,
        Right;

    }

    public static enum Mode {
        LegacyPdfLetter,
        LegacyPdfLedger,
        LegacyText,
        CSV,
        PDF,
        XLS;

    }
}

