/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.cpsolver.studentsct.constraint.LinkedSections;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Subpart;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.onlinesectioning.model.XDistributionType;

@SerializeWith(value=XDistributionSerializer.class)
public class XDistribution
implements Serializable,
Externalizable {
    private static final long serialVersionUID = 1L;
    private Long iDistributionId = null;
    private int iVariant = 0;
    private XDistributionType iType = null;
    private Set<Long> iOfferingIds = new HashSet<Long>();
    private Set<Long> iSectionIds = new HashSet<Long>();

    public XDistribution() {
    }

    public XDistribution(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XDistribution(XDistributionType type, Long id, int variant, Collection<Class_> sections) {
        this.iType = type;
        this.iDistributionId = id;
        this.iVariant = variant;
        for (Class_ clazz : sections) {
            this.iOfferingIds.add(clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getUniqueId());
            this.iSectionIds.add(clazz.getUniqueId());
        }
    }

    public XDistribution(XDistributionType type, Long id, Long offeringId, Collection<Long> sectionIds) {
        this.iType = type;
        this.iDistributionId = id;
        this.iVariant = 0;
        this.iOfferingIds.add(offeringId);
        this.iSectionIds.addAll(sectionIds);
    }

    public XDistribution(LinkedSections link, long id) {
        this.iType = XDistributionType.LinkedSections;
        this.iDistributionId = -id;
        this.iVariant = 0;
        for (Offering offering : link.getOfferings()) {
            this.iOfferingIds.add(offering.getId());
            for (Subpart subpart : link.getSubparts(offering)) {
                for (Section section : link.getSections(subpart)) {
                    this.iSectionIds.add(section.getId());
                }
            }
        }
    }

    public XDistributionType getDistributionType() {
        return this.iType;
    }

    public Long getDistributionId() {
        return this.iDistributionId;
    }

    public int getVariant() {
        return this.iVariant;
    }

    public Set<Long> getOfferingIds() {
        return this.iOfferingIds;
    }

    public Set<Long> getSectionIds() {
        return this.iSectionIds;
    }

    public boolean hasSection(Long sectionId) {
        return this.iSectionIds.contains(sectionId);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof XDistribution)) {
            return false;
        }
        return this.getDistributionId().equals(((XDistribution)o).getDistributionId());
    }

    public int hashCode() {
        return (int)(this.getDistributionId() ^ this.getDistributionId() >>> 32 ^ (long)this.getVariant());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.iDistributionId = in.readLong();
        this.iVariant = in.readInt();
        this.iType = XDistributionType.values()[in.readInt()];
        int nrOfferings = in.readInt();
        this.iOfferingIds.clear();
        for (int i = 0; i < nrOfferings; ++i) {
            this.iOfferingIds.add(in.readLong());
        }
        int nrSections = in.readInt();
        this.iSectionIds.clear();
        for (int i = 0; i < nrSections; ++i) {
            this.iSectionIds.add(in.readLong());
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.iDistributionId);
        out.writeInt(this.iVariant);
        out.writeInt(this.iType.ordinal());
        out.writeInt(this.iOfferingIds.size());
        for (Long offeringId : this.iOfferingIds) {
            out.writeLong(offeringId);
        }
        out.writeInt(this.iSectionIds.size());
        for (Long sectionId : this.iSectionIds) {
            out.writeLong(sectionId);
        }
    }

    public static class XDistributionSerializer
    implements Externalizer<XDistribution> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, XDistribution object) throws IOException {
            object.writeExternal(output);
        }

        public XDistribution readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new XDistribution(input);
        }
    }
}

