/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.solver;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.solver.PageFilter;
import org.unitime.timetable.gwt.client.solver.SolverCookie;
import org.unitime.timetable.gwt.client.solver.TimetableGrid;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.FilterInterface;
import org.unitime.timetable.gwt.shared.SolverInterface;
import org.unitime.timetable.gwt.shared.TimetableGridInterface;

public class TimetablePage
extends Composite {
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private PageFilter iFilter = new PageFilter();
    private SimplePanel iRootPanel;
    private SimpleForm iPanel;
    private FilterInterface iLastFilter;
    private TimetableGridInterface.TimetableGridResponse iLastResponse;

    public TimetablePage() {
        this.iFilter.getHeader().setCollapsible(SolverCookie.getInstance().isTimeGridFilter());
        this.iFilter.getHeader().addCollapsibleHandler(new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                SolverCookie.getInstance().setTimeGridFilter((Boolean)event.getValue());
            }
        });
        this.iPanel = new SimpleForm(2);
        this.iPanel.removeStyleName("unitime-NotPrintableBottomLine");
        this.iPanel.addRow((Widget)this.iFilter);
        this.iFilter.getFooter().addButton("search", MESSAGES.buttonSearch(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                String token = TimetablePage.this.iFilter.getQuery();
                if (!History.getToken().equals(token)) {
                    History.newItem((String)token, (boolean)false);
                }
                TimetablePage.this.search(null);
            }
        });
        this.iFilter.getFooter().setEnabled("search", false);
        this.iFilter.getFooter().addButton("print", MESSAGES.buttonPrint(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                TimetablePage.this.print();
            }
        });
        this.iFilter.getFooter().setEnabled("print", false);
        this.iFilter.getFooter().addButton("export", MESSAGES.buttonExportPDF(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                TimetablePage.this.exportData("pdf");
            }
        });
        this.iFilter.getFooter().setEnabled("export", false);
        this.iFilter.getFooter().addButton("export-xls", MESSAGES.buttonExportXLS(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                TimetablePage.this.exportData("xls");
            }
        });
        this.iFilter.getFooter().setEnabled("export-xls", false);
        this.iRootPanel = new SimplePanel((Widget)this.iPanel);
        this.iRootPanel.addStyleName("unitime-TimetablePage");
        this.initWidget((Widget)this.iRootPanel);
        this.init();
        History.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                TimetablePage.this.iFilter.setQuery((String)event.getValue(), true);
                if (TimetablePage.this.iPanel.getRowCount() > 1) {
                    TimetablePage.this.search(null);
                }
            }
        });
    }

    protected void init() {
        this.iFilter.getFooter().showLoading();
        RPC.execute(new TimetableGridInterface.TimetableGridFilterRequest(), new AsyncCallback<TimetableGridInterface.TimetableGridFilterResponse>(){

            public void onFailure(Throwable caught) {
                TimetablePage.this.iFilter.getFooter().setErrorMessage(MESSAGES.failedToInitialize(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToInitialize(caught.getMessage()), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(TimetableGridInterface.TimetableGridFilterResponse result) {
                TimetablePage.this.iFilter.getFooter().clearMessage();
                TimetablePage.this.iFilter.setValue(result);
                TimetablePage.this.iFilter.getFooter().setEnabled("search", true);
                TimetablePage.createTriggers();
                if (!TimetablePage.this.iFilter.getHeader().isCollapsible().booleanValue() || "1".equals(Window.Location.getParameter((String)"search"))) {
                    TimetablePage.this.search(null);
                }
            }
        });
    }

    public static native void createTriggers();

    public static void __search() {
        final int left = Window.getScrollLeft();
        final int top = Window.getScrollTop();
        TimetablePage page = (TimetablePage)RootPanel.get((String)"UniTimeGWT:Body").getWidget(0);
        page.search(new AsyncCallback<Boolean>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(Boolean result) {
                if (result.booleanValue()) {
                    Window.scrollTo((int)left, (int)top);
                }
            }
        });
    }

    protected void search(final AsyncCallback<Boolean> callback) {
        final TimetableGridInterface.TimetableGridRequest request = new TimetableGridInterface.TimetableGridRequest();
        request.setFilter(this.iFilter.getValue());
        this.iFilter.getFooter().clearMessage();
        for (int row = this.iPanel.getRowCount() - 1; row > 0; --row) {
            this.iPanel.removeRow(row);
        }
        this.iFilter.getFooter().showLoading();
        this.iFilter.getFooter().setEnabled("search", false);
        LoadingWidget.showLoading(MESSAGES.waitLoadingData());
        RPC.execute(request, new AsyncCallback<TimetableGridInterface.TimetableGridResponse>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.hideLoading();
                TimetablePage.this.iFilter.getFooter().setErrorMessage(MESSAGES.failedToLoadTimetableGrid(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToLoadTimetableGrid(caught.getMessage()), caught);
                TimetablePage.this.iFilter.getFooter().setEnabled("search", true);
                if (callback != null) {
                    callback.onFailure(caught);
                }
            }

            public void onSuccess(TimetableGridInterface.TimetableGridResponse result) {
                LoadingWidget.hideLoading();
                TimetablePage.this.iFilter.getFooter().clearMessage();
                TimetablePage.this.populate(request.getFilter(), result);
                TimetablePage.this.iFilter.getFooter().setEnabled("search", true);
                if (callback != null) {
                    callback.onSuccess((Object)(!result.getModels().isEmpty() ? 1 : 0));
                }
            }
        });
    }

    protected void print() {
        ArrayList<ToolBox.Page> pages = new ArrayList<ToolBox.Page>();
        int index = 0;
        for (final TimetableGridInterface.TimetableGridModel model : this.iLastResponse.getModels()) {
            final TimetableGrid grid = new TimetableGrid(this.iLastFilter, model, index++, 1000, this.iLastResponse.getWeekOffset());
            pages.add(new ToolBox.Page(){

                @Override
                public String getName() {
                    return model.getName();
                }

                @Override
                public String getUser() {
                    return "";
                }

                @Override
                public String getSession() {
                    return "";
                }

                @Override
                public Element getBody() {
                    return grid.getElement();
                }
            });
        }
        ToolBox.print(pages);
    }

    private void exportData(String format) {
        String query = "output=timetable." + format + this.iFilter.getQuery();
        RPC.execute(EventInterface.EncodeQueryRpcRequest.encode(query), new AsyncCallback<EventInterface.EncodeQueryRpcResponse>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(EventInterface.EncodeQueryRpcResponse result) {
                ToolBox.open(GWT.getHostPageBaseURL() + "export?q=" + result.getQuery());
            }
        });
    }

    protected void populate(FilterInterface filter, TimetableGridInterface.TimetableGridResponse response) {
        RootPanel cpm;
        this.iLastFilter = filter;
        this.iLastResponse = response;
        this.iFilter.getFooter().setEnabled("print", false);
        this.iFilter.getFooter().setEnabled("export", false);
        this.iFilter.getFooter().setEnabled("export-xls", false);
        for (int row = this.iPanel.getRowCount() - 1; row > 0; --row) {
            this.iPanel.removeRow(row);
        }
        if (response.getModels().isEmpty()) {
            this.iFilter.getFooter().setMessage(MESSAGES.errorTimetableGridNoDataReturned());
            this.iFilter.getFooter().setEnabled("print", false);
            this.iFilter.getFooter().setEnabled("export", false);
            this.iFilter.getFooter().setEnabled("export-xls", false);
            return;
        }
        UniTimeHeaderPanel header = new UniTimeHeaderPanel(MESSAGES.sectTimetables());
        this.iPanel.addHeaderRow((Widget)header);
        int index = 0;
        int width = ToolBox.getClientWidth() - 20;
        P timetables = new P("timetables");
        timetables.getElement().getStyle().clearOverflow();
        for (TimetableGridInterface.TimetableGridModel model : response.getModels()) {
            timetables.add((Widget)new TimetableGrid(filter, model, index++, width, response.getWeekOffset()));
        }
        ScrollPanel scroll = new ScrollPanel((Widget)timetables);
        scroll.addStyleName("scroll-panel");
        this.iPanel.addRow((Widget)scroll);
        this.iFilter.getFooter().setEnabled("print", true);
        this.iFilter.getFooter().setEnabled("export", true);
        this.iFilter.getFooter().setEnabled("export-xls", true);
        if (!response.getAssignedLegend().isEmpty() || !response.getNotAssignedLegend().isEmpty()) {
            P t;
            P b;
            P ll;
            P h;
            P hl;
            this.iPanel.addHeaderRow((Widget)new UniTimeHeaderPanel(MESSAGES.sectLegend()));
            P legend = new P("legend");
            if (!response.getAssignedLegend().isEmpty()) {
                hl = new P("header-line");
                h = new P("text");
                h.setText(MESSAGES.legendAssignedClasses());
                hl.add((Widget)h);
                legend.add((Widget)hl);
                for (TimetableGridInterface.TimetableGridLegend lg : response.getAssignedLegend()) {
                    ll = new P("legend-line");
                    b = new P("box");
                    b.getElement().getStyle().setBackgroundColor(lg.getColor());
                    t = new P("text");
                    t.setHTML(lg.getLabel());
                    ll.add((Widget)b);
                    ll.add((Widget)t);
                    legend.add((Widget)ll);
                }
            }
            if (!response.getNotAssignedLegend().isEmpty()) {
                hl = new P("header-line");
                h = new P("text");
                h.setText(MESSAGES.legendFreeTimes());
                hl.add((Widget)h);
                legend.add((Widget)hl);
                for (TimetableGridInterface.TimetableGridLegend lg : response.getNotAssignedLegend()) {
                    ll = new P("legend-line");
                    b = new P("box");
                    b.getElement().getStyle().setBackgroundColor(lg.getColor());
                    t = new P("text");
                    t.setHTML(lg.getLabel());
                    ll.add((Widget)b);
                    ll.add((Widget)t);
                    legend.add((Widget)ll);
                }
            }
            this.iPanel.addRow((Widget)legend);
        }
        if ((cpm = RootPanel.get((String)"UniTimeGWT:CustomPageMessages")) != null) {
            cpm.clear();
            if (response.hasPageMessages()) {
                for (final SolverInterface.PageMessage pm : response.getPageMessages()) {
                    P p = new P(pm.getType() == SolverInterface.PageMessageType.ERROR ? "unitime-PageError" : (pm.getType() == SolverInterface.PageMessageType.WARNING ? "unitime-PageWarn" : "unitime-PageMessage"));
                    p.setHTML(pm.getMessage());
                    if (pm.hasUrl()) {
                        p.addStyleName("unitime-ClickablePageMessage");
                        p.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                if (pm.hasUrl()) {
                                    ToolBox.open(GWT.getHostPageBaseURL() + pm.getUrl());
                                }
                            }
                        });
                    }
                    cpm.add((Widget)p);
                }
            }
        }
    }
}

