/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.HashSet;
import java.util.Iterator;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.model.Roles;
import org.unitime.timetable.security.rights.Right;

public class PermissionsImport
extends BaseImport {
    @Override
    public void loadXml(Element root) throws Exception {
        if (!root.getName().equalsIgnoreCase("permissions")) {
            throw new Exception("Given XML file is not a Permissions load file.");
        }
        try {
            this.beginTransaction();
            Iterator i = root.elementIterator("role");
            while (i.hasNext()) {
                Element r = (Element)i.next();
                String ref = r.attributeValue("reference");
                Roles role = (Roles)this.getHibSession().createQuery("from Roles where reference = :ref").setString("ref", ref).uniqueResult();
                if (role == null) {
                    role = new Roles();
                    role.setReference(ref);
                    role.setRights(new HashSet<String>());
                }
                role.setAbbv(r.attributeValue("name"));
                role.setManager("true".equals(r.attributeValue("manager", "true")));
                role.setEnabled("true".equals(r.attributeValue("enabled", "true")));
                role.setInstructor("true".equals(r.attributeValue("instructor", "false")));
                role.getRights().clear();
                Iterator j = r.elementIterator("right");
                while (j.hasNext()) {
                    Element p = (Element)j.next();
                    try {
                        role.getRights().add(Right.valueOf(p.getText()).name());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (NullPointerException nullPointerException) {}
                }
                this.getHibSession().saveOrUpdate((Object)role);
            }
            this.info("All done.");
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
    }
}

