/*
 * Licensed to The Apereo Foundation under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for
 * additional information regarding copyright ownership.
 *
 * The Apereo Foundation licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
*/

use timetable;

set @saved_fk_checks=@@foreign_key_checks, foreign_key_checks=0;
set @saved_cs_client = @@character_set_client, character_set_client = utf8;

delete from `academic_area`;
delete from `academic_classification`;
delete from `application_config`;
delete from `assigned_instructors`;
delete from `assigned_rooms`;
delete from `assignment`;
delete from `building`;
delete from `building_pref`;
delete from `change_log`;
delete from `class_`;
delete from `class_instructor`;
delete from `class_waitlist`;
delete from `constraint_info`;
delete from `course_catalog`;
delete from `course_credit_type`;
delete from `course_credit_unit_config`;
delete from `course_credit_unit_type`;
delete from `course_demand`;
delete from `course_offering`;
delete from `course_request`;
delete from `course_request_option`;
delete from `course_subpart_credit`;
delete from `course_type`;
delete from `crse_credit_format`;
delete from `curriculum`;
delete from `curriculum_clasf`;
delete from `curriculum_course`;
delete from `curriculum_course_group`;
delete from `curriculum_group`;
delete from `curriculum_major`;
delete from `curriculum_rule`;
delete from `date_mapping`;
delete from `date_pattern`;
delete from `date_pattern_dept`;
delete from `date_pattern_parent`;
delete from `date_pattern_pref`;
delete from `demand_offr_type`;
delete from `department`;
delete from `departmental_instructor`;
delete from `dept_status_type`;
delete from `dept_to_tt_mgr`;
delete from `designator`;
delete from `dist_type_dept`;
delete from `distribution_object`;
delete from `distribution_pref`;
delete from `distribution_type`;
delete from `event`;
delete from `event_contact`;
delete from `event_join_event_contact`;
delete from `event_note`;
delete from `event_note_meeting`;
delete from `exact_time_mins`;
delete from `exam`;
delete from `exam_instructor`;
delete from `exam_location_pref`;
delete from `exam_owner`;
delete from `exam_period`;
delete from `exam_period_pref`;
delete from `exam_room_assignment`;
delete from `exam_type`;
delete from `external_building`;
delete from `external_room`;
delete from `external_room_department`;
delete from `external_room_feature`;
delete from `feature_type`;
delete from `free_time`;
delete from `hibernate_unique_key`;
delete from `history`;
delete from `instr_offering_config`;
delete from `instructional_offering`;
delete from `itype_desc`;
delete from `jenrl`;
delete from `lastlike_course_demand`;
delete from `manager_settings`;
delete from `meeting`;
delete from `message_log`;
delete from `non_university_location`;
delete from `offering_coordinator`;
delete from `offr_consent_type`;
delete from `offr_group`;
delete from `offr_group_offering`;
delete from `pos_acad_area_major`;
delete from `pos_acad_area_minor`;
delete from `pos_major`;
delete from `pos_minor`;
delete from `position_type`;
delete from `preference_level`;
delete from `query_log`;
delete from `related_course_info`;
delete from `reservation`;
delete from `reservation_clasf`;
delete from `reservation_class`;
delete from `reservation_config`;
delete from `reservation_major`;
delete from `reservation_student`;
delete from `rights`;
delete from `roles`;
delete from `room`;
delete from `room_dept`;
delete from `room_exam_type`;
delete from `room_feature`;
delete from `room_feature_pref`;
delete from `room_group`;
delete from `room_group_pref`;
delete from `room_group_room`;
delete from `room_join_room_feature`;
delete from `room_pref`;
delete from `room_type`;
delete from `room_type_option`;
delete from `saved_hql`;
delete from `scheduling_subpart`;
delete from `script`;
delete from `script_parameter`;
delete from `sectioning_course_types`;
delete from `sectioning_info`;
delete from `sectioning_log`;
delete from `sectioning_queue`;
delete from `sectioning_status`;
delete from `session_config`;
delete from `sessions`;
delete from `settings`;
delete from `solution`;
delete from `solver_gr_to_tt_mgr`;
delete from `solver_group`;
delete from `solver_info`;
delete from `solver_info_def`;
delete from `solver_parameter`;
delete from `solver_parameter_def`;
delete from `solver_parameter_group`;
delete from `solver_predef_setting`;
delete from `sponsoring_organization`;
delete from `staff`;
delete from `standard_event_note`;
delete from `student`;
delete from `student_acad_area`;
delete from `student_accomodation`;
delete from `student_class_enrl`;
delete from `student_enrl`;
delete from `student_enrl_msg`;
delete from `student_group`;
delete from `student_major`;
delete from `student_minor`;
delete from `student_sect_hist`;
delete from `student_to_acomodation`;
delete from `student_to_group`;
delete from `subject_area`;
delete from `time_pattern`;
delete from `time_pattern_days`;
delete from `time_pattern_dept`;
delete from `time_pattern_time`;
delete from `time_pref`;
delete from `timetable_manager`;
delete from `tmtbl_mgr_to_roles`;
delete from `travel_time`;
delete from `user_data`;
delete from `users`;
delete from `waitlist`;
delete from `xconflict`;
delete from `xconflict_exam`;
delete from `xconflict_instructor`;
delete from `xconflict_student`;

insert into `application_config` values
	('tmtbl.db.version','123','Timetabling database version (please do not change -- this key is used by automatic database update)');

insert into `course_credit_type` values
	(238,'collegiate','Collegiate Credit',NULL,' '),
	(239,'continuingEdUnits','Continuing Education Units','CEU','Q'),
	(240,'equivalent','Equivalent Credit','EQV','E'),
	(241,'mastersCredit','Masters Credit','MS','M'),
	(242,'phdThesisCredit','Phd Thesis Credit','PhD','T');

insert into `course_credit_unit_type` values
	(248,'semesterHours','Semester Hours',NULL);

insert into `crse_credit_format` values
	(243,'arrangeHours','Arrange Hours','AH'),
	(244,'fixedUnit','Fixed Unit',NULL),
	(245,'variableMinMax','Variable Min/Max',NULL),
	(246,'variableRange','Variable Range',NULL);

insert into `dept_status_type` values
	(265,'initial','Initial Data Load',0,1,0),
	(266,'input','Input Data Entry',1721,1,1),
	(267,'timetabling','Timetabling',4025,1,2),
	(268,'publish','Timetable Published',61961,1,4),
	(269,'finished','Session Finished',521,1,5),
	(270,'dept_input','External Mgr. Input Data Entry',135,2,6),
	(271,'dept_timetabling','External Mgr. Timetabling',423,2,7),
	(272,'dept_publish','External Mgr. Timetable Published',1,2,9),
	(325,'dept_readonly','Department Read Only',9,2,10),
	(326,'dept_edit','Department Allow Edit',441,2,11),
	(385,'dept_readonly_ni','External Mgr. Timetabling (No Instructor Assignments)',391,2,8),
	(414,'exams','Examination Timetabling',3593,1,3);

insert into `distribution_type` values
	(61,'BTB','Back-To-Back & Same Room','0',1,'P43210R','Classes must be offered in adjacent time segments and must be placed in the same room. Given classes must also be taught on the same days.<BR>When prohibited or (strongly) discouraged: classes cannot be back-to-back. There must be at least half-hour between these classes, and they must be taught on the same days and in the same room.','BTB Same Room',1,0),
	(62,'BTB_TIME','Back-To-Back','0',2,'P43210R','Classes must be offered in adjacent time segments but may be placed in different rooms. Given classes must also be taught on the same days.<BR>When prohibited or (strongly) discouraged: no pair of classes can be taught back-to-back. They may not overlap in time, but must be taught on the same days. This means that there must be at least half-hour between these classes. ','BTB',1,0),
	(63,'SAME_TIME','Same Time','0',3,'P43210R','Given classes must be taught at the same time of day (independent of the actual day the classes meet). For the classes of the same length, this is the same constraint as <i>same start</i>. For classes of different length, the shorter one cannot start before, nor end after, the longer one.<BR>When prohibited or (strongly) discouraged: one class may not meet on any day at a time of day that overlaps with that of the other. For example, one class can not meet M 7:30 while the other meets F 7:30. Note the difference here from the <i>different time</i> constraint that only prohibits the actual class meetings from overlapping.','Same Time',0,0),
	(64,'SAME_DAYS','Same Days','0',4,'P43210R','Given classes must be taught on the same days. In case of classes of different time patterns, a class with fewer meetings must meet on a subset of the days used by the class with more meetings. For example, if one class pattern is 3x50, all others given in the constraint can only be taught on Monday, Wednesday, or Friday. For a 2x100 class MW, MF, WF is allowed but TTh is prohibited.<BR>When prohibited or (strongly) discouraged: any pair of classes classes cannot be taught on the same days (cannot overlap in days). For instance, if one class is MFW, the second has to be TTh.','Same Days',1,0),
	(65,'NHB(1)','1 Hour Between','0',5,'P43210R','Given classes must have exactly 1 hour in between the end of one and the beginning of another. As with the <i>back-to-back time</i> constraint, given classes must be taught on the same days.<BR>When prohibited or (strongly) discouraged: classes can not have 1 hour in between. They may not overlap in time but must be taught on the same days.','1h Btw',0,0),
	(66,'NHB(2)','2 Hours Between','0',6,'P43210R','Given classes must have exactly 2 hours in between the end of one and the beginning of another. As with the <i>back-to-back time</i> constraint, given classes must be taught on the same days.<BR>When prohibited or (strongly) discouraged: classes can not have 2 hours in between. They may not overlap in time but must be taught on the same days.','2h Btw',0,0),
	(67,'NHB(3)','3 Hours Between','0',7,'P43210R','Given classes must have exactly 3 hours in between the end of one and the beginning of another. As with the <i>back-to-back time</i> constraint, given classes must be taught on the same days.<BR>When prohibited or (strongly) discouraged: classes can not have 3 hours in between. They may not overlap in time but must be taught on the same days.','3h Btw',0,0),
	(68,'NHB(4)','4 Hours Between','0',8,'P43210R','Given classes must have exactly 4 hours in between the end of one and the beginning of another. As with the <i>back-to-back time</i> constraint, given classes must be taught on the same days.<BR>When prohibited or (strongly) discouraged: classes can not have 4 hours in between. They may not overlap in time but must be taught on the same days.','4h Btw',0,0),
	(69,'NHB(5)','5 Hours Between','0',9,'P43210R','Given classes must have exactly 5 hours in between the end of one and the beginning of another. As with the <i>back-to-back time</i> constraint, given classes must be taught on the same days.<BR>When prohibited or (strongly) discouraged: classes can not have 5 hours in between. They may not overlap in time but must be taught on the same days.','5h Btw',0,0),
	(70,'NHB(6)','6 Hours Between','0',10,'P43210R','Given classes must have exactly 6 hours in between the end of one and the beginning of another. As with the <i>back-to-back time</i> constraint, given classes must be taught on the same days.<BR>When prohibited or (strongly) discouraged: classes can not have 6 hours in between. They may not overlap in time but must be taught on the same days.','6h Btw',0,0),
	(71,'NHB(7)','7 Hours Between','0',11,'P43210R','Given classes must have exactly 7 hours in between the end of one and the beginning of another. As with the <i>back-to-back time</i> constraint, given classes must be taught on the same days.<BR>When prohibited or (strongly) discouraged: classes can not have 7 hours in between. They may not overlap in time but must be taught on the same days.','7h Btw',0,0),
	(72,'NHB(8)','8 Hours Between','0',12,'P43210R','Given classes must have exactly 8 hours in between the end of one and the beginning of another. As with the <i>back-to-back time</i> constraint, given classes must be taught on the same days.<BR>When prohibited or (strongly) discouraged: classes can not have 8 hours in between. They may not overlap in time but must be taught on the same days.','8h Btw',0,0),
	(73,'DIFF_TIME','Different Time','0',13,'P43210R','Given classes cannot overlap in time. They may be taught at the same time of day if they are on different days. For instance, MF 7:30 is compatible with TTh 7:30.<BR>When prohibited or (strongly) discouraged: every pair of classes in the constraint must overlap in time.','Diff Time',0,0),
	(74,'NHB(1.5)','90 Minutes Between','0',14,'P43210R','Given classes must have exactly 90 minutes in between the end of one and the beginning of another. As with the <i>back-to-back time</i> constraint, given classes must be taught on the same days.<BR>When prohibited or (strongly) discouraged: classes can not have 90 minutes in between. They may not overlap in time but must be taught on the same days.','90min Btw',0,0),
	(75,'NHB(4.5)','4.5 Hours Between','0',15,'P43210R','Given classes must have exactly 4.5 hours in between the end of one and the beginning of another. As with the <i>back-to-back time</i> constraint, given classes must be taught on the same days.<BR>When prohibited or (strongly) discouraged: classes can not have 4.5 hours in between. They may not overlap in time but must be taught on the same days.','4.5h Btw',0,0),
	(101,'SAME_ROOM','Same Room','0',17,'P43210R','Given classes must be taught in the same room.<BR>When prohibited or (strongly) discouraged: any pair of classes in the constraint cannot be taught in the same room.','Same Room',1,0),
	(102,'NHB_GTE(1)','At Least 1 Hour Between','0',18,'P43210R','Given classes have to have 1 hour or more in between.<BR>When prohibited or (strongly) discouraged: given classes have to have less than 1 hour in between.','>=1h Btw',1,0),
	(103,'SAME_START','Same Start Time','0',16,'P43210R','Given classes must start during the same half-hour period of a day (independent of the actual day the classes meet). For instance, MW 7:30 is compatible with TTh 7:30 but not with MWF 8:00.<BR>When prohibited or (strongly) discouraged: any pair of classes in the given constraint cannot start during the same half-hour period of any day of the week.','Same Start',0,0),
	(104,'NHB_LT(6)','Less Than 6 Hours Between','0',19,'P43210R','Given classes must have less than 6 hours from end of first class to the beginning of the next.  Given classes must also be taught on the same days.<BR>When prohibited or (strongly) discouraged: given classes must have 6 or more hours between. This constraint does not carry over from classes taught at the end of one day to the beginning of the next.','<6h Btw',1,0),
	(161,'SAME_STUDENTS','Same Students','0',20,'210R','Given classes are treated as they are attended by the same students, i.e., they cannot overlap in time and if they are back-to-back the assigned rooms cannot be too far (student limit is used).','Same Students',0,0),
	(162,'SAME_INSTR','Same Instructor','0',21,'210R','Given classes are treated as they are taught by the same instructor, i.e., they cannot overlap in time and if they are back-to-back the assigned rooms cannot be too far (instructor limit is used).<BR>If the constraint is required and the classes are back-to-back, discouraged and strongly discouraged distances between assigned rooms are also considered.','Same Instr',0,0),
	(163,'CAN_SHARE_ROOM','Can Share Room','0',22,'2R','Given classes can share the room (use the room in the same time) if the room is big enough.','Share Room',0,0),
	(164,'SPREAD','Spread In Time','0',23,'2R','Given classes have to be spread in time (overlapping of the classes in time needs to be minimized).','Time Spread',0,0),
	(165,'PRECEDENCE','Precedence','1',24,'P43210R','Given classes have to be taught in the given order (the first meeting of the first class has to end before the first meeting of the second class etc.)<BR>When prohibited or (strongly) discouraged: classes have to be taught in the order reverse to the given one','Precede',0,0),
	(185,'MIN_ROOM_USE','Minimize Number Of Rooms Used','0',25,'P43210R','Minimize number of rooms used by the given set of classes.','Min Rooms',1,0),
	(205,'BTB_DAY','Back-To-Back Day','0',26,'P43210R','Classes must be offered on adjacent days and may be placed in different rooms.<BR>When prohibited or (strongly) discouraged: classes can not be taught on adjacent days. They also can not be taught on the same days. This means that there must be at least one day between these classes.','BTB Day',0,0),
	(206,'MIN_GRUSE(10x1h)','Minimize Use Of 1h Groups','0',27,'P43210R','Minimize number of groups of time that are used by the given classes. The time is spread into the following 10 groups of one hour: 7:30a-8:30a, 8:30a-9:30a, 9:30a-10:30a, ... 4:30p-5:30p.','Min 1h Groups',0,0),
	(207,'MIN_GRUSE(5x2h)','Minimize Use Of 2h Groups','0',28,'P43210R','Minimize number of groups of time that are used by the given classes. The time is spread into the following 5 groups of two hours: 7:30a-9:30a, 9:30a-11:30a, 11:30a-1:30p, 1:30p-3:30p, 3:30p-5:30p.','Min 2h Groups',0,0),
	(208,'MIN_GRUSE(3x3h)','Minimize Use Of 3h Groups','0',29,'P43210R','Minimize number of groups of time that are used by the given classes. The time is spread into the following 3 groups: 7:30a-10:30a, 10:30a-2:30p, 2:30p-5:30p.','Min 3h Groups',0,0),
	(209,'MIN_GRUSE(2x5h)','Minimize Use Of 5h Groups','0',30,'P43210R','Minimize number of groups of time that are used by the given classes. The time is spread into the following 2 groups: 7:30a-12:30a, 12:30a-5:30p.','Min 5h Groups',0,0),
	(305,'NDB_GT_1','More Than 1 Day Between','0',32,'P43210R','Given classes must have two or more days in between.<br>When prohibited or (strongly) discouraged: given classes must be offered on adjacent days or with at most one day in between.','>1d Btw',0,0),
	(345,'CH_NOTOVERLAP','Children Cannot Overlap','0',33,'210R','If parent classes do not overlap in time, children classes can not overlap in time as well.<br>Note: This constraint only needs to be put on the parent classes. Preferred configurations are Required All Classes or Pairwise (Strongly) Preferred.','Ch No Ovlap',0,0),
	(365,'FOLLOWING_DAY','Next Day','1',34,'P43210R','The second class has to be placed on the following day of the first class (if the first class is on Friday, second class have to be on Monday).<br> When prohibited or (strongly) discouraged: The second class has to be placed on the previous day of the first class (if the first class is on Monday, second class have to be on Friday).<br> Note: This constraint works only between pairs of classes.','Next Day',0,0),
	(366,'EVERY_OTHER_DAY','Two Days After','1',35,'P43210R','The second class has to be placed two days after the first class (Monday &rarr; Wednesday, Tuesday &rarr; Thurday, Wednesday &rarr; Friday, Thursday &rarr; Monday, Friday &rarr; Tuesday).<br> When prohibited or (strongly) discouraged: The second class has to be placed two days before the first class (Monday &rarr; Thursday, Tuesday &rarr; Friday, Wednesday &rarr; Monday, Thursday &rarr; Tuesday, Friday &rarr; Wednesday).<br> Note: This constraint works only between pairs of classes.','2d After',0,0),
	(367,'MEET_WITH','Meet Together','0',31,'2R','Given classes are meeting together (same as if the given classes require constraints Can Share Room, Same Room, Same Time and Same Days all together).','Meet Together',0,0),
	(405,'EX_SAME_PER','Same Period','0',36,'P43210R','Exams are to be placed at the same period. <BR>When prohibited or (strongly) discouraged: exams are to be placed at different periods.','Same Per',0,1),
	(406,'EX_SAME_ROOM','Same Room','0',37,'P43210R','Exams are to be placed at the same room(s). <BR>When prohibited or (strongly) discouraged: exams are to be placed at different rooms.','Same Room',0,1),
	(407,'EX_PRECEDENCE','Precedence','1',38,'P43210R','Exams are to be placed in the given order. <BR>When prohibited or (strongly) discouraged: exams are to be placed in the order reverse to the given one.','Precede',0,1),
	(1179612,'MAX_HRS_DAY(6)','At Most 6 Hours A Day','0',39,'210R','Classes are to be placed in a way that there is no more than six hours in any day.','At Most 6 Hrs',1,0),
	(1179613,'MAX_HRS_DAY(7)','At Most 7 Hours A Day','0',40,'210R','Classes are to be placed in a way that there is no more than seven hours in any day.','At Most 7 Hrs',1,0),
	(1179614,'MAX_HRS_DAY(8)','At Most 8 Hours A Day','0',41,'210R','Classes are to be placed in a way that there is no more than eight hours in any day.','At Most 8 Hrs',1,0),
	(1277913,'LINKED_SECTIONS','Linked Classes','0',42,'R','Classes (of different courses) are to be attended by the same students. For instance, if class A1 (of a course A) and class B1 (of a course B) are linked, a student requesting both courses must attend A1 if and only if he also attends B1. This is a student sectioning constraint that is interpreted as Same Students constraint during course timetabling.','Linked',0,0),
	(1376214,'MAX_HRS_DAY(5)','At Most 5 Hours A Day','0',43,'210R','Classes are to be placed in a way that there is no more than five hours in any day.','At Most 5 Hrs',1,0),
	(1376215,'BTB_PRECEDENCE','Back-To-Back Precedence','0',44,'P43210R','Given classes have to be taught in the given order, on the same days, and in adjacent time segments.<br>When prohibited or (strongly) discouraged: Given classes have to be taught in the given order, on the same days, but cannot be back-to-back.','BTB Precede',0,0),
	(1376216,'SAME_D_T','Same Days-Time','0',45,'P43210R','Given classes must be taught at the same time of day and on the same days.<br>This constraint combines Same Days and Same Time distribution preferences.<br>When prohibited or (strongly) discouraged: Any pair of classes classes cannot be taught on the same days during the same time.','Same Days-Time',0,0),
	(1376217,'SAME_D_R_T','Same Days-Room-Time','0',46,'P43210R','Given classes must be taught at the same time of day, on the same days and in the same room.<br>Note that this constraint is the same as Meet Together constraint, except it does not allow for room sharing. In other words, it is only useful when these classes are taught during non-overlapping date patterns.<br>When prohibited or (strongly) discouraged: Any pair of classes classes cannot be taught on the same days during the same time in the same room.','Same Days-Room-Time',0,0),
	(1376218,'SAME_WEEKS','Same Weeks','0',47,'P43210R','Given classes must be taught during the same weeks (i.e., must have the same date pattern).<br>When prohibited or (strongly) discouraged: any two classes must have non overlapping date patterns.','Same Weeks',0,0),
	(1474515,'EX_SHARE_ROOM','Can Share Room','0',48,'2R','Given examinations can share a room (use the same room during the same period) if the room is big enough.  If examinations of different seating type are sharing a room, the more restrictive seating type is used to check the room size.','Share Room',0,1),
	(1572816,'NO_CONFLICT','Ignore Student Conflicts','0',49,'2R','All student conflicts between the given classes are to be ignored.','No Conflicts',0,0);

insert into `exact_time_mins` values
	(214405,0,0,0,0),
	(214406,1,5,1,0),
	(214407,6,10,2,0),
	(214408,11,15,4,0),
	(214409,16,20,5,0),
	(214410,21,25,6,0),
	(214411,26,30,7,0),
	(214412,31,35,8,15),
	(214413,36,40,10,15),
	(214414,41,45,11,15),
	(214415,46,50,12,10),
	(214416,51,55,13,15),
	(214417,56,60,14,10),
	(214418,61,65,16,15),
	(214419,66,70,17,15),
	(214420,71,75,18,15),
	(214421,76,80,19,15),
	(214422,81,85,20,15),
	(214423,86,90,21,15),
	(214424,91,95,23,15),
	(214425,96,100,24,10),
	(214426,101,105,25,15),
	(214427,106,110,26,15),
	(214428,111,115,28,15),
	(214429,116,120,29,15),
	(214430,121,125,30,15),
	(214431,126,130,31,15),
	(214432,131,135,32,15),
	(214433,136,140,34,15),
	(214434,141,145,35,15),
	(214435,146,150,36,10),
	(214436,151,155,37,15),
	(214437,156,160,38,15),
	(214438,161,165,40,15),
	(214439,166,170,41,15),
	(214440,171,175,42,15),
	(214441,176,180,43,15),
	(214442,181,185,44,15),
	(214443,186,190,46,15),
	(214444,191,195,47,15),
	(214445,196,200,48,10),
	(214446,201,205,49,15),
	(214447,206,210,50,15),
	(214448,211,215,52,15),
	(214449,216,220,53,15),
	(214450,221,225,54,15),
	(214451,226,230,55,15),
	(214452,231,235,56,15),
	(214453,236,240,58,15),
	(214454,241,245,59,15),
	(214455,246,250,60,10),
	(214456,251,255,61,15),
	(214457,256,260,62,15),
	(214458,261,265,64,15),
	(214459,266,270,65,15),
	(214460,271,275,66,15),
	(214461,276,280,67,15),
	(214462,281,285,68,15),
	(214463,286,290,70,15),
	(214464,291,295,71,15),
	(214465,296,300,72,10),
	(214466,301,305,73,15),
	(214467,306,310,74,15),
	(214468,311,315,76,15),
	(214469,316,320,77,15),
	(214470,321,325,78,15),
	(214471,326,330,79,15),
	(214472,331,335,80,15),
	(214473,336,340,82,15),
	(214474,341,345,83,15),
	(214475,346,350,84,10),
	(214476,351,355,85,15),
	(214477,356,360,86,15),
	(214478,361,365,88,15),
	(214479,366,370,89,15),
	(214480,371,375,90,15),
	(214481,376,380,91,5),
	(214482,381,385,92,15),
	(214483,386,390,94,15),
	(214484,391,395,95,15),
	(214485,396,400,96,10),
	(214486,401,405,97,15),
	(214487,406,410,98,15),
	(214488,411,415,100,15),
	(214489,416,420,101,15),
	(214490,421,425,102,15),
	(214491,426,430,103,15),
	(214492,431,435,104,15),
	(214493,436,440,106,15),
	(214494,441,445,107,15),
	(214495,446,450,108,10),
	(214496,451,455,109,15),
	(214497,456,460,110,15),
	(214498,461,465,112,15),
	(214499,466,470,113,15),
	(214500,471,475,114,15),
	(214501,476,480,115,15),
	(214502,481,485,116,15),
	(214503,486,490,118,15),
	(214504,491,495,119,15),
	(214505,496,500,120,10),
	(214506,501,505,121,15),
	(214507,506,510,122,15),
	(214508,511,515,124,15),
	(214509,516,520,125,15),
	(214510,521,525,126,15),
	(214511,526,530,127,15),
	(214512,531,535,128,15),
	(214513,536,540,130,15),
	(214514,541,545,131,15),
	(214515,546,550,132,10),
	(214516,551,555,133,15),
	(214517,556,560,134,15),
	(214518,561,565,136,15),
	(214519,566,570,137,15),
	(214520,571,575,138,15),
	(214521,576,580,139,15),
	(214522,581,585,140,15),
	(214523,586,590,142,15),
	(214524,591,595,143,15),
	(214525,596,600,144,10),
	(214526,601,605,145,15),
	(214527,606,610,146,15),
	(214528,611,615,148,15),
	(214529,616,620,149,15),
	(214530,621,625,150,15),
	(214531,626,630,151,15),
	(214532,631,635,152,15),
	(214533,636,640,154,15),
	(214534,641,645,155,15),
	(214535,646,650,156,10),
	(214536,651,655,157,15),
	(214537,656,660,158,15),
	(214538,661,665,160,15),
	(214539,666,670,161,15),
	(214540,671,675,162,15),
	(214541,676,680,163,15),
	(214542,681,685,164,15),
	(214543,686,690,166,15),
	(214544,691,695,167,15),
	(214545,696,700,168,10),
	(214546,701,705,169,15),
	(214547,706,710,170,15),
	(214548,711,715,172,15),
	(214549,716,720,173,15);

insert into `exam_type` values
	(1540049,'final','Final',0),
	(1540050,'midterm','Midterm',1);

insert into `hibernate_unique_key` values
	(51);

insert into `itype_desc` values
	(10,'Lec  ','Lecture','lec',1,NULL,1),
	(11,'Lec 1','Lecture 1','lec',0,10,1),
	(12,'Lec 2','Lecture 2','lec',0,10,1),
	(13,'Lec 3','Lecture 3','lec',0,10,1),
	(14,'Lec 4','Lecture 4','lec',0,10,1),
	(15,'Lec 5','Lecture 5','lec',0,10,1),
	(16,'Lec 6','Lecture 6','lec',0,10,1),
	(17,'Lec 7','Lecture 7','lec',0,10,1),
	(18,'Lec 8','Lecture 8','lec',0,10,1),
	(19,'Lec 9','Lecture 9','lec',0,10,1),
	(20,'Rec  ','Recitation','rec',1,NULL,1),
	(21,'Rec 1','Recitation 1','rec',0,20,1),
	(22,'Rec 2','Recitation 2','rec',0,20,1),
	(23,'Rec 3','Recitation 3','rec',0,20,1),
	(24,'Rec 4','Recitation 4','rec',0,20,1),
	(25,'Prsn ','Presentation','prsn',1,NULL,1),
	(26,'Prsn1','Presentation 1','prsn',0,25,1),
	(27,'Prsn2','Presentation 2','prsn',0,25,1),
	(28,'Prsn3','Presentation 3 ','prsn',0,25,1),
	(29,'Prsn4','Presentation 4','prsn',0,25,1),
	(30,'Lab  ','Laboratory','lab',1,NULL,1),
	(31,'Lab 1','Laboratory 1','lab',0,30,1),
	(32,'Lab 2','Laboratory 2','lab',0,30,1),
	(33,'Lab 3','Laboratory 3','lab',0,30,1),
	(34,'Lab 4','Laboratory 4','lab',0,30,1),
	(35,'LabP ','Laboratory Preparation','labP',1,NULL,1),
	(36,'LabP1','Laboratory Preparation 1','labP',0,35,1),
	(37,'LabP2','Laboratory Preparation 2','labP',0,35,1),
	(38,'LabP3','Laboratory Preparation 3','labP',0,35,1),
	(39,'LabP4','Laboratory Preparation 4','labP',0,35,1),
	(40,'Stdo ','Studio','stdo',1,NULL,1),
	(41,'Stdo1','Studio 1','stdo',0,40,1),
	(42,'Stdo2','Studio 2','stdo',0,40,1),
	(43,'Stdo3','Studio 3','stdo',0,40,1),
	(44,'Stdo4','Studio 4','stdo',0,40,1),
	(45,'Dist ','Distance Learning','dist',1,NULL,0),
	(46,'Dist1','Distance Learning 1','dist',0,45,0),
	(47,'Dist2','Distance Learning 2','dist',0,45,0),
	(48,'Dist3','Distance Learning 3','dist',0,45,0),
	(49,'Dist4','Distance Learning 4','dist',0,45,0),
	(50,'Clin ','Clinic','clin',1,NULL,0),
	(51,'Clin1','Clinic 1','clin',0,50,0),
	(52,'Clin2','Clinic 2','clin',0,50,0),
	(53,'Clin3','Clinic 3','clin',0,50,0),
	(54,'Clin4','Clinic 4','clin',0,50,0),
	(55,'Clin5','Clinic 5','clin',0,50,0),
	(56,'Clin6','Clinic 6','clin',0,50,0),
	(57,'Clin7','Clinic 7','clin',0,50,0),
	(58,'Clin8','Clinic 8','clin',0,50,0),
	(59,'Clin9','Clinic 9','clin',0,50,0),
	(60,'Expr ','Experiential','expr',1,NULL,0),
	(61,'Expr1','Experiential 1','expr',0,60,0),
	(62,'Expr2','Experiential 2','expr',0,60,0),
	(63,'Expr3','Experiential 3','expr',0,60,0),
	(64,'Expr4','Experiential 4','expr',0,60,0),
	(65,'Expr5','Experiential 5','expr',0,60,0),
	(66,'Expr6','Experiential 6','expr',0,60,0),
	(67,'Expr7','Experiential 7','expr',0,60,0),
	(68,'Expr8','Experiential 8','expr',0,60,0),
	(69,'Expr9','Experiential 9','expr',0,60,0),
	(70,'Res  ','Research','res',1,NULL,0),
	(71,'Res 1','Research 1','res',0,70,0),
	(72,'Res 2','Research 2','res',0,70,0),
	(73,'Res 3','Research 3','res',0,70,0),
	(74,'Res 4','Research 4','res',0,70,0),
	(75,'Res 5','Research 5','res',0,70,0),
	(76,'Res 6','Research 6','res',0,70,0),
	(77,'Res 7','Research 7','res',0,70,0),
	(78,'Res 8','Research 8','res',0,70,0),
	(79,'Res 9','Research 9','res',0,70,0),
	(80,'Ind  ','Individual Study','ind',1,NULL,0),
	(81,'Ind 1','Individual Study 1','ind',0,80,0),
	(82,'Ind 2','Individual Study 2','ind',0,80,0),
	(83,'Ind 3','Individual Study 3','ind',0,80,0),
	(84,'Ind 4','Individual Study 4','ind',0,80,0),
	(85,'Ind 5','Individual Study 5','ind',0,80,0),
	(86,'Ind 6','Individual Study 6','ind',0,80,0),
	(87,'Ind 7','Individual Study 7','ind',0,80,0),
	(88,'Ind 8','Individual Study 8','ind',0,80,0),
	(89,'Ind 9','Individual Study 9','ind',0,80,0),
	(90,'Pso  ','Practice Study Observation','pso',1,NULL,0),
	(91,'Pso 1','Practice Study Observation 1','pso',0,90,0),
	(92,'Pso 2','Practice Study Observation 2','pso',0,90,0),
	(93,'Pso 3','Practice Study Observation 3','pso',0,90,0),
	(94,'Pso 4','Practice Study Observation 4','pso',0,90,0),
	(95,'Pso 5','Practice Study Observation 5','pso',0,90,0),
	(96,'Pso 6','Practice Study Observation 6','pso',0,90,0),
	(97,'Pso 7','Practice Study Observation 7','pso',0,90,0),
	(98,'Pso 8','Practice Study Observation 8','pso',0,90,0),
	(99,'Pso 9','Practice Study Observation 9','pso',0,90,0);

insert into `offr_consent_type` values
	(225,'IN','Consent of Instructor','Instructor'),
	(226,'DP','Consent of Department','Department');

insert into `position_type` values
	(1,'PROF','Professor',100),
	(2,'ASSOC_PROF','Associate Professor',200),
	(3,'ASST_PROF','Assistant Professor',300),
	(4,'INSTRUCTOR','Instructor',800),
	(5,'CLIN_PROF','Clinical / Professional',500),
	(6,'CONT_LEC','Continuing Lecturer',600),
	(7,'LTD_LEC','Limited-Term Lecturer',700),
	(8,'VISIT_FAC','Visiting Faculty',400),
	(9,'POST_DOC','Post Doctoral',1500),
	(10,'ADJUNCT_FAC','Adjunct Faculty',1000),
	(11,'GRAD_TEACH_ASST','Graduate Teaching Assistant',1200),
	(12,'GRAD_LEC','Graduate Lecturer',1100),
	(13,'CLERICAL_STAFF','Clerical Staff',1600),
	(14,'SERVICE_STAFF','Service Staff',1700),
	(15,'FELLOWSHIP','Fellowship',1800),
	(16,'EMERITUS','Emeritus Faculty',900),
	(17,'OTHER','Other',2000),
	(18,'ADMIN_STAFF','Administrative/Professional Staff',1300),
	(19,'UNDRGRD_TEACH_ASST','Undergrad Teaching Assistant',1400);

insert into `preference_level` values
	(1,'R','Required',1),
	(2,'-2','Strongly Preferred',2),
	(3,'-1','Preferred',3),
	(4,'0','Neutral',4),
	(5,'1','Discouraged',5),
	(6,'2','Strongly Discouraged',6),
	(7,'P','Prohibited',7);

insert into `rights` values
	(1,'AcademicAreaEdit'),
	(1,'AcademicAreas'),
	(1,'AcademicClassificationEdit'),
	(1,'AcademicClassifications'),
	(1,'AcademicSessionAdd'),
	(1,'AcademicSessionDelete'),
	(1,'AcademicSessionEdit'),
	(1,'AcademicSessions'),
	(1,'AddCourseOffering'),
	(1,'AddNonUnivLocation'),
	(1,'AddRoom'),
	(1,'AddSpecialUseRoom'),
	(1,'AddSpecialUseRoomExternalRoom'),
	(1,'AllowTestSessions'),
	(1,'ApplicationConfig'),
	(1,'AssignInstructors'),
	(1,'AssignInstructorsClass'),
	(1,'AssignedClasses'),
	(1,'AssignedExaminations'),
	(1,'AssignmentHistory'),
	(1,'BuildingAdd'),
	(1,'BuildingDelete'),
	(1,'BuildingEdit'),
	(1,'BuildingExportPdf'),
	(1,'BuildingList'),
	(1,'BuildingUpdateData'),
	(1,'CanSelectSolverServer'),
	(1,'CanUseHardDistributionPrefs'),
	(1,'CanUseHardPeriodPrefs'),
	(1,'CanUseHardRoomPrefs'),
	(1,'CanUseHardTimePrefs'),
	(1,'Chameleon'),
	(1,'ChangePassword'),
	(1,'ClassAssignment'),
	(1,'ClassAssignments'),
	(1,'ClassAssignmentsExportCsv'),
	(1,'ClassAssignmentsExportPdf'),
	(1,'ClassDetail'),
	(1,'ClassEdit'),
	(1,'ClassEditClearPreferences'),
	(1,'Classes'),
	(1,'ClassesExportPDF'),
	(1,'ClearHibernateCache'),
	(1,'ConflictStatistics'),
	(1,'ConsentApproval'),
	(1,'CourseCreditFormatEdit'),
	(1,'CourseCreditFormats'),
	(1,'CourseCreditTypeEdit'),
	(1,'CourseCreditTypes'),
	(1,'CourseCreditUnitEdit'),
	(1,'CourseCreditUnits'),
	(1,'CourseRequests'),
	(1,'CourseTimetabling'),
	(1,'CourseTimetablingAudit'),
	(1,'CourseTypeEdit'),
	(1,'CourseTypes'),
	(1,'CurriculumAdd'),
	(1,'CurriculumAdmin'),
	(1,'CurriculumDelete'),
	(1,'CurriculumDetail'),
	(1,'CurriculumEdit'),
	(1,'CurriculumMerge'),
	(1,'CurriculumProjectionRulesDetail'),
	(1,'CurriculumProjectionRulesEdit'),
	(1,'CurriculumView'),
	(1,'DataExchange'),
	(1,'DatePatterns'),
	(1,'DepartmenalRoomFeatureDelete'),
	(1,'DepartmenalRoomFeatureEdit'),
	(1,'DepartmenalRoomGroupDelete'),
	(1,'DepartmenalRoomGroupEdit'),
	(1,'DepartmentAdd'),
	(1,'DepartmentDelete'),
	(1,'DepartmentEdit'),
	(1,'DepartmentEditChangeExternalManager'),
	(1,'DepartmentIndependent'),
	(1,'DepartmentRoomFeatureAdd'),
	(1,'DepartmentRoomGroupAdd'),
	(1,'Departments'),
	(1,'DistributionPreferenceAdd'),
	(1,'DistributionPreferenceClass'),
	(1,'DistributionPreferenceDelete'),
	(1,'DistributionPreferenceDetail'),
	(1,'DistributionPreferenceEdit'),
	(1,'DistributionPreferenceExam'),
	(1,'DistributionPreferenceSubpart'),
	(1,'DistributionPreferences'),
	(1,'DistributionTypeEdit'),
	(1,'DistributionTypes'),
	(1,'EditCourseOffering'),
	(1,'EditCourseOfferingCoordinators'),
	(1,'EditRoomDepartments'),
	(1,'EditRoomDepartmentsExams'),
	(1,'EditRoomDepartmentsFinalExams'),
	(1,'EditRoomDepartmentsMidtermExams'),
	(1,'EnrollmentAuditPDFReports'),
	(1,'EventAddCourseRelated'),
	(1,'EventAddSpecial'),
	(1,'EventAddUnavailable'),
	(1,'EventAnyLocation'),
	(1,'EventApprovePast'),
	(1,'EventDate'),
	(1,'EventDetail'),
	(1,'EventEdit'),
	(1,'EventLocation'),
	(1,'EventLocationApprove'),
	(1,'EventLocationOverbook'),
	(1,'EventLocationUnavailable'),
	(1,'EventLookupContact'),
	(1,'EventLookupSchedule'),
	(1,'EventMeetingApprove'),
	(1,'EventMeetingCancel'),
	(1,'EventMeetingDelete'),
	(1,'EventMeetingEdit'),
	(1,'EventMeetingInquire'),
	(1,'EventRoomTypeEdit'),
	(1,'EventRoomTypes'),
	(1,'EventStatusEdit'),
	(1,'EventStatuses'),
	(1,'Events'),
	(1,'ExactTimes'),
	(1,'ExamTypeEdit'),
	(1,'ExamTypes'),
	(1,'ExaminationAdd'),
	(1,'ExaminationAssignment'),
	(1,'ExaminationAssignmentChanges'),
	(1,'ExaminationClone'),
	(1,'ExaminationConflictStatistics'),
	(1,'ExaminationDelete'),
	(1,'ExaminationDetail'),
	(1,'ExaminationDistributionPreferenceAdd'),
	(1,'ExaminationDistributionPreferenceDelete'),
	(1,'ExaminationDistributionPreferenceDetail'),
	(1,'ExaminationDistributionPreferenceEdit'),
	(1,'ExaminationDistributionPreferences'),
	(1,'ExaminationEdit'),
	(1,'ExaminationEditClearPreferences'),
	(1,'ExaminationPdfReports'),
	(1,'ExaminationPeriods'),
	(1,'ExaminationReports'),
	(1,'ExaminationSchedule'),
	(1,'ExaminationSolver'),
	(1,'ExaminationSolverLog'),
	(1,'ExaminationTimetable'),
	(1,'ExaminationTimetabling'),
	(1,'Examinations'),
	(1,'ExtendedDatePatterns'),
	(1,'ExtendedTimePatterns'),
	(1,'GlobalRoomFeatureAdd'),
	(1,'GlobalRoomFeatureDelete'),
	(1,'GlobalRoomFeatureEdit'),
	(1,'GlobalRoomGroupAdd'),
	(1,'GlobalRoomGroupDelete'),
	(1,'GlobalRoomGroupEdit'),
	(1,'GlobalRoomGroupEditSetDefault'),
	(1,'HQLReportAdd'),
	(1,'HQLReportDelete'),
	(1,'HQLReportEdit'),
	(1,'HQLReports'),
	(1,'HQLReportsAdminOnly'),
	(1,'HQLReportsAdministration'),
	(1,'HQLReportsCourses'),
	(1,'HQLReportsEvents'),
	(1,'HQLReportsExaminations'),
	(1,'HQLReportsStudents'),
	(1,'HasRole'),
	(1,'HibernateStatistics'),
	(1,'Inquiry'),
	(1,'InstrOfferingConfigAdd'),
	(1,'InstrOfferingConfigDelete'),
	(1,'InstrOfferingConfigEdit'),
	(1,'InstrOfferingConfigEditDepartment'),
	(1,'InstrOfferingConfigEditSubpart'),
	(1,'InstructionalOfferingCrossLists'),
	(1,'InstructionalOfferingDetail'),
	(1,'InstructionalOfferings'),
	(1,'InstructionalOfferingsExportPDF'),
	(1,'InstructionalOfferingsWorksheetPDF'),
	(1,'InstructionalTypeAdd'),
	(1,'InstructionalTypeDelete'),
	(1,'InstructionalTypeEdit'),
	(1,'InstructionalTypes'),
	(1,'InstructorAdd'),
	(1,'InstructorDelete'),
	(1,'InstructorDetail'),
	(1,'InstructorEdit'),
	(1,'InstructorEditClearPreferences'),
	(1,'InstructorPreferences'),
	(1,'InstructorRoleEdit'),
	(1,'InstructorRoles'),
	(1,'Instructors'),
	(1,'InstructorsExportPdf'),
	(1,'IsAdmin'),
	(1,'LastChanges'),
	(1,'MajorEdit'),
	(1,'Majors'),
	(1,'ManageInstructors'),
	(1,'ManageSolvers'),
	(1,'MinorEdit'),
	(1,'Minors'),
	(1,'MultipleClassSetup'),
	(1,'MultipleClassSetupClass'),
	(1,'MultipleClassSetupDepartment'),
	(1,'NonUniversityLocationDelete'),
	(1,'NonUniversityLocationEdit'),
	(1,'NotAssignedClasses'),
	(1,'NotAssignedExaminations'),
	(1,'OfferingCanLock'),
	(1,'OfferingCanUnlock'),
	(1,'OfferingConsentTypeEdit'),
	(1,'OfferingConsentTypes'),
	(1,'OfferingDelete'),
	(1,'OfferingEnrollments'),
	(1,'OfferingMakeNotOffered'),
	(1,'OfferingMakeOffered'),
	(1,'PageStatistics'),
	(1,'PermissionEdit'),
	(1,'Permissions'),
	(1,'PersonalSchedule'),
	(1,'PersonalScheduleLookup'),
	(1,'PositionTypeEdit'),
	(1,'PositionTypes'),
	(1,'Registration'),
	(1,'ReservationAdd'),
	(1,'ReservationDelete'),
	(1,'ReservationEdit'),
	(1,'ReservationOffering'),
	(1,'Reservations'),
	(1,'RoleEdit'),
	(1,'Roles'),
	(1,'RoomAvailability'),
	(1,'RoomDelete'),
	(1,'RoomDepartments'),
	(1,'RoomDetail'),
	(1,'RoomDetailAvailability'),
	(1,'RoomDetailEventAvailability'),
	(1,'RoomDetailPeriodPreferences'),
	(1,'RoomEdit'),
	(1,'RoomEditAvailability'),
	(1,'RoomEditChangeCapacity'),
	(1,'RoomEditChangeControll'),
	(1,'RoomEditChangeEventProperties'),
	(1,'RoomEditChangeExaminationStatus'),
	(1,'RoomEditChangeExternalId'),
	(1,'RoomEditChangeRoomProperties'),
	(1,'RoomEditChangeType'),
	(1,'RoomEditEventAvailability'),
	(1,'RoomEditFeatures'),
	(1,'RoomEditGlobalFeatures'),
	(1,'RoomEditGlobalGroups'),
	(1,'RoomEditGroups'),
	(1,'RoomEditPreference'),
	(1,'RoomFeatureTypeEdit'),
	(1,'RoomFeatureTypes'),
	(1,'RoomFeatures'),
	(1,'RoomFeaturesExportPdf'),
	(1,'RoomGroups'),
	(1,'RoomGroupsExportPdf'),
	(1,'RoomTypes'),
	(1,'Rooms'),
	(1,'RoomsExportCsv'),
	(1,'RoomsExportPdf'),
	(1,'SchedulingAssistant'),
	(1,'SchedulingDashboard'),
	(1,'SchedulingSubpartDetail'),
	(1,'SchedulingSubpartDetailClearClassPreferences'),
	(1,'SchedulingSubpartEdit'),
	(1,'SchedulingSubpartEditClearPreferences'),
	(1,'ScriptEdit'),
	(1,'Scripts'),
	(1,'SessionDefaultCurrent'),
	(1,'SessionIndependent'),
	(1,'SessionRollForward'),
	(1,'SettingsAdmin'),
	(1,'SettingsUser'),
	(1,'SolutionChanges'),
	(1,'SolutionReports'),
	(1,'Solver'),
	(1,'SolverConfigurations'),
	(1,'SolverGroups'),
	(1,'SolverLog'),
	(1,'SolverParameterGroups'),
	(1,'SolverParameters'),
	(1,'SolverSolutionExportCsv'),
	(1,'SolverSolutionExportXml'),
	(1,'SolverSolutionSave'),
	(1,'SponsoringOrganizationAdd'),
	(1,'SponsoringOrganizationDelete'),
	(1,'SponsoringOrganizationEdit'),
	(1,'SponsoringOrganizations'),
	(1,'StandardEventNotes'),
	(1,'StandardEventNotesDepartmentEdit'),
	(1,'StandardEventNotesGlobalEdit'),
	(1,'StandardEventNotesSessionEdit'),
	(1,'StatusIndependent'),
	(1,'StatusTypes'),
	(1,'StudentEnrollments'),
	(1,'StudentGroupEdit'),
	(1,'StudentGroups'),
	(1,'StudentScheduling'),
	(1,'StudentSchedulingAdmin'),
	(1,'StudentSchedulingAdvisor'),
	(1,'StudentSchedulingStatusTypeEdit'),
	(1,'StudentSchedulingStatusTypes'),
	(1,'StudentSectioningSolver'),
	(1,'StudentSectioningSolverDashboard'),
	(1,'StudentSectioningSolverLog'),
	(1,'SubjectAreaAdd'),
	(1,'SubjectAreaChangeDepartment'),
	(1,'SubjectAreaDelete'),
	(1,'SubjectAreaEdit'),
	(1,'SubjectAreas'),
	(1,'Suggestions'),
	(1,'TestHQL'),
	(1,'TimePatterns'),
	(1,'TimetableGrid'),
	(1,'TimetableManagerAdd'),
	(1,'TimetableManagerDelete'),
	(1,'TimetableManagerEdit'),
	(1,'TimetableManagers'),
	(1,'Timetables'),
	(1,'TimetablesSolutionChangeNote'),
	(1,'TimetablesSolutionCommit'),
	(1,'TimetablesSolutionDelete'),
	(1,'TimetablesSolutionExportCsv'),
	(1,'TimetablesSolutionLoad'),
	(1,'TimetablesSolutionLoadEmpty'),
	(1,'TravelTimesLoad'),
	(1,'TravelTimesSave'),
	(1,'Users'),
	(21,'AddCourseOffering'),
	(21,'AddNonUnivLocation'),
	(21,'AddSpecialUseRoom'),
	(21,'AddSpecialUseRoomExternalRoom'),
	(21,'AssignInstructors'),
	(21,'AssignInstructorsClass'),
	(21,'AssignedClasses'),
	(21,'AssignmentHistory'),
	(21,'CanUseHardDistributionPrefs'),
	(21,'CanUseHardPeriodPrefs'),
	(21,'CanUseHardRoomPrefs'),
	(21,'CanUseHardTimePrefs'),
	(21,'ChangePassword'),
	(21,'ClassAssignments'),
	(21,'ClassAssignmentsExportCsv'),
	(21,'ClassAssignmentsExportPdf'),
	(21,'ClassDetail'),
	(21,'ClassEdit'),
	(21,'ClassEditClearPreferences'),
	(21,'Classes'),
	(21,'ClassesExportPDF'),
	(21,'ConflictStatistics'),
	(21,'ConsentApproval'),
	(21,'CourseTimetabling'),
	(21,'CourseTimetablingAudit'),
	(21,'CurriculumAdd'),
	(21,'CurriculumDelete'),
	(21,'CurriculumDetail'),
	(21,'CurriculumEdit'),
	(21,'CurriculumProjectionRulesDetail'),
	(21,'CurriculumView'),
	(21,'DepartmenalRoomFeatureDelete'),
	(21,'DepartmenalRoomFeatureEdit'),
	(21,'DepartmenalRoomGroupDelete'),
	(21,'DepartmenalRoomGroupEdit'),
	(21,'DepartmentRoomFeatureAdd'),
	(21,'DepartmentRoomGroupAdd'),
	(21,'DistributionPreferenceAdd'),
	(21,'DistributionPreferenceClass'),
	(21,'DistributionPreferenceDelete'),
	(21,'DistributionPreferenceDetail'),
	(21,'DistributionPreferenceEdit'),
	(21,'DistributionPreferenceExam'),
	(21,'DistributionPreferenceSubpart'),
	(21,'DistributionPreferences'),
	(21,'EditCourseOffering'),
	(21,'EditCourseOfferingCoordinators'),
	(21,'EditRoomDepartments'),
	(21,'EventAddCourseRelated'),
	(21,'EventAddSpecial'),
	(21,'EventDate'),
	(21,'EventDetail'),
	(21,'EventEdit'),
	(21,'EventLocation'),
	(21,'EventLookupSchedule'),
	(21,'EventMeetingCancel'),
	(21,'EventMeetingDelete'),
	(21,'EventMeetingEdit'),
	(21,'Events'),
	(21,'ExaminationAdd'),
	(21,'ExaminationClone'),
	(21,'ExaminationDelete'),
	(21,'ExaminationDetail'),
	(21,'ExaminationDistributionPreferenceAdd'),
	(21,'ExaminationDistributionPreferenceDelete'),
	(21,'ExaminationDistributionPreferenceDetail'),
	(21,'ExaminationDistributionPreferenceEdit'),
	(21,'ExaminationDistributionPreferences'),
	(21,'ExaminationEdit'),
	(21,'ExaminationEditClearPreferences'),
	(21,'ExaminationPdfReports'),
	(21,'ExaminationSchedule'),
	(21,'Examinations'),
	(21,'HQLReports'),
	(21,'HQLReportsCourses'),
	(21,'HasRole'),
	(21,'Inquiry'),
	(21,'InstrOfferingConfigAdd'),
	(21,'InstrOfferingConfigDelete'),
	(21,'InstrOfferingConfigEdit'),
	(21,'InstrOfferingConfigEditDepartment'),
	(21,'InstrOfferingConfigEditSubpart'),
	(21,'InstructionalOfferingCrossLists'),
	(21,'InstructionalOfferingDetail'),
	(21,'InstructionalOfferings'),
	(21,'InstructionalOfferingsExportPDF'),
	(21,'InstructionalOfferingsWorksheetPDF'),
	(21,'InstructorAdd'),
	(21,'InstructorDelete'),
	(21,'InstructorDetail'),
	(21,'InstructorEdit'),
	(21,'InstructorEditClearPreferences'),
	(21,'InstructorPreferences'),
	(21,'Instructors'),
	(21,'InstructorsExportPdf'),
	(21,'ManageInstructors'),
	(21,'MultipleClassSetup'),
	(21,'MultipleClassSetupClass'),
	(21,'MultipleClassSetupDepartment'),
	(21,'NonUniversityLocationDelete'),
	(21,'NonUniversityLocationEdit'),
	(21,'NotAssignedClasses'),
	(21,'OfferingCanLock'),
	(21,'OfferingCanUnlock'),
	(21,'OfferingEnrollments'),
	(21,'OfferingMakeNotOffered'),
	(21,'OfferingMakeOffered'),
	(21,'PersonalSchedule'),
	(21,'PersonalScheduleLookup'),
	(21,'ReservationAdd'),
	(21,'ReservationDelete'),
	(21,'ReservationEdit'),
	(21,'ReservationOffering'),
	(21,'Reservations'),
	(21,'RoomAvailability'),
	(21,'RoomDepartments'),
	(21,'RoomDetail'),
	(21,'RoomDetailAvailability'),
	(21,'RoomEditAvailability'),
	(21,'RoomEditChangeCapacity'),
	(21,'RoomEditChangeExternalId'),
	(21,'RoomEditChangeRoomProperties'),
	(21,'RoomEditChangeType'),
	(21,'RoomEditFeatures'),
	(21,'RoomEditGroups'),
	(21,'RoomEditPreference'),
	(21,'RoomFeatures'),
	(21,'RoomFeaturesExportPdf'),
	(21,'RoomGroups'),
	(21,'RoomGroupsExportPdf'),
	(21,'Rooms'),
	(21,'RoomsExportCsv'),
	(21,'RoomsExportPdf'),
	(21,'SchedulingAssistant'),
	(21,'SchedulingDashboard'),
	(21,'SchedulingSubpartDetail'),
	(21,'SchedulingSubpartDetailClearClassPreferences'),
	(21,'SchedulingSubpartEdit'),
	(21,'SchedulingSubpartEditClearPreferences'),
	(21,'SessionDefaultFirstFuture'),
	(21,'SettingsUser'),
	(21,'SolutionChanges'),
	(21,'SolutionReports'),
	(21,'Solver'),
	(21,'SolverLog'),
	(21,'SolverSolutionExportCsv'),
	(21,'SolverSolutionSave'),
	(21,'StudentEnrollments'),
	(21,'Suggestions'),
	(21,'TimetableGrid'),
	(21,'Timetables'),
	(21,'TimetablesSolutionChangeNote'),
	(21,'TimetablesSolutionCommit'),
	(21,'TimetablesSolutionDelete'),
	(21,'TimetablesSolutionExportCsv'),
	(21,'TimetablesSolutionLoad'),
	(21,'TimetablesSolutionLoadEmpty'),
	(41,'CanUseHardDistributionPrefs'),
	(41,'CanUseHardPeriodPrefs'),
	(41,'CanUseHardRoomPrefs'),
	(41,'CanUseHardTimePrefs'),
	(41,'ChangePassword'),
	(41,'ClassAssignments'),
	(41,'ClassAssignmentsExportCsv'),
	(41,'ClassAssignmentsExportPdf'),
	(41,'ClassDetail'),
	(41,'Classes'),
	(41,'ClassesExportPDF'),
	(41,'CurriculumDetail'),
	(41,'CurriculumProjectionRulesDetail'),
	(41,'CurriculumView'),
	(41,'DepartmentIndependent'),
	(41,'DistributionPreferenceDetail'),
	(41,'DistributionPreferences'),
	(41,'EventAddSpecial'),
	(41,'EventDate'),
	(41,'EventDetail'),
	(41,'EventEdit'),
	(41,'EventLocation'),
	(41,'EventMeetingCancel'),
	(41,'EventMeetingDelete'),
	(41,'EventMeetingEdit'),
	(41,'Events'),
	(41,'ExaminationDetail'),
	(41,'ExaminationDistributionPreferenceDetail'),
	(41,'ExaminationDistributionPreferences'),
	(41,'ExaminationPdfReports'),
	(41,'ExaminationSchedule'),
	(41,'Examinations'),
	(41,'HasRole'),
	(41,'Inquiry'),
	(41,'InstructionalOfferingDetail'),
	(41,'InstructionalOfferings'),
	(41,'InstructionalOfferingsExportPDF'),
	(41,'InstructionalOfferingsWorksheetPDF'),
	(41,'InstructorDetail'),
	(41,'Instructors'),
	(41,'InstructorsExportPdf'),
	(41,'OfferingEnrollments'),
	(41,'RoomAvailability'),
	(41,'RoomDetail'),
	(41,'RoomDetailAvailability'),
	(41,'RoomDetailPeriodPreferences'),
	(41,'RoomFeatures'),
	(41,'RoomFeaturesExportPdf'),
	(41,'RoomGroups'),
	(41,'RoomGroupsExportPdf'),
	(41,'Rooms'),
	(41,'RoomsExportCsv'),
	(41,'RoomsExportPdf'),
	(41,'SchedulingAssistant'),
	(41,'SchedulingDashboard'),
	(41,'SchedulingSubpartDetail'),
	(41,'SessionDefaultCurrent'),
	(41,'SessionIndependentIfNoSessionGiven'),
	(41,'SettingsUser'),
	(41,'StudentEnrollments'),
	(61,'AssignedExaminations'),
	(61,'CanUseHardDistributionPrefs'),
	(61,'CanUseHardPeriodPrefs'),
	(61,'CanUseHardRoomPrefs'),
	(61,'CanUseHardTimePrefs'),
	(61,'ChangePassword'),
	(61,'ClassAssignments'),
	(61,'ClassAssignmentsExportCsv'),
	(61,'ClassAssignmentsExportPdf'),
	(61,'DepartmentIndependent'),
	(61,'DistributionPreferenceExam'),
	(61,'EditRoomDepartmentsExams'),
	(61,'EditRoomDepartmentsFinalExams'),
	(61,'EditRoomDepartmentsMidtermExams'),
	(61,'EventAddSpecial'),
	(61,'EventDate'),
	(61,'EventDetail'),
	(61,'EventEdit'),
	(61,'EventLocation'),
	(61,'EventMeetingCancel'),
	(61,'EventMeetingDelete'),
	(61,'EventMeetingEdit'),
	(61,'Events'),
	(61,'ExaminationAdd'),
	(61,'ExaminationAssignment'),
	(61,'ExaminationAssignmentChanges'),
	(61,'ExaminationClone'),
	(61,'ExaminationConflictStatistics'),
	(61,'ExaminationDelete'),
	(61,'ExaminationDetail'),
	(61,'ExaminationDistributionPreferenceAdd'),
	(61,'ExaminationDistributionPreferenceDelete'),
	(61,'ExaminationDistributionPreferenceDetail'),
	(61,'ExaminationDistributionPreferenceEdit'),
	(61,'ExaminationDistributionPreferences'),
	(61,'ExaminationEdit'),
	(61,'ExaminationEditClearPreferences'),
	(61,'ExaminationPdfReports'),
	(61,'ExaminationReports'),
	(61,'ExaminationSchedule'),
	(61,'ExaminationSolver'),
	(61,'ExaminationSolverLog'),
	(61,'ExaminationTimetable'),
	(61,'ExaminationTimetabling'),
	(61,'Examinations'),
	(61,'HQLReports'),
	(61,'HQLReportsExaminations'),
	(61,'HasRole'),
	(61,'Inquiry'),
	(61,'InstructorDetail'),
	(61,'Instructors'),
	(61,'InstructorsExportPdf'),
	(61,'NotAssignedExaminations'),
	(61,'RoomDetail'),
	(61,'RoomDetailPeriodPreferences'),
	(61,'RoomEdit'),
	(61,'RoomEditChangeExaminationStatus'),
	(61,'RoomFeatures'),
	(61,'RoomFeaturesExportPdf'),
	(61,'RoomGroups'),
	(61,'RoomGroupsExportPdf'),
	(61,'Rooms'),
	(61,'RoomsExportCsv'),
	(61,'RoomsExportPdf'),
	(61,'SessionDefaultFirstExamination'),
	(61,'SettingsUser'),
	(81,'AddNonUnivLocation'),
	(81,'AddSpecialUseRoom'),
	(81,'AddSpecialUseRoomExternalRoom'),
	(81,'CanUseHardDistributionPrefs'),
	(81,'CanUseHardPeriodPrefs'),
	(81,'CanUseHardRoomPrefs'),
	(81,'CanUseHardTimePrefs'),
	(81,'ChangePassword'),
	(81,'EventAddCourseRelated'),
	(81,'EventAddSpecial'),
	(81,'EventAddUnavailable'),
	(81,'EventDate'),
	(81,'EventDetail'),
	(81,'EventEdit'),
	(81,'EventLocation'),
	(81,'EventLocationApprove'),
	(81,'EventLocationOverbook'),
	(81,'EventLocationUnavailable'),
	(81,'EventLookupContact'),
	(81,'EventMeetingApprove'),
	(81,'EventMeetingCancel'),
	(81,'EventMeetingDelete'),
	(81,'EventMeetingEdit'),
	(81,'EventMeetingInquire'),
	(81,'EventRoomTypeEdit'),
	(81,'EventRoomTypes'),
	(81,'EventStatusEdit'),
	(81,'EventStatuses'),
	(81,'Events'),
	(81,'ExaminationSchedule'),
	(81,'HQLReports'),
	(81,'HQLReportsEvents'),
	(81,'HasRole'),
	(81,'Inquiry'),
	(81,'InstructorRoleEdit'),
	(81,'InstructorRoles'),
	(81,'NonUniversityLocationDelete'),
	(81,'NonUniversityLocationEdit'),
	(81,'RoomDetail'),
	(81,'RoomDetailEventAvailability'),
	(81,'RoomEditChangeCapacity'),
	(81,'RoomEditChangeEventProperties'),
	(81,'RoomEditChangeExternalId'),
	(81,'RoomEditChangeRoomProperties'),
	(81,'RoomEditChangeType'),
	(81,'RoomEditEventAvailability'),
	(81,'RoomFeatures'),
	(81,'RoomFeaturesExportPdf'),
	(81,'RoomGroups'),
	(81,'RoomGroupsExportPdf'),
	(81,'Rooms'),
	(81,'RoomsExportCsv'),
	(81,'RoomsExportPdf'),
	(81,'SessionDefaultCurrent'),
	(81,'SettingsUser'),
	(81,'StandardEventNotes'),
	(81,'StandardEventNotesDepartmentEdit'),
	(101,'CanUseHardDistributionPrefs'),
	(101,'CanUseHardPeriodPrefs'),
	(101,'CanUseHardRoomPrefs'),
	(101,'CanUseHardTimePrefs'),
	(101,'ChangePassword'),
	(101,'CurriculumAdd'),
	(101,'CurriculumAdmin'),
	(101,'CurriculumDelete'),
	(101,'CurriculumDetail'),
	(101,'CurriculumEdit'),
	(101,'CurriculumMerge'),
	(101,'CurriculumProjectionRulesDetail'),
	(101,'CurriculumProjectionRulesEdit'),
	(101,'CurriculumView'),
	(101,'DepartmentIndependent'),
	(101,'EventAddSpecial'),
	(101,'EventDate'),
	(101,'EventDetail'),
	(101,'EventEdit'),
	(101,'EventLocation'),
	(101,'EventMeetingCancel'),
	(101,'EventMeetingDelete'),
	(101,'EventMeetingEdit'),
	(101,'Events'),
	(101,'ExaminationSchedule'),
	(101,'HasRole'),
	(101,'Inquiry'),
	(101,'RoomAvailability'),
	(101,'SessionDefaultCurrent'),
	(101,'SettingsUser'),
	(1310680,'CanUseHardDistributionPrefs'),
	(1310680,'CanUseHardPeriodPrefs'),
	(1310680,'CanUseHardRoomPrefs'),
	(1310680,'CanUseHardTimePrefs'),
	(1310680,'ChangePassword'),
	(1310680,'CourseRequests'),
	(1310680,'DepartmentIndependent'),
	(1310680,'EventAddSpecial'),
	(1310680,'EventDate'),
	(1310680,'EventDetail'),
	(1310680,'EventEdit'),
	(1310680,'EventLocation'),
	(1310680,'EventLookupSchedule'),
	(1310680,'EventMeetingCancel'),
	(1310680,'EventMeetingDelete'),
	(1310680,'EventMeetingEdit'),
	(1310680,'Events'),
	(1310680,'ExaminationSchedule'),
	(1310680,'HasRole'),
	(1310680,'Inquiry'),
	(1310680,'OfferingEnrollments'),
	(1310680,'PersonalSchedule'),
	(1310680,'PersonalScheduleLookup'),
	(1310680,'SchedulingAssistant'),
	(1310680,'SchedulingDashboard'),
	(1310680,'SessionDefaultCurrent'),
	(1310680,'SettingsUser'),
	(1310680,'StudentEnrollments'),
	(1310680,'StudentSchedulingAdvisor'),
	(1408981,'ChangePassword'),
	(1408981,'EventAddSpecial'),
	(1408981,'EventDate'),
	(1408981,'EventDetail'),
	(1408981,'EventEdit'),
	(1408981,'EventLocation'),
	(1408981,'EventMeetingCancel'),
	(1408981,'EventMeetingDelete'),
	(1408981,'EventMeetingEdit'),
	(1408981,'Events'),
	(1408981,'Inquiry'),
	(1408981,'SchedulingAssistant'),
	(1408982,'ChangePassword'),
	(1408982,'CourseRequests'),
	(1408982,'EventAddSpecial'),
	(1408982,'EventDate'),
	(1408982,'EventDetail'),
	(1408982,'EventEdit'),
	(1408982,'EventLocation'),
	(1408982,'EventMeetingCancel'),
	(1408982,'EventMeetingDelete'),
	(1408982,'EventMeetingEdit'),
	(1408982,'Events'),
	(1408982,'Inquiry'),
	(1408982,'PersonalSchedule'),
	(1408982,'SchedulingAssistant'),
	(1408982,'SessionDefaultCurrent'),
	(1408982,'StudentEnrollments'),
	(1408983,'ChangePassword'),
	(1408983,'ConsentApproval'),
	(1408983,'EventAddSpecial'),
	(1408983,'EventDate'),
	(1408983,'EventDetail'),
	(1408983,'EventEdit'),
	(1408983,'EventLocation'),
	(1408983,'EventMeetingCancel'),
	(1408983,'EventMeetingDelete'),
	(1408983,'EventMeetingEdit'),
	(1408983,'Events'),
	(1408983,'Inquiry'),
	(1408983,'OfferingEnrollments'),
	(1408983,'PersonalSchedule'),
	(1408983,'SchedulingAssistant'),
	(1408983,'SchedulingDashboard'),
	(1408983,'SessionDefaultCurrent'),
	(1441748,'AcademicAreaEdit'),
	(1441748,'AcademicAreas'),
	(1441748,'AcademicClassificationEdit'),
	(1441748,'AcademicClassifications'),
	(1441748,'AcademicSessionEdit'),
	(1441748,'AcademicSessions'),
	(1441748,'AddCourseOffering'),
	(1441748,'AddNonUnivLocation'),
	(1441748,'AddRoom'),
	(1441748,'AddSpecialUseRoom'),
	(1441748,'AddSpecialUseRoomExternalRoom'),
	(1441748,'AssignInstructors'),
	(1441748,'AssignInstructorsClass'),
	(1441748,'AssignedClasses'),
	(1441748,'AssignedExaminations'),
	(1441748,'AssignmentHistory'),
	(1441748,'BuildingAdd'),
	(1441748,'BuildingDelete'),
	(1441748,'BuildingEdit'),
	(1441748,'BuildingExportPdf'),
	(1441748,'BuildingList'),
	(1441748,'BuildingUpdateData'),
	(1441748,'CanSelectSolverServer'),
	(1441748,'CanUseHardDistributionPrefs'),
	(1441748,'CanUseHardPeriodPrefs'),
	(1441748,'CanUseHardRoomPrefs'),
	(1441748,'CanUseHardTimePrefs'),
	(1441748,'ChangePassword'),
	(1441748,'ClassAssignment'),
	(1441748,'ClassAssignments'),
	(1441748,'ClassAssignmentsExportCsv'),
	(1441748,'ClassAssignmentsExportPdf'),
	(1441748,'ClassDetail'),
	(1441748,'ClassEdit'),
	(1441748,'ClassEditClearPreferences'),
	(1441748,'Classes'),
	(1441748,'ClassesExportPDF'),
	(1441748,'ConflictStatistics'),
	(1441748,'ConsentApproval'),
	(1441748,'CourseCreditFormats'),
	(1441748,'CourseCreditTypes'),
	(1441748,'CourseCreditUnits'),
	(1441748,'CourseRequests'),
	(1441748,'CourseTimetabling'),
	(1441748,'CourseTimetablingAudit'),
	(1441748,'CourseTypes'),
	(1441748,'CurriculumAdd'),
	(1441748,'CurriculumAdmin'),
	(1441748,'CurriculumDelete'),
	(1441748,'CurriculumDetail'),
	(1441748,'CurriculumEdit'),
	(1441748,'CurriculumMerge'),
	(1441748,'CurriculumProjectionRulesDetail'),
	(1441748,'CurriculumProjectionRulesEdit'),
	(1441748,'CurriculumView'),
	(1441748,'DatePatterns'),
	(1441748,'DepartmenalRoomFeatureDelete'),
	(1441748,'DepartmenalRoomFeatureEdit'),
	(1441748,'DepartmenalRoomGroupDelete'),
	(1441748,'DepartmenalRoomGroupEdit'),
	(1441748,'DepartmentAdd'),
	(1441748,'DepartmentDelete'),
	(1441748,'DepartmentEdit'),
	(1441748,'DepartmentEditChangeExternalManager'),
	(1441748,'DepartmentIndependent'),
	(1441748,'DepartmentRoomFeatureAdd'),
	(1441748,'DepartmentRoomGroupAdd'),
	(1441748,'Departments'),
	(1441748,'DistributionPreferenceAdd'),
	(1441748,'DistributionPreferenceClass'),
	(1441748,'DistributionPreferenceDelete'),
	(1441748,'DistributionPreferenceDetail'),
	(1441748,'DistributionPreferenceEdit'),
	(1441748,'DistributionPreferenceExam'),
	(1441748,'DistributionPreferenceSubpart'),
	(1441748,'DistributionPreferences'),
	(1441748,'DistributionTypes'),
	(1441748,'EditCourseOffering'),
	(1441748,'EditCourseOfferingCoordinators'),
	(1441748,'EditRoomDepartments'),
	(1441748,'EditRoomDepartmentsExams'),
	(1441748,'EditRoomDepartmentsFinalExams'),
	(1441748,'EditRoomDepartmentsMidtermExams'),
	(1441748,'EnrollmentAuditPDFReports'),
	(1441748,'EventAddCourseRelated'),
	(1441748,'EventAddSpecial'),
	(1441748,'EventAddUnavailable'),
	(1441748,'EventAnyLocation'),
	(1441748,'EventApprovePast'),
	(1441748,'EventDate'),
	(1441748,'EventDetail'),
	(1441748,'EventEdit'),
	(1441748,'EventLocation'),
	(1441748,'EventLocationApprove'),
	(1441748,'EventLocationOverbook'),
	(1441748,'EventLocationUnavailable'),
	(1441748,'EventLookupContact'),
	(1441748,'EventLookupSchedule'),
	(1441748,'EventMeetingApprove'),
	(1441748,'EventMeetingCancel'),
	(1441748,'EventMeetingDelete'),
	(1441748,'EventMeetingEdit'),
	(1441748,'EventMeetingInquire'),
	(1441748,'EventRoomTypeEdit'),
	(1441748,'EventRoomTypes'),
	(1441748,'EventStatusEdit'),
	(1441748,'EventStatuses'),
	(1441748,'Events'),
	(1441748,'ExamTypes'),
	(1441748,'ExaminationAdd'),
	(1441748,'ExaminationAssignment'),
	(1441748,'ExaminationAssignmentChanges'),
	(1441748,'ExaminationClone'),
	(1441748,'ExaminationConflictStatistics'),
	(1441748,'ExaminationDelete'),
	(1441748,'ExaminationDetail'),
	(1441748,'ExaminationDistributionPreferenceAdd'),
	(1441748,'ExaminationDistributionPreferenceDelete'),
	(1441748,'ExaminationDistributionPreferenceDetail'),
	(1441748,'ExaminationDistributionPreferenceEdit'),
	(1441748,'ExaminationDistributionPreferences'),
	(1441748,'ExaminationEdit'),
	(1441748,'ExaminationEditClearPreferences'),
	(1441748,'ExaminationPdfReports'),
	(1441748,'ExaminationPeriods'),
	(1441748,'ExaminationReports'),
	(1441748,'ExaminationSchedule'),
	(1441748,'ExaminationSolver'),
	(1441748,'ExaminationSolverLog'),
	(1441748,'ExaminationTimetable'),
	(1441748,'ExaminationTimetabling'),
	(1441748,'Examinations'),
	(1441748,'ExtendedDatePatterns'),
	(1441748,'ExtendedTimePatterns'),
	(1441748,'GlobalRoomFeatureAdd'),
	(1441748,'GlobalRoomFeatureDelete'),
	(1441748,'GlobalRoomFeatureEdit'),
	(1441748,'GlobalRoomGroupAdd'),
	(1441748,'GlobalRoomGroupDelete'),
	(1441748,'GlobalRoomGroupEdit'),
	(1441748,'GlobalRoomGroupEditSetDefault'),
	(1441748,'HQLReports'),
	(1441748,'HQLReportsAdminOnly'),
	(1441748,'HQLReportsAdministration'),
	(1441748,'HQLReportsCourses'),
	(1441748,'HQLReportsEvents'),
	(1441748,'HQLReportsExaminations'),
	(1441748,'HQLReportsStudents'),
	(1441748,'HasRole'),
	(1441748,'Inquiry'),
	(1441748,'InstrOfferingConfigAdd'),
	(1441748,'InstrOfferingConfigDelete'),
	(1441748,'InstrOfferingConfigEdit'),
	(1441748,'InstrOfferingConfigEditDepartment'),
	(1441748,'InstrOfferingConfigEditSubpart'),
	(1441748,'InstructionalOfferingCrossLists'),
	(1441748,'InstructionalOfferingDetail'),
	(1441748,'InstructionalOfferings'),
	(1441748,'InstructionalOfferingsExportPDF'),
	(1441748,'InstructionalOfferingsWorksheetPDF'),
	(1441748,'InstructionalTypes'),
	(1441748,'InstructorAdd'),
	(1441748,'InstructorDelete'),
	(1441748,'InstructorDetail'),
	(1441748,'InstructorEdit'),
	(1441748,'InstructorEditClearPreferences'),
	(1441748,'InstructorPreferences'),
	(1441748,'InstructorRoleEdit'),
	(1441748,'InstructorRoles'),
	(1441748,'Instructors'),
	(1441748,'InstructorsExportPdf'),
	(1441748,'IsAdmin'),
	(1441748,'LastChanges'),
	(1441748,'MajorEdit'),
	(1441748,'Majors'),
	(1441748,'ManageInstructors'),
	(1441748,'ManageSolvers'),
	(1441748,'MinorEdit'),
	(1441748,'Minors'),
	(1441748,'MultipleClassSetup'),
	(1441748,'MultipleClassSetupClass'),
	(1441748,'MultipleClassSetupDepartment'),
	(1441748,'NonUniversityLocationDelete'),
	(1441748,'NonUniversityLocationEdit'),
	(1441748,'NotAssignedClasses'),
	(1441748,'NotAssignedExaminations'),
	(1441748,'OfferingCanLock'),
	(1441748,'OfferingCanUnlock'),
	(1441748,'OfferingConsentTypes'),
	(1441748,'OfferingDelete'),
	(1441748,'OfferingEnrollments'),
	(1441748,'OfferingMakeNotOffered'),
	(1441748,'OfferingMakeOffered'),
	(1441748,'Permissions'),
	(1441748,'PersonalSchedule'),
	(1441748,'PersonalScheduleLookup'),
	(1441748,'PositionTypes'),
	(1441748,'ReservationAdd'),
	(1441748,'ReservationDelete'),
	(1441748,'ReservationEdit'),
	(1441748,'ReservationOffering'),
	(1441748,'Reservations'),
	(1441748,'Roles'),
	(1441748,'RoomAvailability'),
	(1441748,'RoomDelete'),
	(1441748,'RoomDepartments'),
	(1441748,'RoomDetail'),
	(1441748,'RoomDetailAvailability'),
	(1441748,'RoomDetailEventAvailability'),
	(1441748,'RoomDetailPeriodPreferences'),
	(1441748,'RoomEdit'),
	(1441748,'RoomEditAvailability'),
	(1441748,'RoomEditChangeCapacity'),
	(1441748,'RoomEditChangeControll'),
	(1441748,'RoomEditChangeEventProperties'),
	(1441748,'RoomEditChangeExaminationStatus'),
	(1441748,'RoomEditChangeExternalId'),
	(1441748,'RoomEditChangeRoomProperties'),
	(1441748,'RoomEditChangeType'),
	(1441748,'RoomEditEventAvailability'),
	(1441748,'RoomEditFeatures'),
	(1441748,'RoomEditGlobalFeatures'),
	(1441748,'RoomEditGlobalGroups'),
	(1441748,'RoomEditGroups'),
	(1441748,'RoomEditPreference'),
	(1441748,'RoomFeatureTypes'),
	(1441748,'RoomFeatures'),
	(1441748,'RoomFeaturesExportPdf'),
	(1441748,'RoomGroups'),
	(1441748,'RoomGroupsExportPdf'),
	(1441748,'Rooms'),
	(1441748,'RoomsExportCsv'),
	(1441748,'RoomsExportPdf'),
	(1441748,'SchedulingAssistant'),
	(1441748,'SchedulingDashboard'),
	(1441748,'SchedulingSubpartDetail'),
	(1441748,'SchedulingSubpartDetailClearClassPreferences'),
	(1441748,'SchedulingSubpartEdit'),
	(1441748,'SchedulingSubpartEditClearPreferences'),
	(1441748,'Scripts'),
	(1441748,'SessionDefaultCurrent'),
	(1441748,'SettingsUser'),
	(1441748,'SolutionChanges'),
	(1441748,'SolutionReports'),
	(1441748,'Solver'),
	(1441748,'SolverGroups'),
	(1441748,'SolverLog'),
	(1441748,'SolverSolutionExportCsv'),
	(1441748,'SolverSolutionExportXml'),
	(1441748,'SolverSolutionSave'),
	(1441748,'SponsoringOrganizations'),
	(1441748,'StandardEventNotes'),
	(1441748,'StandardEventNotesDepartmentEdit'),
	(1441748,'StandardEventNotesSessionEdit'),
	(1441748,'StatusIndependent'),
	(1441748,'StudentEnrollments'),
	(1441748,'StudentGroupEdit'),
	(1441748,'StudentGroups'),
	(1441748,'StudentScheduling'),
	(1441748,'StudentSchedulingAdmin'),
	(1441748,'StudentSchedulingAdvisor'),
	(1441748,'StudentSchedulingStatusTypes'),
	(1441748,'StudentSectioningSolver'),
	(1441748,'StudentSectioningSolverDashboard'),
	(1441748,'StudentSectioningSolverLog'),
	(1441748,'SubjectAreaAdd'),
	(1441748,'SubjectAreaChangeDepartment'),
	(1441748,'SubjectAreaDelete'),
	(1441748,'SubjectAreaEdit'),
	(1441748,'SubjectAreas'),
	(1441748,'Suggestions'),
	(1441748,'TimePatterns'),
	(1441748,'TimetableGrid'),
	(1441748,'TimetableManagerAdd'),
	(1441748,'TimetableManagerDelete'),
	(1441748,'TimetableManagerEdit'),
	(1441748,'TimetableManagers'),
	(1441748,'Timetables'),
	(1441748,'TimetablesSolutionChangeNote'),
	(1441748,'TimetablesSolutionCommit'),
	(1441748,'TimetablesSolutionDelete'),
	(1441748,'TimetablesSolutionExportCsv'),
	(1441748,'TimetablesSolutionLoad'),
	(1441748,'TimetablesSolutionLoadEmpty'),
	(1441748,'TravelTimesLoad'),
	(1441748,'TravelTimesSave'),
	(1507282,'Events'),
	(1507282,'SchedulingAssistant');

insert into `roles` values
	(1,'Sysadmin','System Administrator',1,1,0),
	(21,'Dept Sched Mgr','Department Schedule Manager',1,1,0),
	(41,'View All','View All User',1,1,0),
	(61,'Exam Mgr','Examination Timetabling Manager',1,1,0),
	(81,'Event Mgr','Event Manager',1,1,0),
	(101,'Curriculum Mgr','Curriculum Manager',1,1,0),
	(1310680,'Advisor','Student Advisor',1,1,0),
	(1408981,'No Role','No Role',0,1,0),
	(1408982,'Student','Student',0,1,0),
	(1408983,'Instructor','Instructor',0,1,0),
	(1441748,'Administrator','Session Administrator',1,1,0),
	(1507282,'Anonymous','Anonymous',0,1,0);

insert into `room_feature` values
	(123,'global','Audio Recording','audioRecording',NULL,NULL,'AudRec',239259,NULL),
	(125,'global','Computer','puccComputer',NULL,NULL,'Comp',239259,NULL),
	(437,'global','Fixed Seating','fixedSeating',NULL,NULL,'FixSeat',239259,NULL),
	(438,'global','Computer Projection','computerProjection',NULL,NULL,'CompPr',239259,NULL),
	(440,'global','Tables and Chairs','seatingType','tablesAndChairs',NULL,'Tbls&Chrs',239259,NULL),
	(441,'global','Tablet Arm Chairs','seatingType','tabletArmChairs',NULL,'TblArmChr',239259,NULL),
	(442,'global','Theater Seats','seatingType','theaterSeats',NULL,'ThtrSeat',239259,NULL),
	(468,'global','Chalkboard < 20 Ft.','feetOfChalkboard','< 20',NULL,'Ch<20F',239259,NULL),
	(469,'global','Chalkboard >= 20 Ft.','feetOfChalkboard','>= 20',NULL,'Ch>=20F',239259,NULL);

insert into `room_type` values
	(425,'genClassroom','Classrooms',0,1),
	(426,'computingLab','Computing Laboratories',1,1),
	(427,'departmental','Additional Instructional Rooms',2,1),
	(428,'specialUse','Special Use Rooms',3,1),
	(429,'nonUniversity','Outside Locations',4,0);

insert into `saved_hql` values
	(1146845,'Not-assigned Classes','List all classes with a time pattern (i.e., classes that should not be Arrange Hours) which do not have a committed assignment.','select c.uniqueId as __Class, co.subjectAreaAbbv || \' \' || co.courseNbr as Course, s.itype.abbv || \' \' || c.sectionNumberCache as Section, co.title as Title from Class_ c inner join c.schedulingSubpart s inner join s.instrOfferingConfig.instructionalOffering.courseOfferings co where c.uniqueId in ( select x.uniqueId from Class_ x, TimePref p where (p.owner = x or p.owner = x.schedulingSubpart) and p.prefLevel.prefProlog = \'R\' ) and co.subjectArea.uniqueId in %SUBJECTS% and c.committedAssignment is null order by co.subjectAreaAbbv, co.courseNbr, s.itype.abbv, c.sectionNumberCache',1),
	(1146846,'Multi/No Room Classes','List all classes that either:<ul><li>either require more than one room</li><li>or require no room</li><li>or have zero room ratio</li></ul>','select c.uniqueId as __Class, co.subjectAreaAbbv || \' \' || co.courseNbr as Course, s.itype.abbv || \' \' || c.sectionNumberCache as Section, c.nbrRooms as Nbr_Rooms, c.roomRatio as Room_Ratio from Class_ c inner join c.schedulingSubpart s inner join s.instrOfferingConfig.instructionalOffering.courseOfferings co where co.subjectArea.uniqueId in %SUBJECTS% and (c.nbrRooms != 1 or c.roomRatio = 0.0) order by co.subjectAreaAbbv, co.courseNbr, s.itype.abbv, c.sectionNumberCache',1),
	(1146847,'Schedule Note Classes','List of all classes that has something entered in Student Schedule Note.','select c.uniqueId as __Class, co.subjectAreaAbbv || \' \' || co.courseNbr as Course, s.itype.abbv || \' \' || c.sectionNumberCache as Section, c.schedulePrintNote as Student_Schedule_Note from Class_ c inner join c.schedulingSubpart s inner join s.instrOfferingConfig.instructionalOffering.courseOfferings co where co.subjectArea.uniqueId in %SUBJECTS% and c.schedulePrintNote is not null order by co.subjectAreaAbbv, co.courseNbr, s.itype.abbv, c.sectionNumberCache',1),
	(1146848,'Request Notes Classes','List of all classes that has something entered in Requests / Notes to Schedule Manager.','select c.uniqueId as __Class, co.subjectAreaAbbv || \' \' || co.courseNbr as Course, s.itype.abbv || \' \' || c.sectionNumberCache as Section, c.notes as Notes_to_Schedule_Manager from Class_ c inner join c.schedulingSubpart s inner join s.instrOfferingConfig.instructionalOffering.courseOfferings co where co.subjectArea.uniqueId in %SUBJECTS% and c.notes is not null order by co.subjectAreaAbbv, co.courseNbr, s.itype.abbv, c.sectionNumberCache',1),
	(1146849,'Schedule Book Note Courses','List of all courses that has something entered in Schedule Book Note.','select co.instructionalOffering.uniqueId as __Offering, co.subjectAreaAbbv || \' \' || co.courseNbr as Course, co.scheduleBookNote as Schedule_Book_Note from CourseOffering co where co.subjectArea.uniqueId in %SUBJECTS% and co.scheduleBookNote is not null order by co.subjectAreaAbbv, co.courseNbr',1),
	(1146850,'New Courses','List of all courses that do not have external unique id and courses that have no title.','select co.instructionalOffering.uniqueId as __Offering, co.subjectAreaAbbv || \' \' || co.courseNbr as Course, co.title as Title from CourseOffering co where co.subjectArea.uniqueId in %SUBJECTS% and (co.externalUniqueId is null or co.title is null) order by co.subjectAreaAbbv, co.courseNbr',1),
	(1146851,'Arrange Hours Classes','List all classes that do not have a time pattern.','select c.uniqueId as __Class, co.subjectAreaAbbv || \' \' || co.courseNbr as Course, s.itype.abbv || \' \' || c.sectionNumberCache as Section, co.title as Title from Class_ c inner join c.schedulingSubpart s inner join s.instrOfferingConfig.instructionalOffering.courseOfferings co where c.uniqueId not in ( select x.uniqueId from Class_ x, TimePref p where (p.owner = x or p.owner = x.schedulingSubpart) and p.prefLevel.prefProlog = \'R\' ) and co.subjectArea.uniqueId in %SUBJECTS% order by co.subjectAreaAbbv, co.courseNbr, s.itype.abbv, c.sectionNumberCache',1),
	(1146852,'Cross-listed Courses','List all courses of a given subject area (or subject areas) that are cross-listed.','select co.instructionalOffering.uniqueId as __Offering, co.subjectAreaAbbv || \' \' || co.courseNbr as Course, co.title as Course_Title, ctr.subjectAreaAbbv || \' \' || ctr.courseNbr as Controlling, ctr.title as Controlling_Title from CourseOffering co, CourseOffering ctr where co.subjectArea in %SUBJECTS% and co.isControl is false and co.instructionalOffering = ctr.instructionalOffering and ctr.isControl is true order by co.subjectAreaAbbv, co.courseNbr',1),
	(1146853,'No-conflict Instructors','List of instructors (and their classes) that are not checked for instructor conflicts.','select c.uniqueId as __Class, co.subjectAreaAbbv || \' \' || co.courseNbr as Course, s.itype.abbv || \' \' || c.sectionNumberCache as Section, i.instructor.lastName || \', \' || i.instructor.firstName || \' \' || i.instructor.middleName as Instructor, i.instructor.externalUniqueId as External_Id from ClassInstructor i inner join i.classInstructing c inner join c.schedulingSubpart s inner join s.instrOfferingConfig.instructionalOffering.courseOfferings co where i.lead = false and co.subjectArea.uniqueId in %SUBJECTS% order by co.subjectAreaAbbv, co.courseNbr, s.itype.abbv, c.sectionNumberCache, i.instructor.lastName',1),
	(1146854,'Small Room Classes','List all classes that require (or prefer) a room that is too small for the class to fit in.','select c.uniqueId as __Class, co.subjectAreaAbbv || \' \' || co.courseNbr as Course, s.itype.abbv || \' \' || c.sectionNumberCache as Section, p.room.building.abbreviation || \' \' || p.room.roomNumber as Room, p.room.capacity as Size, case c.roomRatio when 1.0 then (c.expectedCapacity || \'\') else (floor(c.expectedCapacity * c.roomRatio) || \' (\' || c.roomRatio || \' x \' || c.expectedCapacity || \')\') end as Needed, p.prefLevel.prefName as Preference from Class_ c inner join c.schedulingSubpart s inner join s.instrOfferingConfig.instructionalOffering.courseOfferings co, RoomPref p where co.subjectArea.uniqueId in %SUBJECTS% and (p.owner = c or p.owner = s) and floor(c.expectedCapacity * c.roomRatio) > p.room.capacity and p.prefLevel.prefProlog in (\'R\', \'-1\', \'-2\') and c.nbrRooms > 0 order by co.subjectAreaAbbv, co.courseNbr, s.itype.abbv, c.sectionNumberCache',1),
	(1638350,'Message Log','Display message log','select\n  timeStamp as Time,\n  (case level when 50000 then \'<font color=\"red\">Fatal</font>\' when 40000 then \'<font color=\"red\">Error</font>\' when 30000 then \'<font color=\"orange\">Warning</font>\' when 20000 then \'Info\' when 10000 then \'Debug\' else \'Other\' end) as Level,\n  logger as Logger,\n  (case when exception is null then message when message is null then exception else (message || \'\\\\n\' || exception) end) as Message,\n  (case when ndc is null then thread else (thread || \'\\\\n\' || ndc) end) as Context\nfrom MessageLog order by timeStamp desc',16),
	(1638351,'Query Log','Display query log','select\n  m.lastName || \' \' || m.firstName as User,\n  case\n    when q.uri like \'%.gwt: %\' then substring(q.uri, instr(q.uri, \':\') + 1)\n    else q.uri end as Query,\n  case\n    when q.uri like \'%.gwt: %\' and length(q.query) <= 165 + instr(q.query, \'org.unitime.timetable.gwt.services.\')\n      then substring(q.query, instr(q.query, \'org.unitime.timetable.gwt.services.\') + 35)\n    when q.uri like \'%.gwt: %\'\n      then (substring(substring(q.query, instr(q.query, \'org.unitime.timetable.gwt.services.\') + 35), 1, 130) || \'...\')\n    when q.query is null or length(q.query) < 130 then q.query\n    else (substring(q.query, 1, 130) || \'...\') end as Parameters,\n  q.timeStamp as Time_Stamp,\n  q.timeSpent / 1000.0 as Time\nfrom QueryLog q, TimetableManager m\nwhere \n  q.uid = m.externalUniqueId and q.uri not like \'menu.gwt%\'\norder by q.timeStamp desc',16);

insert into `sectioning_status` values
	(1343447,'Enabled','Access enabled',7,NULL),
	(1343448,'Disabled','Access disabled',4,NULL),
	(1343449,'Not Available','Temporarily not available',6,'Access is temporarily disabled. Please try again later...'),
	(1343450,'No Email','Access enabled, no email notification',3,NULL);

insert into `sessions` values
	('blank','2010-09-06 00:00:00','2010-12-05 00:00:00','2010-12-12 00:00:00',239259,'00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',NULL,266,NULL,'2010','Fall','2010-12-06 00:00:00','2010-09-01 00:00:00','2010-12-31 00:00:00',NULL,1,1,1);

insert into `settings` values
	(42,'timeGrid','vertical','horizontal,vertical,text','Time grid display format'),
	(85,'name','last-initial','last-first,first-last,initial-last,last-initial,first-middle-last,short','Instructor name display format'),
	(86,'cfgAutoCalc','yes','yes,no','Automatically calculate number of classes and room size when editing configuration'),
	(87,'timeGridSize','Workdays x Daytime','Workdays x Daytime,All Week x Daytime,Workdays x Evening,All Week x Evening,All Week x All Times','Time grid default selection'),
	(88,'jsConfirm','yes','yes,no','Display confirmation dialogs'),
	(89,'inheritInstrPref','never','ask,always,never','Inherit instructor preferences on a class'),
	(108,'showVarLimits','no','yes,no','Show the option to set variable class limits'),
	(128,'keepSort','no','yes,no','Sort classes on detail pages'),
	(148,'roomFeaturesInOneColumn','yes','yes,no','Display Room Features In One Column'),
	(168,'dispLastChanges','yes','yes,no','Display information from the change log in pages.'),
	(188,'printNoteDisplay','icon','icon,shortened text,full text','Display an icon or shortened text when a class has a schedule print note.'),
	(189,'crsOffrNoteDisplay','icon','icon,shortened text,full text','Display an icon or shortened text when a course offering has a schedule note.'),
	(190,'mgrNoteDisplay','icon','icon,shortened text,full text','Display an icon or shortened text when a class has a note to the schedule manager.'),
	(208,'unitime.menu.style','Dynamic On Top','Dynamic On Top,Static On Top,Tree On Side,Stack On Side','Menu style');

insert into `solver_info_def` values
	(1,'GlobalInfo','Global solution information table','org.unitime.timetable.solver.ui.PropertiesInfo'),
	(2,'CBSInfo','Conflict-based statistics','org.unitime.timetable.solver.ui.ConflictStatisticsInfo'),
	(3,'AssignmentInfo','Preferences of a single assignment','org.unitime.timetable.solver.ui.AssignmentPreferenceInfo'),
	(4,'DistributionInfo','Distribution (group constraint) preferences','org.unitime.timetable.solver.ui.GroupConstraintInfo'),
	(5,'JenrlInfo','Student conflicts','org.unitime.timetable.solver.ui.JenrlInfo'),
	(6,'LogInfo','Solver Log','org.unitime.timetable.solver.ui.LogInfo'),
	(7,'BtbInstructorInfo','Back-to-back instructor preferences','org.unitime.timetable.solver.ui.BtbInstructorConstraintInfo');

insert into `solver_parameter` values
	(24921,'300',54,NULL,3),
	(1701,'false',10,NULL,3),
	(1,'MPP',1,NULL,1),
	(2,'on',3,NULL,1),
	(3,'false',4,NULL,1),
	(5,'0',17,NULL,1),
	(6,'false',4,NULL,2),
	(7,'Save and Unload',2,NULL,2),
	(8,'0',54,NULL,2),
	(11,'0.0',56,NULL,3),
	(12,'0.0',57,NULL,3),
	(13,'0.0',58,NULL,3),
	(14,'0.0',59,NULL,3),
	(15,'0.0',60,NULL,3),
	(16,'0.0',61,NULL,3),
	(17,'0.0',62,NULL,3),
	(24922,'false',4,NULL,3),
	(18,'0.0',63,NULL,3),
	(19,'0.0',64,NULL,3),
	(20,'0.0',65,NULL,3),
	(21,'0.0',66,NULL,3),
	(22,'0.0',67,NULL,3),
	(24,'1.0',94,NULL,3),
	(25,'1.0',95,NULL,3),
	(27,'0.0',97,NULL,3),
	(28,'0.0',98,NULL,3),
	(29,'0.0',99,NULL,3),
	(31,'0.0',101,NULL,3),
	(32,'0.0',102,NULL,3),
	(33,'0.0',103,NULL,3),
	(34,'0.0',104,NULL,3),
	(35,'0.0',105,NULL,3),
	(36,'0.0',106,NULL,3),
	(37,'0.0',107,NULL,3),
	(38,'0.0',140,NULL,3),
	(39,'0.0',143,NULL,3),
	(40,'0.0',108,NULL,3),
	(20974,'DIFF_TIME',202,NULL,1),
	(20975,'on',55,NULL,3),
	(90439,'20.0',99,NULL,4),
	(91742,'7.6',56,NULL,4),
	(91743,'2.4',57,NULL,4),
	(94676,'on',261,NULL,4),
	(94677,'on',13,NULL,4),
	(1212384,'0.0',1212379,NULL,3),
	(1212385,'0.0',1212381,NULL,3);

insert into `solver_parameter_def` values
	(1,'Basic.Mode','Initial','Solver mode','enum(Initial,MPP)',0,1,1),
	(2,'Basic.WhenFinished','No Action','When finished','enum(No Action,Save,Save as New,Save and Unload,Save as New and Unload)',1,1,1),
	(3,'Basic.DisobeyHard','false','Allow breaking of hard constraints','boolean',6,1,1),
	(4,'General.SwitchStudents','true','Students sectioning','boolean',2,0,1),
	(5,'General.DeptBalancing','false','Use departmental balancing','boolean',9,1,2),
	(6,'General.CBS','true','Use conflict-based statistics','boolean',0,1,2),
	(7,'General.SaveBestUnassigned','-1','Minimal number of unassigned variables to save best solution found (-1 always save)','integer',1,0,2),
	(9,'General.UseDistanceConstraints','true','Use building distances','boolean',2,0,2),
	(10,'General.Spread','true','Use same subpart balancing','boolean',3,1,2),
	(11,'General.AutoSameStudents','true','Use automatic same_students constraints','boolean',4,1,2),
	(12,'General.NormalizedPrefDecreaseFactor','0.77','Time preference normalization decrease factor','double',5,1,2),
	(13,'Global.LoadStudentEnrlsFromSolution','false','Load student enrollments from solution<BR>(faster, but it ignores new classes)','boolean',7,1,2),
	(14,'DeptBalancing.SpreadFactor','1.2','Initial allowance of the slots for a particular time','double',0,1,5),
	(15,'DeptBalancing.Unassignments2Weaken','0','Increase the initial allowance when it causes the given number of unassignments','integer',1,1,5),
	(16,'Spread.SpreadFactor','1.2','Initial allowance of the slots for a particular time','double',0,1,12),
	(17,'Spread.Unassignments2Weaken','50','Increase the initial allowance when it causes the given number of unassignments','integer',1,1,12),
	(18,'ConflictStatistics.Ageing','1.0','Ageing (koef)','double',0,0,6),
	(19,'ConflictStatistics.AgeingHalfTime','0','Ageing -- half time (number of iteration)','integer',1,0,6),
	(20,'ConflictStatistics.Print','true','Print conflict statistics','boolean',2,0,6),
	(21,'ConflictStatistics.PrintInterval','-1','Number of iterations to print CBS (-1 just keep in memory and save within the solution)','integer',3,0,6),
	(22,'PerturbationCounter.Class','net.sf.cpsolver.coursett.heuristics.UniversalPerturbationsCounter','Perturbations counter','text',0,0,11),
	(23,'Termination.Class','net.sf.cpsolver.ifs.termination.MPPTerminationCondition','Termination condition','text',1,0,11),
	(24,'Comparator.Class','net.sf.cpsolver.coursett.heuristics.TimetableComparator','Solution comparator','text',2,0,11),
	(25,'Variable.Class','net.sf.cpsolver.coursett.heuristics.LectureSelection','Lecture selection','text',3,0,11),
	(26,'Value.Class','net.sf.cpsolver.coursett.heuristics.PlacementSelection','Placement selection','text',4,0,11),
	(27,'TimetableLoader','org.unitime.timetable.solver.TimetableDatabaseLoader','Loader class','text',5,0,11),
	(28,'TimetableSaver','org.unitime.timetable.solver.TimetableDatabaseSaver','Saver class','text',6,0,11),
	(29,'Perturbations.DifferentPlacement','0.0','Different value than initial is assigned','double',0,1,4),
	(30,'Perturbations.AffectedStudentWeight','0.1','Number of students which are enrolled in a class which is placed to a different location than initial','double',1,1,4),
	(32,'Perturbations.AffectedInstructorWeight','0.0','Number of classes which are placed to a different room than initial','double',2,1,4),
	(34,'Perturbations.DifferentRoomWeight','0.0','Number of classes which are placed to a different room than initial','double',3,1,4),
	(35,'Perturbations.DifferentBuildingWeight','0.0','Number of classes which are placed to a different building than initial','double',4,1,4),
	(36,'Perturbations.DifferentTimeWeight','0.0','Number of classes which are placed in a different time than initial','double',5,1,4),
	(37,'Perturbations.DifferentDayWeight','0.0','Number of classes which are placed in a different days than initial','double',6,1,4),
	(38,'Perturbations.DifferentHourWeight','0.0','Number of classes which are placed in a different hours than initial','double',7,1,4),
	(39,'Perturbations.DeltaStudentConflictsWeight','0.0','Difference of student conflicts of classes assigned to current placements instead of initial placements','double',8,1,4),
	(40,'Perturbations.NewStudentConflictsWeight','0.0','New created student conflicts -- particular students are taken into account','double',9,1,4),
	(41,'Perturbations.TooFarForInstructorsWeight','0.0','New placement of a class is too far from the intial placement (instructor-wise)','double',10,1,4),
	(42,'Perturbations.TooFarForStudentsWeight','0.0','New placement of a class is too far from the intial placement (student-wise)','double',11,1,4),
	(43,'Perturbations.DeltaInstructorDistancePreferenceWeight','0.0','Difference between number of instructor distance preferences of the initial ','double',12,1,4),
	(44,'Perturbations.DeltaRoomPreferenceWeight','0.0','Difference between room preferences of the initial and the current solution','double',13,1,4),
	(45,'Perturbations.DeltaTimePreferenceWeight','0.0','Difference between time preferences of the initial and the current solution','double',14,1,4),
	(46,'Perturbations.AffectedStudentByTimeWeight','0.0','Number of students which are enrolled in a class which is placed to a different time than initial','double',15,1,4),
	(47,'Perturbations.AffectedInstructorByTimeWeight','0.0','Number of instructors which are assigned to classes which are placed to different time than initial','double',16,1,4),
	(48,'Perturbations.AffectedStudentByRoomWeight','0.0','Number of students which are enrolled in a class which is placed to a different room than initial','double',17,1,4),
	(49,'Perturbations.AffectedInstructorByRoomWeight','0.0','Number of instructors which are assigned to classes which are placed to different room than initial','double',18,1,4),
	(50,'Perturbations.AffectedStudentByBldgWeight','0.0','Number of students which are enrolled in a class which is placed to a different building than initial','double',19,1,4),
	(51,'Perturbations.AffectedInstructorByBldgWeight','0.0','Number of instructors which are assigned to classes which are placed to different building than initial','double',20,1,4),
	(52,'Termination.MinPerturbances','-1','Minimal allowed number of perturbances (-1 not use)','integer',0,0,7),
	(53,'Termination.MaxIters','-1','Maximal number of iteration','integer',1,0,7),
	(54,'Termination.TimeOut','1800','Maximal solver time (in sec)','integer',2,1,7),
	(55,'Termination.StopWhenComplete','false','Stop computation when a complete solution is found','boolean',3,1,7),
	(56,'Comparator.HardStudentConflictWeight','0.8','Weight of hard student conflict','double',0,1,8),
	(57,'Comparator.StudentConflictWeight','0.2','Weight of student conflict','double',1,1,8),
	(58,'Comparator.TimePreferenceWeight','0.3','Time preferences weight','double',2,1,8),
	(59,'Comparator.ContrPreferenceWeight','2.0','Distribution preferences weight','double',3,1,8),
	(60,'Comparator.RoomPreferenceWeight','1.0','Room preferences weight','double',4,1,8),
	(61,'Comparator.UselessSlotWeight','0.1','Useless slots weight','double',5,1,8),
	(62,'Comparator.TooBigRoomWeight','0.1','Too big room weight','double',6,1,8),
	(63,'Comparator.DistanceInstructorPreferenceWeight','1.0','Back-to-back instructor preferences weight','double',7,1,8),
	(64,'Comparator.PerturbationPenaltyWeight','1.0','Perturbation penalty weight','double',8,1,8),
	(65,'Comparator.DeptSpreadPenaltyWeight','1.0','Department balancing weight','double',10,1,8),
	(66,'Comparator.SpreadPenaltyWeight','1.0','Same subpart balancing weight','double',11,1,8),
	(67,'Comparator.CommitedStudentConflictWeight','1.0','Commited student conflict weight','double',12,1,8),
	(68,'Lecture.RouletteWheelSelection','true','Roulette wheel selection','boolean',0,0,9),
	(69,'Lecture.RandomWalkProb','1.0','Random walk probability','double',1,0,9),
	(70,'Lecture.DomainSizeWeight','30.0','Domain size weight','double',2,0,9),
	(71,'Lecture.NrAssignmentsWeight','10.0','Number of assignments weight','double',3,0,9),
	(72,'Lecture.InitialAssignmentWeight','20.0','Initial assignment weight','double',4,0,9),
	(73,'Lecture.NrConstraintsWeight','0.0','Number of constraint weight','double',5,0,9),
	(74,'Lecture.HardStudentConflictWeight','%Comparator.HardStudentConflictWeight%','Hard student conflict weight','double',6,0,9),
	(75,'Lecture.StudentConflictWeight','%Comparator.StudentConflictWeight%','Student conflict weight','double',7,0,9),
	(76,'Lecture.TimePreferenceWeight','%Comparator.TimePreferenceWeight%','Time preference weight','double',8,0,9),
	(77,'Lecture.ContrPreferenceWeight','%Comparator.ContrPreferenceWeight%','Constraint preference weight','double',9,0,9),
	(78,'Lecture.RoomPreferenceWeight','%Comparator.RoomPreferenceWeight%','Room preference weight','double',11,0,9),
	(79,'Lecture.UselessSlotWeight','%Comparator.UselessSlotWeight%','Useless slot weight','double',12,0,9),
	(81,'Lecture.TooBigRoomWeight','%Comparator.TooBigRoomWeight%','Too big room weight','double',13,0,9),
	(82,'Lecture.DistanceInstructorPreferenceWeight','%Comparator.DistanceInstructorPreferenceWeight%','Back-to-back instructor preferences weight','double',14,0,9),
	(83,'Lecture.DeptSpreadPenaltyWeight','%Comparator.DeptSpreadPenaltyWeight%','Department balancing weight','double',15,0,9),
	(84,'Lecture.SelectionSubSet','true','Selection among subset of lectures (faster)','boolean',16,0,9),
	(85,'Lecture.SelectionSubSetMinSize','10','Minimal subset size','integer',17,0,9),
	(86,'Lecture.SelectionSubSetPart','0.2','Subset size in percentage of all lectures available for selection','double',18,0,9),
	(87,'Lecture.SpreadPenaltyWeight','%Comparator.SpreadPenaltyWeight%','Same subpart balancing weight','double',19,0,9),
	(88,'Lecture.CommitedStudentConflictWeight','%Comparator.CommitedStudentConflictWeight%','Commited student conflict weight','double',20,0,9),
	(89,'Placement.RandomWalkProb','0.00','Random walk probability','double',0,1,10),
	(90,'Placement.MPP_InitialProb','0.20','MPP initial selection probability ','double',1,1,10),
	(91,'Placement.MPP_Limit','-1','MPP limit (-1 for no limit)','integer',2,1,10),
	(92,'Placement.MPP_PenaltyLimit','-1.0','Limit of the perturbations penalty (-1 for no limit)','double',3,1,10),
	(93,'Placement.NrAssignmentsWeight1','0.0','Number of assignments weight (level 1)','double',4,0,10),
	(94,'Placement.NrConflictsWeight1','1.0','Number of conflicts weight (level 1)','double',5,1,10),
	(95,'Placement.WeightedConflictsWeight1','2.0','Weighted conflicts weight (CBS, level 1)','double',6,1,10),
	(96,'Placement.NrPotentialConflictsWeight1','0.0','Number of potential conflicts weight (CBS, level 1)','double',7,0,10),
	(97,'Placement.MPP_DeltaInitialAssignmentWeight1','0.1','Delta initial assigments weight (MPP, level 1)','double',8,1,10),
	(98,'Placement.NrHardStudConfsWeight1','0.3','Hard student conflicts weight (level 1)','double',9,1,10),
	(99,'Placement.NrStudConfsWeight1','0.05','Student conflicts weight (level 1)','double',10,1,10),
	(100,'Placement.TimePreferenceWeight1','0.0','Time preference weight (level 1)','double',12,0,10),
	(101,'Placement.DeltaTimePreferenceWeight1','0.2','Time preference delta weight (level 1)','double',14,1,10),
	(102,'Placement.ConstrPreferenceWeight1','0.25','Constraint preference weight (level 1)','double',16,1,10),
	(103,'Placement.RoomPreferenceWeight1','0.1','Room preference weight (level 1)','double',17,1,10),
	(104,'Placement.UselessSlotsWeight1','0.0','Useless slot weight (level 1)','double',18,1,10),
	(105,'Placement.TooBigRoomWeight1','0.01','Too big room weight (level 1)','double',19,1,10),
	(106,'Placement.DistanceInstructorPreferenceWeight1','0.1','Back-to-back instructor preferences weight (level 1)','double',20,1,10),
	(107,'Placement.DeptSpreadPenaltyWeight1','0.1','Department balancing: penalty of when a slot over initial allowance is used (level 1)','double',21,1,10),
	(108,'Placement.ThresholdKoef1','0.1','Threshold koeficient (level 1)','double',22,1,10),
	(109,'Placement.NrAssignmentsWeight2','0.0','Number of assignments weight (level 2)','double',23,0,10),
	(110,'Placement.NrConflictsWeight2','0.0','Number of conflicts weight (level 2)','double',24,1,10),
	(111,'Placement.WeightedConflictsWeight2','0.0','Weighted conflicts weight (CBS, level 2)','double',25,1,10),
	(112,'Placement.NrPotentialConflictsWeight2','0.0','Number of potential conflicts weight (CBS, level 2)','double',26,0,10),
	(113,'Placement.MPP_DeltaInitialAssignmentWeight2','%Comparator.PerturbationPenaltyWeight%','Delta initial assigments weight (MPP, level 2)','double',27,0,10),
	(114,'Placement.NrHardStudConfsWeight2','%Comparator.HardStudentConflictWeight%','Hard student conflicts weight (level 2)','double',28,0,10),
	(115,'Placement.NrStudConfsWeight2','%Comparator.StudentConflictWeight%','Student conflicts weight (level 2)','double',29,0,10),
	(116,'Placement.TimePreferenceWeight2','%Comparator.TimePreferenceWeight%','Time preference weight (level 2)','double',30,0,10),
	(117,'Placement.DeltaTimePreferenceWeight2','0.0','Time preference delta weight (level 2)','double',31,0,10),
	(118,'Placement.ConstrPreferenceWeight2','%Comparator.ContrPreferenceWeight%','Constraint preference weight (level 2)','double',32,0,10),
	(119,'Placement.RoomPreferenceWeight2','%Comparator.RoomPreferenceWeight%','Room preference weight (level 2)','double',33,0,10),
	(120,'Placement.UselessSlotsWeight2','%Comparator.UselessSlotWeight%','Useless slot weight (level 2)','double',34,0,10),
	(121,'Placement.TooBigRoomWeight2','%Comparator.TooBigRoomWeight%','Too big room weight (level 2)','double',35,0,10),
	(122,'Placement.DistanceInstructorPreferenceWeight2','%Comparator.DistanceInstructorPreferenceWeight%','Back-to-back instructor preferences weight (level 2)','double',36,0,10),
	(123,'Placement.DeptSpreadPenaltyWeight2','%Comparator.DeptSpreadPenaltyWeight%','Department balancing: penalty of when a slot over initial allowance is used (level 2)','double',37,0,10),
	(124,'Placement.ThresholdKoef2','0.1','Threshold koeficient (level 2)','double',38,0,10),
	(125,'Placement.NrAssignmentsWeight3','0.0','Number of assignments weight (level 3)','double',39,0,10),
	(126,'Placement.NrConflictsWeight3','0.0','Number of conflicts weight (level 3)','double',40,0,10),
	(127,'Placement.WeightedConflictsWeight3','0.0','Weighted conflicts weight (CBS, level 3)','double',41,0,10),
	(128,'Placement.NrPotentialConflictsWeight3','0.0','Number of potential conflicts weight (CBS, level 3)','double',42,0,10),
	(129,'Placement.MPP_DeltaInitialAssignmentWeight3','0.0','Delta initial assigments weight (MPP, level 3)','double',43,0,10),
	(130,'Placement.NrHardStudConfsWeight3','0.0','Hard student conflicts weight (level 3)','double',44,0,10),
	(131,'Placement.NrStudConfsWeight3','0.0','Student conflicts weight (level 3)','double',45,0,10),
	(132,'Placement.TimePreferenceWeight3','0.0','Time preference weight (level 3)','double',46,0,10),
	(133,'Placement.DeltaTimePreferenceWeight3','0.0','Time preference delta weight (level 3)','double',47,0,10),
	(134,'Placement.ConstrPreferenceWeight3','0.0','Constraint preference weight (level 3)','double',48,0,10),
	(135,'Placement.RoomPreferenceWeight3','0.0','Room preference weight (level 3)','double',49,0,10),
	(136,'Placement.UselessSlotsWeight3','0.0','Useless slot weight (level 3)','double',50,0,10),
	(137,'Placement.TooBigRoomWeight3','0.0','Too big room weight (level 3)','double',51,0,10),
	(138,'Placement.DistanceInstructorPreferenceWeight3','0.0','Back-to-back instructor preferences weight (level 3)','double',52,0,10),
	(139,'Placement.DeptSpreadPenaltyWeight3','0.0','Department balancing: penalty of when a slot over initial allowance is used (level 3)','double',53,0,10),
	(140,'Placement.SpreadPenaltyWeight1','0.1','Same subpart balancing: penalty of when a slot over initial allowance is used (level 1)','double',54,1,10),
	(141,'Placement.SpreadPenaltyWeight2','%Comparator.SpreadPenaltyWeight%','Same subpart balancing: penalty of when a slot over initial allowance is used (level 2)','double',55,0,10),
	(142,'Placement.SpreadPenaltyWeight3','0.0','Same subpart balancing: penalty of when a slot over initial allowance is used (level 3)','double',56,0,10),
	(143,'Placement.NrCommitedStudConfsWeight1','0.5','Commited student conlict weight (level 1)','double',57,1,10),
	(144,'Placement.NrCommitedStudConfsWeight2','%Comparator.CommitedStudentConflictWeight%','Commited student conlict weight (level 2)','double',58,0,10),
	(145,'Placement.NrCommitedStudConfsWeight3','0.0','Commited student conlict weight (level 3)','double',59,0,10),
	(146,'SearchIntensification.IterationLimit','100','Iteration limit (number of iteration after which the search is restarted to the best known solution)','integer',0,1,13),
	(147,'SearchIntensification.ResetInterval','5','Number of consecutive restarts to increase iteration limit (if this number of restarts is reached, iteration limit is increased)','integer',1,1,13),
	(148,'SearchIntensification.MultiplyInterval','2','Iteration limit incremental coefficient (when a better solution is found, iteration limit is changed back to initial)','integer',2,1,13),
	(149,'SearchIntensification.Multiply','2','Reset conflict-based statistics (number of consecutive restarts after which CBS is cleared, zero means no reset of CBS)','integer',3,1,13),
	(150,'General.SearchIntensification','true','Use search intensification','boolean',6,1,2),
	(161,'Placement.CanUnassingSingleton','true','Can unassign a singleton value','boolean',60,1,10),
	(162,'General.SettingsId','-1','Settings Id','integer',8,0,2),
	(181,'TimePreferences.Weight','0.0','Time preferences weight','double',0,1,21),
	(182,'TimePreferences.Pref','2222222222222224222222222222222223333222222222222222222222222224222222222222222223333222222222222222222222222224222222222222222223333222222222222222222222222224222222222222222223333222222222222222222222222224222222222222222223333222222222222222222222','Time preferences','timepref',1,1,21),
	(201,'General.SolverWarnings',NULL,'Solver Warnings','text',10,0,2),
	(202,'General.AutoSameStudentsConstraint','SAME_STUDENTS','Automatic same student constraint','enum(SAME_STUDENTS,DIFF_TIME)',11,1,2),
	(203,'Instructor.NoPreferenceLimit','0.0','Instructor Constraint: No Preference Limit','double',0,1,41),
	(204,'Instructor.DiscouragedLimit','50.0','Instructor Constraint: Discouraged Limit','double',1,1,41),
	(205,'Instructor.ProhibitedLimit','200.0','Instructor Constraint: Prohibited Limit','double',2,1,41),
	(206,'Student.DistanceLimit','67.0','Student Conflict: Distance Limit (deprecated)','double',3,0,41),
	(207,'Student.DistanceLimit75min','100.0','Student Conflict: Distance Limit (after 75min class, deprecated)','double',4,0,41),
	(221,'Neighbour.Class','net.sf.cpsolver.coursett.heuristics.NeighbourSelectionWithSuggestions','Neighbour Selection','text',7,0,11),
	(222,'Neighbour.SuggestionProbability','0.1','Probability of using suggestions','double',0,1,61),
	(223,'Neighbour.SuggestionTimeout','500','Suggestions timeout','integer',1,1,61),
	(224,'Neighbour.SuggestionDepth','4','Suggestions depth','integer',2,1,61),
	(225,'Neighbour.SuggestionProbabilityAllAssigned','0.5','Probability of using suggestions (when all classes are assigned)','double',3,1,61),
	(241,'General.IgnoreRoomSharing','false','Ignore Room Sharing','boolean',12,1,2),
	(261,'OnFlySectioning.Enabled','false','Enable on fly sectioning (if enabled, students will be resectioned after each iteration)','boolean',0,1,81),
	(262,'OnFlySectioning.Recursive','true','Recursively resection lectures affected by a student swap','boolean',1,1,81),
	(263,'OnFlySectioning.ConfigAsWell','false','Resection students between configurations as well','boolean',2,1,81),
	(264,'ExamBasic.Mode','Initial','Solver mode','enum(Initial,MPP)',0,1,82),
	(265,'ExamBasic.WhenFinished','No Action','When finished','enum(No Action,Save,Save and Unload)',1,1,82),
	(266,'Exams.MaxRooms','4','Default number of room splits per exam','integer',0,1,83),
	(267,'Exams.IsDayBreakBackToBack','false','Consider back-to-back over day break','boolean',1,1,83),
	(268,'Exams.DirectConflictWeight','1000.0','Direct conflict weight','double',2,1,83),
	(269,'Exams.MoreThanTwoADayWeight','100.0','Three or more exams a day conflict weight','double',3,1,83),
	(270,'Exams.BackToBackConflictWeight','10.0','Back-to-back conflict weight','double',4,1,83),
	(271,'Exams.DistanceBackToBackConflictWeight','25.0','Distance back-to-back conflict weight','double',5,1,83),
	(272,'Exams.BackToBackDistance','-1','Back-to-back distance (-1 means disabled)','double',6,1,83),
	(273,'Exams.PeriodWeight','1.0','Period preference weight','double',7,1,83),
	(274,'Exams.RoomWeight','1.0','Room preference weight','double',8,1,83),
	(275,'Exams.DistributionWeight','1.0','Distribution preference weight','double',9,1,83),
	(276,'Exams.RoomSplitWeight','10.0','Room split weight','double',10,1,83),
	(277,'Exams.RoomSizeWeight','0.001','Excessive room size weight','double',11,1,83),
	(279,'Exams.RotationWeight','0.001','Exam rotation weight','double',12,1,83),
	(280,'Neighbour.Class','net.sf.cpsolver.exam.heuristics.ExamNeighbourSelection','Examination timetabling neighbour selection class','text',0,0,84),
	(281,'Termination.TimeOut','1800','Maximal solver time (in sec)','integer',1,1,84),
	(282,'Exam.Algorithm','Great Deluge','Used heuristics','enum(Great Deluge,Simulated Annealing)',2,1,84),
	(283,'HillClimber.MaxIdle','25000','Hill Climber: maximal idle iteration','integer',3,1,84),
	(284,'Termination.StopWhenComplete','false','Stop when a complete solution if found','boolean',4,0,84),
	(285,'General.SaveBestUnassigned','-1','Save best when x unassigned','integer',5,0,84),
	(286,'GreatDeluge.CoolRate','0.99999995','Cooling rate','double',0,1,85),
	(287,'GreatDeluge.UpperBoundRate','1.05','Upper bound rate','double',1,1,85),
	(288,'GreatDeluge.LowerBoundRate','0.95','Lower bound rate','double',2,1,85),
	(289,'SimulatedAnnealing.InitialTemperature','1.5','Initial temperature','double',0,1,86),
	(290,'SimulatedAnnealing.CoolingRate','0.95','Cooling rate','double',1,1,86),
	(291,'SimulatedAnnealing.TemperatureLength','25000','Temperature length','integer',2,1,86),
	(292,'SimulatedAnnealing.ReheatLengthCoef','5','Reheat length coefficient','double',3,1,86),
	(301,'Exams.InstructorDirectConflictWeight','0.0','Direct instructor conflict weight','double',13,1,83),
	(302,'Exams.InstructorMoreThanTwoADayWeight','0.0','Three or more exams a day instructor conflict weight','double',14,1,83),
	(303,'Exams.InstructorBackToBackConflictWeight','0.0','Back-to-back instructor conflict weight','double',15,1,83),
	(304,'Exams.InstructorDistanceBackToBackConflictWeight','0.0','Distance back-to-back instructor conflict weight','double',16,1,83),
	(305,'Exams.PerturbationWeight','0.001','Perturbation penalty weight','double',17,1,83),
	(321,'Exams.RoomSplitDistanceWeight','0.01','If an examination in split between two or more rooms, weight for an average distance between these rooms','double',18,1,83),
	(322,'Exams.LargeSize','-1','Large Exam Penalty: minimal size of a large exam (disabled if -1)','integer',19,1,83),
	(323,'Exams.LargePeriod','0.67','Large Exam Penalty: first discouraged period = number of periods x this factor','double',20,1,83),
	(324,'Exams.LargeWeight','1.0','Large Exam Penalty: weight of a large exam that is assigned on or after the first discouraged period','double',21,1,83),
	(325,'StudentSctBasic.Mode','Initial','Solver mode','enum(Initial,MPP,Projection)',0,1,101),
	(326,'StudentSctBasic.WhenFinished','No Action','When finished','enum(No Action,Save,Save and Unload)',1,1,101),
	(327,'Termination.Class','net.sf.cpsolver.ifs.termination.GeneralTerminationCondition','Student sectioning termination class','text',0,0,102),
	(328,'Termination.StopWhenComplete','true','Stop when a complete solution if found','boolean',1,1,102),
	(329,'Termination.TimeOut','28800','Maximal solver time (in sec)','integer',2,1,102),
	(330,'Comparator.Class','net.sf.cpsolver.ifs.solution.GeneralSolutionComparator','Student sectioning solution comparator class','text',3,0,102),
	(331,'Value.Class','net.sf.cpsolver.studentsct.heuristics.EnrollmentSelection','Student sectioning value selection class','text',4,0,102),
	(332,'Value.WeightConflicts','1.0','CBS weight','double',5,0,102),
	(333,'Value.WeightNrAssignments','0.0','Number of past assignments weight','double',6,0,102),
	(334,'Variable.Class','net.sf.cpsolver.ifs.heuristics.GeneralVariableSelection','Student sectioning variable selection class','text',7,0,102),
	(335,'Neighbour.Class','net.sf.cpsolver.studentsct.heuristics.StudentSctNeighbourSelection','Student sectioning neighbour selection class','text',8,0,102),
	(336,'General.SaveBestUnassigned','0','Save best even when no complete solution is found','integer',9,0,102),
	(337,'StudentSct.StudentDist','true','Use student distance conflicts','boolean',10,1,102),
	(338,'StudentSct.CBS','true','Use conflict-based statistics','boolean',11,1,102),
	(339,'Load.IncludeCourseDemands','true','Load real student requests','boolean',12,0,102),
	(340,'Load.IncludeLastLikeStudents','false','Load last-like  course demands','boolean',13,0,102),
	(341,'SectionLimit.PreferDummyStudents','true','Section limit constraint: favour unassignment of last-like course requests','boolean',14,0,102),
	(342,'Student.DummyStudentWeight','0.01','Last-like student request weight','double',15,1,102),
	(343,'Neighbour.BranchAndBoundMinimizePenalty','false','Branch&bound: If true, section penalties (instead of section values) are minimized','boolean',16,0,102),
	(344,'Neighbour.BranchAndBoundTimeout','5000','Branch&bound: Timeout for each neighbour selection (in milliseconds)','integer',17,1,102),
	(345,'Neighbour.RandomUnassignmentProb','0.5','Random Unassignment: Probability of a random selection of a student','double',18,1,102),
	(346,'Neighbour.RandomUnassignmentOfProblemStudentProb','0.9','Random Unassignment: Probability of a random selection of a problematic student','double',19,1,102),
	(347,'Neighbour.SwapStudentsTimeout','5000','Student Swap: Timeout for each neighbour selection (in milliseconds)','integer',20,1,102),
	(348,'Neighbour.SwapStudentsMaxValues','100','Student Swap: Limit for the number of considered values for each course request','integer',21,1,102),
	(349,'Neighbour.MaxValues','100','Backtrack: Limit on the number of enrollments to be visited of each course request','integer',22,1,102),
	(350,'Neighbour.BackTrackTimeout','5000','Backtrack: Timeout for each neighbour selection (in milliseconds)','integer',23,1,102),
	(351,'Neighbour.BackTrackDepth','4','Backtrack: Search depth','integer',24,1,102),
	(352,'CourseRequest.SameTimePrecise','true','More precise (but slower) computation of enrollments of a course request while skipping enrollments with the same times','boolean',25,0,102),
	(361,'Exams.PeriodSizeWeight','1.0','Examination period x examination size weight','double',22,1,83),
	(362,'Exams.PeriodIndexWeight','0.0000001','Examination period index weight','double',23,1,83),
	(363,'Exams.RoomPerturbationWeight','0.1','Room perturbation penalty (change of room) weight','double',24,1,83),
	(364,'Comparator.Class','net.sf.cpsolver.ifs.solution.GeneralSolutionComparator','Examination solution comparator class','text',6,0,84),
	(365,'General.IgnoreCommittedStudentConflicts','false','Do not load committed student conflicts (deprecated)','boolean',13,0,2),
	(366,'General.WeightStudents','true','Weight last-like students (deprecated)','boolean',14,0,2),
	(367,'Curriculum.StudentCourseDemadsClass','Projected Student Course Demands','Student course demands','enum(Last Like Student Course Demands,Weighted Last Like Student Course Demands,Projected Student Course Demands,Curricula Course Demands,Curricula Last Like Course Demands,Student Course Requests,Enrolled Student Course Demands)',4,1,1),
	(368,'General.CommittedStudentConflicts','Load','Committed student conflicts','enum(Load,Compute,Ignore)',5,1,1),
	(369,'General.LoadCommittedAssignments','false','Load committed assignments','boolean',3,1,1),
	(370,'Distances.Ellipsoid','DEFAULT','Ellipsoid to be used to compute distances','enum(DEFAULT,LEGACY,WGS84,GRS80,Airy1830,Intl1924,Clarke1880,GRS67)',5,1,41),
	(371,'Distances.Speed','67.0','Student speed in meters per minute','double',6,1,41),
	(1048545,'StudentWeights.Priority','0.5010','Priority','double',0,1,1048544),
	(1048546,'StudentWeights.FirstAlternative','0.5010','First alternative','double',1,1,1048544),
	(1048547,'StudentWeights.SecondAlternative','0.2510','Second alternative','double',2,1,1048544),
	(1048548,'StudentWeights.DistanceConflict','0.0100','Distance conflict','double',3,1,1048544),
	(1048549,'StudentWeights.TimeOverlapFactor','0.5000','Time overlap','double',4,1,1048544),
	(1048550,'StudentWeights.TimeOverlapMaxLimit','0.5000','Time overlap limit','double',5,0,1048544),
	(1048551,'StudentWeights.BalancingFactor','0.0050','Section balancing','double',6,1,1048544),
	(1048552,'StudentWeights.AlternativeRequestFactor','0.1260','Alternative request (equal weights)','double',7,1,1048544),
	(1048553,'StudentWeights.LeftoverSpread','false','Spread leftover weight equaly','boolean',8,1,1048544),
	(1048554,'StudentWeights.Mode','Priority','Student weights','enum(Priority,Equal,Legacy)',2,1,101),
	(1048555,'StudentSct.TimeOverlaps','true','Use time overlaps','boolean',26,1,102),
	(1048556,'Load.TweakLimits','false','Tweak class limits to fit all enrolled students','boolean',27,1,102),
	(1081311,'StudentSct.ProjectedCourseDemadsClass','None','Projected student course demands','enum(None,Last Like Student Course Demands,Projected Student Course Demands,Curricula Course Demands,Curricula Last Like Course Demands,Student Course Requests,Enrolled Student Course Demands)',3,1,101),
	(1114078,'StudentWeights.ProjectedStudentWeight','0.0100','Projected student request','double',9,1,1048544),
	(1212379,'Comparator.DistStudentConflictWeight','0.2','Weight of distance student conflict','double',9,1,8),
	(1212380,'Lecture.DistStudentConflictWeight','%Comparator.DistStudentConflictWeight%','Distance student conflict weight','double',10,0,9),
	(1212381,'Placement.NrDistStudConfsWeight1','0.05','Distance student conflict weight (level 1)','double',11,1,10),
	(1212382,'Placement.NrDistStudConfsWeight2','%Comparator.DistStudentConflictWeight%','Distance student conflict weight (level 2)','double',13,0,10),
	(1212383,'Placement.NrDistStudConfsWeight3','0.0','Distance student conflict weight (level 3)','double',15,0,10),
	(1605583,'Distances.ComputeDistanceConflictsBetweenNonBTBClasses','false','Compute Distance Conflicts Between Non BTB Classes','boolean',7,1,41),
	(1605584,'Instructor.InstructorLongTravelInMinutes','30.0','Instructor Long Travel in Minutes (only when computing distances between non-BTB classes is enabled)','double',8,1,41),
	(1605585,'General.AutoPrecedence','Neutral','Automatic precedence constraint','enum(Required,Strongly Preferred,Preferred,Neutral)',15,1,2),
	(1605586,'DiscouragedRoom.Unassignments2Weaken','1000','Number of unassignments for the discouraged room constraint to weaken','integer',16,1,2),
	(1605587,'CurriculaCourseDemands.IncludeOtherStudents','true','Curriculum Course Demands: Include Other Students','boolean',17,1,2),
	(1605588,'General.AdditionalCriteria','net.sf.cpsolver.coursett.criteria.additional.ImportantStudentConflict;net.sf.cpsolver.coursett.criteria.additional.ImportantStudentHardConflict','Additional Criteria (semicolon separated list of class names)','text',18,0,2),
	(1605589,'General.PurgeInvalidPlacements','true','Purge invalid placements during the data load','boolean',19,0,2),
	(1605590,'CurriculumEnrollmentPriority.GroupMatch','.*','Important Curriculum Groups (regexp matching the group name -- all courses of a matching group are marked as important)','text',20,0,2),
	(1605591,'Precedence.ConsiderDatePatterns','true','Precedence Constraint: consider date patterns','text',21,1,2),
	(1605592,'General.JenrlMaxConflicts','1.0','Joint Enrollment Constraint: conflict limit (% limit of the smaller class)','double',22,1,2),
	(1605593,'General.JenrlMaxConflictsWeaken','0.001','Joint Enrollment Constraint: limit weakening','double',23,1,2),
	(1605594,'Comparator.ImportantStudentConflictWeight','0.0','Weight of important student conflict','double',13,1,8),
	(1605595,'Comparator.ImportantHardStudentConflictWeight','0.0','Weight of important hard student conflict','double',14,1,8),
	(1605596,'Placement.NrImportantStudConfsWeight1','0.0','Important student conflict weight (level 1)','double',61,1,10),
	(1605597,'Placement.NrImportantStudConfsWeight2','%Comparator.ImportantStudentConflictWeight%','Important student conflict weight (level 2)','double',62,0,10),
	(1605598,'Placement.NrImportantStudConfsWeight3','0.0','Important student conflict weight (level 3)','double',63,0,10),
	(1605599,'Placement.NrImportantHardStudConfsWeight1','0.0','Important hard student conflict weight (level 1)','double',64,1,10),
	(1605600,'Placement.NrImportantHardStudConfsWeight2','%Comparator.ImportantHardStudentConflictWeight%','Important hard student conflict weight (level 2)','double',65,0,10),
	(1605601,'Placement.NrImportantHardStudConfsWeight3','0.0','Important hard student conflict weight (level 3)','double',66,0,10),
	(1605602,'Exams.RoomSizeFactor','1.0','Excessive room size factor','double',25,1,83),
	(1605603,'Exams.DistanceToStronglyPreferredRoomWeight','0.0','Distance to strongly preferred room weight','double',26,1,83),
	(1605604,'Exams.AdditionalCriteria','net.sf.cpsolver.exam.criteria.additional.DistanceToStronglyPreferredRoom','Additional Criteria (semicolon separated list of class names)','text',7,1,84);

insert into `solver_parameter_group` values
	(1,'Basic','Basic Settings',NULL,0,0),
	(2,'General','General Settings',NULL,1,0),
	(3,'MPP','Minimal-perturbation Setting',NULL,2,0),
	(4,'Perturbations','Perturbation Penalty',NULL,3,0),
	(5,'DepartmentSpread','Departmental Balancing',NULL,4,0),
	(6,'ConflictStatistics','Conflict-based Statistics',NULL,5,0),
	(7,'Termination','Termination Conditions',NULL,6,0),
	(8,'Comparator','Solution Comparator Weights',NULL,7,0),
	(9,'Variable','Lecture Selection',NULL,8,0),
	(10,'Value','Placement Selection',NULL,9,0),
	(11,'Classes','Implementations',NULL,10,0),
	(12,'Spread','Same Subpart Balancing',NULL,11,0),
	(13,'SearchIntensification','Search Intensification',NULL,12,0),
	(21,'TimePreferences','Default Time Preferences',NULL,13,0),
	(41,'Distance','Distances',NULL,14,0),
	(61,'Neighbour','Neighbour Selection',NULL,15,0),
	(81,'OnFlySectioning','On Fly Student Sectioning',NULL,16,0),
	(82,'ExamBasic','Basic Parameters',NULL,17,1),
	(83,'ExamWeights','Examination Weights',NULL,18,1),
	(84,'Exam','General Parameters',NULL,19,1),
	(85,'ExamGD','Great Deluge Parameters',NULL,20,1),
	(86,'ExamSA','Simulated Annealing Parameters',NULL,21,1),
	(101,'StudentSctBasic','Basic Parameters',NULL,22,2),
	(102,'StudentSct','General Parameters',NULL,23,2),
	(1048544,'StudentSctWeights','Student Weitghts',NULL,24,2);

insert into `solver_predef_setting` values
	(1,'Default.Interactive','Interactive',0),
	(2,'Default.Validate','Validate',1),
	(3,'Default.Check','Check',1),
	(4,'Default.Solver','Default',1),
	(101,'Exam.Default','Default',2),
	(121,'StudentSct.Default','Default',3);

insert into `timetable_manager` values
	(470,'1','Deafult',NULL,'Admin','demo@unitime.org',NULL);

insert into `tmtbl_mgr_to_roles` values
	(470,1,510,1,1);

insert into `users` values
	('admin','ISMvKXpXpadDiUoOSoAfww==','1');

set foreign_key_checks=@saved_fk_checks;
set character_set_client=@saved_cs_client;
