/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.io.CannotParseException;
import biweekly.io.ParseContext;
import biweekly.io.WriteContext;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ListPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.ExceptionDates;
import biweekly.property.ICalProperty;
import biweekly.util.ICalDate;
import java.util.ArrayList;
import java.util.List;

public class ExceptionDatesScribe
extends ListPropertyScribe<ExceptionDates, ICalDate> {
    public ExceptionDatesScribe() {
        super(ExceptionDates.class, "EXDATE");
    }

    @Override
    protected ICalDataType _defaultDataType(ICalVersion version) {
        return ICalDataType.DATE_TIME;
    }

    @Override
    protected ICalParameters _prepareParameters(ExceptionDates property, WriteContext context) {
        if (ExceptionDatesScribe.isInObservance(context)) {
            return property.getParameters();
        }
        boolean hasTime = property.getValues().isEmpty() ? false : this.dataType(property, context.getVersion()) == ICalDataType.DATE_TIME;
        return ExceptionDatesScribe.handleTzidParameter(property, hasTime, context);
    }

    @Override
    protected ICalDataType _dataType(ExceptionDates property, ICalVersion version) {
        List dates = property.getValues();
        if (!dates.isEmpty()) {
            return ((ICalDate)dates.get(0)).hasTime() ? ICalDataType.DATE_TIME : ICalDataType.DATE;
        }
        return this.defaultDataType(version);
    }

    @Override
    protected ExceptionDates newInstance(ICalDataType dataType, ICalParameters parameters) {
        return new ExceptionDates();
    }

    @Override
    protected String writeValue(ExceptionDates property, ICalDate value, WriteContext context) {
        if (ExceptionDatesScribe.isInObservance(context)) {
            return ExceptionDatesScribe.date(value).observance(true).extended(false).write();
        }
        return ExceptionDatesScribe.date(value, (ICalProperty)property, context).extended(false).write();
    }

    @Override
    protected ICalDate readValue(ExceptionDates property, String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        ICalDate date;
        try {
            boolean hasTime = dataType == ICalDataType.DATE_TIME;
            date = ExceptionDatesScribe.date(value).hasTime(hasTime).parse();
        }
        catch (IllegalArgumentException e) {
            throw new CannotParseException(19, new Object[0]);
        }
        context.addDate(date, property, parameters);
        return date;
    }

    @Override
    protected void _writeXml(ExceptionDates property, XCalElement element, WriteContext context) {
        List values = property.getValues();
        if (values.isEmpty()) {
            element.append(this.defaultDataType(context.getVersion()), "");
            return;
        }
        if (ExceptionDatesScribe.isInObservance(context)) {
            for (ICalDate value : values) {
                String valueStr = ExceptionDatesScribe.date(value).observance(true).extended(true).write();
                element.append(ICalDataType.DATE_TIME, valueStr);
            }
            return;
        }
        for (ICalDate value : values) {
            ICalDataType dataType = value.hasTime() ? ICalDataType.DATE_TIME : ICalDataType.DATE;
            String dateStr = ExceptionDatesScribe.date(value, (ICalProperty)property, context).extended(true).write();
            element.append(dataType, dateStr);
        }
    }

    @Override
    protected ExceptionDates _parseXml(XCalElement element, ICalParameters parameters, ParseContext context) {
        List<String> dateTimeElements = element.all(ICalDataType.DATE_TIME);
        List<String> dateElements = element.all(ICalDataType.DATE);
        if (dateTimeElements.isEmpty() && dateElements.isEmpty()) {
            throw ExceptionDatesScribe.missingXmlElements(ICalDataType.DATE_TIME, ICalDataType.DATE);
        }
        ExceptionDates property = new ExceptionDates();
        List values = property.getValues();
        for (String value : dateTimeElements) {
            ICalDate datetime = this.readValue(property, value, ICalDataType.DATE_TIME, parameters, context);
            values.add(datetime);
        }
        for (String value : dateElements) {
            ICalDate date = this.readValue(property, value, ICalDataType.DATE, parameters, context);
            values.add(date);
        }
        return property;
    }

    @Override
    protected JCalValue _writeJson(ExceptionDates property, WriteContext context) {
        List values = property.getValues();
        if (values.isEmpty()) {
            return JCalValue.single("");
        }
        ArrayList<String> valuesStr = new ArrayList<String>();
        if (ExceptionDatesScribe.isInObservance(context)) {
            for (ICalDate value : values) {
                String valueStr = ExceptionDatesScribe.date(value).observance(true).extended(true).write();
                valuesStr.add(valueStr);
            }
            return JCalValue.multi(valuesStr);
        }
        for (ICalDate value : values) {
            String dateStr = ExceptionDatesScribe.date(value, (ICalProperty)property, context).extended(true).write();
            valuesStr.add(dateStr);
        }
        return JCalValue.multi(valuesStr);
    }

    @Override
    protected ExceptionDates _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        List<String> valueStrs = value.asMulti();
        ExceptionDates property = new ExceptionDates();
        List values = property.getValues();
        for (String valueStr : valueStrs) {
            ICalDate date = this.readValue(property, valueStr, dataType, parameters, context);
            values.add(date);
        }
        return property;
    }
}

