/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.base.BaseIndividualReservation;

public class IndividualReservation
extends BaseIndividualReservation {
    private static final long serialVersionUID = 1L;

    public IndividualReservation() {
    }

    public IndividualReservation(Long uniqueId) {
        super(uniqueId);
    }

    @Override
    public boolean isApplicable(Student student, CourseRequest request) {
        return this.getStudents().contains(student);
    }

    @Override
    public int getPriority() {
        return ApplicationProperty.ReservationPriorityIndividual.intValue();
    }

    @Override
    public boolean isCanAssignOverLimit() {
        return ApplicationProperty.ReservationCanOverLimitIndividual.isTrue();
    }

    @Override
    public boolean isMustBeUsed() {
        return ApplicationProperty.ReservationMustBeUsedIndividual.isTrue();
    }

    @Override
    public boolean isAllowOverlap() {
        return ApplicationProperty.ReservationAllowOverlapIndividual.isTrue();
    }

    @Override
    public int getReservationLimit() {
        return this.getStudents().size();
    }
}

