/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.unitime.commons.MultiComparable;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.ExamsForm;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamStatus;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamInfo;
import org.unitime.timetable.spring.SpringApplicationContextHolder;
import org.unitime.timetable.util.LoginManager;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.webutil.PdfWebTable;

@Action(value="exams", results={@Result(name={"show"}, type="tiles", location="exams.tiles"), @Result(name={"personal"}, type="redirect", location="/personalSchedule.action")})
@TilesDefinition(name="exams.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Examination Schedule"), @TilesPutAttribute(name="body", value="/exam/exams.jsp"), @TilesPutAttribute(name="checkLogin", value="false"), @TilesPutAttribute(name="checkRole", value="false")})
public class ExamsAction
extends UniTimeAction<ExamsForm> {
    private static final long serialVersionUID = 252256673838259727L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private String year;
    private String term;
    private String campus;
    private String type;
    private String subject;
    private String select;

    public String getYear() {
        return this.year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public String getTerm() {
        return this.term;
    }

    public void setTerm(String term) {
        this.term = term;
    }

    public String getCampus() {
        return this.campus;
    }

    public void setCampus(String campus) {
        this.campus = campus;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getSelect() {
        return this.select;
    }

    public void setSelect(String select) {
        this.select = select;
    }

    public String execute() throws Exception {
        Session session;
        if (this.form == null) {
            this.form = new ExamsForm();
            ((ExamsForm)this.form).reset();
        }
        if (((ExamsForm)this.form).getOp() != null) {
            this.op = ((ExamsForm)this.form).getOp();
        }
        if (this.subject != null || this.select != null) {
            ((ExamsForm)this.form).load(this.request.getSession());
            if (this.subject != null) {
                ((ExamsForm)this.form).setSubjectArea(this.subject);
            } else if (((ExamsForm)this.form).canDisplayAllSubjectsAtOnce().booleanValue()) {
                ((ExamsForm)this.form).setSubjectArea("--ALL--");
            }
            if (this.year != null && this.term != null && this.campus != null && (session = Session.getSessionUsingInitiativeYearTerm(this.campus, this.year, this.term)) != null) {
                ((ExamsForm)this.form).setSession(session.getUniqueId());
            }
            if (this.type != null) {
                try {
                    ((ExamsForm)this.form).setExamType(Long.valueOf(this.type));
                }
                catch (NumberFormatException e) {
                    ExamType examType = ExamType.findByReference(this.type);
                    if (examType != null) {
                        ((ExamsForm)this.form).setExamType(examType.getUniqueId());
                    }
                }
            } else {
                ((ExamsForm)this.form).setExamType(null);
            }
            this.op = MSG.buttonApply();
        }
        if ("Change".equals(this.op)) {
            ((ExamsForm)this.form).save(this.request.getSession());
        }
        if (MSG.buttonLogIn().equals(this.op)) {
            if (((ExamsForm)this.form).getUsername() != null && ((ExamsForm)this.form).getUsername().length() > 0 && ((ExamsForm)this.form).getPassword() != null && ((ExamsForm)this.form).getPassword().length() > 0) {
                try {
                    UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)((ExamsForm)this.form).getUsername(), (Object)((ExamsForm)this.form).getPassword());
                    Authentication authResult = this.getAuthenticationManager().authenticate((Authentication)authRequest);
                    SecurityContextHolder.getContext().setAuthentication(authResult);
                    UserContext user = (UserContext)authResult.getPrincipal();
                    if (user.getCurrentAuthority() == null || !user.getCurrentAuthority().hasRight(Right.PersonalSchedule)) {
                        for (UserAuthority userAuthority : user.getAuthorities()) {
                            if (userAuthority.getAcademicSession() == null || !userAuthority.getAcademicSession().getQualifierId().equals(((ExamsForm)this.form).getSession()) || !userAuthority.hasRight(Right.PersonalSchedule)) continue;
                            user.setCurrentAuthority(userAuthority);
                            break;
                        }
                    }
                    this.request.getSession().setAttribute("loginPage", (Object)"exams");
                    LoginManager.loginSuceeded(authResult.getName());
                    if (user.getCurrentAuthority() == null) {
                        this.response.sendRedirect("selectPrimaryRole.action");
                        return null;
                    }
                    return "personal";
                }
                catch (Exception e) {
                    ((ExamsForm)this.form).setMessage("Authentication failed: " + e.getMessage());
                    LoginManager.addFailedLoginAttempt(((ExamsForm)this.form).getUsername(), new Date());
                }
            }
            this.op = MSG.buttonApply();
        }
        if (MSG.buttonApply().equals(this.op)) {
            ((ExamsForm)this.form).save(this.request.getSession());
        }
        ((ExamsForm)this.form).load(this.request.getSession());
        WebTable.setOrder(this.sessionContext, "exams.order", this.request.getParameter("ord"), 1);
        if (((ExamsForm)this.form).getSession() != null && ((ExamsForm)this.form).getSubjectArea() != null && ((ExamsForm)this.form).getSubjectArea().length() > 0 && ((ExamsForm)this.form).getExamType() != null) {
            DepartmentStatusType type;
            session = (Session)new SessionDAO().get(((ExamsForm)this.form).getSession());
            ExamStatus status = ExamStatus.findStatus(((ExamsForm)this.form).getSession(), ((ExamsForm)this.form).getExamType());
            DepartmentStatusType departmentStatusType = type = status == null || status.getStatus() == null ? session.getStatusType() : status.getStatus();
            if (type != null && type.can(((ExamsForm)this.form).isFinals() ? DepartmentStatusType.Status.ReportExamsFinal : DepartmentStatusType.Status.ReportExamsMidterm)) {
                List exams = null;
                if ("--ALL--".equals(((ExamsForm)this.form).getSubjectArea())) {
                    exams = Exam.findAll(((ExamsForm)this.form).getSession(), ((ExamsForm)this.form).getExamType());
                } else {
                    SubjectArea subjectArea = SubjectArea.findByAbbv(((ExamsForm)this.form).getSession(), ((ExamsForm)this.form).getSubjectArea());
                    if (subjectArea != null) {
                        exams = Exam.findExamsOfSubjectAreaIncludeCrossLists(subjectArea.getUniqueId(), ((ExamsForm)this.form).getExamType());
                    }
                }
                if (exams != null && !exams.isEmpty()) {
                    PdfWebTable table;
                    ArrayList<ExamAssignment> arrayList = new ArrayList<ExamAssignment>();
                    for (Exam exam : exams) {
                        if (exam.getAssignedPeriod() == null) continue;
                        arrayList.add(new ExamAssignment(exam));
                    }
                    if (!arrayList.isEmpty() && (table = this.getTable(true, arrayList)) != null) {
                        ((ExamsForm)this.form).setTable(table.printTable(WebTable.getOrder(this.sessionContext, "exams.order")), table.getNrColumns(), table.getLines().size());
                    }
                }
            }
        }
        LookupTables.setupExamTypes(this.request, null);
        return "show";
    }

    private PdfWebTable getTable(boolean html, List<ExamAssignment> exams) {
        String itype = MSG.columnExamInstructionalType();
        if (ApplicationProperty.ExaminationReportsExternalId.isTrue() && (itype = ApplicationProperty.ExaminationReportsExternalIdName.value()) == null) {
            itype = MSG.columnExamExternalId();
        }
        PdfWebTable table = new PdfWebTable(7, ((ExamsForm)this.form).getSessionLabel() + " " + ((ExamsForm)this.form).getExamTypeLabel().toLowerCase() + " " + MSG.examinations() + ("--ALL--".equals(((ExamsForm)this.form).getSubjectArea()) ? "" : " (" + ((ExamsForm)this.form).getSubjectArea() + ")"), "exams.action?ord=%%", new String[]{MSG.columnExamSubject(), MSG.columnExamCourse(), itype, MSG.columnExamSection(), MSG.columnExamDate(), MSG.columnExamTime(), MSG.columnExamRoom()}, new String[]{"left", "left", "left", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true, true, true});
        table.setRowStyle("white-space:nowrap");
        String noRoom = ApplicationProperty.ExaminationsNoRoomText.value();
        for (ExamAssignment exam : exams) {
            for (ExamInfo.ExamSectionInfo section : exam.getSectionsIncludeCrosslistedDummies()) {
                if (!"--ALL--".equals(((ExamsForm)this.form).getSubjectArea()) && !section.getSubject().equals(((ExamsForm)this.form).getSubjectArea())) continue;
                table.addLine(new String[]{section.getSubject(), section.getCourseNbr(), section.getItype(), section.getSection(), exam.getDate(false), exam.getTime(false), exam.getNrRooms() == 0 ? noRoom : (html ? exam.getRoomsNameWithHint(false, ", ") : exam.getRoomsName(", "))}, new Comparable[]{new MultiComparable((Comparable)((Object)section.getSubject()), (Comparable)((Object)section.getCourseNbr()), (Comparable)((Object)section.getItype()), (Comparable)((Object)section.getSection()), exam.getPeriodOrd()), new MultiComparable((Comparable)((Object)section.getSubject()), (Comparable)((Object)section.getCourseNbr()), (Comparable)((Object)section.getItype()), (Comparable)((Object)section.getSection()), exam.getPeriodOrd()), new MultiComparable((Comparable)((Object)section.getSubject()), (Comparable)((Object)section.getItype()), (Comparable)((Object)section.getCourseNbr()), (Comparable)((Object)section.getSection()), exam.getPeriodOrd()), new MultiComparable((Comparable)((Object)section.getSubject()), (Comparable)((Object)section.getCourseNbr()), (Comparable)((Object)section.getSection()), (Comparable)((Object)section.getItype()), exam.getPeriodOrd()), new MultiComparable(exam.getPeriodOrd(), (Comparable)((Object)section.getSubject()), (Comparable)((Object)section.getCourseNbr()), (Comparable)((Object)section.getSection()), (Comparable)((Object)section.getItype())), new MultiComparable(exam.getPeriod().getStartSlot(), (Comparable)((Object)section.getSubject()), (Comparable)((Object)section.getCourseNbr()), (Comparable)((Object)section.getSection()), (Comparable)((Object)section.getItype()), exam.getPeriodOrd()), new MultiComparable((Comparable)((Object)exam.getRoomsName(":")), (Comparable)((Object)section.getSubject()), (Comparable)((Object)section.getCourseNbr()), (Comparable)((Object)section.getItype()), (Comparable)((Object)section.getSection()), exam.getPeriodOrd())});
            }
        }
        return table;
    }

    protected AuthenticationManager getAuthenticationManager() {
        return (AuthenticationManager)SpringApplicationContextHolder.getBean("authenticationManager");
    }
}

