/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.solver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cpsolver.coursett.constraint.FlexibleConstraint;
import org.cpsolver.coursett.constraint.GroupConstraint;
import org.cpsolver.coursett.constraint.InstructorConstraint;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.criteria.StudentCommittedConflict;
import org.cpsolver.coursett.criteria.StudentConflict;
import org.cpsolver.coursett.criteria.StudentDistanceConflict;
import org.cpsolver.coursett.criteria.StudentHardConflict;
import org.cpsolver.coursett.criteria.StudentOverlapConflict;
import org.cpsolver.coursett.criteria.placement.DeltaTimePreference;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.Criterion;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.CPSolverMessages;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SuggestionsInterface;
import org.unitime.timetable.gwt.shared.TableInterface;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.solver.ClassAssignmentDetailsBackend;
import org.unitime.timetable.server.solver.SuggestionsContext;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.TimetableSolver;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.ui.GroupConstraintInfo;
import org.unitime.timetable.solver.ui.JenrlInfo;
import org.unitime.timetable.util.Constants;

@GwtRpcImplements(value=SuggestionsInterface.SelectedAssignmentsRequest.class)
public class SelectedAssignmentBackend
implements GwtRpcImplementation<SuggestionsInterface.SelectedAssignmentsRequest, SuggestionsInterface.Suggestion> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    protected static CPSolverMessages MSG = Localization.create(CPSolverMessages.class);
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;

    @Override
    public SuggestionsInterface.Suggestion execute(SuggestionsInterface.SelectedAssignmentsRequest request, SessionContext context) {
        SolverProxy solver;
        context.checkPermission(Right.Suggestions);
        SuggestionsContext cx = new SuggestionsContext();
        String instructorFormat = context.getUser().getProperty(UserProperty.NameFormat);
        if (instructorFormat != null) {
            cx.setInstructorNameFormat(instructorFormat);
        }
        if ((solver = this.courseTimetablingSolverService.getSolver()) == null) {
            throw new GwtRpcException(MESSAGES.warnSolverNotLoaded());
        }
        if (solver.isWorking()) {
            throw new GwtRpcException(MESSAGES.warnSolverIsWorking());
        }
        SuggestionsInterface.Suggestion response = solver.getSelectedSuggestion(cx, request);
        if (request.getClassId() != null) {
            response.setSelectedPlacement(solver.getClassAssignmentDetails(cx, request.getClassId(), true, true));
        }
        return response;
    }

    public static Placement getPlacement(TimetableModel model, SuggestionsInterface.SelectedAssignment assignment, boolean checkValidity) {
        for (Lecture lecture : model.variables()) {
            if (!lecture.getClassId().equals(assignment.getClassId())) continue;
            Object timeLocation = null;
            for (Object t : lecture.timeLocations()) {
                if (t.getDayCode() != assignment.getDays() || t.getStartSlot() != assignment.getStartSlot() || !t.getTimePatternId().equals(assignment.getPatternId()) || !t.getDatePatternId().equals(assignment.getDatePatternId())) continue;
                timeLocation = t;
                break;
            }
            ArrayList<RoomLocation> roomLocations = new ArrayList<RoomLocation>();
            if (lecture.getNrRooms() > 0) {
                Object t;
                t = assignment.getRoomIds().iterator();
                while (t.hasNext()) {
                    Long roomId = (Long)t.next();
                    for (RoomLocation r : lecture.roomLocations()) {
                        if (!r.getId().equals(roomId)) continue;
                        roomLocations.add(r);
                    }
                }
            }
            if (timeLocation == null || roomLocations.size() != lecture.getNrRooms()) continue;
            Placement placement = new Placement(lecture, timeLocation, roomLocations);
            if (checkValidity && !placement.isValid()) {
                return null;
            }
            return placement;
        }
        return null;
    }

    public static void setAssigned(SuggestionsInterface.ClassAssignmentDetails details, SuggestionsInterface.SelectedAssignment assignment) {
        details.setAssignedTime(null);
        if (details.hasTimes()) {
            for (SuggestionsInterface.TimeInfo time : details.getTimes()) {
                if (time.getDays() != assignment.getDays() || time.getStartSlot() != assignment.getStartSlot() || assignment.getPatternId() != null && !assignment.getPatternId().equals(time.getPatternId()) || assignment.getDatePatternId() != null && !assignment.getDatePatternId().equals(time.getDatePatternId())) continue;
                details.setAssignedTime(time);
            }
        }
        if (details.getNrAssignedRooms() > 0) {
            details.getAssignedRoom().clear();
        }
        if (details.hasRooms() && assignment.getRoomIds() != null) {
            block1: for (Long roomId : assignment.getRoomIds()) {
                for (SuggestionsInterface.RoomInfo room : details.getRooms()) {
                    if (!room.getId().equals(roomId)) continue;
                    details.setAssignedRoom(room);
                    continue block1;
                }
            }
        }
    }

    public static SuggestionsInterface.ClassAssignmentDetails createClassAssignmentDetails(SuggestionsContext context, Solver solver, Lecture lecture, Placement oldPlacement, Placement newPlacement) {
        SuggestionsInterface.ClassAssignmentDetails details = ClassAssignmentDetailsBackend.createClassAssignmentDetails(context, solver, lecture, oldPlacement, false, false);
        if (newPlacement != null) {
            if (newPlacement.isMultiRoom()) {
                for (RoomLocation room : newPlacement.getRoomLocations()) {
                    details.setAssignedRoom(new SuggestionsInterface.RoomInfo(room.getName(), room.getId(), room.getRoomSize(), room.getPreference() == 0 && lecture.nrRoomLocations() == lecture.getNrRooms() ? PreferenceLevel.sIntLevelRequired : room.getPreference()));
                }
            } else {
                RoomLocation room = newPlacement.getRoomLocation();
                details.setAssignedRoom(new SuggestionsInterface.RoomInfo(room.getName(), room.getId(), room.getRoomSize(), room.getPreference() == 0 && lecture.nrRoomLocations() == lecture.getNrRooms() ? PreferenceLevel.sIntLevelRequired : room.getPreference()));
            }
            TimeLocation time = newPlacement.getTimeLocation();
            int min = Constants.SLOT_LENGTH_MIN * time.getNrSlotsPerMeeting() - time.getBreakTime();
            details.setAssignedTime(new SuggestionsInterface.TimeInfo(time.getDayCode(), time.getStartSlot(), time.getPreference() == 0 && lecture.nrTimeLocations() == 1 ? PreferenceLevel.sIntLevelRequired : time.getPreference(), min, time.getDatePatternName(), time.getTimePatternId(), time.getDatePatternId(), time.getDatePatternPreference()));
            if (!lecture.getInstructorConstraints().isEmpty()) {
                for (int i = 0; i < lecture.getInstructorConstraints().size(); ++i) {
                    InstructorConstraint ic = (InstructorConstraint)lecture.getInstructorConstraints().get(i);
                    details.setInstructor(new SuggestionsInterface.InstructorInfo(ic.getName(), ic.getResourceId()));
                }
            }
            Map<String, String> translations = context.courseObjectives();
            for (Criterion criterion : lecture.getModel().getCriteria()) {
                String translatedName;
                if (criterion instanceof StudentOverlapConflict || criterion instanceof DeltaTimePreference) continue;
                String string = translatedName = translations == null || translations.isEmpty() ? null : translations.get(criterion.getName());
                if (translatedName != null) {
                    details.setAssignedObjective(translatedName, criterion.getValue(solver.currentSolution().getAssignment(), (Value)newPlacement, null));
                    continue;
                }
                details.setAssignedObjective(criterion.getName(), criterion.getValue(solver.currentSolution().getAssignment(), (Value)newPlacement, null));
            }
        }
        return details;
    }

    public static SuggestionsInterface.Suggestion createSuggestion(SuggestionsContext context, TimetableSolver solver, Map<Lecture, Placement> initialAssignments, List<Long> order, Collection<Placement> unresolvedConflicts) {
        return SelectedAssignmentBackend.createSuggestion(context, solver, initialAssignments, order, unresolvedConflicts, null);
    }

    public static SuggestionsInterface.Suggestion createSuggestion(SuggestionsContext context, TimetableSolver solver, Map<Lecture, Placement> initialAssignments, List<Long> order, Collection<Placement> unresolvedConflicts, Map<Lecture, Placement> unresolvedAssignments) {
        SuggestionsInterface.Suggestion suggestion = new SuggestionsInterface.Suggestion();
        Assignment assignment = solver.currentSolution().getAssignment();
        if (unresolvedConflicts != null) {
            for (Placement p : unresolvedConflicts) {
                suggestion.addUnresolvedConflict(SelectedAssignmentBackend.createClassAssignmentDetails(context, (Solver)solver, (Lecture)p.variable(), p, null));
            }
        }
        if (initialAssignments != null) {
            Placement anotherPlacement;
            SuggestionsInterface.DistributionInfo dist;
            HashSet jenrls = new HashSet();
            HashSet gcs = new HashSet();
            HashSet fcs = new HashSet();
            HashMap committed = new HashMap();
            for (Lecture lecture : assignment.assignedVariables()) {
                Placement ini;
                Placement p = (Placement)assignment.getValue((Variable)lecture);
                if (unresolvedAssignments != null && unresolvedAssignments.containsKey(lecture)) {
                    p = unresolvedAssignments.get(lecture);
                }
                if ((ini = initialAssignments.get(p.variable())) != null && ini.equals((Object)p)) continue;
                suggestion.addDifferentAssignment(SelectedAssignmentBackend.createClassAssignmentDetails(context, (Solver)solver, (Lecture)p.variable(), ini, p));
                jenrls.addAll(lecture.activeJenrls(assignment));
                if (p.getCommitedConflicts() > 0) {
                    HashMap x = new HashMap();
                    for (Object s : lecture.students()) {
                        Set confs = s.conflictPlacements(p);
                        if (confs == null) continue;
                        Iterator j = confs.iterator();
                        while (j.hasNext()) {
                            Placement commitedPlacement;
                            Integer current = (Integer)x.get(commitedPlacement = (Placement)j.next());
                            x.put(commitedPlacement, 1 + (current == null ? 0 : current));
                        }
                    }
                    committed.put(p, x);
                }
                gcs.addAll(lecture.groupConstraints());
                fcs.addAll(lecture.getFlexibleGroupConstraints());
                for (InstructorConstraint ic : lecture.getInstructorConstraints()) {
                    Object s;
                    s = ic.variables().iterator();
                    while (s.hasNext()) {
                        int pref;
                        Lecture other = (Lecture)s.next();
                        Placement otherPlacement = (Placement)assignment.getValue((Variable)other);
                        if (other.equals((Object)lecture) || otherPlacement == null || (pref = ic.getDistancePreference(p, otherPlacement)) == PreferenceLevel.sIntLevelNeutral) continue;
                        SuggestionsInterface.BtbInstructorInfo conf = new SuggestionsInterface.BtbInstructorInfo();
                        conf.setOther(SelectedAssignmentBackend.createClassAssignmentDetails(context, (Solver)solver, (Lecture)p.variable(), p, null));
                        conf.setAnother(SelectedAssignmentBackend.createClassAssignmentDetails(context, (Solver)solver, (Lecture)otherPlacement.variable(), otherPlacement, null));
                        conf.setPreference(pref);
                        suggestion.addBtbInstructorConflict(conf);
                    }
                }
            }
            if (unresolvedAssignments != null) {
                for (Map.Entry entry : unresolvedAssignments.entrySet()) {
                    Placement ini;
                    Lecture lecture = (Lecture)entry.getKey();
                    Placement p = (Placement)entry.getValue();
                    if (assignment.getValue((Variable)lecture) != null || (ini = initialAssignments.get(p.variable())) != null && ini.equals((Object)p)) continue;
                    suggestion.addDifferentAssignment(SelectedAssignmentBackend.createClassAssignmentDetails(context, (Solver)solver, (Lecture)p.variable(), ini, p));
                    jenrls.addAll(lecture.activeJenrls(assignment));
                    if (p.getCommitedConflicts() > 0) {
                        HashMap x = new HashMap();
                        for (Student s : lecture.students()) {
                            Set confs = s.conflictPlacements(p);
                            if (confs == null) continue;
                            Iterator j = confs.iterator();
                            while (j.hasNext()) {
                                Placement commitedPlacement;
                                Integer current = (Integer)x.get(commitedPlacement = (Placement)j.next());
                                x.put(commitedPlacement, 1 + (current == null ? 0 : current));
                            }
                        }
                        committed.put(p, x);
                    }
                    gcs.addAll(lecture.groupConstraints());
                    fcs.addAll(lecture.getFlexibleGroupConstraints());
                    for (InstructorConstraint ic : lecture.getInstructorConstraints()) {
                        for (Lecture other : ic.variables()) {
                            int pref;
                            Placement otherPlacement = (Placement)assignment.getValue((Variable)other);
                            if (other.equals((Object)lecture) || otherPlacement == null || (pref = ic.getDistancePreference(p, otherPlacement)) == PreferenceLevel.sIntLevelNeutral) continue;
                            SuggestionsInterface.BtbInstructorInfo conf = new SuggestionsInterface.BtbInstructorInfo();
                            conf.setOther(SelectedAssignmentBackend.createClassAssignmentDetails(context, (Solver)solver, (Lecture)p.variable(), p, null));
                            conf.setAnother(SelectedAssignmentBackend.createClassAssignmentDetails(context, (Solver)solver, (Lecture)otherPlacement.variable(), otherPlacement, null));
                            conf.setPreference(pref);
                            suggestion.addBtbInstructorConflict(conf);
                        }
                    }
                }
            }
            if (order != null && suggestion.hasDifferentAssignments()) {
                Collections.sort(suggestion.getDifferentAssignments(), new ClassAssignmentDetailsComparator(order));
            }
            for (JenrlConstraint jenrlConstraint : jenrls) {
                if (jenrlConstraint.jenrl() <= 0.0) continue;
                SuggestionsInterface.StudentConflictInfo conf = new SuggestionsInterface.StudentConflictInfo();
                conf.setOther(SelectedAssignmentBackend.createClassAssignmentDetails(context, (Solver)solver, (Lecture)jenrlConstraint.first(), (Placement)assignment.getValue(jenrlConstraint.first()), null));
                conf.setAnother(SelectedAssignmentBackend.createClassAssignmentDetails(context, (Solver)solver, (Lecture)jenrlConstraint.second(), (Placement)assignment.getValue(jenrlConstraint.second()), null));
                if (suggestion.hasDifferentAssignments()) {
                    int i1 = suggestion.getDifferentAssignments().indexOf(conf.getOther());
                    int i2 = suggestion.getDifferentAssignments().indexOf(conf.getAnother());
                    if (i2 > 0 && i1 < i2) {
                        SuggestionsInterface.ClassAssignmentDetails d = conf.getOther();
                        conf.setOther(conf.getAnother());
                        conf.setAnother(d);
                    }
                }
                conf.setInfo(ClassAssignmentDetailsBackend.toJenrlInfo(new JenrlInfo((Solver)solver, jenrlConstraint)));
                suggestion.addStudentConflict(conf);
            }
            for (GroupConstraint groupConstraint : gcs) {
                if (groupConstraint.isSatisfied(assignment)) continue;
                dist = new SuggestionsInterface.DistributionInfo();
                dist.setInfo(ClassAssignmentDetailsBackend.toGroupConstraintInfo(new GroupConstraintInfo((Assignment<Lecture, Placement>)assignment, groupConstraint)));
                for (Lecture another : groupConstraint.variables()) {
                    anotherPlacement = (Placement)assignment.getValue((Variable)another);
                    if (anotherPlacement == null) continue;
                    dist.addClass(SelectedAssignmentBackend.createClassAssignmentDetails(context, (Solver)solver, another, anotherPlacement, null));
                }
                suggestion.addDistributionConflict(dist);
            }
            Iterator<Object> iterator = fcs.iterator();
            while (iterator.hasNext()) {
                FlexibleConstraint flexibleConstraint = (FlexibleConstraint)iterator.next();
                if (flexibleConstraint.isHard() || flexibleConstraint.getNrViolations(assignment, new HashSet(), new HashMap()) == 0.0) continue;
                dist = new SuggestionsInterface.DistributionInfo();
                dist.setInfo(ClassAssignmentDetailsBackend.toGroupConstraintInfo(new GroupConstraintInfo((Assignment<Lecture, Placement>)assignment, flexibleConstraint)));
                for (Lecture another : flexibleConstraint.variables()) {
                    anotherPlacement = (Placement)assignment.getValue((Variable)another);
                    if (anotherPlacement == null) continue;
                    dist.addClass(SelectedAssignmentBackend.createClassAssignmentDetails(context, (Solver)solver, another, anotherPlacement, null));
                }
                suggestion.addDistributionConflict(dist);
            }
        }
        TimetableModel m = (TimetableModel)solver.currentSolution().getModel();
        suggestion.setValue(m.getTotalValue(assignment));
        suggestion.setUnassignedVariables(m.nrUnassignedVariables(assignment));
        Map<String, String> translations = context.courseObjectives();
        for (Criterion c : m.getCriteria()) {
            String translatedName;
            if (c instanceof StudentOverlapConflict || c instanceof DeltaTimePreference) continue;
            String string = translatedName = translations == null || translations.isEmpty() ? null : translations.get(c.getName());
            if (translatedName != null) {
                suggestion.setCriterion(translatedName, c.getValue(assignment));
                continue;
            }
            suggestion.setCriterion(c.getName(), c.getValue(assignment));
        }
        Criterion sc = m.getCriterion(StudentConflict.class);
        Criterion shc = m.getCriterion(StudentHardConflict.class);
        Criterion sdc = m.getCriterion(StudentDistanceConflict.class);
        Criterion criterion = m.getCriterion(StudentCommittedConflict.class);
        long studentConflicts = Math.round((criterion == null ? 0.0 : criterion.getValue(assignment)) + (sc == null ? 0.0 : sc.getValue(assignment)) - context.getBaseStudentConflicts());
        long studentConflictsCommitted = Math.round((criterion == null ? 0.0 : criterion.getValue(assignment)) - context.getBaseStudentConflictsCommitted());
        long studentConflictsDistance = Math.round((sdc == null ? 0.0 : sdc.getValue(assignment)) - context.getBaseStudentConflictsDistance());
        long studentConflictsHard = Math.round((shc == null ? 0.0 : shc.getValue(assignment)) - context.getBaseStudentConflictsHard());
        TableInterface.TableCellMulti studentConfs = new TableInterface.TableCellMulti();
        studentConfs.add(SelectedAssignmentBackend.dispNumber(studentConflicts));
        if (studentConflictsCommitted != 0L) {
            if (studentConfs.getNrChunks() <= 1) {
                studentConfs.add(" (");
            } else {
                studentConfs.add(",");
            }
            studentConfs.add(SelectedAssignmentBackend.dispNumber(studentConflictsCommitted).setFormattedValue("c" + (studentConflictsCommitted > 0L ? "+" : "") + studentConflictsCommitted));
        }
        if (studentConflictsDistance != 0L) {
            if (studentConfs.getNrChunks() <= 1) {
                studentConfs.add(" (");
            } else {
                studentConfs.add(",");
            }
            studentConfs.add(SelectedAssignmentBackend.dispNumber(studentConflictsDistance).setFormattedValue("d" + (studentConflictsDistance > 0L ? "+" : "") + studentConflictsDistance));
        }
        if (studentConflictsHard != 0L) {
            if (studentConfs.getNrChunks() <= 1) {
                studentConfs.add(" (");
            } else {
                studentConfs.add(",");
            }
            studentConfs.add(SelectedAssignmentBackend.dispNumber(studentConflictsHard).setFormattedValue("h" + (studentConflictsHard > 0L ? "+" : "") + studentConflictsHard));
        }
        if (studentConfs.getNrChunks() > 1) {
            studentConfs.add(")");
        }
        suggestion.setStudentConflictSummary(studentConfs);
        return suggestion;
    }

    protected static void fillDescriptions(Assignment<Lecture, Placement> assignment, Placement p, Map<Long, String> descriptions) {
        for (Constraint constraint : ((Lecture)p.variable()).hardConstraints()) {
            HashSet conflicts = new HashSet();
            constraint.computeConflicts(assignment, (Value)p, conflicts);
            for (Placement conflict : conflicts) {
                if (descriptions.containsKey(((Lecture)conflict.variable()).getClassId())) continue;
                descriptions.put(((Lecture)conflict.variable()).getClassId(), TimetableSolver.getConstraintName((Constraint<Lecture, Placement>)constraint));
            }
        }
    }

    public static SuggestionsInterface.Suggestion computeSuggestion(SuggestionsContext context, TimetableSolver solver, List<SuggestionsInterface.SelectedAssignment> assignments, Placement placement) {
        Lecture lect;
        SuggestionsInterface.Suggestion ret = null;
        Solution solution = solver.currentSolution();
        TimetableModel model = (TimetableModel)solution.getModel();
        Assignment assignment = solution.getAssignment();
        ArrayList unAssignedVariables = new ArrayList(assignment.unassignedVariables((Model)model));
        HashMap<Lecture, Placement> initialAssignments = new HashMap<Lecture, Placement>();
        for (Lecture lec : assignment.assignedVariables()) {
            initialAssignments.put(lec, (Placement)assignment.getValue((Variable)lec));
        }
        HashMap<Variable, Placement> conflictsToResolve = new HashMap<Variable, Placement>();
        ArrayList<Long> resolvedLectures = new ArrayList<Long>();
        HashMap<Lecture, Placement> unresolvedLectures = new HashMap<Lecture, Placement>();
        ArrayList<Placement> hints = new ArrayList<Placement>();
        HashMap<Long, String> descriptions = new HashMap<Long, String>();
        if (assignments != null) {
            for (SuggestionsInterface.SelectedAssignment a : assignments) {
                Placement plac = SelectedAssignmentBackend.getPlacement(model, a, false);
                if (plac == null) continue;
                if (!plac.isValid()) {
                    String reason = TimetableSolver.getNotValidReason(plac, (Assignment<Lecture, Placement>)assignment, solver.getProperties().getPropertyBoolean("General.UseAmPm", true));
                    throw new GwtRpcException(reason == null ? MSG.reasonNotKnown() : reason);
                }
                Lecture lect2 = (Lecture)plac.variable();
                if (placement != null && ((Lecture)placement.variable()).equals((Object)lect2)) continue;
                hints.add(plac);
                SelectedAssignmentBackend.fillDescriptions((Assignment<Lecture, Placement>)assignment, plac, descriptions);
                Set conflicts = model.conflictValues(assignment, (Value)plac);
                for (Placement conflictPlacement : conflicts) {
                    conflictsToResolve.put(conflictPlacement.variable(), conflictPlacement);
                    assignment.unassign(0L, conflictPlacement.variable());
                }
                if (!conflicts.contains(plac)) {
                    resolvedLectures.add(lect2.getClassId());
                    conflictsToResolve.remove(lect2);
                    assignment.assign(0L, (Value)plac);
                    continue;
                }
                unresolvedLectures.put((Lecture)plac.variable(), plac);
            }
        }
        if (placement != null) {
            SelectedAssignmentBackend.fillDescriptions((Assignment<Lecture, Placement>)assignment, placement, descriptions);
            Lecture lect3 = (Lecture)placement.variable();
            Set conflicts = model.conflictValues(assignment, (Value)placement);
            for (Placement conflictPlacement : conflicts) {
                conflictsToResolve.put(conflictPlacement.variable(), conflictPlacement);
                assignment.unassign(0L, conflictPlacement.variable());
            }
            if (!conflicts.contains(placement)) {
                resolvedLectures.add(lect3.getClassId());
                conflictsToResolve.remove(lect3);
                assignment.assign(0L, (Value)placement);
            } else {
                unresolvedLectures.put((Lecture)placement.variable(), placement);
            }
        }
        ret = SelectedAssignmentBackend.createSuggestion(context, solver, initialAssignments, null, conflictsToResolve.values(), unresolvedLectures);
        ret.setCanAssign(unresolvedLectures.isEmpty());
        if (placement != null) {
            ret.setPlacement(SelectedAssignmentBackend.createClassAssignmentDetails(context, (Solver)solver, (Lecture)placement.variable(), placement, null));
        }
        for (Placement plac : hints) {
            lect = (Lecture)plac.variable();
            if (assignment.getValue((Variable)lect) == null) continue;
            assignment.unassign(0L, (Variable)lect);
        }
        for (Lecture lect4 : unAssignedVariables) {
            if (assignment.getValue((Variable)lect4) == null) continue;
            assignment.unassign(0L, (Variable)lect4);
        }
        if (placement != null) {
            assignment.unassign(0L, placement.variable());
        }
        for (Placement plac : initialAssignments.values()) {
            if (plac.equals((Object)assignment.getValue((Variable)(lect = (Lecture)plac.variable())))) continue;
            assignment.assign(0L, (Value)plac);
        }
        if (ret.hasDifferentAssignments()) {
            for (SuggestionsInterface.ClassAssignmentDetails d : ret.getDifferentAssignments()) {
                d.setConflict((String)descriptions.get(d.getClazz().getClassId()));
            }
        }
        if (ret.hasUnresolvedConflicts()) {
            for (SuggestionsInterface.ClassAssignmentDetails d : ret.getUnresolvedConflicts()) {
                d.setConflict((String)descriptions.get(d.getClazz().getClassId()));
            }
        }
        Map<String, String> translations = context.courseObjectives();
        for (Criterion c : model.getCriteria()) {
            String translatedName;
            if (c instanceof StudentOverlapConflict || c instanceof DeltaTimePreference) continue;
            String string = translatedName = translations == null || translations.isEmpty() ? null : translations.get(c.getName());
            if (translatedName != null) {
                ret.setBaseCriterion(translatedName, c.getValue(assignment));
                continue;
            }
            ret.setBaseCriterion(c.getName(), c.getValue(assignment));
        }
        ret.setBaseValue(model.getTotalValue(assignment));
        ret.setBaseUnassignedVariables(model.nrUnassignedVariables(assignment));
        return ret;
    }

    public static TableInterface.TableCellInterface dispNumber(long value) {
        TableInterface.TableCellInterface<Long> cell = new TableInterface.TableCellInterface<Long>(value).setColor(value < 0L ? "green" : (value > 0L ? "red" : null));
        if (value > 0L) {
            cell.setFormattedValue("+" + value);
        }
        return cell;
    }

    public static class ClassAssignmentDetailsComparator
    implements Comparator<SuggestionsInterface.ClassAssignmentDetails> {
        private List<Long> iOrder;

        public ClassAssignmentDetailsComparator(List<Long> order) {
            this.iOrder = order;
        }

        @Override
        public int compare(SuggestionsInterface.ClassAssignmentDetails d1, SuggestionsInterface.ClassAssignmentDetails d2) {
            int i1 = this.iOrder.indexOf(d1.getClazz().getClassId());
            int i2 = this.iOrder.indexOf(d2.getClazz().getClassId());
            return Integer.valueOf(i1).compareTo(i2);
        }
    }
}

