/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.basic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.cpsolver.ifs.heuristics.RouletteWheelSelection;
import org.hibernate.criterion.Order;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.OverrideType;
import org.unitime.timetable.model.dao.OverrideTypeDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CustomCourseLookupHolder;
import org.unitime.timetable.onlinesectioning.custom.Customization;
import org.unitime.timetable.onlinesectioning.custom.ExternalTermProvider;
import org.unitime.timetable.onlinesectioning.match.CourseMatcher;
import org.unitime.timetable.onlinesectioning.model.XAreaClassificationMajor;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.status.StatusPageSuggestionsAction;

public class ListCourseOfferings
implements OnlineSectioningAction<Collection<ClassAssignmentInterface.CourseAssignment>> {
    private static final long serialVersionUID = 1L;
    protected String iQuery = null;
    protected CourseRequestInterface.Request iRequest = null;
    protected Integer iLimit = null;
    protected CourseMatcher iMatcher = null;
    protected Long iStudentId;
    protected String iFilterIM = null;
    private transient XStudent iStudent = null;

    public ListCourseOfferings forQuery(String query) {
        this.iQuery = query;
        return this;
    }

    public ListCourseOfferings forRequest(CourseRequestInterface.Request request) {
        this.iRequest = request;
        return this;
    }

    public ListCourseOfferings withLimit(Integer limit) {
        this.iLimit = limit;
        return this;
    }

    public ListCourseOfferings withMatcher(CourseMatcher matcher) {
        this.iMatcher = matcher;
        return this;
    }

    public ListCourseOfferings forStudent(Long studentId) {
        this.iStudentId = studentId;
        return this;
    }

    public Long getStudentId() {
        return this.iStudentId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ClassAssignmentInterface.CourseAssignment> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        OnlineSectioningServer.Lock lock = server.readLock();
        try {
            List overrides;
            String filter;
            XStudent xStudent = this.iStudent = this.getStudentId() == null ? null : server.getStudent(this.getStudentId());
            if (this.iStudent != null && (filter = server.getConfig().getProperty("Filter.OnlineOnlyStudentFilter", null)) != null && !filter.isEmpty()) {
                if (new Query(filter).match(new StatusPageSuggestionsAction.StudentMatcher(this.iStudent, server.getAcademicSession().getDefaultSectioningStatus(), server, false))) {
                    this.iFilterIM = server.getConfig().getProperty("Filter.OnlineOnlyInstructionalModeRegExp");
                } else if (server.getConfig().getPropertyBoolean("Filter.OnlineOnlyExclusiveCourses", false)) {
                    this.iFilterIM = server.getConfig().getProperty("Filter.ResidentialInstructionalModeRegExp");
                }
            }
            if (this.iFilterIM != null) {
                if (helper.hasAdminPermission() && server.getConfig().getPropertyBoolean("Filter.OnlineOnlyAdminOverride", false)) {
                    this.iFilterIM = null;
                } else if (helper.hasAvisorPermission() && server.getConfig().getPropertyBoolean("Filter.OnlineOnlyAdvisorOverride", false)) {
                    this.iFilterIM = null;
                }
            }
            List<Object> courses = null;
            if (this.iRequest != null) {
                courses = new ArrayList();
                for (Long courseId : this.iRequest.getCourseIds()) {
                    XCourse course = server.getCourse(courseId);
                    if (course == null) continue;
                    courses.add(this.convert(course, server));
                }
            } else {
                courses = this.listCourses(server, helper);
            }
            if (courses != null && !courses.isEmpty() && courses.size() <= 1000 && (overrides = OverrideTypeDAO.getInstance().findAll(helper.getHibSession(), Order.asc((String)"label"))) != null && !overrides.isEmpty()) {
                HashMap<Long, ClassAssignmentInterface.CourseAssignment> table = new HashMap<Long, ClassAssignmentInterface.CourseAssignment>();
                for (ClassAssignmentInterface.CourseAssignment courseAssignment : courses) {
                    table.put(courseAssignment.getCourseId(), courseAssignment);
                }
                for (CourseOffering courseOffering : helper.getHibSession().createQuery("from CourseOffering co left join fetch co.disabledOverrides do where co.uniqueId in :courseIds").setParameterList("courseIds", table.keySet(), (Type)LongType.INSTANCE).list()) {
                    for (OverrideType overrideType : overrides) {
                        if (courseOffering.getDisabledOverrides().contains(overrideType)) continue;
                        ((ClassAssignmentInterface.CourseAssignment)table.get(courseOffering.getUniqueId())).addOverride(overrideType.getReference(), overrideType.getLabel());
                    }
                }
            }
            if (ApplicationProperty.ListCourseOfferingsMatchingCampusFirst.isTrue() && this.iStudent != null && courses != null && !courses.isEmpty()) {
                String campus;
                XAreaClassificationMajor primary = this.iStudent.getPrimaryMajor();
                String string = campus = primary == null ? null : primary.getCampus();
                if (campus != null && !campus.equals(server.getAcademicSession().getCampus())) {
                    Object object;
                    ExternalTermProvider ext = (ExternalTermProvider)Customization.ExternalTermProvider.getProvider();
                    ArrayList<ClassAssignmentInterface.CourseAssignment> arrayList = new ArrayList<ClassAssignmentInterface.CourseAssignment>(courses.size());
                    for (ClassAssignmentInterface.CourseAssignment courseAssignment : courses) {
                        if (ext == null) {
                            if (!courseAssignment.getSubject().startsWith(campus + " - ")) continue;
                            arrayList.add(courseAssignment);
                            continue;
                        }
                        if (!campus.equals(ext.getExternalCourseCampus(server.getAcademicSession(), courseAssignment.getSubject(), courseAssignment.getCourseNbr()))) continue;
                        arrayList.add(courseAssignment);
                    }
                    if (arrayList.isEmpty()) {
                        object = courses;
                        return object;
                    }
                    for (ClassAssignmentInterface.CourseAssignment courseAssignment : courses) {
                        if (ext == null) {
                            if (courseAssignment.getSubject().startsWith(campus + " - ")) continue;
                            arrayList.add(courseAssignment);
                            continue;
                        }
                        if (campus.equals(ext.getExternalCourseCampus(server.getAcademicSession(), courseAssignment.getSubject(), courseAssignment.getCourseNbr()))) continue;
                        arrayList.add(courseAssignment);
                    }
                    object = arrayList;
                    return object;
                }
            }
            List<Object> list = courses;
            return list;
        }
        finally {
            lock.release();
        }
    }

    protected List<ClassAssignmentInterface.CourseAssignment> listCourses(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        List<ClassAssignmentInterface.CourseAssignment> ret = this.customCourseLookup(server, helper);
        if (ret != null && !ret.isEmpty()) {
            return ret;
        }
        ret = new ArrayList<ClassAssignmentInterface.CourseAssignment>();
        for (XCourseId xCourseId : server.findCourses(this.iQuery, this.iLimit, this.iMatcher)) {
            XCourse course = server.getCourse(xCourseId.getCourseId());
            if (course == null) continue;
            ret.add(this.convert(course, server));
        }
        return ret;
    }

    protected List<ClassAssignmentInterface.CourseAssignment> customCourseLookup(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        try {
            List<XCourse> courses;
            if (this.iMatcher != null) {
                this.iMatcher.setServer(server);
            }
            if (this.iQuery != null && !this.iQuery.isEmpty() && CustomCourseLookupHolder.hasProvider() && (courses = CustomCourseLookupHolder.getProvider().getCourses(server, helper, this.iQuery, true)) != null && !courses.isEmpty()) {
                ArrayList<ClassAssignmentInterface.CourseAssignment> ret = new ArrayList<ClassAssignmentInterface.CourseAssignment>();
                for (XCourse course : courses) {
                    if (course == null || this.iMatcher != null && !this.iMatcher.match(course)) continue;
                    ret.add(this.convert(course, server));
                }
                ListCourseOfferings.setSelection(ret);
                return ret;
            }
        }
        catch (Exception e) {
            helper.error("Failed to use the custom course lookup: " + e.getMessage(), e);
        }
        return null;
    }

    protected ClassAssignmentInterface.CourseAssignment convert(XCourse c, OnlineSectioningServer server) {
        ClassAssignmentInterface.CourseAssignment course = new ClassAssignmentInterface.CourseAssignment();
        course.setCourseId(c.getCourseId());
        course.setSubject(c.getSubjectArea());
        course.setCourseNbr(c.getCourseNumber());
        course.setTitle(c.getTitle());
        course.setNote(c.getNote());
        course.setCreditAbbv(c.getCreditAbbv());
        course.setCreditText(c.getCreditText());
        course.setTitle(c.getTitle());
        course.setHasUniqueName(c.hasUniqueName());
        course.setLimit(c.getLimit());
        course.setSnapShotLimit(c.getSnapshotLimit());
        XOffering offering = server.getOffering(c.getOfferingId());
        XEnrollment enrollment = null;
        if (this.iFilterIM != null && this.iStudent != null) {
            XCourseRequest r = this.iStudent.getRequestForCourse(c.getCourseId());
            XEnrollment xEnrollment = enrollment = r == null ? null : r.getEnrollment();
        }
        if (offering != null) {
            course.setAvailability(offering.getCourseAvailability(server.getRequests(c.getOfferingId()), c));
            for (XConfig config : offering.getConfigs()) {
                if (!(this.iFilterIM == null || enrollment != null && config.getConfigId().equals(enrollment.getConfigId()))) {
                    String imRef;
                    String string = imRef = config.getInstructionalMethod() == null ? null : config.getInstructionalMethod().getReference();
                    if (!this.iFilterIM.isEmpty() ? imRef == null || !imRef.matches(this.iFilterIM) : imRef != null && !imRef.isEmpty()) continue;
                }
                if (config.getInstructionalMethod() != null) {
                    course.addInstructionalMethod(config.getInstructionalMethod().getUniqueId(), config.getInstructionalMethod().getLabel());
                    continue;
                }
                course.setHasNoInstructionalMethod(true);
            }
            course.setHasCrossList(offering.hasCrossList());
            course.setCanWaitList(offering.isWaitList());
        }
        return course;
    }

    public static void setSelection(List<ClassAssignmentInterface.CourseAssignment> courses) {
        if (courses == null || courses.isEmpty()) {
            return;
        }
        SelectionMode mode = SelectionMode.valueOf(ApplicationProperty.ListCourseOfferingsSelectionMode.value());
        int limit = ApplicationProperty.ListCourseOfferingsSelectionLimit.intValue();
        if (ApplicationProperty.ListCourseOfferingsSelectionRandomize.isTrue()) {
            RouletteWheelSelection roulette = new RouletteWheelSelection();
            for (ClassAssignmentInterface.CourseAssignment ca : courses) {
                int p = mode.getPoints(ca);
                if (p <= 0) continue;
                roulette.add((Object)ca, (double)p);
            }
            int idx = 0;
            while (roulette.hasMoreElements() && idx < limit) {
                ClassAssignmentInterface.CourseAssignment ca;
                ca = (ClassAssignmentInterface.CourseAssignment)roulette.nextElement();
                ca.setSelection(idx++);
            }
        } else {
            ClassAssignmentInterface.CourseAssignment ca;
            int p;
            ArrayList<ClassAssignmentInterface.CourseAssignment> sorted = new ArrayList<ClassAssignmentInterface.CourseAssignment>(courses);
            Collections.sort(sorted, mode);
            int idx = 0;
            Iterator iterator = sorted.iterator();
            while (iterator.hasNext() && (p = mode.getPoints(ca = (ClassAssignmentInterface.CourseAssignment)iterator.next())) > 0 && idx < limit) {
                ca.setSelection(idx++);
            }
        }
    }

    @Override
    public String name() {
        return "list-courses";
    }

    public static enum SelectionMode implements Comparator<ClassAssignmentInterface.CourseAssignment>
    {
        availability(new SelectionModeInterface(){

            @Override
            public int getPoints(ClassAssignmentInterface.CourseAssignment ca) {
                int p = 0;
                if (ca.getLimit() != null) {
                    p += 4 * (ca.getLimit() < 0 ? 9999 : ca.getLimit());
                }
                if (ca.getEnrollment() != null) {
                    p -= 3 * ca.getEnrollment();
                }
                if (ca.getRequested() != null) {
                    p -= ca.getRequested().intValue();
                }
                return p;
            }
        }),
        limit(new SelectionModeInterface(){

            @Override
            public int getPoints(ClassAssignmentInterface.CourseAssignment ca) {
                return ca.getLimit() < 0 ? 999 : ca.getLimit();
            }
        }),
        snapshot(new SelectionModeInterface(){

            @Override
            public int getPoints(ClassAssignmentInterface.CourseAssignment ca) {
                int snapshot = ca.getSnapShotLimit() == null ? 0 : (ca.getSnapShotLimit() < 0 ? 999 : ca.getSnapShotLimit());
                int limit = ca.getLimit() < 0 ? 999 : ca.getLimit();
                return Math.max(snapshot, limit);
            }
        });

        SelectionModeInterface iMode;

        private SelectionMode(SelectionModeInterface mode) {
            this.iMode = mode;
        }

        public int getPoints(ClassAssignmentInterface.CourseAssignment ca) {
            return this.iMode.getPoints(ca);
        }

        @Override
        public int compare(ClassAssignmentInterface.CourseAssignment ca1, ClassAssignmentInterface.CourseAssignment ca2) {
            int p2;
            int p1 = this.getPoints(ca1);
            if (p1 != (p2 = this.getPoints(ca2))) {
                return p1 > p2 ? -1 : 1;
            }
            return ca1.getCourseNameWithTitle().compareTo(ca2.getCourseNameWithTitle());
        }
    }

    static interface SelectionModeInterface {
        public int getPoints(ClassAssignmentInterface.CourseAssignment var1);
    }
}

