/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.Iterator;
import java.util.List;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseCourseCatalog;
import org.unitime.timetable.model.dao.SubjectAreaDAO;

public class CourseCatalog
extends BaseCourseCatalog {
    private static final long serialVersionUID = 1L;

    public CourseCatalog() {
    }

    public CourseCatalog(Long uniqueId) {
        super(uniqueId);
    }

    public static CourseCatalog findCourseFromPreviousSessionInCatalogForSession(CourseOffering courseOffering, Session session) {
        List l;
        if (courseOffering == null || session == null) {
            return null;
        }
        String query = "select distinct cc from CourseCatalog cc";
        query = query + " where cc.session.uniqueId=:sessionId";
        query = query + "  and ((cc.subject=:subjectAbbv";
        query = query + "    and cc.courseNumber=:courseNbr";
        query = query + "    and (cc.previousSubject is null or cc.previousSubject = cc.subject)";
        query = query + "    and (cc.previousCourseNumber is null or cc.previousCourseNumber = cc.courseNumber))";
        query = query + "   or (cc.previousSubject=:subjectAbbv";
        query = query + "    and cc.previousCourseNumber=:courseNbr))";
        if (courseOffering.getPermId() != null && Integer.parseInt(courseOffering.getPermId()) > 0) {
            query = query + "  and cc.permanentId = '" + courseOffering.getPermId() + "'";
        }
        if ((l = SubjectAreaDAO.getInstance().getQuery(query).setLong("sessionId", session.getUniqueId().longValue()).setString("subjectAbbv", courseOffering.getSubjectAreaAbbv()).setString("courseNbr", courseOffering.getCourseNbr()).list()) != null && l.size() == 1) {
            return (CourseCatalog)l.get(0);
        }
        if (l != null && l.size() > 1) {
            CourseCatalog cc = null;
            boolean found = false;
            Iterator ccIt = l.iterator();
            while (ccIt.hasNext() && !found) {
                cc = (CourseCatalog)ccIt.next();
                if (cc.getPreviousSubject().equals(courseOffering.getSubjectAreaAbbv()) && cc.getPreviousCourseNumber().equals(courseOffering.getCourseNbr())) {
                    found = true;
                    continue;
                }
                if (cc.getPermanentId() == null || courseOffering.getPermId() == null || !cc.getPermanentId().equals(courseOffering.getPermId())) continue;
                found = true;
            }
            if (found) {
                return cc;
            }
        }
        return null;
    }

    public static CourseCatalog findCourseInCatalogForSession(CourseOffering courseOffering, Session session) {
        if (courseOffering == null || session == null) {
            return null;
        }
        String query = "select distinct cc.* from CourseCatalog cc";
        query = query + " where cc.session.uniqueId=:sessionId";
        query = query + "  and cc.subject=:subjectAbbv";
        query = query + "  and cc.courseNumber=:courseNbr";
        List l = SubjectAreaDAO.getInstance().getQuery(query).setLong("sessionId", session.getUniqueId().longValue()).setString("subjectAbbv", courseOffering.getSubjectAreaAbbv()).setString("courseNbr", courseOffering.getCourseNbr()).list();
        if (l != null && l.size() == 1) {
            return (CourseCatalog)l.get(0);
        }
        if (l != null && l.size() > 1) {
            CourseCatalog cc = null;
            boolean found = false;
            Iterator ccIt = l.iterator();
            while (ccIt.hasNext() && !found) {
                cc = (CourseCatalog)ccIt.next();
                if (!cc.getSubject().equals(courseOffering.getSubjectAreaAbbv()) || !cc.getCourseNumber().equals(courseOffering.getCourseNbr())) continue;
                found = true;
            }
            if (found) {
                return cc;
            }
        }
        return null;
    }
}

