/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.util.Date;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.ClassInfoForm;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.base.BasePreferenceGroup;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.course.ui.ClassInfoModel;
import org.unitime.timetable.util.DefaultRoomAvailabilityService;
import org.unitime.timetable.util.RoomAvailability;

@Action(value="classInfo", results={@Result(name={"show"}, type="tiles", location="classInfo.tiles")})
@TilesDefinition(name="classInfo.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Class Assignment"), @TilesPutAttribute(name="body", value="/tt/info.jsp"), @TilesPutAttribute(name="showMenu", value="false")})
public class ClassInfoAction
extends UniTimeAction<ClassInfoForm> {
    private static final long serialVersionUID = 7634412254896426556L;
    protected static CourseMessages MSG = Localization.create(CourseMessages.class);
    protected Long classId = null;
    protected String op2 = null;
    protected String time;
    protected String date;
    protected String room;
    protected Long deleteId;

    public Long getClassId() {
        return this.classId;
    }

    public void setClassId(Long classId) {
        this.classId = classId;
    }

    public String getOp2() {
        return this.op2;
    }

    public void setOp2(String op2) {
        this.op2 = op2;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public String getRoom() {
        return this.room;
    }

    public void setRoom(String room) {
        this.room = room;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public Long getDelete() {
        return this.deleteId;
    }

    public void setDelete(Long deleteId) {
        this.deleteId = deleteId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        Serializable session;
        Object type;
        if (this.form == null) {
            this.form = new ClassInfoForm();
        }
        ((ClassInfoForm)this.form).setSessionId(this.sessionContext.getUser().getCurrentAcademicSessionId());
        if (this.op == null) {
            this.op = ((ClassInfoForm)this.form).getOp();
        }
        if (this.op2 != null && !this.op2.isEmpty()) {
            this.op = this.op2;
        }
        ((ClassInfoForm)this.form).setOp(this.op);
        ClassInfoModel model = (ClassInfoModel)this.sessionContext.getAttribute(SessionAttribute.ClassInfoModel);
        if (model == null) {
            model = new ClassInfoModel();
            this.sessionContext.setAttribute(SessionAttribute.ClassInfoModel, (Object)model);
            type = ApplicationProperty.ClassAssignmentStudentConflictsType.value();
            if ("none".equalsIgnoreCase((String)type)) {
                model.setShowStudentConflicts(false);
                model.setUseRealStudents(StudentClassEnrollment.sessionHasEnrollments(this.sessionContext.getUser().getCurrentAcademicSessionId()));
            } else if ("actual".equalsIgnoreCase((String)type)) {
                model.setShowStudentConflicts(true);
                model.setUseRealStudents(true);
            } else if ("solution".equalsIgnoreCase((String)type)) {
                model.setShowStudentConflicts(true);
                model.setUseRealStudents(false);
            } else {
                model.setUseRealStudents(StudentClassEnrollment.sessionHasEnrollments(this.sessionContext.getUser().getCurrentAcademicSessionId()));
            }
        }
        model.setSessionContext(this.sessionContext);
        if (this.op == null && model.getClass() != null && this.classId == null) {
            this.op = "Apply";
        }
        if (MSG.actionFilterApply().equals(this.op) || "Apply".equals(this.op)) {
            ((ClassInfoForm)this.form).save(this.request.getSession());
        } else if ("Refresh".equals(this.op)) {
            ((ClassInfoForm)this.form).reset();
        }
        ((ClassInfoForm)this.form).load(this.request.getSession());
        ((ClassInfoForm)this.form).setModel(model);
        model.apply(this.request, (ClassInfoForm)this.form);
        if (this.op == null) {
            model.clear(this.sessionContext.getUser().getExternalUserId());
        } else if ("Apply".equals(this.op)) {
            model.refreshRooms();
            if (model.isKeepConflictingAssignments() != ((ClassInfoForm)this.form).getKeepConflictingAssignments()) {
                model.update();
            }
        }
        if (this.classId != null) {
            model.setClazz((Class_)new Class_DAO().get(this.classId));
            if (model.getClassAssignment() != null && (model.getChange() == null || model.getChange().getCurrent(model.getClazz().getClassId()) == null)) {
                model.setTime(model.getClassAssignment().getTimeId());
            }
            ((ClassInfoForm)this.form).save(this.request.getSession());
        }
        if (model.getClazz() == null) {
            throw new Exception(MSG.errorNoClassGiven());
        }
        this.sessionContext.checkPermission(model.getClazz().getClazz(), Right.ClassAssignment);
        if (RoomAvailability.getInstance() != null && this.op == null && !(RoomAvailability.getInstance() instanceof DefaultRoomAvailabilityService)) {
            session = (Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId());
            Date[] bounds = DatePattern.getBounds(((BasePreferenceGroup)session).getUniqueId());
            RoomAvailability.getInstance().activate(((BasePreferenceGroup)session).getUniqueId(), bounds[0], bounds[1], RoomAvailabilityInterface.sClassType, false);
            RoomAvailability.setAvailabilityWarning(this.request, (Session)session, true, true);
        }
        if ("Select".equals(this.op)) {
            session = model;
            synchronized (session) {
                if (this.time != null) {
                    model.setTime(this.time);
                }
                if (this.date != null) {
                    model.setDate(this.date);
                }
                if (this.room != null) {
                    model.setRooms(this.room);
                }
                if (this.deleteId != null) {
                    model.delete(this.deleteId);
                }
            }
        }
        if ("Type".equals(this.op)) {
            type = this.request.getParameter("type");
            if ("actual".equalsIgnoreCase((String)type)) {
                model.setUseRealStudents(true);
            } else if ("solution".equalsIgnoreCase((String)type)) {
                model.setUseRealStudents(false);
            }
            model.setClazz(model.getClazz().getClazz());
            model.update();
        }
        if (MSG.actionClassAssign().equals(this.op) || "Assign".equals(this.op)) {
            type = model;
            synchronized (type) {
                String message = model.assign(this.sessionContext);
                if (message == null || message.trim().length() == 0) {
                    ((ClassInfoForm)this.form).setOp("Close");
                } else {
                    ((ClassInfoForm)this.form).setMessage(message);
                }
            }
        }
        if ("Lock".equals(this.op)) {
            InstructionalOffering offering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(Long.valueOf(this.request.getParameter("offering")));
            this.sessionContext.checkPermission(offering, Right.OfferingCanLock);
            offering.getSession().lockOffering(offering.getUniqueId());
        }
        if ("Close".equals(this.op)) {
            ((ClassInfoForm)this.form).setOp("Close");
        }
        if (((ClassInfoForm)this.form).getOp() == null || ((ClassInfoForm)this.form).getOp().equals("Close")) {
            ((ClassInfoForm)this.form).setKeepConflictingAssignments(false);
            this.request.getSession().removeAttribute("ClassInfo.KeepConflictingAssignments");
        }
        return "show";
    }
}

