/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util;

import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.interfaces.ExternalUidLookup;

@Deprecated
public class LdapExternalUidLookup
implements ExternalUidLookup {
    public DirContext getDirContext() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", ApplicationProperties.getProperty("tmtbl.authenticate.ldap.ctxFactory", "com.sun.jndi.ldap.LdapCtxFactory"));
        env.put("java.naming.provider.url", ApplicationProperties.getProperty("tmtbl.authenticate.ldap.provider"));
        env.put("java.naming.referral", ApplicationProperties.getProperty("tmtbl.authenticate.ldap.referral", "ignore"));
        if (ApplicationProperties.getProperty("tmtbl.authenticate.ldap.version") != null) {
            env.put("java.naming.ldap.version", ApplicationProperties.getProperty("tmtbl.authenticate.ldap.version"));
        }
        env.put("java.naming.security.authentication", ApplicationProperties.getProperty("tmtbl.authenticate.ldap.security", "simple"));
        if (ApplicationProperties.getProperty("tmtbl.authenticate.ldap.socketFactory") != null) {
            env.put("java.naming.ldap.factory.socket", ApplicationProperties.getProperty("tmtbl.authenticate.ldap.socketFactory"));
        }
        if (ApplicationProperties.getProperty("tmtbl.authenticate.ldap.ssl.keyStore") != null) {
            System.setProperty("javax.net.ssl.keyStore", ApplicationProperties.getProperty("tmtbl.authenticate.ldap.ssl.keyStore").replaceAll("%WEB-INF%", ApplicationProperties.getBasePath()));
        }
        if (ApplicationProperties.getProperty("tmtbl.authenticate.ldap.ssl.trustStore") != null) {
            System.setProperty("javax.net.ssl.trustStore", ApplicationProperties.getProperty("tmtbl.authenticate.ldap.ssl.trustStore").replaceAll("%WEB-INF%", ApplicationProperties.getBasePath()));
        }
        if (ApplicationProperties.getProperty("tmtbl.authenticate.ldap.ssl.trustStorePassword") != null) {
            System.setProperty("javax.net.ssl.keyStorePassword", ApplicationProperties.getProperty("tmtbl.authenticate.ldap.ssl.keyStorePassword"));
        }
        if (ApplicationProperties.getProperty("tmtbl.authenticate.ldap.ssl.trustStorePassword") != null) {
            System.setProperty("javax.net.ssl.trustStorePassword", ApplicationProperties.getProperty("tmtbl.authenticate.ldap.ssl.trustStorePassword"));
        }
        if (ApplicationProperties.getProperty("tmtbl.authenticate.ldap.ssl.trustStoreType") != null) {
            System.setProperty("javax.net.ssl.trustStoreType", ApplicationProperties.getProperty("tmtbl.authenticate.ldap.ssl.trustStoreType"));
        }
        return new InitialDirContext(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExternalUidLookup.UserInfo doLookup(String searchId) throws Exception {
        String query = ApplicationProperties.getProperty("tmtbl.authenticate.ldap.identify");
        if (query == null) {
            return null;
        }
        try (DirContext ctx = null;){
            ctx = this.getDirContext();
            String idAttributeName = ApplicationProperties.getProperty("tmtbl.authenticate.ldap.externalId", "uid");
            String loginAttributeName = ApplicationProperties.getProperty("tmtbl.authenticate.ldap.login", "uid");
            Attributes attributes = ctx.getAttributes(query.replaceAll("%", searchId), new String[]{idAttributeName, loginAttributeName, "cn", "givenName", "sn", "mail"});
            Attribute idAttribute = attributes.get(idAttributeName);
            if (idAttribute == null) {
                ExternalUidLookup.UserInfo userInfo = null;
                return userInfo;
            }
            ExternalUidLookup.UserInfo user = new ExternalUidLookup.UserInfo();
            user.setExternalId((String)idAttribute.get());
            user.setUserName((String)attributes.get(loginAttributeName).get());
            if (attributes.get("cn") != null) {
                user.setName((String)attributes.get("cn").get());
            }
            if (attributes.get("givenName") != null) {
                user.setFirstName((String)attributes.get("givenName").get());
            }
            if (attributes.get("cn") != null) {
                user.setName((String)attributes.get("cn").get());
            }
            if (attributes.get("sn") != null) {
                user.setLastName((String)attributes.get("sn").get());
            }
            if (attributes.get("mail") != null) {
                user.setEmail((String)attributes.get("mail").get());
            } else {
                String email = user.getUserName() + "@";
                for (String x : query.split(",")) {
                    if (!x.startsWith("dc=")) continue;
                    email = email + (email.endsWith("@") ? "" : ".") + x.substring(3);
                }
                if (!email.endsWith("@")) {
                    user.setEmail(email);
                }
            }
            ExternalUidLookup.UserInfo userInfo = user;
            return userInfo;
        }
    }
}

