/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.exam;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.reports.AbstractReport;
import org.unitime.timetable.reports.exam.ConflictsByCourseAndStudentReport;
import org.unitime.timetable.reports.exam.PdfLegacyExamReport;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamInfo;

public class ConflictsByCourseAndInstructorReport
extends PdfLegacyExamReport {
    protected static Log sLog = LogFactory.getLog(ConflictsByCourseAndStudentReport.class);
    Hashtable<Long, String> iStudentNames = new Hashtable();

    public ConflictsByCourseAndInstructorReport(int mode, File file, Session session, ExamType examType, Collection<SubjectArea> subjectAreas, Collection<ExamAssignmentInfo> exams) throws IOException, DocumentException {
        super(mode, file, MSG.legacyReportConflictsByCourseAndInstructor(), session, examType, subjectAreas, exams);
    }

    @Override
    public void printReport() throws DocumentException {
        sLog.debug((Object)MSG.statusSortingSections());
        Hashtable<String, TreeSet<ExamInfo.ExamSectionInfo>> subject2courseSections = new Hashtable<String, TreeSet<ExamInfo.ExamSectionInfo>>();
        for (ExamAssignmentInfo exam : this.getExams()) {
            if (exam.getPeriod() == null) continue;
            for (ExamInfo.ExamSectionInfo section : exam.getSectionsIncludeCrosslistedDummies()) {
                if (!this.hasSubjectArea(section)) continue;
                TreeSet<ExamInfo.ExamSectionInfo> sections = (TreeSet<ExamInfo.ExamSectionInfo>)subject2courseSections.get(section.getSubject());
                if (sections == null) {
                    sections = new TreeSet<ExamInfo.ExamSectionInfo>();
                    subject2courseSections.put(section.getSubject(), sections);
                }
                sections.add(section);
            }
        }
        sLog.debug((Object)MSG.statusPrintingReport());
        this.setHeaderLine(new AbstractReport.Line(this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnID() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 10), this.rpad(MSG.lrDate(), 7), this.rpad(MSG.lrTime(), 6), this.rpad(MSG.lrName(), 25), this.rpad(MSG.lrType(), 6), this.rpad(MSG.lrSubject(), 7), this.rpad(MSG.lrCourse(), 8), this.iItype ? this.rpad(this.iExternal ? MSG.lrExtnID() : MSG.lrType(), 6) : NULL, this.rpad(MSG.lrSection(), 10), this.rpad(MSG.lrTime(), 15)), new AbstractReport.Line(this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 10), this.lpad("", '-', 7), this.lpad("", '-', 6), this.lpad("", '-', 25), this.lpad("", '-', 6), this.lpad("", '-', 7), this.lpad("", '-', 8), this.iItype ? this.lpad("", '-', 6) : NULL, this.lpad("", '-', 10), this.lpad("", '-', 15)));
        this.printHeader();
        for (String subject : new TreeSet(subject2courseSections.keySet())) {
            TreeSet sections = (TreeSet)subject2courseSections.get(subject);
            if (this.iSubjectPrinted) {
                this.newPage();
            }
            this.setPageName(subject);
            this.setCont(subject);
            this.iSubjectPrinted = false;
            for (ExamInfo.ExamSectionInfo section : sections) {
                ExamAssignmentInfo exam = section.getExamAssignmentInfo();
                if (exam == null || exam.getPeriod() == null) continue;
                this.iCoursePrinted = false;
                for (ExamInfo.ExamInstructorInfo instructor : exam.getInstructors()) {
                    this.iStudentPrinted = false;
                    if (this.iDirect) {
                        for (ExamAssignmentInfo.DirectConflict directConflict : exam.getInstructorDirectConflicts()) {
                            if (!directConflict.getStudents().contains(instructor.getId())) continue;
                            this.iPeriodPrinted = false;
                            if (directConflict.getOtherExam() != null) {
                                for (ExamInfo.ExamSectionInfo other : directConflict.getOtherExam().getSectionsIncludeCrosslistedDummies()) {
                                    if (!directConflict.getOtherExam().getInstructors().contains(instructor)) continue;
                                    this.println(this.rpad(this.iSubjectPrinted && this.isSkipRepeating() ? "" : subject, 7), this.rpad(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getCourseNbr(), 8), this.iItype ? this.rpad(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getItype(), 6) : NULL, this.formatSection10(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getSection()), this.iCoursePrinted && this.isSkipRepeating() ? this.rpad("", 7) : this.formatShortPeriodNoEndTimeDate(exam), this.iCoursePrinted && this.isSkipRepeating() ? this.rpad("", 6) : this.formatShortPeriodNoEndTimeTime(exam), this.rpad(this.iStudentPrinted && this.isSkipRepeating() ? "" : instructor.getName(), 25), this.rpad(this.iPeriodPrinted && this.isSkipRepeating() ? "" : MSG.lrDIRECT(), 6), this.rpad(other.getSubject(), 7), this.rpad(other.getCourseNbr(), 8), this.iItype ? this.rpad(other.getItype(), 6) : NULL, this.formatSection10(other.getSection()), new AbstractReport.Cell(other.getExamAssignment().getTimeFixedLength()));
                                    this.iPeriodPrinted = !this.iNewPage;
                                    this.iStudentPrinted = this.iPeriodPrinted;
                                    this.iCoursePrinted = this.iPeriodPrinted;
                                    this.iSubjectPrinted = this.iPeriodPrinted;
                                }
                                continue;
                            }
                            if (directConflict.getOtherEventId() == null) continue;
                            if (directConflict.isOtherClass()) {
                                this.println(this.rpad(this.iSubjectPrinted && this.isSkipRepeating() ? "" : subject, 7), this.rpad(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getCourseNbr(), 8), this.iItype ? this.rpad(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getItype(), 6) : NULL, this.formatSection10(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getSection()), this.iCoursePrinted && this.isSkipRepeating() ? this.rpad("", 7) : this.formatShortPeriodNoEndTimeDate(exam), this.iCoursePrinted && this.isSkipRepeating() ? this.rpad("", 6) : this.formatShortPeriodNoEndTimeTime(exam), this.rpad(this.iStudentPrinted && this.isSkipRepeating() ? "" : instructor.getName(), 25), this.rpad(this.iPeriodPrinted && this.isSkipRepeating() ? "" : MSG.lrCLASS(), 6), this.rpad(directConflict.getOtherClass().getSchedulingSubpart().getControllingCourseOffering().getSubjectAreaAbbv(), 7), this.rpad(directConflict.getOtherClass().getSchedulingSubpart().getControllingCourseOffering().getCourseNbr(), 8), this.iItype ? this.rpad(this.iExternal ? directConflict.getOtherClass().getExternalUniqueId() : directConflict.getOtherClass().getSchedulingSubpart().getItypeDesc(), 6) : NULL, this.formatSection10(this.iUseClassSuffix && directConflict.getOtherClass().getClassSuffix() != null ? directConflict.getOtherClass().getClassSuffix() : directConflict.getOtherClass().getSectionNumberString()), new AbstractReport.Cell(this.getMeetingTime(directConflict.getOtherEventTime())));
                            } else {
                                this.println(this.rpad(this.iSubjectPrinted && this.isSkipRepeating() ? "" : subject, 7), this.rpad(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getCourseNbr(), 8), this.iItype ? this.rpad(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getItype(), 6) : NULL, this.formatSection10(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getSection()), this.iCoursePrinted && this.isSkipRepeating() ? this.rpad("", 7) : this.formatShortPeriodNoEndTimeDate(exam), this.iCoursePrinted && this.isSkipRepeating() ? this.rpad("", 6) : this.formatShortPeriodNoEndTimeTime(exam), this.rpad(this.iStudentPrinted && this.isSkipRepeating() ? "" : instructor.getName(), 25), this.rpad(this.iPeriodPrinted && this.isSkipRepeating() ? "" : MSG.lrEVENT(), 6), this.rpad(directConflict.getOtherEventName(), this.iItype ? 34 : 27).withColSpan(this.iItype ? 4 : 3), this.getMeetingTime(directConflict.getOtherEventTime()));
                            }
                            this.iPeriodPrinted = !this.iNewPage;
                            this.iStudentPrinted = this.iPeriodPrinted;
                            this.iCoursePrinted = this.iPeriodPrinted;
                            this.iSubjectPrinted = this.iPeriodPrinted;
                        }
                    }
                    if (this.iM2d) {
                        for (ExamAssignmentInfo.MoreThanTwoADayConflict moreThanTwoADayConflict : exam.getInstructorMoreThanTwoADaysConflicts()) {
                            if (!moreThanTwoADayConflict.getStudents().contains(instructor.getId())) continue;
                            this.iPeriodPrinted = false;
                            for (ExamAssignment otherExam : moreThanTwoADayConflict.getOtherExams()) {
                                if (!otherExam.getInstructors().contains(instructor)) continue;
                                for (ExamInfo.ExamSectionInfo other : otherExam.getSectionsIncludeCrosslistedDummies()) {
                                    this.println(this.rpad(this.iSubjectPrinted && this.isSkipRepeating() ? "" : subject, 7), this.rpad(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getCourseNbr(), 8), this.iItype ? this.rpad(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getItype(), 6) : NULL, this.formatSection10(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getSection()), this.iCoursePrinted && this.isSkipRepeating() ? this.rpad("", 7) : this.formatShortPeriodNoEndTimeDate(exam), this.iCoursePrinted && this.isSkipRepeating() ? this.rpad("", 6) : this.formatShortPeriodNoEndTimeTime(exam), this.rpad(this.iStudentPrinted && this.isSkipRepeating() ? "" : instructor.getName(), 25), this.rpad(this.iPeriodPrinted && this.isSkipRepeating() ? "" : MSG.lrMore2DAY(), 6), this.rpad(other.getSubject(), 7), this.rpad(other.getCourseNbr(), 8), this.iItype ? this.rpad(other.getItype(), 6) : NULL, this.formatSection10(other.getSection()), new AbstractReport.Cell(other.getExamAssignment().getTimeFixedLength()));
                                    this.iPeriodPrinted = !this.iNewPage;
                                    this.iStudentPrinted = this.iPeriodPrinted;
                                    this.iCoursePrinted = this.iPeriodPrinted;
                                    this.iSubjectPrinted = this.iPeriodPrinted;
                                }
                            }
                        }
                    }
                    if (!this.iBtb) continue;
                    for (ExamAssignmentInfo.BackToBackConflict backToBackConflict : exam.getInstructorBackToBackConflicts()) {
                        if (!backToBackConflict.getStudents().contains(instructor.getId())) continue;
                        this.iPeriodPrinted = false;
                        for (ExamInfo.ExamSectionInfo other : backToBackConflict.getOtherExam().getSectionsIncludeCrosslistedDummies()) {
                            if (!backToBackConflict.getOtherExam().getInstructors().contains(instructor)) continue;
                            this.println(this.rpad(this.iSubjectPrinted && this.isSkipRepeating() ? "" : subject, 7), this.rpad(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getCourseNbr(), 8), this.iItype ? this.rpad(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getItype(), 6) : NULL, this.formatSection10(this.iCoursePrinted && this.isSkipRepeating() ? "" : section.getSection()), this.iCoursePrinted && this.isSkipRepeating() ? this.rpad("", 7) : this.formatShortPeriodNoEndTimeDate(exam), this.iCoursePrinted && this.isSkipRepeating() ? this.rpad("", 6) : this.formatShortPeriodNoEndTimeTime(exam), this.rpad(this.iStudentPrinted && this.isSkipRepeating() ? "" : instructor.getName(), 25), this.rpad(this.iPeriodPrinted && this.isSkipRepeating() ? "" : MSG.lrBTB(), 6), this.rpad(other.getSubject(), 7), this.rpad(other.getCourseNbr(), 8), this.iItype ? this.rpad(other.getItype(), 6) : NULL, this.formatSection10(other.getSection()), new AbstractReport.Cell(other.getExamAssignment().getTimeFixedLength()));
                            this.iPeriodPrinted = !this.iNewPage;
                            this.iStudentPrinted = this.iPeriodPrinted;
                            this.iCoursePrinted = this.iPeriodPrinted;
                            this.iSubjectPrinted = this.iPeriodPrinted;
                        }
                    }
                }
            }
            this.setCont(null);
        }
        if (this.iSubjectPrinted) {
            this.lastPage();
        }
    }
}

