/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.model.Advisor;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Roles;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentSectioningQueue;
import org.unitime.timetable.model.base.BaseAdvisor;
import org.unitime.timetable.model.dao.StudentDAO;

public class StudentAdvisorsImport
extends BaseImport {
    @Override
    public void loadXml(Element root) throws Exception {
        if (!root.getName().equalsIgnoreCase("studentAdvisors")) {
            throw new Exception("Given XML file is not student groups load file.");
        }
        try {
            Session session;
            this.beginTransaction();
            String campus = root.attributeValue("campus");
            String year = root.attributeValue("year");
            String term = root.attributeValue("term");
            boolean incremental = "true".equalsIgnoreCase(root.attributeValue("incremental", "false"));
            if (incremental) {
                this.info("Incremental mode.");
            }
            if ((session = Session.getSessionUsingInitiativeYearTerm(campus, year, term)) == null) {
                throw new Exception("No session found for the given campus, year, and term.");
            }
            Hashtable<String, Advisor> id2advisor = new Hashtable<String, Advisor>();
            for (Object advisor : this.getHibSession().createQuery("from Advisor where session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
                id2advisor.put(((BaseAdvisor)advisor).getExternalUniqueId(), (Advisor)advisor);
            }
            Hashtable<String, Roles> ref2role = new Hashtable<String, Roles>();
            for (Roles roles : Roles.findAll(true, this.getHibSession())) {
                ref2role.put(roles.getReference(), roles);
            }
            Hashtable<String, Student> id2student = new Hashtable<String, Student>();
            for (Student student : StudentDAO.getInstance().findBySession(this.getHibSession(), session.getUniqueId())) {
                if (student.getExternalUniqueId() == null) continue;
                id2student.put(student.getExternalUniqueId(), student);
            }
            HashSet<Long> hashSet = new HashSet<Long>();
            Iterator i = root.elementIterator("studentAdvisor");
            while (i.hasNext()) {
                Element element = (Element)i.next();
                String externalId = element.attributeValue("externalId");
                Advisor advisor = (Advisor)id2advisor.remove(externalId);
                if (advisor == null) {
                    advisor = new Advisor();
                    advisor.setSession(session);
                    advisor.setExternalUniqueId(externalId);
                }
                advisor.setStudents(new HashSet<Student>());
                advisor.setFirstName(element.attributeValue("firstName"));
                advisor.setMiddleName(element.attributeValue("middleName"));
                advisor.setLastName(element.attributeValue("lastName"));
                advisor.setEmail(element.attributeValue("email"));
                advisor.setAcademicTitle(element.attributeValue("acadTitle"));
                advisor.setRole((Roles)ref2role.get(element.attributeValue("role", "Advisor")));
                if (advisor.getRole() == null) {
                    this.warn("Advisor role " + element.attributeValue("role", "Advisor") + " does not exist.");
                    continue;
                }
                this.info("Advisor " + (advisor.hasName() ? advisor.getName(DepartmentalInstructor.sNameFormatLastFirstMiddle) + " (" + externalId + ")" : externalId) + (advisor.getUniqueId() == null ? " created." : " updated."));
                Element updateStudentsEl = element.element("updateStudents");
                if (updateStudentsEl != null) {
                    Hashtable<String, Student> students = new Hashtable<String, Student>();
                    for (Student s : advisor.getStudents()) {
                        students.put(s.getExternalUniqueId(), s);
                    }
                    Iterator j = updateStudentsEl.elementIterator("student");
                    while (j.hasNext()) {
                        Element studentEl = (Element)j.next();
                        String extId = studentEl.attributeValue("externalId");
                        if (extId == null) {
                            this.warn("A student has no external id.");
                            continue;
                        }
                        if (students.remove(extId) != null) continue;
                        Student student = (Student)id2student.get(extId);
                        if (student == null) {
                            this.warn("Student " + extId + " does not exist.");
                            continue;
                        }
                        if (student == null) continue;
                        advisor.getStudents().add(student);
                        student.getAdvisors().add(advisor);
                        hashSet.add(student.getUniqueId());
                    }
                    if (!students.isEmpty()) {
                        for (Student student : students.values()) {
                            student.getAdvisors().remove(advisor);
                            hashSet.add(student.getUniqueId());
                        }
                        advisor.getStudents().removeAll(students.values());
                    }
                }
                this.getHibSession().saveOrUpdate((Object)advisor);
            }
            if (!incremental) {
                for (Advisor advisor : id2advisor.values()) {
                    this.info("Advisor " + (advisor.hasName() ? advisor.getName(DepartmentalInstructor.sNameFormatLastFirstMiddle) + " (" + advisor.getExternalUniqueId() + ")" : advisor.getExternalUniqueId()) + " deleted.");
                    if (advisor.getStudents() != null) {
                        for (Student student : advisor.getStudents()) {
                            hashSet.add(student.getUniqueId());
                            student.getAdvisors().remove(advisor);
                        }
                    }
                    this.getHibSession().delete((Object)advisor);
                }
            }
            if (!hashSet.isEmpty()) {
                StudentSectioningQueue.studentChanged(this.getHibSession(), null, session.getUniqueId(), hashSet);
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
    }
}

