/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import java.util.HashSet;
import java.util.List;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.server.CheckMaster;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;
import org.unitime.timetable.onlinesectioning.updates.CheckOfferingAction;

@CheckMaster(value=CheckMaster.Master.REQUIRED)
public class CheckAllOfferingsAction
extends CheckOfferingAction {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        List offeringIds = null;
        helper.beginTransaction();
        try {
            offeringIds = helper.getHibSession().createQuery("select io.uniqueId from InstructionalOffering io where io.session.uniqueId = :sessionId and io.notOffered = false").setLong("sessionId", server.getAcademicSession().getUniqueId().longValue()).list();
            helper.commitTransaction();
        }
        catch (Exception e) {
            helper.rollbackTransaction();
            if (e instanceof SectioningException) {
                throw (SectioningException)e;
            }
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
        helper.info("Checking all offerings for " + server.getAcademicSession() + "...");
        HashSet<Long> recheck = new HashSet<Long>();
        OnlineSectioningServer.Lock lock = server.lockAll();
        try {
            for (Long offeringId : offeringIds) {
                this.checkOffering(server, helper, server.getOffering(offeringId), recheck);
            }
        }
        finally {
            lock.release();
        }
        if (!recheck.isEmpty()) {
            helper.info("Re-checking " + recheck.size() + " offerings...");
            server.execute(server.createAction(CheckOfferingAction.class).forOfferings(recheck), helper.getUser());
        }
        helper.info("Check done.");
        return true;
    }

    @Override
    public SectioningRequest.ReschedulingReason check(OnlineSectioningServer server, XStudent student, XOffering offering, XCourseRequest request) {
        if (request.getEnrollment() == null) {
            return null;
        }
        if (!offering.getOfferingId().equals(request.getEnrollment().getOfferingId())) {
            return null;
        }
        if (!server.getConfig().getPropertyBoolean("Enrollment.ReSchedulingEnabled", false)) {
            return null;
        }
        if (!this.hasReSchedulingStatus(student, server)) {
            return null;
        }
        List<XSection> sections = offering.getSections(request.getEnrollment());
        XConfig config = offering.getConfig(request.getEnrollment().getConfigId());
        if (config == null || sections.size() != config.getSubparts().size()) {
            for (XSection s1 : sections) {
                if (offering.getSubpart(s1.getSubpartId()).getConfigId().equals(config.getConfigId())) continue;
                return SectioningRequest.ReschedulingReason.MULTIPLE_CONFIGS;
            }
            return sections.size() < config.getSubparts().size() ? SectioningRequest.ReschedulingReason.MISSING_CLASS : SectioningRequest.ReschedulingReason.MULTIPLE_ENRLS;
        }
        boolean ignoreBreakTime = server.getConfig().getPropertyBoolean("ReScheduling.IgnoreBreakTimeConflicts", false);
        for (XSection s1 : sections) {
            for (XSection s2 : sections) {
                if (s1.getSectionId() < s2.getSectionId() && s1.isOverlapping(offering.getDistributions(), s2, ignoreBreakTime)) {
                    return SectioningRequest.ReschedulingReason.TIME_CONFLICT;
                }
                if (s1.getSectionId().equals(s2.getSectionId()) || !s1.getSubpartId().equals(s2.getSubpartId())) continue;
                return SectioningRequest.ReschedulingReason.MULTIPLE_ENRLS;
            }
            if (offering.getSubpart(s1.getSubpartId()).getConfigId().equals(config.getConfigId())) continue;
            return SectioningRequest.ReschedulingReason.MULTIPLE_CONFIGS;
        }
        if (!offering.isAllowOverlap(student, request.getEnrollment().getConfigId(), request.getEnrollment(), sections) && !server.getConfig().getPropertyBoolean("Enrollment.CanKeepTimeConflict", false)) {
            for (XRequest r : student.getRequests()) {
                XEnrollment e;
                XOffering other;
                if (!(r instanceof XCourseRequest) || r.getRequestId().equals(request.getRequestId()) || ((XCourseRequest)r).getEnrollment() == null || (other = server.getOffering((e = ((XCourseRequest)r).getEnrollment()).getOfferingId())) == null) continue;
                List<XSection> assignment = other.getSections(e);
                if (other.isAllowOverlap(student, e.getConfigId(), e, assignment)) continue;
                for (XSection section : sections) {
                    if (!section.isOverlapping(offering.getDistributions(), assignment, ignoreBreakTime)) continue;
                    if (request.isAlternative() && !r.isAlternative()) {
                        return SectioningRequest.ReschedulingReason.TIME_CONFLICT;
                    }
                    if (request.isAlternative() != r.isAlternative() || request.getPriority() <= r.getPriority()) continue;
                    return SectioningRequest.ReschedulingReason.TIME_CONFLICT;
                }
            }
        }
        if (!server.getConfig().getPropertyBoolean("Enrollment.CanKeepCancelledClass", false)) {
            for (XSection section : sections) {
                if (!section.isCancelled()) continue;
                return SectioningRequest.ReschedulingReason.CLASS_CANCELLED;
            }
        }
        return null;
    }
}

