/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.ExamLocationPref;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.Session;

public abstract class BaseLocation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Long iPermanentId;
    private Integer iCapacity;
    private Double iCoordinateX;
    private Double iCoordinateY;
    private Boolean iIgnoreTooFar;
    private Boolean iIgnoreRoomCheck;
    private Double iArea;
    private Integer iEventStatus;
    private String iNote;
    private Integer iBreakTime;
    private String iManagerIds;
    private String iPattern;
    private String iShareNote;
    private String iEventAvailability;
    private Integer iExamCapacity;
    private String iDisplayName;
    private String iExternalUniqueId;
    private Session iSession;
    private Department iEventDepartment;
    private Set<RoomFeature> iFeatures;
    private Set<ExamType> iExamTypes;
    private Set<ExamLocationPref> iExamPreferences;
    private Set<Assignment> iAssignments;
    private Set<RoomGroup> iRoomGroups;
    private Set<RoomDept> iRoomDepts;
    public static String PROP_UNIQUEID = "uniqueId";
    public static String PROP_PERMANENT_ID = "permanentId";
    public static String PROP_CAPACITY = "capacity";
    public static String PROP_COORDINATE_X = "coordinateX";
    public static String PROP_COORDINATE_Y = "coordinateY";
    public static String PROP_IGNORE_TOO_FAR = "ignoreTooFar";
    public static String PROP_IGNORE_ROOM_CHECK = "ignoreRoomCheck";
    public static String PROP_AREA = "area";
    public static String PROP_EVENT_STATUS = "eventStatus";
    public static String PROP_NOTE = "note";
    public static String PROP_BREAK_TIME = "breakTime";
    public static String PROP_MANAGER_IDS = "managerIds";
    public static String PROP_PATTERN = "pattern";
    public static String PROP_SHARE_NOTE = "shareNote";
    public static String PROP_AVAILABILITY = "eventAvailability";
    public static String PROP_EXAM_CAPACITY = "examCapacity";
    public static String PROP_DISPLAY_NAME = "displayName";
    public static String PROP_EXTERNAL_UID = "externalUniqueId";

    public BaseLocation() {
        this.initialize();
    }

    public BaseLocation(Long uniqueId) {
        this.setUniqueId(uniqueId);
        this.initialize();
    }

    protected void initialize() {
    }

    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    public Long getPermanentId() {
        return this.iPermanentId;
    }

    public void setPermanentId(Long permanentId) {
        this.iPermanentId = permanentId;
    }

    public Integer getCapacity() {
        return this.iCapacity;
    }

    public void setCapacity(Integer capacity) {
        this.iCapacity = capacity;
    }

    public Double getCoordinateX() {
        return this.iCoordinateX;
    }

    public void setCoordinateX(Double coordinateX) {
        this.iCoordinateX = coordinateX;
    }

    public Double getCoordinateY() {
        return this.iCoordinateY;
    }

    public void setCoordinateY(Double coordinateY) {
        this.iCoordinateY = coordinateY;
    }

    public Boolean isIgnoreTooFar() {
        return this.iIgnoreTooFar;
    }

    public Boolean getIgnoreTooFar() {
        return this.iIgnoreTooFar;
    }

    public void setIgnoreTooFar(Boolean ignoreTooFar) {
        this.iIgnoreTooFar = ignoreTooFar;
    }

    public Boolean isIgnoreRoomCheck() {
        return this.iIgnoreRoomCheck;
    }

    public Boolean getIgnoreRoomCheck() {
        return this.iIgnoreRoomCheck;
    }

    public void setIgnoreRoomCheck(Boolean ignoreRoomCheck) {
        this.iIgnoreRoomCheck = ignoreRoomCheck;
    }

    public Double getArea() {
        return this.iArea;
    }

    public void setArea(Double area) {
        this.iArea = area;
    }

    public Integer getEventStatus() {
        return this.iEventStatus;
    }

    public void setEventStatus(Integer eventStatus) {
        this.iEventStatus = eventStatus;
    }

    public String getNote() {
        return this.iNote;
    }

    public void setNote(String note) {
        this.iNote = note;
    }

    public Integer getBreakTime() {
        return this.iBreakTime;
    }

    public void setBreakTime(Integer breakTime) {
        this.iBreakTime = breakTime;
    }

    public String getManagerIds() {
        return this.iManagerIds;
    }

    public void setManagerIds(String managerIds) {
        this.iManagerIds = managerIds;
    }

    public String getPattern() {
        return this.iPattern;
    }

    public void setPattern(String pattern) {
        this.iPattern = pattern;
    }

    public String getShareNote() {
        return this.iShareNote;
    }

    public void setShareNote(String shareNote) {
        this.iShareNote = shareNote;
    }

    public String getEventAvailability() {
        return this.iEventAvailability;
    }

    public void setEventAvailability(String eventAvailability) {
        this.iEventAvailability = eventAvailability;
    }

    public Integer getExamCapacity() {
        return this.iExamCapacity;
    }

    public void setExamCapacity(Integer examCapacity) {
        this.iExamCapacity = examCapacity;
    }

    public String getDisplayName() {
        return this.iDisplayName;
    }

    public void setDisplayName(String displayName) {
        this.iDisplayName = displayName;
    }

    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    public Department getEventDepartment() {
        return this.iEventDepartment;
    }

    public void setEventDepartment(Department eventDepartment) {
        this.iEventDepartment = eventDepartment;
    }

    public Set<RoomFeature> getFeatures() {
        return this.iFeatures;
    }

    public void setFeatures(Set<RoomFeature> features) {
        this.iFeatures = features;
    }

    public void addTofeatures(RoomFeature roomFeature) {
        if (this.iFeatures == null) {
            this.iFeatures = new HashSet<RoomFeature>();
        }
        this.iFeatures.add(roomFeature);
    }

    public Set<ExamType> getExamTypes() {
        return this.iExamTypes;
    }

    public void setExamTypes(Set<ExamType> examTypes) {
        this.iExamTypes = examTypes;
    }

    public void addToexamTypes(ExamType examType) {
        if (this.iExamTypes == null) {
            this.iExamTypes = new HashSet<ExamType>();
        }
        this.iExamTypes.add(examType);
    }

    public Set<ExamLocationPref> getExamPreferences() {
        return this.iExamPreferences;
    }

    public void setExamPreferences(Set<ExamLocationPref> examPreferences) {
        this.iExamPreferences = examPreferences;
    }

    public void addToexamPreferences(ExamLocationPref examLocationPref) {
        if (this.iExamPreferences == null) {
            this.iExamPreferences = new HashSet<ExamLocationPref>();
        }
        this.iExamPreferences.add(examLocationPref);
    }

    public Set<Assignment> getAssignments() {
        return this.iAssignments;
    }

    public void setAssignments(Set<Assignment> assignments) {
        this.iAssignments = assignments;
    }

    public void addToassignments(Assignment assignment) {
        if (this.iAssignments == null) {
            this.iAssignments = new HashSet<Assignment>();
        }
        this.iAssignments.add(assignment);
    }

    public Set<RoomGroup> getRoomGroups() {
        return this.iRoomGroups;
    }

    public void setRoomGroups(Set<RoomGroup> roomGroups) {
        this.iRoomGroups = roomGroups;
    }

    public void addToroomGroups(RoomGroup roomGroup) {
        if (this.iRoomGroups == null) {
            this.iRoomGroups = new HashSet<RoomGroup>();
        }
        this.iRoomGroups.add(roomGroup);
    }

    public Set<RoomDept> getRoomDepts() {
        return this.iRoomDepts;
    }

    public void setRoomDepts(Set<RoomDept> roomDepts) {
        this.iRoomDepts = roomDepts;
    }

    public void addToroomDepts(RoomDept roomDept) {
        if (this.iRoomDepts == null) {
            this.iRoomDepts = new HashSet<RoomDept>();
        }
        this.iRoomDepts.add(roomDept);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Location)) {
            return false;
        }
        if (this.getUniqueId() == null || ((Location)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((Location)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "Location[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "Location[\n\tArea: " + this.getArea() + "\n\tBreakTime: " + this.getBreakTime() + "\n\tCapacity: " + this.getCapacity() + "\n\tCoordinateX: " + this.getCoordinateX() + "\n\tCoordinateY: " + this.getCoordinateY() + "\n\tDisplayName: " + this.getDisplayName() + "\n\tEventAvailability: " + this.getEventAvailability() + "\n\tEventDepartment: " + this.getEventDepartment() + "\n\tEventStatus: " + this.getEventStatus() + "\n\tExamCapacity: " + this.getExamCapacity() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tIgnoreRoomCheck: " + this.getIgnoreRoomCheck() + "\n\tIgnoreTooFar: " + this.getIgnoreTooFar() + "\n\tManagerIds: " + this.getManagerIds() + "\n\tNote: " + this.getNote() + "\n\tPattern: " + this.getPattern() + "\n\tPermanentId: " + this.getPermanentId() + "\n\tSession: " + this.getSession() + "\n\tShareNote: " + this.getShareNote() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

