/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.unitime.timetable.gwt.client.aria.AriaSuggestBox;
import org.unitime.timetable.gwt.client.events.UniTimeFilterBox;
import org.unitime.timetable.gwt.client.widgets.FilterBox;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.EventInterface;

public class SectioningStatusFilterBox
extends UniTimeFilterBox<SectioningStatusFilterRpcRequest> {
    private static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    private static final StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    private static final GwtMessages GWT_MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private boolean iOnline;
    private AriaSuggestBox iCourse;
    private FilterBox.Chip iLastCourse;
    private AriaSuggestBox iStudent;
    private FilterBox.Chip iLastStudent;

    public SectioningStatusFilterBox(boolean online) {
        super(null);
        this.iOnline = online;
        FilterBox.StaticSimpleFilter mode = new FilterBox.StaticSimpleFilter("mode", GWT_MESSAGES.tagSectioningMode(), new String[0]);
        mode.setMultipleSelection(false);
        this.addFilter(mode);
        this.addFilter(new FilterBox.StaticSimpleFilter("type", GWT_MESSAGES.tagSectioningType(), new String[0]));
        this.addFilter(new FilterBox.StaticSimpleFilter("status", GWT_MESSAGES.tagSectioningStatus(), new String[0]));
        this.addFilter(new FilterBox.StaticSimpleFilter("approver", GWT_MESSAGES.tagApprover(), new String[0]));
        this.addFilter(new FilterBox.StaticSimpleFilter("area", GWT_MESSAGES.tagAcademicArea(), new String[0]));
        this.addFilter(new FilterBox.StaticSimpleFilter("major", GWT_MESSAGES.tagMajor(), new String[0]));
        this.addFilter(new FilterBox.StaticSimpleFilter("concentration", GWT_MESSAGES.tagConcentration(), new String[0]));
        this.addFilter(new FilterBox.StaticSimpleFilter("minor", GWT_MESSAGES.tagMinor(), new String[0]));
        this.addFilter(new FilterBox.StaticSimpleFilter("classification", GWT_MESSAGES.tagClassification(), new String[0]));
        this.addFilter(new FilterBox.StaticSimpleFilter("degree", GWT_MESSAGES.tagDegree(), new String[0]));
        this.addFilter(new FilterBox.StaticSimpleFilter("program", GWT_MESSAGES.tagProgram(), new String[0]));
        this.addFilter(new FilterBox.StaticSimpleFilter("campus", GWT_MESSAGES.tagCampus(), new String[0]));
        this.addFilter(new FilterBox.StaticSimpleFilter("group", GWT_MESSAGES.tagStudentGroup(), new String[0]));
        this.addFilter(new FilterBox.StaticSimpleFilter("accommodation", GWT_MESSAGES.tagStudentAccommodation(), new String[0]));
        this.addFilter(new FilterBox.StaticSimpleFilter("credit", GWT_MESSAGES.tagCredit(), new String[0]));
        this.addFilter(new FilterBox.StaticSimpleFilter("overlap", GWT_MESSAGES.tagOverlap(), new String[0]));
        this.addFilter(new FilterBox.StaticSimpleFilter("advisor", GWT_MESSAGES.tagAdvisor(), new String[0]));
        FilterBox.StaticSimpleFilter override = new FilterBox.StaticSimpleFilter("override", MESSAGES.tagOverride(), new String[0]);
        override.setMultipleSelection(true);
        this.addFilter(override);
        this.addFilter(new FilterBox.StaticSimpleFilter("assignment", GWT_MESSAGES.tagSectioningAssignment(), new String[0]){

            @Override
            public void validate(String text, AsyncCallback<FilterBox.Chip> callback) {
                String translatedValue = null;
                if ("assigned".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.assignmentType()[0];
                } else if ("reserved".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.assignmentType()[1];
                } else if ("not assigned".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.assignmentType()[2];
                } else if ("wait-listed".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.assignmentType()[3];
                } else if ("critical".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.assignmentType().length > 4 ? CONSTANTS.assignmentType()[4] : null;
                } else if ("assigned critical".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.assignmentType().length > 5 ? CONSTANTS.assignmentType()[5] : null;
                } else if ("not assigned critical".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.assignmentType().length > 6 ? CONSTANTS.assignmentType()[6] : null;
                } else if ("important".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.assignmentType().length > 7 ? CONSTANTS.assignmentType()[7] : null;
                } else if ("assigned important".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.assignmentType().length > 8 ? CONSTANTS.assignmentType()[8] : null;
                } else if ("not assigned important".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.assignmentType().length > 9 ? CONSTANTS.assignmentType()[9] : null;
                } else if ("no-substitutes".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.assignmentType().length > 10 ? CONSTANTS.assignmentType()[10] : null;
                } else if ("assigned no-subs".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.assignmentType().length > 11 ? CONSTANTS.assignmentType()[11] : null;
                } else if ("not assigned no-subs".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.assignmentType().length > 12 ? CONSTANTS.assignmentType()[12] : null;
                } else if ("vital".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.assignmentType().length > 13 ? CONSTANTS.assignmentType()[13] : null;
                } else if ("assigned vital".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.assignmentType().length > 14 ? CONSTANTS.assignmentType()[14] : null;
                } else if ("not assigned vital".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.assignmentType().length > 15 ? CONSTANTS.assignmentType()[15] : null;
                }
                callback.onSuccess((Object)new FilterBox.Chip(this.getCommand(), text).withTranslatedCommand(this.getLabel()).withTranslatedValue(translatedValue));
            }
        });
        this.addFilter(new FilterBox.StaticSimpleFilter("consent", GWT_MESSAGES.tagSectioningConsent(), new String[0]){

            @Override
            public void validate(String text, AsyncCallback<FilterBox.Chip> callback) {
                String translatedValue = null;
                if ("consent".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.consentTypeAbbv()[0];
                } else if ("no consent".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.consentTypeAbbv()[1];
                } else if ("waiting".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.consentTypeAbbv()[2];
                } else if ("approved".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.consentTypeAbbv()[3];
                } else if ("to do".equalsIgnoreCase(text)) {
                    translatedValue = CONSTANTS.consentTypeAbbv()[3];
                }
                callback.onSuccess((Object)new FilterBox.Chip(this.getCommand(), text).withTranslatedCommand(this.getLabel()).withTranslatedValue(translatedValue));
            }
        });
        FilterBox.StaticSimpleFilter op = new FilterBox.StaticSimpleFilter("operation", GWT_MESSAGES.tagSectioningOperation(), new String[0]);
        op.setMultipleSelection(true);
        this.addFilter(op);
        final TextBox curriculum = new TextBox();
        curriculum.setStyleName("unitime-TextArea");
        curriculum.setMaxLength(100);
        curriculum.setWidth("200px");
        curriculum.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                boolean removed = SectioningStatusFilterBox.this.removeChip(new FilterBox.Chip("curriculum", null), false);
                if (curriculum.getText().isEmpty()) {
                    if (removed) {
                        SectioningStatusFilterBox.this.fireValueChangeEvent();
                    }
                } else {
                    SectioningStatusFilterBox.this.addChip(new FilterBox.Chip("curriculum", curriculum.getText()).withTranslatedCommand(GWT_MESSAGES.tagCurriculum()), true);
                }
            }
        });
        Label courseLab = new Label(MESSAGES.propCourse());
        this.iCourse = new AriaSuggestBox(new CourseOracle());
        this.iCourse.setStyleName("unitime-TextArea");
        this.iCourse.setWidth("200px");
        FilterBox.StaticSimpleFilter courseFilter = new FilterBox.StaticSimpleFilter("course", GWT_MESSAGES.tagCourse(), new String[0]);
        courseFilter.setMultipleSelection(true);
        this.addFilter(courseFilter);
        this.iCourse.getValueBox().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                SectioningStatusFilterBox.this.courseChanged(true);
            }
        });
        this.iCourse.getValueBox().addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        SectioningStatusFilterBox.this.courseChanged(false);
                    }
                });
            }
        });
        this.iCourse.getValueBox().addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (event.getNativeKeyCode() == 8) {
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            SectioningStatusFilterBox.this.courseChanged(false);
                        }
                    });
                }
            }
        });
        this.iCourse.getValueBox().addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                SectioningStatusFilterBox.this.courseChanged(true);
            }
        });
        this.iCourse.addSelectionHandler(new SelectionHandler<SuggestOracle.Suggestion>(){

            public void onSelection(SelectionEvent<SuggestOracle.Suggestion> event) {
                SectioningStatusFilterBox.this.courseChanged(true);
            }
        });
        Label studentLab = new Label(MESSAGES.propStudent());
        studentLab.getElement().getStyle().setMarginLeft(10.0, Style.Unit.PX);
        this.iStudent = new AriaSuggestBox(new StudentOracle());
        this.iStudent.setStyleName("unitime-TextArea");
        this.iStudent.setWidth("200px");
        this.addFilter(new FilterBox.StaticSimpleFilter("student", GWT_MESSAGES.tagStudent(), new String[0]));
        this.iStudent.getValueBox().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                SectioningStatusFilterBox.this.studentChanged(true);
            }
        });
        this.iStudent.getValueBox().addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        SectioningStatusFilterBox.this.studentChanged(false);
                    }
                });
            }
        });
        this.iStudent.getValueBox().addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (event.getNativeKeyCode() == 8) {
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            SectioningStatusFilterBox.this.studentChanged(false);
                        }
                    });
                }
            }
        });
        this.iStudent.getValueBox().addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                SectioningStatusFilterBox.this.studentChanged(true);
            }
        });
        this.iStudent.addSelectionHandler(new SelectionHandler<SuggestOracle.Suggestion>(){

            public void onSelection(SelectionEvent<SuggestOracle.Suggestion> event) {
                SectioningStatusFilterBox.this.studentChanged(true);
            }
        });
        FilterBox.StaticSimpleFilter pref = new FilterBox.StaticSimpleFilter("prefer", GWT_MESSAGES.tagPrefer(), new String[0]);
        pref.setVisible(false);
        this.addFilter(pref);
        FilterBox.StaticSimpleFilter req = new FilterBox.StaticSimpleFilter("require", GWT_MESSAGES.tagRequire(), new String[0]);
        req.setVisible(false);
        this.addFilter(req);
        FilterBox.StaticSimpleFilter im = new FilterBox.StaticSimpleFilter("im", GWT_MESSAGES.tagInstructionalMethod(), new String[0]);
        im.setMultipleSelection(true);
        this.addFilter(im);
        this.addFilter(new FilterBox.StaticSimpleFilter("lookup", GWT_MESSAGES.tagLookup(), new String[0]));
        this.addFilter(new FilterBox.CustomFilter("Other", GWT_MESSAGES.tagOther(), new Widget[]{courseLab, this.iCourse, studentLab, this.iStudent}){

            @Override
            public void getSuggestions(List<FilterBox.Chip> chips, String text, AsyncCallback<Collection<FilterBox.Suggestion>> callback) {
                if (text.isEmpty()) {
                    callback.onSuccess(null);
                } else {
                    String second;
                    String first;
                    String prefix;
                    String number2;
                    FilterBox.Chip old;
                    ArrayList<FilterBox.Suggestion> suggestions;
                    block37: {
                        suggestions = new ArrayList<FilterBox.Suggestion>();
                        old = null;
                        for (FilterBox.Chip c : chips) {
                            if (!c.getCommand().equals("limit")) continue;
                            old = c;
                            break;
                        }
                        try {
                            if (Integer.parseInt(text) <= 9999) {
                                suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("limit", text).withTranslatedCommand(GWT_MESSAGES.tagLimit()), old));
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        old = null;
                        for (FilterBox.Chip c : chips) {
                            if (!c.getCommand().equals("credit")) continue;
                            old = c;
                            break;
                        }
                        try {
                            number2 = text;
                            prefix = "";
                            if (text.startsWith("<=") || text.startsWith(">=")) {
                                number2 = number2.substring(2);
                                prefix = text.substring(0, 2);
                            } else if (text.startsWith("<") || text.startsWith(">")) {
                                number2 = number2.substring(1);
                                prefix = text.substring(0, 1);
                            }
                            try {
                                if (Float.parseFloat(number2) <= 99.0f) {
                                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("credit", text).withTranslatedCommand(GWT_MESSAGES.tagCredit()), old));
                                    if (prefix.isEmpty()) {
                                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("credit", "<=" + text).withTranslatedCommand(GWT_MESSAGES.tagCredit()), old));
                                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("credit", ">=" + text).withTranslatedCommand(GWT_MESSAGES.tagCredit()), old));
                                    }
                                }
                            }
                            catch (NumberFormatException e) {
                                RegExp rx = RegExp.compile((String)"^([0-9]+\\.?[0-9]*)([^0-9\\.].*)$");
                                MatchResult m = rx.exec(number2);
                                if (m != null) {
                                    Float.parseFloat(m.getGroup(1));
                                    String im = m.getGroup(2).trim();
                                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("credit", prefix + m.getGroup(1) + " " + im).withTranslatedCommand(GWT_MESSAGES.tagCredit()), old));
                                    if (prefix.isEmpty()) {
                                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("credit", "<=" + m.getGroup(1) + " " + im).withTranslatedCommand(GWT_MESSAGES.tagCredit()), old));
                                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("credit", ">=" + m.getGroup(1) + " " + im).withTranslatedCommand(GWT_MESSAGES.tagCredit()), old));
                                    }
                                }
                            }
                        }
                        catch (Exception number2) {
                            // empty catch block
                        }
                        try {
                            if (!text.contains("..")) break block37;
                            try {
                                first = text.substring(0, text.indexOf(46));
                                second = text.substring(text.indexOf("..") + 2);
                                if (Float.parseFloat(first) < Float.parseFloat(second) && Float.parseFloat(second) <= 99.0f) {
                                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("credit", text).withTranslatedCommand(GWT_MESSAGES.tagCredit()), old));
                                }
                            }
                            catch (NumberFormatException e) {
                                RegExp rx = RegExp.compile((String)"^([0-9]+\\.?[0-9]*)\\.\\.([0-9]+\\.?[0-9]*)([^0-9].*)$");
                                MatchResult m = rx.exec(text);
                                if (m != null) {
                                    suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("credit", m.getGroup(1) + ".." + m.getGroup(2) + " " + m.getGroup(3).trim()).withTranslatedCommand(GWT_MESSAGES.tagCredit()), old));
                                }
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    old = null;
                    for (FilterBox.Chip c : chips) {
                        if (!c.getCommand().equals("overlap")) continue;
                        old = c;
                        break;
                    }
                    try {
                        number2 = text;
                        prefix = "";
                        if (text.startsWith("<=") || text.startsWith(">=")) {
                            number2 = number2.substring(2);
                            prefix = text.substring(0, 2);
                        } else if (text.startsWith("<") || text.startsWith(">")) {
                            number2 = number2.substring(1);
                            prefix = text.substring(0, 1);
                        }
                        if (Integer.parseInt(number2) <= 999) {
                            suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("overlap", text).withTranslatedCommand(GWT_MESSAGES.tagOverlap()), old));
                            if (prefix.isEmpty()) {
                                suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("overlap", "<=" + text).withTranslatedCommand(GWT_MESSAGES.tagOverlap()), old));
                                suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("overlap", ">=" + text).withTranslatedCommand(GWT_MESSAGES.tagOverlap()), old));
                            }
                        }
                    }
                    catch (Exception number3) {
                        // empty catch block
                    }
                    if (text.contains("..")) {
                        try {
                            first = text.substring(0, text.indexOf(46));
                            second = text.substring(text.indexOf("..") + 2);
                            if (Integer.parseInt(first) < Integer.parseInt(second) && Integer.parseInt(second) <= 999) {
                                suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("overlap", text).withTranslatedCommand(GWT_MESSAGES.tagOverlap()), old));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    callback.onSuccess(suggestions);
                }
            }
        });
        this.addValueChangeHandler(new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                List<FilterBox.Chip> courses = SectioningStatusFilterBox.this.getChips("course");
                SectioningStatusFilterBox.this.iLastCourse = courses.isEmpty() ? null : courses.get(courses.size() - 1);
                SectioningStatusFilterBox.this.iLastStudent = SectioningStatusFilterBox.this.getChip("student");
                if (!SectioningStatusFilterBox.this.isFilterPopupShowing()) {
                    FilterBox.Chip chip = SectioningStatusFilterBox.this.getChip("curriculum");
                    if (chip == null) {
                        curriculum.setText("");
                    } else {
                        curriculum.setText(chip.getValue());
                    }
                    if (SectioningStatusFilterBox.this.iLastCourse == null) {
                        SectioningStatusFilterBox.this.iCourse.setText("");
                    } else {
                        SectioningStatusFilterBox.this.iCourse.setText(SectioningStatusFilterBox.this.iLastCourse.getValue());
                    }
                    FilterBox.Chip student = SectioningStatusFilterBox.this.getChip("student");
                    if (student == null) {
                        SectioningStatusFilterBox.this.iStudent.setText("");
                    } else {
                        SectioningStatusFilterBox.this.iStudent.setText(student.getValue());
                    }
                }
                SectioningStatusFilterBox.this.init(false, SectioningStatusFilterBox.this.getAcademicSessionId(), new Command(){

                    public void execute() {
                        if (SectioningStatusFilterBox.this.isFilterPopupShowing()) {
                            SectioningStatusFilterBox.this.showFilterPopup();
                        }
                    }
                });
            }
        });
    }

    private void courseChanged(boolean fireChange) {
        FilterBox.Chip oldChip;
        List<FilterBox.Chip> oldChips = this.getChips("course");
        FilterBox.Chip chip = oldChip = oldChips.isEmpty() ? null : oldChips.get(oldChips.size() - 1);
        if (this.iCourse.getText().isEmpty()) {
            if (oldChip != null) {
                this.removeChip(oldChip, fireChange);
            }
        } else {
            FilterBox.Chip newChip = new FilterBox.Chip("course", this.iCourse.getText()).withTranslatedCommand(GWT_MESSAGES.tagCourse());
            if (oldChip != null) {
                if (newChip.equals(oldChip)) {
                    if (fireChange && !newChip.equals(this.iLastCourse)) {
                        this.fireValueChangeEvent();
                    }
                    return;
                }
                this.removeChip(oldChip, false);
            }
            this.addChip(newChip, fireChange);
        }
    }

    private void studentChanged(boolean fireChange) {
        FilterBox.Chip oldChip = this.getChip("student");
        if (this.iStudent.getText().isEmpty()) {
            if (oldChip != null) {
                this.removeChip(oldChip, fireChange);
            }
        } else {
            FilterBox.Chip newChip = new FilterBox.Chip("student", this.iStudent.getText()).withTranslatedCommand(GWT_MESSAGES.tagStudent());
            if (oldChip != null) {
                if (newChip.equals(oldChip)) {
                    if (fireChange && !newChip.equals(this.iLastStudent)) {
                        this.fireValueChangeEvent();
                    }
                    return;
                }
                this.removeChip(oldChip, false);
            }
            this.addChip(newChip, fireChange);
        }
    }

    @Override
    protected boolean populateFilter(FilterBox.Filter filter, List<EventInterface.FilterRpcResponse.Entity> entities) {
        if (filter != null && filter instanceof FilterBox.StaticSimpleFilter) {
            FilterBox.StaticSimpleFilter simple = (FilterBox.StaticSimpleFilter)filter;
            ArrayList<FilterBox.Chip> chips = new ArrayList<FilterBox.Chip>();
            if (entities != null) {
                for (EventInterface.FilterRpcResponse.Entity entity : entities) {
                    chips.add(new FilterBox.Chip(filter.getCommand(), entity.getAbbreviation()).withLabel(entity.getName()).withCount(entity.getCount()).withTranslatedCommand(filter.getLabel()).withTranslatedValue(entity.getProperty("translated-value", null)));
                }
            }
            simple.setValues(chips);
            return true;
        }
        return false;
    }

    @Override
    public SectioningStatusFilterRpcRequest createRpcRequest() {
        SectioningStatusFilterRpcRequest req = new SectioningStatusFilterRpcRequest();
        req.setOption("online", this.iOnline ? "true" : "false");
        return req;
    }

    @Override
    protected void onLoad(EventInterface.FilterRpcResponse result) {
        if (!result.hasEntities()) {
            return;
        }
        boolean added = false;
        block0: for (String type : result.getTypes()) {
            for (FilterBox.Filter filter : ((FilterBox)this.iFilter.getWidget()).getFilters()) {
                if (!filter.getCommand().equals(type)) continue;
                continue block0;
            }
            ((FilterBox)this.iFilter.getWidget()).getFilters().add(((FilterBox)this.iFilter.getWidget()).getFilters().size() - 10, new FilterBox.StaticSimpleFilter(type, result.getTypeLabel(type), new String[0]));
            added = true;
        }
        if (added) {
            this.setValue(this.getValue(), false);
        }
    }

    public class StudentOracle
    extends SuggestOracle {
        public void requestSuggestions(final SuggestOracle.Request request, final SuggestOracle.Callback callback) {
            if (!request.getQuery().isEmpty()) {
                ((FilterBox)SectioningStatusFilterBox.this.iFilter.getWidget()).getSuggestionsProvider().getSuggestions(((FilterBox)SectioningStatusFilterBox.this.iFilter.getWidget()).getChips(null), request.getQuery(), new AsyncCallback<Collection<FilterBox.Suggestion>>(){

                    public void onFailure(Throwable caught) {
                    }

                    public void onSuccess(Collection<FilterBox.Suggestion> result) {
                        if (result == null) {
                            return;
                        }
                        ArrayList<StudentSuggestion> suggestions = new ArrayList<StudentSuggestion>();
                        for (FilterBox.Suggestion suggestion : result) {
                            if (suggestion.getChipToAdd() == null || !"student".equals(suggestion.getChipToAdd().getCommand())) continue;
                            suggestions.add(new StudentSuggestion(suggestion));
                        }
                        callback.onSuggestionsReady(request, new SuggestOracle.Response(suggestions));
                    }
                });
            }
        }
    }

    public class StudentSuggestion
    implements SuggestOracle.Suggestion {
        private FilterBox.Suggestion iSuggestion;

        StudentSuggestion(FilterBox.Suggestion suggestion) {
            this.iSuggestion = suggestion;
        }

        public String getDisplayString() {
            return this.iSuggestion.getChipToAdd().getLabel();
        }

        public String getReplacementString() {
            return this.iSuggestion.getChipToAdd().getValue();
        }
    }

    public class CourseOracle
    extends SuggestOracle {
        public void requestSuggestions(final SuggestOracle.Request request, final SuggestOracle.Callback callback) {
            if (!request.getQuery().isEmpty()) {
                ((FilterBox)SectioningStatusFilterBox.this.iFilter.getWidget()).getSuggestionsProvider().getSuggestions(((FilterBox)SectioningStatusFilterBox.this.iFilter.getWidget()).getChips(null), request.getQuery(), new AsyncCallback<Collection<FilterBox.Suggestion>>(){

                    public void onFailure(Throwable caught) {
                    }

                    public void onSuccess(Collection<FilterBox.Suggestion> result) {
                        if (result == null) {
                            return;
                        }
                        ArrayList<CourseSuggestion> suggestions = new ArrayList<CourseSuggestion>();
                        for (FilterBox.Suggestion suggestion : result) {
                            if (suggestion.getChipToAdd() == null || !"course".equals(suggestion.getChipToAdd().getCommand())) continue;
                            suggestions.add(new CourseSuggestion(suggestion));
                        }
                        callback.onSuggestionsReady(request, new SuggestOracle.Response(suggestions));
                    }
                });
            }
        }

        public boolean isDisplayStringHTML() {
            return true;
        }
    }

    public class CourseSuggestion
    implements SuggestOracle.Suggestion {
        private FilterBox.Suggestion iSuggestion;

        CourseSuggestion(FilterBox.Suggestion suggestion) {
            this.iSuggestion = suggestion;
        }

        public String getDisplayString() {
            return this.iSuggestion.getChipToAdd().getLabel() + (this.iSuggestion.getChipToAdd().hasToolTip() ? " <span class='item-hint'>" + this.iSuggestion.getChipToAdd().getToolTip() + "</span>" : "");
        }

        public String getReplacementString() {
            return this.iSuggestion.getChipToAdd().getValue();
        }
    }

    public static class SectioningStatusFilterRpcRequest
    extends EventInterface.FilterRpcRequest {
        private static final long serialVersionUID = 1L;
    }
}

