/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution.jgroups;

import net.sf.ehcache.Ehcache;
import net.sf.ehcache.bootstrap.BootstrapCacheLoader;
import net.sf.ehcache.distribution.RemoteCacheException;
import net.sf.ehcache.distribution.jgroups.BootstrapRequest;
import net.sf.ehcache.distribution.jgroups.JGroupsBootstrapManager;
import net.sf.ehcache.distribution.jgroups.JGroupsCacheManagerPeerProvider;

public class JGroupsBootstrapCacheLoader
implements BootstrapCacheLoader {
    protected boolean asynchronous;
    protected int maximumChunkSizeBytes;

    public JGroupsBootstrapCacheLoader(boolean asynchronous, int maximumChunkSize) {
        this.asynchronous = asynchronous;
        this.maximumChunkSizeBytes = maximumChunkSize;
    }

    public void load(Ehcache cache) throws RemoteCacheException {
        JGroupsCacheManagerPeerProvider cachePeerProvider = JGroupsCacheManagerPeerProvider.getCachePeerProvider(cache);
        BootstrapRequest bootstrapRequest = new BootstrapRequest(cache, this.asynchronous, this.maximumChunkSizeBytes);
        JGroupsBootstrapManager bootstrapManager = cachePeerProvider.getBootstrapManager();
        bootstrapManager.handleBootstrapRequest(bootstrapRequest);
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public int getMaximumChunkSizeBytes() {
        return this.maximumChunkSizeBytes;
    }

    public Object clone() throws CloneNotSupportedException {
        return new JGroupsBootstrapCacheLoader(this.asynchronous, this.maximumChunkSizeBytes);
    }
}

