/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.TypeOverrides;
import org.hibernate.cache.infinispan.collection.CollectionRegionImpl;
import org.hibernate.cache.infinispan.entity.EntityRegionImpl;
import org.hibernate.cache.infinispan.impl.BaseRegion;
import org.hibernate.cache.infinispan.naturalid.NaturalIdRegionImpl;
import org.hibernate.cache.infinispan.query.QueryResultsRegionImpl;
import org.hibernate.cache.infinispan.timestamp.ClusteredTimestampsRegionImpl;
import org.hibernate.cache.infinispan.timestamp.TimestampTypeOverrides;
import org.hibernate.cache.infinispan.timestamp.TimestampsRegionImpl;
import org.hibernate.cache.infinispan.tm.HibernateTransactionManagerLookup;
import org.hibernate.cache.infinispan.util.CacheCommandFactory;
import org.hibernate.cache.infinispan.util.Caches;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cfg.Settings;
import org.hibernate.internal.util.ClassLoaderHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.module.ModuleCommandFactory;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.GenericTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class InfinispanRegionFactory
implements RegionFactory {
    private static final Log log = LogFactory.getLog(InfinispanRegionFactory.class);
    private static final String PREFIX = "hibernate.cache.infinispan.";
    private static final String CONFIG_SUFFIX = ".cfg";
    private static final String STRATEGY_SUFFIX = ".eviction.strategy";
    private static final String WAKE_UP_INTERVAL_SUFFIX = ".eviction.wake_up_interval";
    private static final String MAX_ENTRIES_SUFFIX = ".eviction.max_entries";
    private static final String LIFESPAN_SUFFIX = ".expiration.lifespan";
    private static final String MAX_IDLE_SUFFIX = ".expiration.max_idle";
    public static final String INFINISPAN_CONFIG_RESOURCE_PROP = "hibernate.cache.infinispan.cfg";
    public static final String INFINISPAN_GLOBAL_STATISTICS_PROP = "hibernate.cache.infinispan.statistics";
    public static final String INFINISPAN_USE_SYNCHRONIZATION_PROP = "hibernate.cache.infinispan.use_synchronization";
    private static final String NATURAL_ID_KEY = "naturalid";
    public static final String NATURAL_ID_CACHE_RESOURCE_PROP = "hibernate.cache.infinispan.naturalid.cfg";
    private static final String ENTITY_KEY = "entity";
    public static final String ENTITY_CACHE_RESOURCE_PROP = "hibernate.cache.infinispan.entity.cfg";
    private static final String COLLECTION_KEY = "collection";
    public static final String COLLECTION_CACHE_RESOURCE_PROP = "hibernate.cache.infinispan.collection.cfg";
    private static final String TIMESTAMPS_KEY = "timestamps";
    public static final String TIMESTAMPS_CACHE_RESOURCE_PROP = "hibernate.cache.infinispan.timestamps.cfg";
    private static final String QUERY_KEY = "query";
    public static final String QUERY_CACHE_RESOURCE_PROP = "hibernate.cache.infinispan.query.cfg";
    public static final String DEF_INFINISPAN_CONFIG_RESOURCE = "org/hibernate/cache/infinispan/builder/infinispan-configs.xml";
    public static final String DEF_ENTITY_RESOURCE = "entity";
    public static final String DEF_TIMESTAMPS_RESOURCE = "timestamps";
    public static final String DEF_QUERY_RESOURCE = "local-query";
    public static final boolean DEF_USE_SYNCHRONIZATION = true;
    public static final String PENDING_PUTS_CACHE_NAME = "pending-puts";
    private EmbeddedCacheManager manager;
    private final Map<String, TypeOverrides> typeOverrides = new HashMap<String, TypeOverrides>();
    private final Set<String> definedConfigurations = new HashSet<String>();
    private TransactionManagerLookup transactionManagerlookup;
    private List<String> regionNames = new ArrayList<String>();

    public InfinispanRegionFactory() {
    }

    public InfinispanRegionFactory(Properties props) {
    }

    public CollectionRegion buildCollectionRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Building collection cache region [" + regionName + "]"));
        }
        AdvancedCache cache = this.getCache(regionName, COLLECTION_KEY, properties);
        CollectionRegionImpl region = new CollectionRegionImpl(cache, regionName, metadata, this);
        this.startRegion(region, regionName);
        return region;
    }

    public EntityRegion buildEntityRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Building entity cache region [" + regionName + "]"));
        }
        AdvancedCache cache = this.getCache(regionName, "entity", properties);
        EntityRegionImpl region = new EntityRegionImpl(cache, regionName, metadata, this);
        this.startRegion(region, regionName);
        return region;
    }

    public NaturalIdRegion buildNaturalIdRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Building natural id cache region [" + regionName + "]"));
        }
        AdvancedCache cache = this.getCache(regionName, NATURAL_ID_KEY, properties);
        NaturalIdRegionImpl region = new NaturalIdRegionImpl(cache, regionName, metadata, this);
        this.startRegion(region, regionName);
        return region;
    }

    public QueryResultsRegion buildQueryResultsRegion(String regionName, Properties properties) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Building query results cache region [" + regionName + "]"));
        }
        String cacheName = this.typeOverrides.get(QUERY_KEY).getCacheName();
        if (!regionName.equals("org.hibernate.cache.internal.StandardQueryCache")) {
            cacheName = regionName;
        }
        AdvancedCache cache = this.getCache(cacheName, QUERY_KEY, properties);
        QueryResultsRegionImpl region = new QueryResultsRegionImpl(cache, regionName, this);
        this.startRegion(region, regionName);
        return region;
    }

    public TimestampsRegion buildTimestampsRegion(String regionName, Properties properties) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Building timestamps cache region [" + regionName + "]"));
        }
        AdvancedCache cache = this.getCache(regionName, "timestamps", properties);
        TimestampsRegionImpl region = this.createTimestampsRegion(cache, regionName);
        this.startRegion(region, regionName);
        return region;
    }

    protected TimestampsRegionImpl createTimestampsRegion(AdvancedCache cache, String regionName) {
        if (Caches.isClustered(cache)) {
            return new ClusteredTimestampsRegionImpl(cache, regionName, this);
        }
        return new TimestampsRegionImpl(cache, regionName, this);
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public AccessType getDefaultAccessType() {
        return AccessType.TRANSACTIONAL;
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public void setCacheManager(EmbeddedCacheManager manager) {
        this.manager = manager;
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.manager;
    }

    public void start(Settings settings, Properties properties) throws CacheException {
        log.debug((Object)"Starting Infinispan region factory");
        try {
            this.transactionManagerlookup = this.createTransactionManagerLookup(settings, properties);
            this.manager = this.createCacheManager(properties);
            this.initGenericDataTypeOverrides();
            Enumeration<?> keys = properties.propertyNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                int prefixLoc = key.indexOf(PREFIX);
                if (prefixLoc == -1) continue;
                this.dissectProperty(prefixLoc, key, properties);
            }
            this.defineGenericDataTypeCacheConfigurations(properties);
            this.definePendingPutsCache();
        }
        catch (CacheException ce) {
            throw ce;
        }
        catch (Throwable t) {
            throw new CacheException("Unable to start region factory", t);
        }
    }

    private void definePendingPutsCache() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.LOCAL).transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL).expiration().maxIdle(TimeUnit.SECONDS.toMillis(60L)).storeAsBinary().enabled(false).locking().isolationLevel(IsolationLevel.READ_COMMITTED).jmxStatistics().disable();
        this.manager.defineConfiguration(PENDING_PUTS_CACHE_NAME, builder.build());
    }

    protected TransactionManagerLookup createTransactionManagerLookup(Settings settings, Properties properties) {
        return new HibernateTransactionManagerLookup(settings, properties);
    }

    public void stop() {
        log.debug((Object)"Stop region factory");
        this.stopCacheRegions();
        this.stopCacheManager();
    }

    protected void stopCacheRegions() {
        log.debug((Object)"Clear region references");
        this.getCacheCommandFactory(this.manager.getCache().getAdvancedCache()).clearRegions(this.regionNames);
        this.regionNames.clear();
    }

    protected void stopCacheManager() {
        log.debug((Object)"Stop cache manager");
        this.manager.stop();
    }

    public Map<String, TypeOverrides> getTypeOverrides() {
        return Collections.unmodifiableMap(this.typeOverrides);
    }

    public Set<String> getDefinedConfigurations() {
        return Collections.unmodifiableSet(this.definedConfigurations);
    }

    protected EmbeddedCacheManager createCacheManager(Properties properties) throws CacheException {
        try {
            InputStream is;
            String configLoc = ConfigurationHelper.getString((String)INFINISPAN_CONFIG_RESOURCE_PROP, (Map)properties, (String)DEF_INFINISPAN_CONFIG_RESOURCE);
            ClassLoader classLoader = ClassLoaderHelper.getContextClassLoader();
            try {
                is = FileLookupFactory.newInstance().lookupFileStrict(configLoc, classLoader);
            }
            catch (FileNotFoundException e) {
                classLoader = this.getClass().getClassLoader();
                is = FileLookupFactory.newInstance().lookupFileStrict(configLoc, classLoader);
            }
            ParserRegistry parserRegistry = new ParserRegistry(classLoader);
            ConfigurationBuilderHolder holder = parserRegistry.parse(is);
            String globalStats = this.extractProperty(INFINISPAN_GLOBAL_STATISTICS_PROP, properties);
            if (globalStats != null) {
                holder.getGlobalConfigurationBuilder().globalJmxStatistics().enabled(Boolean.parseBoolean(globalStats));
            }
            return this.createCacheManager(holder);
        }
        catch (IOException e) {
            throw new CacheException("Unable to create default cache manager", (Throwable)e);
        }
    }

    protected EmbeddedCacheManager createCacheManager(ConfigurationBuilderHolder holder) {
        return new DefaultCacheManager(holder, true);
    }

    private void startRegion(BaseRegion region, String regionName) {
        this.regionNames.add(regionName);
        this.getCacheCommandFactory(region.getCache()).addRegion(regionName, region);
    }

    private Map<String, TypeOverrides> initGenericDataTypeOverrides() {
        TypeOverrides entityOverrides = new TypeOverrides();
        entityOverrides.setCacheName("entity");
        this.typeOverrides.put("entity", entityOverrides);
        TypeOverrides collectionOverrides = new TypeOverrides();
        collectionOverrides.setCacheName("entity");
        this.typeOverrides.put(COLLECTION_KEY, collectionOverrides);
        TypeOverrides naturalIdOverrides = new TypeOverrides();
        naturalIdOverrides.setCacheName("entity");
        this.typeOverrides.put(NATURAL_ID_KEY, naturalIdOverrides);
        TimestampTypeOverrides timestampOverrides = new TimestampTypeOverrides();
        timestampOverrides.setCacheName("timestamps");
        this.typeOverrides.put("timestamps", timestampOverrides);
        TypeOverrides queryOverrides = new TypeOverrides();
        queryOverrides.setCacheName(DEF_QUERY_RESOURCE);
        this.typeOverrides.put(QUERY_KEY, queryOverrides);
        return this.typeOverrides;
    }

    private void dissectProperty(int prefixLoc, String key, Properties properties) {
        int suffixLoc;
        if (!key.equals(INFINISPAN_CONFIG_RESOURCE_PROP) && (suffixLoc = key.indexOf(CONFIG_SUFFIX)) != -1) {
            TypeOverrides cfgOverride = this.getOrCreateConfig(prefixLoc, key, suffixLoc);
            cfgOverride.setCacheName(this.extractProperty(key, properties));
        } else {
            suffixLoc = key.indexOf(STRATEGY_SUFFIX);
            if (suffixLoc != -1) {
                TypeOverrides cfgOverride = this.getOrCreateConfig(prefixLoc, key, suffixLoc);
                cfgOverride.setEvictionStrategy(this.extractProperty(key, properties));
            } else {
                suffixLoc = key.indexOf(WAKE_UP_INTERVAL_SUFFIX);
                if (suffixLoc != -1) {
                    TypeOverrides cfgOverride = this.getOrCreateConfig(prefixLoc, key, suffixLoc);
                    cfgOverride.setEvictionWakeUpInterval(Long.parseLong(this.extractProperty(key, properties)));
                } else {
                    suffixLoc = key.indexOf(MAX_ENTRIES_SUFFIX);
                    if (suffixLoc != -1) {
                        TypeOverrides cfgOverride = this.getOrCreateConfig(prefixLoc, key, suffixLoc);
                        cfgOverride.setEvictionMaxEntries(Integer.parseInt(this.extractProperty(key, properties)));
                    } else {
                        suffixLoc = key.indexOf(LIFESPAN_SUFFIX);
                        if (suffixLoc != -1) {
                            TypeOverrides cfgOverride = this.getOrCreateConfig(prefixLoc, key, suffixLoc);
                            cfgOverride.setExpirationLifespan(Long.parseLong(this.extractProperty(key, properties)));
                        } else {
                            suffixLoc = key.indexOf(MAX_IDLE_SUFFIX);
                            if (suffixLoc != -1) {
                                TypeOverrides cfgOverride = this.getOrCreateConfig(prefixLoc, key, suffixLoc);
                                cfgOverride.setExpirationMaxIdle(Long.parseLong(this.extractProperty(key, properties)));
                            }
                        }
                    }
                }
            }
        }
    }

    private String extractProperty(String key, Properties properties) {
        String value = ConfigurationHelper.extractPropertyValue((String)key, (Properties)properties);
        log.debugf("Configuration override via property %s: %s", (Object)key, (Object)value);
        return value;
    }

    private TypeOverrides getOrCreateConfig(int prefixLoc, String key, int suffixLoc) {
        String name = key.substring(prefixLoc + PREFIX.length(), suffixLoc);
        TypeOverrides cfgOverride = this.typeOverrides.get(name);
        if (cfgOverride == null) {
            cfgOverride = new TypeOverrides();
            this.typeOverrides.put(name, cfgOverride);
        }
        return cfgOverride;
    }

    private void defineGenericDataTypeCacheConfigurations(Properties properties) {
        String[] defaultGenericDataTypes;
        for (String type : defaultGenericDataTypes = new String[]{"entity", COLLECTION_KEY, "timestamps", QUERY_KEY}) {
            TypeOverrides override = this.overrideStatisticsIfPresent(this.typeOverrides.get(type), properties);
            String cacheName = override.getCacheName();
            ConfigurationBuilder builder = new ConfigurationBuilder();
            this.applyConfiguration(cacheName, builder);
            override.applyTo(builder);
            this.configureTransactionManager(builder, cacheName, properties);
            Configuration cfg = builder.build();
            override.validateInfinispanConfiguration(cfg);
            this.manager.defineConfiguration(cacheName, cfg);
            this.definedConfigurations.add(cacheName);
        }
    }

    private AdvancedCache getCache(String regionName, String typeKey, Properties properties) {
        AdvancedCache cache;
        TypeOverrides regionOverride = this.typeOverrides.get(regionName);
        if (!this.definedConfigurations.contains(regionName)) {
            String templateCacheName;
            ConfigurationBuilder builder = new ConfigurationBuilder();
            if (regionOverride != null) {
                String cacheName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cache region specific configuration exists: " + regionOverride));
                }
                templateCacheName = (cacheName = regionOverride.getCacheName()) != null ? cacheName : this.typeOverrides.get(typeKey).getCacheName();
                this.applyConfiguration(templateCacheName, builder);
                regionOverride = this.overrideStatisticsIfPresent(regionOverride, properties);
                regionOverride.applyTo(builder);
            } else {
                templateCacheName = this.typeOverrides.get(typeKey).getCacheName();
                builder.read(this.manager.getCacheConfiguration(templateCacheName));
                this.typeOverrides.get(typeKey).applyTo(builder);
            }
            this.configureTransactionManager(builder, templateCacheName, properties);
            this.manager.defineConfiguration(regionName, builder.build());
            this.definedConfigurations.add(regionName);
        }
        if (!(cache = this.manager.getCache(regionName).getAdvancedCache()).getStatus().allowInvocations()) {
            cache.start();
        }
        return this.createCacheWrapper(cache);
    }

    private void applyConfiguration(String cacheName, ConfigurationBuilder builder) {
        Configuration cfg = this.manager.getCacheConfiguration(cacheName);
        if (cfg != null) {
            builder.read(cfg);
        }
    }

    private CacheCommandFactory getCacheCommandFactory(AdvancedCache cache) {
        GlobalComponentRegistry globalCr = cache.getComponentRegistry().getGlobalComponentRegistry();
        Map factories = (Map)globalCr.getComponent("org.infinispan.modules.command.factories");
        for (ModuleCommandFactory factory : factories.values()) {
            if (!(factory instanceof CacheCommandFactory)) continue;
            return (CacheCommandFactory)factory;
        }
        throw new CacheException("Infinispan custom cache command factory not installed (possibly because the classloader where Infinispan lives couldn't find the Hibernate Infinispan cache provider)");
    }

    protected AdvancedCache createCacheWrapper(AdvancedCache cache) {
        return cache;
    }

    private void configureTransactionManager(ConfigurationBuilder builder, String cacheName, Properties properties) {
        Configuration baseCfg = this.manager.getCacheConfiguration(cacheName);
        if (baseCfg != null && baseCfg.transaction().transactionMode().isTransactional()) {
            String ispnTmLookupClassName = baseCfg.transaction().transactionManagerLookup().getClass().getName();
            String hbTmLookupClassName = HibernateTransactionManagerLookup.class.getName();
            if (GenericTransactionManagerLookup.class.getName().equals(ispnTmLookupClassName)) {
                log.debug((Object)"Using default Infinispan transaction manager lookup instance (GenericTransactionManagerLookup), overriding it with Hibernate transaction manager lookup");
                builder.transaction().transactionManagerLookup(this.transactionManagerlookup);
            } else if (ispnTmLookupClassName != null && !ispnTmLookupClassName.equals(hbTmLookupClassName)) {
                log.debug((Object)("Infinispan is configured [" + ispnTmLookupClassName + "] with a different transaction manager lookup " + "class than Hibernate [" + hbTmLookupClassName + "]"));
            } else {
                builder.transaction().transactionManagerLookup(this.transactionManagerlookup);
            }
            String useSyncProp = this.extractProperty(INFINISPAN_USE_SYNCHRONIZATION_PROP, properties);
            boolean useSync = useSyncProp == null ? true : Boolean.parseBoolean(useSyncProp);
            builder.transaction().useSynchronization(useSync);
        }
    }

    private TypeOverrides overrideStatisticsIfPresent(TypeOverrides override, Properties properties) {
        String globalStats = this.extractProperty(INFINISPAN_GLOBAL_STATISTICS_PROP, properties);
        if (globalStats != null) {
            override.setExposeStatistics(Boolean.parseBoolean(globalStats));
        }
        return override;
    }
}

