/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.serial;

import java.io.IOException;
import java.io.ObjectStreamConstants;
import org.jboss.marshalling.reflect.SerializableClass;
import org.jboss.marshalling.reflect.SerializableField;
import org.jboss.marshalling.serial.BlockUnmarshaller;
import org.jboss.marshalling.serial.Descriptor;
import org.jboss.marshalling.serial.SerialUnmarshaller;
import org.jboss.marshalling.util.Kind;

class UnknownDescriptor
extends Descriptor
implements ObjectStreamConstants {
    private final SerializableField[] fields;
    private final int flags;

    protected UnknownDescriptor(Descriptor parent, SerializableField[] fields, int flags) {
        super(parent, null);
        this.fields = fields;
        this.flags = flags;
    }

    @Override
    public SerializableField[] getFields() {
        return this.fields;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    protected void readSerial(SerialUnmarshaller serialUnmarshaller, SerializableClass sc, Object subject) throws IOException, ClassNotFoundException {
        this.discardFields(serialUnmarshaller);
        if ((this.flags & 1) != 0) {
            BlockUnmarshaller blockUnmarshaller = serialUnmarshaller.getBlockUnmarshaller();
            blockUnmarshaller.readToEndBlockData();
            blockUnmarshaller.unblock();
        }
    }

    void discardFields(SerialUnmarshaller serialUnmarshaller) throws IOException, ClassNotFoundException {
        block10: for (SerializableField serializableField : this.fields) {
            switch (serializableField.getKind()) {
                case BOOLEAN: {
                    serialUnmarshaller.readBoolean();
                    continue block10;
                }
                case BYTE: {
                    serialUnmarshaller.readByte();
                    continue block10;
                }
                case CHAR: {
                    serialUnmarshaller.readChar();
                    continue block10;
                }
                case DOUBLE: {
                    serialUnmarshaller.readDouble();
                    continue block10;
                }
                case FLOAT: {
                    serialUnmarshaller.readFloat();
                    continue block10;
                }
                case INT: {
                    serialUnmarshaller.readInt();
                    continue block10;
                }
                case LONG: {
                    serialUnmarshaller.readLong();
                    continue block10;
                }
                case SHORT: {
                    serialUnmarshaller.readShort();
                }
            }
        }
        for (SerializableField serializableField : this.fields) {
            if (serializableField.getKind() != Kind.OBJECT) continue;
            serialUnmarshaller.readObject();
        }
    }
}

