/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.reservation;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cpsolver.studentsct.model.AreaClassificationMajor;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.reservation.Restriction;

public class CurriculumRestriction
extends Restriction {
    private Set<String> iAcadAreas = new HashSet<String>();
    private Set<String> iClassifications = new HashSet<String>();
    private Set<String> iMajors = new HashSet<String>();
    private Set<String> iMinors = new HashSet<String>();
    private Map<String, Set<String>> iConcentrations = null;

    public CurriculumRestriction(long id, Offering offering, Collection<String> acadAreas, Collection<String> classifications, Collection<String> majors, Collection<String> minors) {
        super(id, offering);
        if (acadAreas != null) {
            this.iAcadAreas.addAll(acadAreas);
        }
        if (classifications != null) {
            this.iClassifications.addAll(classifications);
        }
        if (majors != null) {
            this.iMajors.addAll(majors);
        }
        if (minors != null) {
            this.iMinors.addAll(minors);
        }
    }

    public CurriculumRestriction(long id, Offering offering, Collection<String> acadAreas, Collection<String> classifications, Collection<String> majors) {
        super(id, offering);
        if (acadAreas != null) {
            this.iAcadAreas.addAll(acadAreas);
        }
        if (classifications != null) {
            this.iClassifications.addAll(classifications);
        }
        if (majors != null) {
            this.iMajors.addAll(majors);
        }
    }

    @Deprecated
    public CurriculumRestriction(long id, Offering offering, String acadArea, Collection<String> classifications, Collection<String> majors) {
        super(id, offering);
        this.iAcadAreas.add(acadArea);
        if (classifications != null) {
            this.iClassifications.addAll(classifications);
        }
        if (majors != null) {
            this.iMajors.addAll(majors);
        }
    }

    public Set<String> getAcademicAreas() {
        return this.iAcadAreas;
    }

    @Deprecated
    public String getAcademicArea() {
        if (this.getAcademicAreas().isEmpty()) {
            return "";
        }
        return this.getAcademicAreas().iterator().next();
    }

    public Set<String> getMajors() {
        return this.iMajors;
    }

    public Set<String> getMinors() {
        return this.iMinors;
    }

    public Set<String> getClassifications() {
        return this.iClassifications;
    }

    public Set<String> getConcentrations(String major) {
        return this.iConcentrations == null ? null : this.iConcentrations.get(major);
    }

    public void addConcentration(String major, String concentration) {
        Set<String> concentrations;
        if (this.iConcentrations == null) {
            this.iConcentrations = new HashMap<String, Set<String>>();
        }
        if ((concentrations = this.iConcentrations.get(major)) == null) {
            concentrations = new HashSet<String>();
            this.iConcentrations.put(major, concentrations);
        }
        concentrations.add(concentration);
    }

    @Override
    public boolean isApplicable(Student student) {
        if (!this.getMajors().isEmpty() || this.getMinors().isEmpty()) {
            for (AreaClassificationMajor acm : student.getAreaClassificationMajors()) {
                if (!this.getAcademicAreas().contains(acm.getArea()) || !this.getClassifications().isEmpty() && !this.getClassifications().contains(acm.getClassification()) || !this.getMajors().isEmpty() && !this.getMajors().contains(acm.getMajor())) continue;
                Set<String> conc = this.getConcentrations(acm.getMajor());
                if (conc != null && !conc.isEmpty()) {
                    return acm.getConcentration() != null && conc.contains(acm.getConcentration());
                }
                return true;
            }
        }
        if (!this.getMinors().isEmpty()) {
            for (AreaClassificationMajor acm : student.getAreaClassificationMinors()) {
                if (!this.getAcademicAreas().contains(acm.getArea()) || !this.getClassifications().isEmpty() && !this.getClassifications().contains(acm.getClassification()) || !this.getMinors().contains(acm.getMajor())) continue;
                return true;
            }
        }
        return false;
    }
}

