/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.constraint;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.criteria.BrokenTimePatterns;
import org.cpsolver.coursett.criteria.UselessHalfHours;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomSharingModel;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentConstraintContext;
import org.cpsolver.ifs.assignment.context.ConstraintWithContext;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.util.DataProperties;

public class RoomConstraint
extends ConstraintWithContext<Lecture, Placement, RoomConstraintContext> {
    private Long iResourceId;
    private String iName;
    private Long iBuildingId;
    private int iCapacity = 0;
    private List<Placement>[] iAvailable = null;
    private boolean iConstraint = true;
    private Double iPosX = null;
    private Double iPosY = null;
    private boolean iIgnoreTooFar = false;
    private RoomSharingModel iRoomSharingModel = null;
    private Long iType = null;
    private int iDayOfWeekOffset = 0;
    private RoomConstraint iParentRoom;
    private List<RoomConstraint> iPartitions;

    public RoomConstraint(Long id, String name, Long buildingId, int capacity, RoomSharingModel roomSharingModel, Double x, Double y, boolean ignoreTooFar, boolean constraint) {
        this.iResourceId = id;
        this.iName = name;
        this.iBuildingId = buildingId;
        this.iCapacity = capacity;
        this.iConstraint = constraint;
        this.iRoomSharingModel = roomSharingModel;
        this.iPosX = x;
        this.iPosY = y;
        this.iIgnoreTooFar = ignoreTooFar;
    }

    @Override
    public void setModel(Model<Lecture, Placement> model) {
        super.setModel(model);
        if (model != null) {
            DataProperties config = ((TimetableModel)model).getProperties();
            this.iDayOfWeekOffset = config.getPropertyInt("DatePattern.DayOfWeekOffset", 0);
        }
    }

    public void setNotAvailable(Placement placement) {
        if (this.iAvailable == null) {
            this.iAvailable = new List[288 * Constants.NR_DAYS];
            for (int i = 0; i < this.iAvailable.length; ++i) {
                this.iAvailable[i] = null;
            }
        }
        TimeLocation.IntEnumeration e = placement.getTimeLocation().getSlots();
        while (e.hasMoreElements()) {
            int slot = (Integer)e.nextElement();
            if (this.iAvailable[slot] == null) {
                this.iAvailable[slot] = new ArrayList<Placement>(1);
            }
            this.iAvailable[slot].add(placement);
        }
        for (Lecture lecture : this.variables()) {
            lecture.clearValueCache();
        }
    }

    public boolean isAvailable(int slot) {
        if (this.getConstraint() && this.iAvailable != null && this.iAvailable[slot] != null && !this.iAvailable[slot].isEmpty()) {
            return false;
        }
        return this.getSharingModel() == null || !this.getSharingModel().isNotAvailable(slot);
    }

    public boolean isAvailable(Lecture lecture, TimeLocation time, Long scheduler) {
        int slot;
        TimeLocation.IntEnumeration e;
        if (this.iAvailable != null && this.getConstraint()) {
            e = time.getSlots();
            while (e.hasMoreElements()) {
                slot = (Integer)e.nextElement();
                if (this.iAvailable[slot] == null) continue;
                for (Placement p : this.iAvailable[slot]) {
                    if (lecture.canShareRoom((Lecture)p.variable()) || !time.shareWeeks(p.getTimeLocation())) continue;
                    return false;
                }
            }
        }
        if (this.getParentRoom() != null && this.getParentRoom().getConstraint() && this.getParentRoom().iAvailable != null) {
            e = time.getSlots();
            while (e.hasMoreElements()) {
                slot = (Integer)e.nextElement();
                if (this.getParentRoom().iAvailable[slot] == null) continue;
                for (Placement p : this.getParentRoom().iAvailable[slot]) {
                    if (lecture.canShareRoom((Lecture)p.variable()) || !time.shareWeeks(p.getTimeLocation())) continue;
                    return false;
                }
            }
        }
        if (this.getPartitions() != null) {
            for (RoomConstraint partition : this.getPartitions()) {
                if (partition.iAvailable == null || !partition.getConstraint()) continue;
                TimeLocation.IntEnumeration e2 = time.getSlots();
                while (e2.hasMoreElements()) {
                    int slot2 = (Integer)e2.nextElement();
                    if (partition.iAvailable[slot2] == null) continue;
                    for (Placement p : partition.iAvailable[slot2]) {
                        if (lecture.canShareRoom((Lecture)p.variable()) || !time.shareWeeks(p.getTimeLocation())) continue;
                        return false;
                    }
                }
            }
        }
        return this.getSharingModel() == null || this.getSharingModel().isAvailable(time, scheduler);
    }

    public List<Placement>[] getAvailableArray() {
        return this.iAvailable;
    }

    public RoomSharingModel getSharingModel() {
        return this.iRoomSharingModel;
    }

    public void addPartition(RoomConstraint room) {
        room.iParentRoom = this;
        if (this.iPartitions == null) {
            this.iPartitions = new ArrayList<RoomConstraint>();
        }
        this.iPartitions.add(room);
    }

    public RoomConstraint getParentRoom() {
        return this.iParentRoom;
    }

    public List<RoomConstraint> getPartitions() {
        return this.iPartitions;
    }

    public Long getResourceId() {
        return this.iResourceId;
    }

    public Long getBuildingId() {
        return this.iBuildingId;
    }

    @Override
    public String getName() {
        return this.iName;
    }

    public String getRoomName() {
        return this.iName;
    }

    public int getCapacity() {
        return this.iCapacity;
    }

    @Override
    public void computeConflicts(Assignment<Lecture, Placement> assignment, Placement placement, Set<Placement> conflicts) {
        TimeLocation.IntEnumeration e;
        Object context;
        BitSet weekCode;
        HashSet<Placement> shared;
        Placement current;
        Lecture lecture;
        if (!this.getConstraint()) {
            return;
        }
        if (!placement.hasRoomLocation(this.getResourceId())) {
            return;
        }
        if (this.getParentRoom() != null && this.getParentRoom().getConstraint()) {
            lecture = (Lecture)placement.variable();
            current = assignment.getValue(lecture);
            shared = null;
            weekCode = placement.getTimeLocation().getWeekCode();
            context = (RoomConstraintContext)this.getParentRoom().getContext((Assignment)assignment);
            e = placement.getTimeLocation().getSlots();
            while (e.hasMoreElements()) {
                int slot = (Integer)e.nextElement();
                for (Placement confPlacement : ((RoomConstraintContext)context).getPlacements(slot)) {
                    if (!confPlacement.getTimeLocation().shareWeeks(weekCode) || confPlacement.equals(current) || shared != null && shared.contains(confPlacement)) continue;
                    if (confPlacement.canShareRooms(placement) && this.checkRoomSize(placement, (Collection<Placement>)shared, confPlacement)) {
                        if (shared == null) {
                            shared = new HashSet();
                        }
                        shared.add(confPlacement);
                        continue;
                    }
                    conflicts.add(confPlacement);
                }
            }
        }
        if (this.getPartitions() != null) {
            lecture = (Lecture)placement.variable();
            current = assignment.getValue(lecture);
            shared = null;
            weekCode = placement.getTimeLocation().getWeekCode();
            for (RoomConstraint partition : this.iPartitions) {
                if (!partition.getConstraint()) continue;
                RoomConstraintContext context2 = (RoomConstraintContext)partition.getContext((Assignment)assignment);
                TimeLocation.IntEnumeration e2 = placement.getTimeLocation().getSlots();
                while (e2.hasMoreElements()) {
                    int slot = (Integer)e2.nextElement();
                    for (Placement confPlacement : context2.getPlacements(slot)) {
                        if (!confPlacement.getTimeLocation().shareWeeks(weekCode) || confPlacement.equals(current) || shared != null && shared.contains(confPlacement)) continue;
                        if (confPlacement.canShareRooms(placement) && this.checkRoomSize(placement, shared, confPlacement)) {
                            if (shared == null) {
                                shared = new HashSet();
                            }
                            shared.add(confPlacement);
                            continue;
                        }
                        conflicts.add(confPlacement);
                    }
                }
            }
        }
        lecture = (Lecture)placement.variable();
        current = assignment.getValue(lecture);
        shared = null;
        weekCode = placement.getTimeLocation().getWeekCode();
        context = (RoomConstraintContext)this.getContext((Assignment)assignment);
        e = placement.getTimeLocation().getSlots();
        while (e.hasMoreElements()) {
            int slot = (Integer)e.nextElement();
            for (Placement confPlacement : ((RoomConstraintContext)context).getPlacements(slot)) {
                if (!confPlacement.getTimeLocation().shareWeeks(weekCode) || confPlacement.equals(current) || shared != null && shared.contains(confPlacement)) continue;
                if (confPlacement.canShareRooms(placement) && this.checkRoomSize(placement, (Collection<Placement>)shared, confPlacement)) {
                    if (shared == null) {
                        shared = new HashSet<Placement>();
                    }
                    shared.add(confPlacement);
                    continue;
                }
                conflicts.add(confPlacement);
            }
        }
    }

    public boolean checkRoomSize(Placement placement, Collection<Placement> other, Placement extra) {
        int day = -1;
        TimeLocation t1 = placement.getTimeLocation();
        while ((day = t1.getWeekCode().nextSetBit(1 + day)) >= 0) {
            TimeLocation t2;
            int dow = (day + this.iDayOfWeekOffset) % 7;
            if ((t1.getDayCode() & Constants.DAY_CODES[dow]) == 0 || extra != null && (!(t2 = extra.getTimeLocation()).hasDay(day) || (t2.getDayCode() & Constants.DAY_CODES[dow]) == 0)) continue;
            for (int i = 0; i < t1.getLength(); ++i) {
                int slot = t1.getStartSlot() + i;
                int size = ((Lecture)placement.variable()).maxRoomUse();
                if (extra != null) {
                    TimeLocation t22 = extra.getTimeLocation();
                    if (t22.getStartSlot() > slot || slot >= t22.getStartSlot() + t22.getLength()) continue;
                    size += ((Lecture)extra.variable()).maxRoomUse();
                }
                if (other != null) {
                    for (Placement p : other) {
                        TimeLocation t23 = p.getTimeLocation();
                        if (!t23.hasDay(day) || (t23.getDayCode() & Constants.DAY_CODES[dow]) == 0 || t23.getStartSlot() > slot || slot >= t23.getStartSlot() + t23.getLength()) continue;
                        size += ((Lecture)p.variable()).maxRoomUse();
                    }
                }
                if (size <= this.getCapacity()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean checkRoomSize(Placement placement, Collection<Placement> other) {
        return this.checkRoomSize(placement, other, null);
    }

    @Override
    public boolean inConflict(Assignment<Lecture, Placement> assignment, Placement placement) {
        TimeLocation.IntEnumeration e;
        Object context;
        BitSet weekCode;
        HashSet<Placement> shared;
        Placement current;
        Lecture lecture;
        if (!this.getConstraint()) {
            return false;
        }
        if (!placement.hasRoomLocation(this.getResourceId())) {
            return false;
        }
        if (this.getParentRoom() != null && this.getParentRoom().getConstraint()) {
            lecture = (Lecture)placement.variable();
            current = assignment.getValue(lecture);
            shared = null;
            weekCode = placement.getTimeLocation().getWeekCode();
            context = (RoomConstraintContext)this.getParentRoom().getContext((Assignment)assignment);
            e = placement.getTimeLocation().getSlots();
            while (e.hasMoreElements()) {
                int slot = (Integer)e.nextElement();
                for (Placement confPlacement : ((RoomConstraintContext)context).getPlacements(slot)) {
                    if (!confPlacement.getTimeLocation().shareWeeks(weekCode) || confPlacement.equals(current) || shared != null && shared.contains(confPlacement)) continue;
                    if (confPlacement.canShareRooms(placement) && this.checkRoomSize(placement, (Collection<Placement>)shared, confPlacement)) {
                        if (shared == null) {
                            shared = new HashSet();
                        }
                        shared.add(confPlacement);
                        continue;
                    }
                    return true;
                }
            }
        }
        if (this.getPartitions() != null) {
            lecture = (Lecture)placement.variable();
            current = assignment.getValue(lecture);
            shared = null;
            weekCode = placement.getTimeLocation().getWeekCode();
            for (RoomConstraint partition : this.iPartitions) {
                if (!partition.getConstraint()) continue;
                RoomConstraintContext context2 = (RoomConstraintContext)partition.getContext((Assignment)assignment);
                TimeLocation.IntEnumeration e2 = placement.getTimeLocation().getSlots();
                while (e2.hasMoreElements()) {
                    int slot = (Integer)e2.nextElement();
                    for (Placement confPlacement : context2.getPlacements(slot)) {
                        if (!confPlacement.getTimeLocation().shareWeeks(weekCode) || confPlacement.equals(current) || shared != null && shared.contains(confPlacement)) continue;
                        if (confPlacement.canShareRooms(placement) && this.checkRoomSize(placement, shared, confPlacement)) {
                            if (shared == null) {
                                shared = new HashSet();
                            }
                            shared.add(confPlacement);
                            continue;
                        }
                        return true;
                    }
                }
            }
        }
        lecture = (Lecture)placement.variable();
        current = assignment.getValue(lecture);
        shared = null;
        weekCode = placement.getTimeLocation().getWeekCode();
        context = (RoomConstraintContext)this.getContext((Assignment)assignment);
        e = placement.getTimeLocation().getSlots();
        while (e.hasMoreElements()) {
            int slot = (Integer)e.nextElement();
            for (Placement confPlacement : ((RoomConstraintContext)context).getPlacements(slot)) {
                if (!confPlacement.getTimeLocation().shareWeeks(weekCode) || confPlacement.equals(current) || shared != null && shared.contains(confPlacement)) continue;
                if (confPlacement.canShareRooms(placement) && this.checkRoomSize(placement, (Collection<Placement>)shared, confPlacement)) {
                    if (shared == null) {
                        shared = new HashSet<Placement>();
                    }
                    shared.add(confPlacement);
                    continue;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isConsistent(Placement p1, Placement p2) {
        if (!this.getConstraint()) {
            return true;
        }
        if (this.getParentRoom() != null && (p1.hasRoomLocation(this.getResourceId()) && p2.hasRoomLocation(this.getParentRoom().getResourceId()) || p2.hasRoomLocation(this.getResourceId()) && p1.hasRoomLocation(this.getParentRoom().getResourceId())) && p1.getTimeLocation().hasIntersection(p2.getTimeLocation()) && (!p1.canShareRooms(p2) || ((Lecture)p1.variable()).maxRoomUse() + ((Lecture)p2.variable()).maxRoomUse() > this.getCapacity())) {
            return true;
        }
        if (!p1.hasRoomLocation(this.getResourceId())) {
            return false;
        }
        if (!p2.hasRoomLocation(this.getResourceId())) {
            return false;
        }
        return p1.getTimeLocation().hasIntersection(p2.getTimeLocation()) && (!p1.canShareRooms(p2) || ((Lecture)p1.variable()).maxRoomUse() + ((Lecture)p2.variable()).maxRoomUse() > this.getCapacity());
    }

    @Override
    public void assigned(Assignment<Lecture, Placement> assignment, long iteration, Placement placement) {
        if (placement.hasRoomLocation(this.getResourceId())) {
            super.assigned(assignment, iteration, placement);
        }
    }

    @Override
    public void unassigned(Assignment<Lecture, Placement> assignment, long iteration, Placement placement) {
        if (placement.hasRoomLocation(this.getResourceId())) {
            super.unassigned(assignment, iteration, placement);
        }
    }

    public List<Placement> getResource(Assignment<Lecture, Placement> assignment, int slot) {
        return ((RoomConstraintContext)this.getContext((Assignment)assignment)).getPlacements(slot);
    }

    public Placement[] getResourceOfWeek(Assignment<Lecture, Placement> assignment, int startDay) {
        return ((RoomConstraintContext)this.getContext((Assignment)assignment)).getResourceOfWeek(startDay);
    }

    public String toString() {
        return "Room " + this.getName();
    }

    public void setCoordinates(Double x, Double y) {
        this.iPosX = x;
        this.iPosY = y;
    }

    public Double getPosX() {
        return this.iPosX;
    }

    public Double getPosY() {
        return this.iPosY;
    }

    public boolean getIgnoreTooFar() {
        return this.iIgnoreTooFar;
    }

    public boolean getConstraint() {
        return this.iConstraint;
    }

    public Long getType() {
        return this.iType;
    }

    public void setType(Long type) {
        this.iType = type;
    }

    @Override
    public RoomConstraintContext createAssignmentContext(Assignment<Lecture, Placement> assignment) {
        return new RoomConstraintContext(assignment);
    }

    public class RoomConstraintContext
    implements AssignmentConstraintContext<Lecture, Placement> {
        private List<Placement>[] iResource = new List[288 * Constants.NR_DAYS];
        private int iLastUselessHalfHours = 0;
        private double iLastBrokenTimePatterns = 0.0;

        public RoomConstraintContext(Assignment<Lecture, Placement> assignment) {
            for (int i = 0; i < this.iResource.length; ++i) {
                this.iResource[i] = new ArrayList<Placement>(3);
            }
            for (Lecture lecture : RoomConstraint.this.variables()) {
                Placement placement = assignment.getValue(lecture);
                if (placement == null || !placement.hasRoomLocation(RoomConstraint.this.getResourceId())) continue;
                TimeLocation.IntEnumeration e = placement.getTimeLocation().getSlots();
                while (e.hasMoreElements()) {
                    int slot = (Integer)e.nextElement();
                    this.iResource[slot].add(placement);
                }
            }
            this.iLastUselessHalfHours = UselessHalfHours.countUselessSlotsHalfHours(this);
            RoomConstraint.this.getModel().getCriterion(UselessHalfHours.class).inc(assignment, this.iLastUselessHalfHours);
            this.iLastBrokenTimePatterns = (double)BrokenTimePatterns.countUselessSlotsBrokenTimePatterns(this) / 6.0;
            RoomConstraint.this.getModel().getCriterion(BrokenTimePatterns.class).inc(assignment, this.iLastBrokenTimePatterns);
        }

        @Override
        public void assigned(Assignment<Lecture, Placement> assignment, Placement placement) {
            if (!placement.hasRoomLocation(RoomConstraint.this.getResourceId())) {
                return;
            }
            TimeLocation.IntEnumeration e = placement.getTimeLocation().getSlots();
            while (e.hasMoreElements()) {
                int slot = (Integer)e.nextElement();
                this.iResource[slot].add(placement);
            }
            RoomConstraint.this.getModel().getCriterion(UselessHalfHours.class).inc(assignment, -this.iLastUselessHalfHours);
            this.iLastUselessHalfHours = UselessHalfHours.countUselessSlotsHalfHours(this);
            RoomConstraint.this.getModel().getCriterion(UselessHalfHours.class).inc(assignment, this.iLastUselessHalfHours);
            RoomConstraint.this.getModel().getCriterion(BrokenTimePatterns.class).inc(assignment, -this.iLastBrokenTimePatterns);
            this.iLastBrokenTimePatterns = (double)BrokenTimePatterns.countUselessSlotsBrokenTimePatterns(this) / 6.0;
            RoomConstraint.this.getModel().getCriterion(BrokenTimePatterns.class).inc(assignment, this.iLastBrokenTimePatterns);
        }

        @Override
        public void unassigned(Assignment<Lecture, Placement> assignment, Placement placement) {
            if (!placement.hasRoomLocation(RoomConstraint.this.getResourceId())) {
                return;
            }
            TimeLocation.IntEnumeration e = placement.getTimeLocation().getSlots();
            while (e.hasMoreElements()) {
                int slot = (Integer)e.nextElement();
                this.iResource[slot].remove(placement);
            }
            RoomConstraint.this.getModel().getCriterion(UselessHalfHours.class).inc(assignment, -this.iLastUselessHalfHours);
            this.iLastUselessHalfHours = UselessHalfHours.countUselessSlotsHalfHours(this);
            RoomConstraint.this.getModel().getCriterion(UselessHalfHours.class).inc(assignment, this.iLastUselessHalfHours);
            RoomConstraint.this.getModel().getCriterion(BrokenTimePatterns.class).inc(assignment, -this.iLastBrokenTimePatterns);
            this.iLastBrokenTimePatterns = (double)BrokenTimePatterns.countUselessSlotsBrokenTimePatterns(this) / 6.0;
            RoomConstraint.this.getModel().getCriterion(BrokenTimePatterns.class).inc(assignment, this.iLastBrokenTimePatterns);
        }

        public List<Placement> getPlacements(int slot) {
            return this.iResource[slot];
        }

        public Placement getPlacement(int slot, int day) {
            for (Placement p : this.iResource[slot]) {
                if (!p.getTimeLocation().hasDay(day)) continue;
                return p;
            }
            return null;
        }

        public Placement[] getResourceOfWeek(int startDay) {
            Placement[] ret = new Placement[this.iResource.length];
            for (int i = 0; i < this.iResource.length; ++i) {
                ret[i] = this.getPlacement(i, startDay + i / 288);
            }
            return ret;
        }

        public boolean inConflict(Lecture lecture, TimeLocation time) {
            TimeLocation.IntEnumeration e = time.getSlots();
            while (e.hasMoreElements()) {
                int slot = (Integer)e.nextElement();
                for (Placement confPlacement : this.getPlacements(slot)) {
                    if (!confPlacement.getTimeLocation().shareWeeks(time.getWeekCode()) || ((Lecture)confPlacement.variable()).equals(lecture) || ((Lecture)confPlacement.variable()).canShareRoom(lecture)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

