/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.component;

import biweekly.ICalVersion;
import biweekly.component.ICalComponent;
import biweekly.component.VAlarm;
import biweekly.io.DataModelConversionException;
import biweekly.io.scribe.component.ICalComponentScribe;
import biweekly.parameter.Related;
import biweekly.property.Action;
import biweekly.property.Attachment;
import biweekly.property.Attendee;
import biweekly.property.AudioAlarm;
import biweekly.property.DateEnd;
import biweekly.property.DateStart;
import biweekly.property.Description;
import biweekly.property.DisplayAlarm;
import biweekly.property.DurationProperty;
import biweekly.property.EmailAlarm;
import biweekly.property.ProcedureAlarm;
import biweekly.property.Repeat;
import biweekly.property.Trigger;
import biweekly.property.VCalAlarmProperty;
import biweekly.property.ValuedProperty;
import biweekly.util.Duration;
import biweekly.util.StringUtils;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class VAlarmScribe
extends ICalComponentScribe<VAlarm> {
    public VAlarmScribe() {
        super(VAlarm.class, "VALARM");
    }

    @Override
    protected VAlarm _newInstance() {
        return new VAlarm(null, null);
    }

    @Override
    public void checkForDataModelConversions(VAlarm component, ICalComponent parent, ICalVersion version) {
        if (version != ICalVersion.V1_0) {
            return;
        }
        VCalAlarmProperty vcalAlarm = VAlarmScribe.convert(component, parent);
        if (vcalAlarm == null) {
            return;
        }
        DataModelConversionException e = new DataModelConversionException(null);
        e.getProperties().add(vcalAlarm);
        throw e;
    }

    @Override
    public Set<ICalVersion> getSupportedVersions() {
        return EnumSet.of(ICalVersion.V2_0_DEPRECATED, ICalVersion.V2_0);
    }

    private static VCalAlarmProperty convert(VAlarm valarm, ICalComponent parent) {
        Repeat repeat;
        VCalAlarmProperty property = VAlarmScribe.create(valarm);
        if (property == null) {
            return null;
        }
        property.setStart(VAlarmScribe.determineStartDate(valarm, parent));
        DurationProperty duration = valarm.getDuration();
        if (duration != null) {
            property.setSnooze((Duration)duration.getValue());
        }
        if ((repeat = valarm.getRepeat()) != null) {
            property.setRepeat((Integer)repeat.getValue());
        }
        return property;
    }

    private static VCalAlarmProperty create(VAlarm valarm) {
        Action action = valarm.getAction();
        if (action == null) {
            return null;
        }
        if (action.isAudio()) {
            AudioAlarm aalarm = new AudioAlarm();
            List<Attachment> attaches = valarm.getAttachments();
            if (!attaches.isEmpty()) {
                String uri;
                Attachment attach = attaches.get(0);
                String formatType = attach.getFormatType();
                aalarm.setParameter("TYPE", formatType);
                byte[] data = attach.getData();
                if (data != null) {
                    aalarm.setData(data);
                }
                if ((uri = attach.getUri()) != null) {
                    String contentId = StringUtils.afterPrefixIgnoreCase(uri, "cid:");
                    if (contentId == null) {
                        aalarm.setUri(uri);
                    } else {
                        aalarm.setContentId(contentId);
                    }
                }
            }
            return aalarm;
        }
        if (action.isDisplay()) {
            Description description = valarm.getDescription();
            String text = ValuedProperty.getValue(description);
            return new DisplayAlarm(text);
        }
        if (action.isEmail()) {
            List<Attendee> attendees = valarm.getAttendees();
            String email = attendees.isEmpty() ? null : attendees.get(0).getEmail();
            EmailAlarm malarm = new EmailAlarm(email);
            Description description = valarm.getDescription();
            String note = ValuedProperty.getValue(description);
            malarm.setNote(note);
            return malarm;
        }
        if (action.isProcedure()) {
            Description description = valarm.getDescription();
            String path = ValuedProperty.getValue(description);
            return new ProcedureAlarm(path);
        }
        return null;
    }

    private static Date determineStartDate(VAlarm valarm, ICalComponent parent) {
        Trigger trigger = valarm.getTrigger();
        if (trigger == null) {
            return null;
        }
        Date triggerStart = trigger.getDate();
        if (triggerStart != null) {
            return triggerStart;
        }
        Duration triggerDuration = trigger.getDuration();
        if (triggerDuration == null) {
            return null;
        }
        if (parent == null) {
            return null;
        }
        Related related = trigger.getRelated();
        Date date = null;
        if (related == Related.START) {
            date = (Date)ValuedProperty.getValue(parent.getProperty(DateStart.class));
        } else if (related == Related.END && (date = (Date)ValuedProperty.getValue(parent.getProperty(DateEnd.class))) == null) {
            Date dateStart = (Date)ValuedProperty.getValue(parent.getProperty(DateStart.class));
            Duration duration = (Duration)ValuedProperty.getValue(parent.getProperty(DurationProperty.class));
            if (duration != null && dateStart != null) {
                date = duration.add(dateStart);
            }
        }
        return date == null ? null : triggerDuration.add(date);
    }
}

