/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.curricula.students;

import java.util.ArrayList;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.ValueSelection;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;
import org.unitime.timetable.solver.curricula.students.CurModel;
import org.unitime.timetable.solver.curricula.students.CurValue;
import org.unitime.timetable.solver.curricula.students.CurVariable;

public class CurValueSelection
implements ValueSelection<CurVariable, CurValue> {
    public CurValueSelection(DataProperties cfg) {
    }

    public void init(Solver<CurVariable, CurValue> solver) {
    }

    public CurValue selectValue(Solution<CurVariable, CurValue> solution, CurVariable selectedVariable) {
        return this.selectValueSlow(solution, selectedVariable);
    }

    public CurValue selectValueFast(Solution<CurVariable, CurValue> solution, CurVariable selectedVariable) {
        CurModel m = (CurModel)solution.getModel();
        Assignment assignment = solution.getAssignment();
        CurValue currentValue = (CurValue)assignment.getValue((Variable)selectedVariable);
        if (currentValue != null && currentValue.getStudent().getCourses((Assignment<CurVariable, CurValue>)assignment).size() <= m.getStudentLimit().getMinLimit()) {
            return null;
        }
        int size = selectedVariable.values(solution.getAssignment()).size();
        int i = ToolBox.random((int)size);
        for (int j = 0; j < size; ++j) {
            CurValue student = (CurValue)((Object)selectedVariable.values(solution.getAssignment()).get((i + j) % size));
            if (student.equals((Object)currentValue) || selectedVariable.getCourse().getStudents((Assignment<CurVariable, CurValue>)assignment).contains((Object)student.getStudent()) || student.getStudent().getCourses((Assignment<CurVariable, CurValue>)assignment).size() >= m.getStudentLimit().getMaxLimit()) continue;
            if (selectedVariable.getCourse().getSize((Assignment<CurVariable, CurValue>)assignment) + student.getStudent().getWeight() - (currentValue == null ? 0.0 : currentValue.getStudent().getWeight()) > selectedVariable.getCourse().getMaxSize() || currentValue != null && selectedVariable.getCourse().getSize((Assignment<CurVariable, CurValue>)assignment) + student.getStudent().getWeight() - currentValue.getStudent().getWeight() < selectedVariable.getCourse().getMaxSize() - m.getMinStudentWidth()) continue;
            return student;
        }
        return null;
    }

    public CurValue selectValueSlow(Solution<CurVariable, CurValue> solution, CurVariable selectedVariable) {
        CurModel m = (CurModel)solution.getModel();
        Assignment assignment = solution.getAssignment();
        CurValue currentValue = (CurValue)assignment.getValue((Variable)selectedVariable);
        if (currentValue != null && currentValue.getStudent().getCourses((Assignment<CurVariable, CurValue>)assignment).size() <= m.getStudentLimit().getMinLimit()) {
            return null;
        }
        ArrayList<CurValue> bestStudents = new ArrayList<CurValue>();
        ArrayList<CurValue> allImprovingStudents = new ArrayList<CurValue>();
        ArrayList<CurValue> allStudents = new ArrayList<CurValue>();
        double bestValue = 0.0;
        for (CurValue student : selectedVariable.values(solution.getAssignment())) {
            if (student.equals((Object)currentValue) || selectedVariable.getCourse().getStudents((Assignment<CurVariable, CurValue>)assignment).contains((Object)student.getStudent()) || student.getStudent().getCourses((Assignment<CurVariable, CurValue>)assignment).size() >= m.getStudentLimit().getMaxLimit()) continue;
            double value = student.toDouble((Assignment<CurVariable, CurValue>)assignment);
            Set conflicts = m.conflictValues(assignment, student);
            for (CurValue conf : conflicts) {
                value -= conf.toDouble((Assignment<CurVariable, CurValue>)assignment);
            }
            if (bestStudents.isEmpty() || bestValue > value) {
                bestValue = value;
                bestStudents.clear();
                bestStudents.add(student);
            } else if (bestValue == value) {
                bestStudents.add(student);
            }
            if (value != 0.0) {
                allImprovingStudents.add(student);
            }
            allStudents.add(student);
        }
        if (currentValue != null) {
            double rnd = ToolBox.random();
            if (rnd < 0.01) {
                return (CurValue)((Object)ToolBox.random(allStudents));
            }
            if (rnd < 0.1) {
                return (CurValue)((Object)ToolBox.random(allImprovingStudents));
            }
        }
        return (CurValue)((Object)ToolBox.random(bestStudents));
    }
}

