/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.cpsolver.studentsct.reservation.CourseRestriction;
import org.cpsolver.studentsct.reservation.Restriction;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XRestriction;
import org.unitime.timetable.onlinesectioning.model.XRestrictionType;
import org.unitime.timetable.onlinesectioning.model.XStudent;

@SerializeWith(value=XCourseRestrictionSerializer.class)
public class XCourseRestriction
extends XRestriction {
    private static final long serialVersionUID = 1L;
    private XCourseId iCourseId;
    private int iLimit = -1;

    public XCourseRestriction() {
    }

    public XCourseRestriction(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XCourseRestriction(CourseRestriction reservation) {
        super(XRestrictionType.Course, (Restriction)reservation);
        this.iCourseId = new XCourseId(reservation.getCourse());
        this.iLimit = reservation.getCourse().getLimit();
    }

    public Long getCourseId() {
        return this.iCourseId.getCourseId();
    }

    @Override
    public Long getOfferingId() {
        return this.iCourseId.getOfferingId();
    }

    @Override
    public boolean isApplicable(XStudent student, XCourseId course) {
        if (course != null) {
            return this.iCourseId.equals(course);
        }
        for (XRequest request : student.getRequests()) {
            if (!(request instanceof XCourseRequest) || !((XCourseRequest)request).getCourseIds().contains(this.iCourseId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.iCourseId = new XCourseId(in);
        this.iLimit = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        this.iCourseId.writeExternal(out);
        out.writeInt(this.iLimit);
    }

    public static class XCourseRestrictionSerializer
    implements Externalizer<XCourseRestriction> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, XCourseRestriction object) throws IOException {
            object.writeExternal(output);
        }

        public XCourseRestriction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new XCourseRestriction(input);
        }
    }
}

