/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.timetable.model.ClassDurationType;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.ItypeDesc;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseInstrOfferingConfig;
import org.unitime.timetable.model.comparators.InstrOfferingConfigComparator;
import org.unitime.timetable.model.comparators.NavigationComparator;
import org.unitime.timetable.model.dao.InstrOfferingConfigDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.util.duration.DurationModel;
import org.unitime.timetable.util.duration.MinutesPerWeek;

public class InstrOfferingConfig
extends BaseInstrOfferingConfig {
    private static final long serialVersionUID = 1L;

    public InstrOfferingConfig() {
    }

    public InstrOfferingConfig(Long uniqueId) {
        super(uniqueId);
    }

    public Department getDepartment() {
        return this.getInstructionalOffering().getDepartment();
    }

    public Session getSession() {
        return this.getInstructionalOffering().getSession();
    }

    public Long getSessionId() {
        return this.getInstructionalOffering().getSessionId();
    }

    public String getCourseName() {
        return this.getControllingCourseOffering().getCourseName();
    }

    public String getCourseNameWithTitle() {
        return this.getControllingCourseOffering().getCourseNameWithTitle();
    }

    public CourseOffering getControllingCourseOffering() {
        return this.getInstructionalOffering().getControllingCourseOffering();
    }

    public boolean hasClasses() {
        Set<SchedulingSubpart> subparts = this.getSchedulingSubparts();
        if (subparts != null && !subparts.isEmpty()) {
            for (SchedulingSubpart ss : subparts) {
                if (ss.getClasses() == null || ss.getClasses().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public int getFirstSectionNumber(ItypeDesc itype) {
        if (this.getInstructionalOffering().getInstrOfferingConfigs().size() <= 1) {
            return 1;
        }
        InstrOfferingConfigComparator cmp = new InstrOfferingConfigComparator(null);
        int ret = 1;
        for (InstrOfferingConfig cfg : this.getInstructionalOffering().getInstrOfferingConfigs()) {
            int size = 0;
            if (cmp.compare(cfg, this) >= 0) continue;
            for (SchedulingSubpart subpart : cfg.getSchedulingSubparts()) {
                if (!subpart.getItype().equals(itype)) continue;
                size = Math.max(size, subpart.getClasses().size());
            }
            ret += size;
        }
        return ret;
    }

    @Override
    public void addToschedulingSubparts(SchedulingSubpart schedulingSubpart) {
        if (null == this.getSchedulingSubparts()) {
            this.setSchedulingSubparts(new HashSet<SchedulingSubpart>());
        }
        this.getSchedulingSubparts().add(schedulingSubpart);
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (name != null && name.length() > 0) {
            return name;
        }
        if (this.getInstructionalOffering() == null) {
            return null;
        }
        if (this.getUniqueId() == null) {
            return String.valueOf(this.getInstructionalOffering().getInstrOfferingConfigs().size() + 1);
        }
        int idx = 0;
        for (InstrOfferingConfig c : this.getInstructionalOffering().getInstrOfferingConfigs()) {
            if (c.getUniqueId().compareTo(this.getUniqueId()) >= 0) continue;
            ++idx;
        }
        return String.valueOf(idx + 1);
    }

    public static String getGeneratedName(InstructionalOffering io) {
        if (io == null) {
            return null;
        }
        int idx = 1;
        HashMap<String, String> idxes = new HashMap<String, String>();
        for (InstrOfferingConfig c : io.getInstrOfferingConfigs()) {
            idxes.put(c.getName(), c.getName());
        }
        while (idxes.get("" + idx) != null) {
            ++idx;
        }
        return "" + idx;
    }

    public InstrOfferingConfig getNextInstrOfferingConfig(SessionContext context) {
        return this.getNextInstrOfferingConfig(context, new NavigationComparator());
    }

    public InstrOfferingConfig getPreviousInstrOfferingConfig(SessionContext context) {
        return this.getPreviousInstrOfferingConfig(context, new NavigationComparator());
    }

    public InstrOfferingConfig getNextInstrOfferingConfig(SessionContext context, Comparator cmp) {
        InstrOfferingConfig next = null;
        for (InstrOfferingConfig c : this.getInstructionalOffering().getInstrOfferingConfigs()) {
            if (cmp.compare(this, c) >= 0 || next != null && cmp.compare(next, c) <= 0) continue;
            next = c;
        }
        if (next != null) {
            return next;
        }
        InstructionalOffering nextIO = this.getInstructionalOffering().getNextInstructionalOffering(context, cmp);
        if (nextIO == null) {
            return null;
        }
        for (InstrOfferingConfig c : nextIO.getInstrOfferingConfigs()) {
            if (next != null && cmp.compare(next, c) <= 0) continue;
            next = c;
        }
        return next;
    }

    public InstrOfferingConfig getPreviousInstrOfferingConfig(SessionContext context, Comparator cmp) {
        InstrOfferingConfig previous = null;
        for (InstrOfferingConfig c : this.getInstructionalOffering().getInstrOfferingConfigs()) {
            if (cmp.compare(this, c) <= 0 || previous != null && cmp.compare(previous, c) >= 0) continue;
            previous = c;
        }
        if (previous != null) {
            return previous;
        }
        InstructionalOffering previousIO = this.getInstructionalOffering().getPreviousInstructionalOffering(context, cmp);
        if (previousIO == null) {
            return null;
        }
        for (InstrOfferingConfig c : previousIO.getInstrOfferingConfigs()) {
            if (previous != null && cmp.compare(previous, c) >= 0) continue;
            previous = c;
        }
        return previous;
    }

    @Override
    public String toString() {
        return this.getCourseName() + " [" + this.getName() + "]";
    }

    public boolean hasGroupedClasses() {
        if (this.getSchedulingSubparts() != null && this.getSchedulingSubparts().size() > 0) {
            SchedulingSubpart ss2 = null;
            for (SchedulingSubpart ss2 : this.getSchedulingSubparts()) {
                if (ss2.getParentSubpart() == null) continue;
                if (!ss2.getParentSubpart().getItype().getItype().equals(ss2.getItype().getItype())) {
                    return true;
                }
                Class_ c2 = null;
                for (Class_ c2 : ss2.getParentSubpart().getClasses()) {
                    if (!c2.isOddOrEvenWeeksOnly()) continue;
                    return true;
                }
                for (Class_ c2 : ss2.getClasses()) {
                    if (!c2.isOddOrEvenWeeksOnly()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Object clone() {
        InstrOfferingConfig newInstrOffrConfig = new InstrOfferingConfig();
        newInstrOffrConfig.setLimit(this.getLimit());
        newInstrOffrConfig.setName(this.getName());
        newInstrOffrConfig.setUnlimitedEnrollment(this.isUnlimitedEnrollment());
        newInstrOffrConfig.setClassDurationType(this.getClassDurationType());
        newInstrOffrConfig.setInstructionalMethod(this.getInstructionalMethod());
        return newInstrOffrConfig;
    }

    private void setSubpartConfig(SchedulingSubpart schedulingSubpart, InstrOfferingConfig instrOffrConfig) {
        schedulingSubpart.setInstrOfferingConfig(instrOffrConfig);
        instrOffrConfig.addToschedulingSubparts(schedulingSubpart);
        if (schedulingSubpart.getChildSubparts() != null) {
            SchedulingSubpart childSubpart2 = null;
            for (SchedulingSubpart childSubpart2 : schedulingSubpart.getChildSubparts()) {
                this.setSubpartConfig(childSubpart2, instrOffrConfig);
            }
        }
    }

    public Object cloneWithSubparts() {
        InstrOfferingConfig newInstrOffrConfig = (InstrOfferingConfig)this.clone();
        if (this.getSchedulingSubparts() != null) {
            SchedulingSubpart origSubpart2 = null;
            SchedulingSubpart newSubpart = null;
            for (SchedulingSubpart origSubpart2 : this.getSchedulingSubparts()) {
                if (origSubpart2.getParentSubpart() != null) continue;
                newSubpart = (SchedulingSubpart)origSubpart2.cloneDeep();
                this.setSubpartConfig(newSubpart, newInstrOffrConfig);
            }
        }
        return newInstrOffrConfig;
    }

    public static InstrOfferingConfig findByIdRolledForwardFrom(Long sessionId, Long uniqueIdRolledForwardFrom) {
        return (InstrOfferingConfig)new InstrOfferingConfigDAO().getSession().createQuery("select ioc from InstrOfferingConfig ioc where ioc.instructionalOffering.session.uniqueId=:sessionId and ioc.uniqueIdRolledForwardFrom=:uniqueIdRolledForwardFrom").setLong("sessionId", sessionId.longValue()).setLong("uniqueIdRolledForwardFrom", uniqueIdRolledForwardFrom.longValue()).setCacheable(true).uniqueResult();
    }

    public ClassDurationType getEffectiveDurationType() {
        if (this.getClassDurationType() != null) {
            return this.getClassDurationType();
        }
        return this.getSession().getDefaultClassDurationType();
    }

    public DurationModel getDurationModel() {
        ClassDurationType type = this.getEffectiveDurationType();
        if (type == null) {
            return new MinutesPerWeek(null);
        }
        return type.getModel();
    }

    public int getEnrollment() {
        int enrollment = 0;
        Iterator<SchedulingSubpart> iterator = this.getSchedulingSubparts().iterator();
        if (iterator.hasNext()) {
            SchedulingSubpart subpart = iterator.next();
            for (Class_ clazz : subpart.getClasses()) {
                enrollment += clazz.getEnrollment().intValue();
            }
        }
        return enrollment;
    }

    public InstructionalMethod getEffectiveInstructionalMethod() {
        if (this.getInstructionalMethod() != null) {
            return this.getInstructionalMethod();
        }
        return this.getSession().getDefaultInstructionalMethod();
    }

    public Integer getSnapShotLimit() {
        Integer snapShotLimit = null;
        for (SchedulingSubpart subpart : this.getSchedulingSubparts()) {
            int subpartLimit = 0;
            for (Class_ c : subpart.getClasses()) {
                if (c.isCancelled().booleanValue()) continue;
                if (c.getSnapshotLimit() != null) {
                    subpartLimit += c.getSnapshotLimit().intValue();
                    continue;
                }
                if (c.getExpectedCapacity() == null || !c.isEnabledForStudentScheduling().booleanValue()) continue;
                subpartLimit += c.getExpectedCapacity().intValue();
            }
            if (snapShotLimit != null && snapShotLimit <= subpartLimit) continue;
            snapShotLimit = subpartLimit;
        }
        return snapShotLimit;
    }

    public TreeSet<Department> findPossibleFundingDepts(org.hibernate.Session hibSession) {
        TreeSet<Department> deptSet = new TreeSet<Department>();
        String query = "from Department d where d.externalFundingDept = true and d.session.uniqueId = :sessId";
        deptSet.addAll(hibSession.createQuery(query).setLong("sessId", this.getSessionId().longValue()).setCacheable(true).list());
        for (CourseOffering co : this.getInstructionalOffering().getCourseOfferings()) {
            deptSet.add(co.getDepartment());
            deptSet.add(co.getEffectiveFundingDept());
        }
        deptSet.add(this.getInstructionalOffering().getDepartment());
        deptSet.add(this.getInstructionalOffering().getEffectiveFundingDept());
        return deptSet;
    }
}

