/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.Date;
import java.util.Properties;
import org.dom4j.CDATA;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.dom.DOMCDATA;
import org.unitime.timetable.dataexchange.BaseExport;
import org.unitime.timetable.model.SavedHQL;
import org.unitime.timetable.model.SavedHQLParameter;
import org.unitime.timetable.model.Session;

public class HQLExport
extends BaseExport {
    @Override
    public void saveXml(Document document, Session session, Properties parameters) throws Exception {
        try {
            this.beginTransaction();
            document.addDocType("reports", "-//UniTime//UniTime HQL Reports DTD/EN", "http://www.unitime.org/interface/Reports.dtd");
            Element root = document.addElement("reports");
            root.addAttribute("created", new Date().toString());
            for (SavedHQL report : this.getHibSession().createQuery("from SavedHQL order by name").list()) {
                HQLExport.exportReport(root, report);
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
        }
    }

    public static Element exportReport(Element parent, SavedHQL report) {
        Element reportEl = parent.addElement("report");
        reportEl.addAttribute("name", report.getName());
        for (SavedHQL.Flag flag : SavedHQL.Flag.values()) {
            if (!report.isSet(flag)) continue;
            reportEl.addElement("flag").setText(flag.name());
        }
        if (report.getDescription() != null) {
            reportEl.addElement("description").add((CDATA)new DOMCDATA(report.getDescription()));
        }
        if (report.getQuery() != null) {
            reportEl.addElement("query").add((CDATA)new DOMCDATA(report.getQuery()));
        }
        for (SavedHQLParameter parameter : report.getParameters()) {
            Element paramEl = reportEl.addElement("parameter");
            paramEl.addAttribute("name", parameter.getName());
            if (parameter.getLabel() != null) {
                paramEl.addAttribute("label", parameter.getLabel());
            }
            paramEl.addAttribute("type", parameter.getType());
            if (parameter.getDefaultValue() == null) continue;
            paramEl.addAttribute("default", parameter.getDefaultValue());
        }
        return reportEl;
    }
}

