/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.InstructorAction;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.InstructorEditForm;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.security.rights.Right;

@Action(value="instructorAdd", results={@Result(name={"showAdd"}, type="tiles", location="instructorAdd.tiles")})
@TilesDefinition(name="instructorAdd.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Add Instructor"), @TilesPutAttribute(name="body", value="/user/instructorAdd.jsp")})
public class InstructorAddAction
extends InstructorAction {
    private static final long serialVersionUID = 3203081761214701242L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);

    @Override
    public String execute() throws Exception {
        super.execute();
        ((InstructorEditForm)this.form).setMatchFound(null);
        if (MSG.actionBackToInstructors().equals(this.op)) {
            this.response.sendRedirect(this.response.encodeURL("instructorSearch.action"));
            return null;
        }
        if (this.sessionContext.getAttribute(SessionAttribute.DepartmentId) != null) {
            String deptId = (String)this.sessionContext.getAttribute(SessionAttribute.DepartmentId);
            Department d = (Department)new DepartmentDAO().get(Long.valueOf(deptId));
            ((InstructorEditForm)this.form).setDeptName(d.getName().trim());
            ((InstructorEditForm)this.form).setDeptCode(d.getDeptCode());
        }
        this.sessionContext.checkPermission((Serializable)((Object)((InstructorEditForm)this.form).getDeptCode()), "Department", Right.InstructorAdd);
        if (MSG.actionSaveInstructor().equals(this.op)) {
            ((InstructorEditForm)this.form).validate(this);
            if (!this.hasFieldErrors() && this.isDeptInstructorUnique()) {
                this.doUpdate();
                this.response.sendRedirect(this.response.encodeURL("instructorSearch.action"));
                return null;
            }
            if (!this.hasFieldErrors()) {
                this.addFieldError("uniqueId", MSG.errorInstructorIdAlreadyExistsInList());
            }
            return "showAdd";
        }
        if (MSG.actionLookupInstructor().equals(this.op)) {
            ((InstructorEditForm)this.form).validate(this);
            if (!this.hasFieldErrors()) {
                this.findMatchingInstructor();
                if (((InstructorEditForm)this.form).getMatchFound() == null || !((InstructorEditForm)this.form).getMatchFound().booleanValue()) {
                    this.addFieldError("lookup", MSG.errorNoMatchingRecordsFound());
                }
            }
            return "showAdd";
        }
        if (MSG.actionSelectInstructor().equals(this.op)) {
            String select = ((InstructorEditForm)this.form).getSearchSelect();
            if (select != null && select.trim().length() > 0) {
                if (select.equalsIgnoreCase("i2a2")) {
                    this.fillI2A2Info();
                } else {
                    this.fillStaffInfo();
                }
            } else {
                this.addFieldError("lookup", MSG.errorNoInstructorSelectedFromList());
            }
            return "showAdd";
        }
        return "showAdd";
    }
}

