/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesDefinitions;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.springframework.web.util.HtmlUtils;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.ApplicationConfigForm;
import org.unitime.timetable.model.ApplicationConfig;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SessionConfig;
import org.unitime.timetable.model.base.BaseApplicationConfig;
import org.unitime.timetable.model.base.BaseSessionConfig;
import org.unitime.timetable.model.dao.ApplicationConfigDAO;
import org.unitime.timetable.model.dao.SessionConfigDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.rights.Right;

@Action(value="applicationConfig", results={@Result(name={"list"}, type="tiles", location="applicationConfigList.tiles"), @Result(name={"add"}, type="tiles", location="applicationConfigAdd.tiles"), @Result(name={"edit"}, type="tiles", location="applicationConfigEdit.tiles")})
@TilesDefinitions(value={@TilesDefinition(name="applicationConfigList.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Application Configuration"), @TilesPutAttribute(name="body", value="/admin/applicationConfig.jsp")}), @TilesDefinition(name="applicationConfigAdd.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Add Application Setting"), @TilesPutAttribute(name="body", value="/admin/applicationConfig.jsp")}), @TilesDefinition(name="applicationConfigEdit.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Edit Application Setting"), @TilesPutAttribute(name="body", value="/admin/applicationConfig.jsp")})})
public class ApplicationConfigAction
extends UniTimeAction<ApplicationConfigForm> {
    private static final long serialVersionUID = -980973696522046141L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private String apply;
    private String id;

    public String getApply() {
        return this.apply;
    }

    public void setApply(String apply) {
        this.apply = apply;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String execute() throws Exception {
        String oldValue;
        org.hibernate.Session hibSession;
        this.sessionContext.checkPermission(Right.ApplicationConfig);
        if (this.form == null) {
            this.form = new ApplicationConfigForm();
        }
        if (this.op == null) {
            this.op = ((ApplicationConfigForm)this.form).getOp();
        }
        if (this.op == null) {
            ((ApplicationConfigForm)this.form).reset();
            this.op = ((ApplicationConfigForm)this.form).getOp();
        }
        if ("1".equals(this.apply)) {
            this.sessionContext.getUser().setProperty("ApplicationConfig.showAll", ((ApplicationConfigForm)this.form).getShowAll() ? "1" : "0");
        }
        if (this.op.equals("edit")) {
            ((ApplicationConfigForm)this.form).setOp("edit");
            this.sessionContext.checkPermission(Right.ApplicationConfigEdit);
            if (this.id == null || this.id.trim().isEmpty()) {
                this.addFieldError("form.key", MSG.errorRequiredField(MSG.columnAppConfigKey()));
            } else {
                SessionConfig sessionConfig = SessionConfig.getConfig(this.id, this.sessionContext.getUser().getCurrentAcademicSessionId());
                if (sessionConfig == null) {
                    ApplicationConfig appConfig = (ApplicationConfig)ApplicationConfigDAO.getInstance().get(this.id);
                    if (appConfig == null) {
                        ApplicationProperty p = ApplicationProperty.fromKey(this.id);
                        if (p != null) {
                            ((ApplicationConfigForm)this.form).setOp("add");
                            ((ApplicationConfigForm)this.form).setKey(this.id);
                            ((ApplicationConfigForm)this.form).setValue(ApplicationProperties.getProperty(this.id, ""));
                            ((ApplicationConfigForm)this.form).setDescription(p.description());
                            ((ApplicationConfigForm)this.form).setAllSessions(true);
                        } else {
                            this.addFieldError("form.key", MSG.errorDoesNotExists(this.id));
                        }
                    } else {
                        ((ApplicationConfigForm)this.form).setKey(appConfig.getKey());
                        ((ApplicationConfigForm)this.form).setValue(appConfig.getValue());
                        ((ApplicationConfigForm)this.form).setDescription(appConfig.getDescription());
                        if (((ApplicationConfigForm)this.form).getDescription() == null || ((ApplicationConfigForm)this.form).getDescription().isEmpty()) {
                            ((ApplicationConfigForm)this.form).setDescription(ApplicationProperty.getDescription(((ApplicationConfigForm)this.form).getKey()));
                        }
                        ((ApplicationConfigForm)this.form).setAllSessions(true);
                    }
                } else {
                    ApplicationConfig appConfig;
                    ((ApplicationConfigForm)this.form).setKey(sessionConfig.getKey());
                    ((ApplicationConfigForm)this.form).setValue(sessionConfig.getValue());
                    ((ApplicationConfigForm)this.form).setDescription(sessionConfig.getDescription());
                    if (((ApplicationConfigForm)this.form).getDescription() == null || ((ApplicationConfigForm)this.form).getDescription().isEmpty()) {
                        ((ApplicationConfigForm)this.form).setDescription(ApplicationProperty.getDescription(((ApplicationConfigForm)this.form).getKey()));
                    }
                    ((ApplicationConfigForm)this.form).setAllSessions(false);
                    List sessionIds = SessionConfigDAO.getInstance().getSession().createQuery("select session.uniqueId from SessionConfig where key = :key and value = :value").setString("key", this.id).setString("value", sessionConfig.getValue()).list();
                    Long[] sessionIdsArry = new Long[sessionIds.size()];
                    for (int i = 0; i < sessionIds.size(); ++i) {
                        sessionIdsArry[i] = (Long)sessionIds.get(i);
                    }
                    ((ApplicationConfigForm)this.form).setSessions(sessionIdsArry);
                    if ((sessionConfig.getDescription() == null || sessionConfig.getDescription().isEmpty()) && (appConfig = (ApplicationConfig)ApplicationConfigDAO.getInstance().get(this.id)) != null) {
                        ((ApplicationConfigForm)this.form).setDescription(appConfig.getDescription());
                    }
                }
            }
        }
        if (this.op.equals(MSG.actionAddSetting())) {
            this.sessionContext.checkPermission(Right.ApplicationConfigEdit);
            ((ApplicationConfigForm)this.form).reset();
            ((ApplicationConfigForm)this.form).setAllSessions(true);
            if (this.sessionContext.getUser().getCurrentAcademicSessionId() != null) {
                ((ApplicationConfigForm)this.form).setSessions(new Long[]{this.sessionContext.getUser().getCurrentAcademicSessionId()});
            }
            ((ApplicationConfigForm)this.form).setOp("add");
        }
        if (this.op.equals(MSG.actionSaveSetting()) || this.op.equals(MSG.actionUpdateSetting())) {
            this.sessionContext.checkPermission(Right.ApplicationConfigEdit);
            ((ApplicationConfigForm)this.form).validate(this);
            if (!this.hasFieldErrors()) {
                try {
                    Serializable config;
                    hibSession = SessionConfigDAO.getInstance().getSession();
                    boolean update = this.op.equals(MSG.actionUpdateSetting());
                    oldValue = null;
                    boolean wasSession = false;
                    SessionConfig sessionConfig = SessionConfig.getConfig(((ApplicationConfigForm)this.form).getKey(), this.sessionContext.getUser().getCurrentAcademicSessionId());
                    if (sessionConfig == null) {
                        ApplicationConfig appConfig = (ApplicationConfig)ApplicationConfigDAO.getInstance().get(((ApplicationConfigForm)this.form).getKey());
                        if (appConfig != null) {
                            oldValue = appConfig.getValue();
                        }
                    } else {
                        oldValue = sessionConfig.getValue();
                        wasSession = true;
                    }
                    if (((ApplicationConfigForm)this.form).isAllSessions()) {
                        if (wasSession) {
                            if (update) {
                                for (SessionConfig config2 : hibSession.createQuery("from SessionConfig where key = :key and value = :value").setString("key", ((ApplicationConfigForm)this.form).getKey()).setString("value", oldValue).list()) {
                                    this.getSolverServerService().setApplicationProperty(config2.getSession().getUniqueId(), ((ApplicationConfigForm)this.form).getKey(), null);
                                    hibSession.delete((Object)config2);
                                }
                            } else {
                                config = SessionConfig.getConfig(((ApplicationConfigForm)this.form).getKey(), this.sessionContext.getUser().getCurrentAcademicSessionId());
                                if (config != null) {
                                    this.getSolverServerService().setApplicationProperty(((BaseSessionConfig)config).getSession().getUniqueId(), ((ApplicationConfigForm)this.form).getKey(), null);
                                    hibSession.delete((Object)config);
                                }
                            }
                        }
                        if ((config = (ApplicationConfig)ApplicationConfigDAO.getInstance().get(((ApplicationConfigForm)this.form).getKey())) == null) {
                            config = new ApplicationConfig();
                            ((BaseApplicationConfig)config).setKey(((ApplicationConfigForm)this.form).getKey());
                        }
                        ((BaseApplicationConfig)config).setValue(((ApplicationConfigForm)this.form).getValue());
                        ((BaseApplicationConfig)config).setDescription(((ApplicationConfigForm)this.form).getDescription());
                        this.getSolverServerService().setApplicationProperty(null, ((ApplicationConfigForm)this.form).getKey(), ((ApplicationConfigForm)this.form).getValue());
                        hibSession.saveOrUpdate((Object)config);
                    } else {
                        if (update && !wasSession && (config = (ApplicationConfig)ApplicationConfigDAO.getInstance().get(((ApplicationConfigForm)this.form).getKey())) != null) {
                            this.getSolverServerService().setApplicationProperty(null, ((ApplicationConfigForm)this.form).getKey(), null);
                            hibSession.delete((Object)config);
                        }
                        HashSet<Long> updatedSessionIds = new HashSet<Long>();
                        for (Long sessionId : ((ApplicationConfigForm)this.form).getSessions()) {
                            SessionConfig config3 = (SessionConfig)hibSession.createQuery("from SessionConfig where key = :key and session.uniqueId = :sessionId").setLong("sessionId", sessionId.longValue()).setString("key", ((ApplicationConfigForm)this.form).getKey()).uniqueResult();
                            if (config3 == null) {
                                config3 = new SessionConfig();
                                config3.setKey(((ApplicationConfigForm)this.form).getKey());
                                config3.setSession((Session)SessionDAO.getInstance().get(sessionId, hibSession));
                            }
                            config3.setValue(((ApplicationConfigForm)this.form).getValue());
                            config3.setDescription(((ApplicationConfigForm)this.form).getDescription());
                            this.getSolverServerService().setApplicationProperty(sessionId, ((ApplicationConfigForm)this.form).getKey(), ((ApplicationConfigForm)this.form).getValue());
                            hibSession.saveOrUpdate((Object)config3);
                            updatedSessionIds.add(sessionId);
                        }
                        if (update && oldValue != null) {
                            for (SessionConfig other : hibSession.createQuery("from SessionConfig where key = :key and value = :value").setString("key", ((ApplicationConfigForm)this.form).getKey()).setString("value", oldValue).list()) {
                                if (updatedSessionIds.contains(other.getSession().getUniqueId())) continue;
                                this.getSolverServerService().setApplicationProperty(other.getSession().getUniqueId(), ((ApplicationConfigForm)this.form).getKey(), null);
                                hibSession.delete((Object)other);
                            }
                        }
                    }
                    hibSession.flush();
                    this.request.setAttribute("hash", (Object)((ApplicationConfigForm)this.form).getKey());
                    ((ApplicationConfigForm)this.form).reset();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.addFieldError("form.key", e.getMessage());
                }
            }
        }
        if (this.op.equals(MSG.actionDeleteSetting())) {
            this.sessionContext.checkPermission(Right.ApplicationConfigEdit);
            ((ApplicationConfigForm)this.form).validate(this);
            if (!this.hasFieldErrors()) {
                try {
                    hibSession = SessionConfigDAO.getInstance().getSession();
                    BaseSessionConfig sessionConfig = null;
                    if (this.sessionContext.getUser().getCurrentAcademicSessionId() != null) {
                        sessionConfig = (SessionConfig)hibSession.createQuery("from SessionConfig where key = :key and session.uniqueId = :sessionId").setLong("sessionId", this.sessionContext.getUser().getCurrentAcademicSessionId().longValue()).setString("key", ((ApplicationConfigForm)this.form).getKey()).uniqueResult();
                    }
                    if (sessionConfig == null) {
                        ApplicationConfig appConfig = (ApplicationConfig)ApplicationConfigDAO.getInstance().get(((ApplicationConfigForm)this.form).getKey());
                        if (appConfig != null) {
                            hibSession.delete((Object)appConfig);
                            this.getSolverServerService().setApplicationProperty(null, ((ApplicationConfigForm)this.form).getKey(), null);
                        }
                    } else {
                        oldValue = sessionConfig.getValue();
                        hibSession.delete((Object)sessionConfig);
                        this.getSolverServerService().setApplicationProperty(this.sessionContext.getUser().getCurrentAcademicSessionId(), ((ApplicationConfigForm)this.form).getKey(), null);
                        for (SessionConfig other : hibSession.createQuery("from SessionConfig where key = :key and value = :value").setString("key", ((ApplicationConfigForm)this.form).getKey()).setString("value", oldValue).list()) {
                            this.getSolverServerService().setApplicationProperty(other.getSession().getUniqueId(), ((ApplicationConfigForm)this.form).getKey(), null);
                            hibSession.delete((Object)other);
                        }
                    }
                    hibSession.flush();
                    this.request.setAttribute("hash", (Object)((ApplicationConfigForm)this.form).getKey());
                    ((ApplicationConfigForm)this.form).reset();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.addFieldError("form.key", e.getMessage());
                }
            }
        }
        if (this.op.equals(MSG.actionCancelSetting())) {
            this.request.setAttribute("hash", (Object)((ApplicationConfigForm)this.form).getKey());
            ((ApplicationConfigForm)this.form).reset();
        }
        ((ApplicationConfigForm)this.form).setShowAll("1".equals(this.sessionContext.getUser().getProperty("ApplicationConfig.showAll", "0")));
        if ("list".equals(((ApplicationConfigForm)this.form).getOp())) {
            this.getApplicationConfigList(((ApplicationConfigForm)this.form).getShowAll());
            return "list";
        }
        return MSG.actionSaveSetting().equals(this.op) || "add".equals(((ApplicationConfigForm)this.form).getOp()) ? "add" : "edit";
    }

    private void getApplicationConfigList(boolean showAll) throws Exception {
        WebTable.setOrder(this.sessionContext, "applicationConfig.ord", this.request.getParameter("ord"), 1);
        WebTable webTable = new WebTable(4, null, "applicationConfig.action?ord=%%", new String[]{MSG.columnAppConfigKey(), MSG.columnAppConfigValue(), MSG.columnAppConfigDescription()}, new String[]{"left", "left", "left"}, null);
        webTable.enableHR("#9CB0CE");
        String hash = (String)this.request.getAttribute("hash");
        HashMap<String, Serializable> configs = new HashMap<String, Serializable>();
        for (Object config : ApplicationConfigDAO.getInstance().findAll()) {
            configs.put(((BaseApplicationConfig)config).getKey(), (Serializable)config);
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Map.Entry entry : ApplicationProperties.getProperties().entrySet()) {
            properties.put(entry.getKey().toString(), entry.getValue().toString());
        }
        for (ApplicationProperty property : ApplicationProperty.values()) {
            if (properties.containsKey(property.key()) || property.isSecret() || property.isDeprecated()) continue;
            if (property.reference() == null) {
                properties.put(property.key(), property.defaultValue() == null ? "" : property.defaultValue());
                continue;
            }
            boolean nomatch = true;
            for (Object key : properties.keySet()) {
                if (!property.matches(key.toString())) continue;
                nomatch = false;
                break;
            }
            if (!nomatch) continue;
            properties.put(property.key(), property.defaultValue() == null ? "" : property.defaultValue());
        }
        if (this.sessionContext.getUser().getCurrentAcademicSessionId() != null) {
            for (SessionConfig sessionConfig : SessionConfig.findAll(this.sessionContext.getUser().getCurrentAcademicSessionId())) {
                configs.put(sessionConfig.getKey(), sessionConfig);
            }
        }
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(ApplicationProperty.ApplicationConfigPattern.value());
        }
        catch (Exception exception) {
            pattern = Pattern.compile(ApplicationProperty.ApplicationConfigPattern.defaultValue());
        }
        boolean bl = this.sessionContext.hasPermission(Right.ApplicationConfigEdit);
        if (properties.isEmpty()) {
            webTable.addLine(null, new String[]{MSG.messageNoAppConfKeys()}, null, null);
        } else {
            for (String key : new TreeSet(properties.keySet())) {
                Serializable config;
                String value = (String)properties.get(key);
                Object o = configs.get(key);
                ApplicationProperty p = ApplicationProperty.fromKey(key);
                String description = ApplicationProperty.getDescription(key);
                if (description == null) {
                    description = "";
                }
                WebTable.WebTableLine line = null;
                if (o == null) {
                    if (!pattern.matcher(key).matches() || !showAll && p != null && (value == null ? "" : value).equals(p.value() == null ? "" : p.value())) continue;
                    String reference = null;
                    if (p != null && p.reference() != null) {
                        reference = p.reference();
                    }
                    if (p != null && p.isSecret()) continue;
                    line = webTable.addLine(bl && p != null && !p.isReadOnly() ? "onClick=\"document.location='applicationConfig.action?op=edit&id=" + (reference == null ? key : key.replace("%", "<" + reference + ">")) + "';\"" : null, new String[]{"<a id='" + (reference == null ? key : key.replace("%", "<" + reference + ">")) + "'>" + (reference == null ? HtmlUtils.htmlEscape((String)key) : HtmlUtils.htmlEscape((String)key).replace("%", "<i><u>" + reference + "</i></u>")) + "</a>", "<font color='gray'>" + HtmlUtils.htmlEscape((String)value) + "</font>", reference == null ? description : description.replace("%", "<i><u>" + reference + "</i></u>")}, (Comparable[])new String[]{key, value, description});
                    if (!key.equals(hash)) continue;
                    line.setBgColor("rgb(168,187,225)");
                    continue;
                }
                if (o instanceof SessionConfig) {
                    config = (SessionConfig)o;
                    if (((BaseSessionConfig)config).getDescription() != null && !((BaseSessionConfig)config).getDescription().isEmpty()) {
                        description = ((BaseSessionConfig)config).getDescription();
                    }
                    line = webTable.addLine(bl && (p == null || !p.isReadOnly()) ? "onClick=\"document.location='applicationConfig.action?op=edit&id=" + key + "';\"" : null, new String[]{"<a id='" + key + "'>" + HtmlUtils.htmlEscape((String)key) + " <sup><font color='#2066CE' title='" + MSG.hintAppConfigAppliesTo(((BaseSessionConfig)config).getSession().getLabel()) + "'>" + MSG.supAppConfigSessionOnly() + "</font></sup></a>", HtmlUtils.htmlEscape((String)value), description}, (Comparable[])new String[]{key, value, description});
                } else {
                    config = (ApplicationConfig)o;
                    if (((BaseApplicationConfig)config).getDescription() != null && !((BaseApplicationConfig)config).getDescription().isEmpty()) {
                        description = ((BaseApplicationConfig)config).getDescription();
                    }
                    line = webTable.addLine(bl && (p == null || !p.isReadOnly()) ? "onClick=\"document.location='applicationConfig.action?op=edit&id=" + key + "';\"" : null, new String[]{"<a id='" + key + "'>" + HtmlUtils.htmlEscape((String)key) + "</a>", HtmlUtils.htmlEscape((String)value), description}, (Comparable[])new String[]{key, value, description});
                }
                if (!key.equals(hash)) continue;
                line.setBgColor("rgb(168,187,225)");
            }
        }
        this.request.setAttribute("appConfig", (Object)webTable.printTable(WebTable.getOrder(this.sessionContext, "applicationConfig.ord")));
    }
}

