/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.solver;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SuggestionsInterface;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.dao.SolutionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.ui.ConflictStatisticsInfo;
import org.unitime.timetable.util.Constants;

@GwtRpcImplements(value=SuggestionsInterface.ConflictBasedStatisticsRequest.class)
public class ConflictBasedStatisticsBackend
implements GwtRpcImplementation<SuggestionsInterface.ConflictBasedStatisticsRequest, GwtRpcResponseList<SuggestionsInterface.CBSNode>> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;

    public static boolean isAllSubjects(String subjects) {
        if (subjects == null || subjects.isEmpty() || subjects.equals(Constants.ALL_OPTION_VALUE)) {
            return true;
        }
        for (String id : subjects.split(",")) {
            if (!Constants.ALL_OPTION_VALUE.equals(id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public GwtRpcResponseList<SuggestionsInterface.CBSNode> execute(SuggestionsInterface.ConflictBasedStatisticsRequest request, SessionContext context) {
        if (request.hasClassId()) {
            context.checkPermission(Right.Suggestions);
        } else {
            context.checkPermission(Right.ConflictStatistics);
        }
        if (!request.hasClassId()) {
            context.getUser().setProperty("Cbs.type", request.isVariableOriented() ? "0" : "1");
            context.getUser().setProperty("Cbs.limit", String.valueOf(request.getLimit()));
        }
        SolverProxy solver = this.courseTimetablingSolverService.getSolver();
        ConflictStatisticsInfo info = null;
        if (solver != null) {
            info = request.hasClassId() ? solver.getCbsInfo(request.getClassId()) : solver.getCbsInfo();
        } else {
            String solutionIdsStr = (String)context.getAttribute(SessionAttribute.SelectedSolution);
            if (solutionIdsStr != null) {
                for (String solutionId : solutionIdsStr.split(",")) {
                    ConflictStatisticsInfo x;
                    Solution solution = (Solution)SolutionDAO.getInstance().get(Long.valueOf(solutionId));
                    if (solution == null || (x = (ConflictStatisticsInfo)solution.getInfo("CBSInfo")) == null) continue;
                    if (info == null) {
                        info = x;
                        continue;
                    }
                    info.merge(x);
                }
            }
        }
        if (info == null || info.getCBS().isEmpty()) {
            return null;
        }
        return this.convert(info.getCBS(), request.getClassId(), request.isVariableOriented(), request.getLimit() / 100.0);
    }

    protected GwtRpcResponseList<SuggestionsInterface.CBSNode> convert(Collection<ConflictStatisticsInfo.CBSVariable> variables, Long classId, boolean variableOriented, double limit) {
        GwtRpcResponseList<SuggestionsInterface.CBSNode> response = new GwtRpcResponseList<SuggestionsInterface.CBSNode>();
        if (variableOriented) {
            variables = ConflictStatisticsInfo.filter(variables, limit);
            for (ConflictStatisticsInfo.CBSVariable var : variables) {
                SuggestionsInterface.CBSNode varNode = null;
                if (classId == null) {
                    varNode = this.variableNode(var);
                    response.add(varNode);
                } else if (!classId.equals(var.getId())) continue;
                for (ConflictStatisticsInfo.CBSValue val : ConflictStatisticsInfo.filter(var.values(), limit)) {
                    SuggestionsInterface.CBSNode valNode = this.valueNode(val);
                    if (varNode != null) {
                        varNode.addNode(valNode);
                    } else {
                        response.add(valNode);
                    }
                    for (ConflictStatisticsInfo.CBSConstraint con : ConflictStatisticsInfo.filter(val.constraints(), limit)) {
                        SuggestionsInterface.CBSNode conNode = this.constraintNode(con);
                        valNode.addNode(conNode);
                        for (ConflictStatisticsInfo.CBSAssignment ass : ConflictStatisticsInfo.filter(con.assignments(), limit)) {
                            conNode.addNode(this.assignmentNode(ass));
                        }
                    }
                }
            }
        } else {
            Collection<ConflictStatisticsInfo.CBSConstraint> constraints = ConflictStatisticsInfo.transpose(variables, classId);
            for (ConflictStatisticsInfo.CBSConstraint consraint : ConflictStatisticsInfo.filter(constraints, limit)) {
                SuggestionsInterface.CBSNode conNode = this.constraintNode(consraint);
                response.add(conNode);
                for (ConflictStatisticsInfo.CBSVariable variable : ConflictStatisticsInfo.filter(consraint.variables(), limit)) {
                    SuggestionsInterface.CBSNode varNode = null;
                    if (classId == null) {
                        varNode = this.variableNode(variable);
                        conNode.addNode(varNode);
                    }
                    for (ConflictStatisticsInfo.CBSValue value : ConflictStatisticsInfo.filter(variable.values(), limit)) {
                        SuggestionsInterface.CBSNode valNode = this.valueNode(value);
                        if (varNode != null) {
                            varNode.addNode(valNode);
                        } else {
                            conNode.addNode(valNode);
                        }
                        for (ConflictStatisticsInfo.CBSAssignment ass : ConflictStatisticsInfo.filter(value.assignments(), limit)) {
                            valNode.addNode(this.assignmentNode(ass));
                        }
                    }
                }
            }
        }
        return response;
    }

    private SuggestionsInterface.CBSNode variableNode(ConflictStatisticsInfo.CBSVariable variable) {
        SuggestionsInterface.CBSNode node = new SuggestionsInterface.CBSNode();
        node.setCount(variable.getCounter());
        node.setName(variable.getName());
        node.setPref(variable.getPref());
        node.setClassId(variable.getId());
        return node;
    }

    private SuggestionsInterface.CBSNode valueNode(ConflictStatisticsInfo.CBSValue value) {
        SuggestionsInterface.CBSNode node = new SuggestionsInterface.CBSNode();
        node.setCount(value.getCounter());
        SuggestionsInterface.SelectedAssignment sa = new SuggestionsInterface.SelectedAssignment();
        sa.setClassId(value.variable().getId());
        sa.setDatePatternId(value.getDatePatternId());
        sa.setDays(value.getDayCode());
        sa.setPatternId(value.getPatternId());
        sa.setStartSlot(value.getStartSlot());
        sa.setRoomIds(value.getRoomIds());
        String html = "<font color='" + PreferenceLevel.int2color(value.getTimePref()) + "'>" + value.getDays() + " " + value.getStartTime() + " - " + value.getEndTime() + " " + value.getDatePatternName() + "</font> ";
        String name = value.getDays() + " " + value.getStartTime() + " - " + value.getEndTime() + " " + value.getDatePatternName();
        for (int i = 0; i < value.getRoomIds().size(); ++i) {
            html = html + (i > 0 ? ", " : "") + "<font color='" + PreferenceLevel.int2color(value.getRoomPrefs().get(i)) + "'>" + value.getRoomNames().get(i) + "</font>";
            name = name + (i > 0 ? ", " : "") + value.getRoomNames().get(i);
        }
        if (value.getInstructorName() != null) {
            html = html + " " + value.getInstructorName();
        }
        node.setName(name);
        node.setHTML(html);
        node.setSelection(sa);
        return node;
    }

    private SuggestionsInterface.CBSNode constraintNode(ConflictStatisticsInfo.CBSConstraint constraint) {
        SuggestionsInterface.CBSNode node = new SuggestionsInterface.CBSNode();
        node.setCount(constraint.getCounter());
        node.setPref(constraint.getPref());
        switch (constraint.getType()) {
            case 4: {
                node.setName(MESSAGES.constraintDeptSpread(constraint.getName()));
                break;
            }
            case 5: {
                node.setName(MESSAGES.constraintSameSubpartSpread(constraint.getName()));
                break;
            }
            case 3: {
                node.setName(MESSAGES.constraintDistribution(constraint.getName()));
                break;
            }
            case 2: {
                node.setName(MESSAGES.constraintInstructor(constraint.getName()));
                try {
                    node.setLink("gwt.jsp?page=timetableGrid&resource=1&filter=" + URLEncoder.encode(constraint.getName(), "UTF-8") + "&search=1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
                break;
            }
            case 1: {
                node.setName(MESSAGES.constraintRoom(constraint.getName()));
                try {
                    node.setLink("gwt.jsp?page=timetableGrid&resource=0&filter=" + URLEncoder.encode(constraint.getName(), "UTF-8") + "&search=1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
                break;
            }
            case 7: {
                node.setName(MESSAGES.constraintClassLimit(constraint.getName()));
                break;
            }
            default: {
                node.setName(constraint.getName() == null ? MESSAGES.constraintUnknown() : constraint.getName());
            }
        }
        return node;
    }

    private SuggestionsInterface.CBSNode assignmentNode(ConflictStatisticsInfo.CBSAssignment assignment) {
        SuggestionsInterface.CBSNode node = new SuggestionsInterface.CBSNode();
        node.setCount(assignment.getCounter());
        SuggestionsInterface.SelectedAssignment sa = new SuggestionsInterface.SelectedAssignment();
        sa.setClassId(assignment.getId());
        sa.setDatePatternId(assignment.getDatePatternId());
        sa.setDays(assignment.getDayCode());
        sa.setPatternId(assignment.getPatternId());
        sa.setStartSlot(assignment.getStartSlot());
        sa.setRoomIds(assignment.getRoomIds());
        String name = assignment.getVariableName() + " " + assignment.getDays() + " " + assignment.getStartTime() + " - " + assignment.getEndTime() + " " + assignment.getDatePatternName();
        String html = "<font color='" + PreferenceLevel.prolog2color(assignment.getPref()) + "'>" + assignment.getVariableName() + "</font> &larr; <font color='" + PreferenceLevel.int2color(assignment.getTimePref()) + "'>" + assignment.getDays() + " " + assignment.getStartTime() + " - " + assignment.getEndTime() + " " + assignment.getDatePatternName() + "</font> ";
        for (int i = 0; i < assignment.getRoomIds().size(); ++i) {
            html = html + (i > 0 ? ", " : "") + "<font color='" + PreferenceLevel.int2color((Integer)assignment.getRoomPrefs().get(i)) + "'>" + assignment.getRoomNames().get(i) + "</font>";
            name = name + (i > 0 ? ", " : "") + assignment.getRoomNames().get(i);
        }
        if (assignment.getInstructorName() != null) {
            html = html + " " + assignment.getInstructorName();
        }
        node.setName(name);
        node.setHTML(html);
        node.setSelection(sa);
        return node;
    }
}

