/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.List;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseLearningManagementSystemInfo;
import org.unitime.timetable.model.dao.LearningManagementSystemInfoDAO;
import org.unitime.timetable.security.UserContext;

public class LearningManagementSystemInfo
extends BaseLearningManagementSystemInfo {
    private static final long serialVersionUID = 45964274048126169L;
    public static String LEARNING_MANAGEMENT_SYSTEM_LIST_ATTR = "lmsList";

    public boolean isUsed(org.hibernate.Session hibSession) {
        if (this.isDefaultLms().booleanValue()) {
            return true;
        }
        return ((Number)(hibSession == null ? LearningManagementSystemInfoDAO.getInstance().getSession() : hibSession).createQuery("select count(c) from Class_ c where c.lmsInfo.uniqueId = :lmsId").setLong("lmsId", this.getUniqueId().longValue()).setCacheable(true).uniqueResult()).intValue() > 0;
    }

    public static List<LearningManagementSystemInfo> findAll(UserContext user) {
        return LearningManagementSystemInfo.findAll(user.getCurrentAcademicSessionId());
    }

    public static List<LearningManagementSystemInfo> findAll(Long sessionId) {
        List list = LearningManagementSystemInfoDAO.getInstance().getSession().createQuery("select distinct lms from LearningManagementSystemInfo as lms where lms.session.uniqueId=:sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).list();
        return list;
    }

    public static LearningManagementSystemInfo findBySessionIdAndReference(Long sessionId, String reference) {
        LearningManagementSystemInfo lms = (LearningManagementSystemInfo)LearningManagementSystemInfoDAO.getInstance().getSession().createQuery("select distinct lms from LearningManagementSystemInfo as lms where lms.session.uniqueId=:sessionId and lms.reference = :ref").setLong("sessionId", sessionId.longValue()).setString("ref", reference).setCacheable(true).uniqueResult();
        return lms;
    }

    public static LearningManagementSystemInfo getDefaultIfExists(Long sessionId) {
        return (LearningManagementSystemInfo)LearningManagementSystemInfoDAO.getInstance().getSession().createQuery("select distinct lms from LearningManagementSystemInfo as lms where lms.session.uniqueId=:sessionId and lms.defaultLms = true").setLong("sessionId", sessionId.longValue()).setCacheable(true).uniqueResult();
    }

    public static boolean isLmsInfoDefinedForSession(Long sessionId) {
        LearningManagementSystemInfoDAO lmsdao = LearningManagementSystemInfoDAO.getInstance();
        return lmsdao.findBySession(lmsdao.getSession(), sessionId).size() > 0;
    }

    public static boolean isLmsInfoDefinedForSession(Session hibSession, Long sessionId) {
        return LearningManagementSystemInfo.isLmsInfoDefinedForSession(hibSession, sessionId);
    }

    public Object clone() {
        LearningManagementSystemInfo newLms = new LearningManagementSystemInfo();
        newLms.setReference(this.getReference());
        newLms.setLabel(this.getLabel());
        newLms.setExternalUniqueId(this.getExternalUniqueId());
        newLms.setDefaultLms(this.getDefaultLms());
        newLms.setSession(this.getSession());
        return newLms;
    }
}

