/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.weights;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.DefaultSingleAssignment;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.extension.DistanceConflict;
import org.cpsolver.studentsct.extension.StudentQuality;
import org.cpsolver.studentsct.extension.TimeOverlapsCounter;
import org.cpsolver.studentsct.model.Choice;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.RequestGroup;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.weights.StudentWeights;

public class PriorityStudentWeights
implements StudentWeights {
    protected double iPriorityFactor = 0.501;
    protected double iFirstAlternativeFactor = 0.501;
    protected double iSecondAlternativeFactor = 0.251;
    protected double iDistanceConflict = 0.01;
    protected double iShortDistanceConflict = 0.1;
    protected double iTimeOverlapFactor = 0.5;
    protected double iTimeOverlapMaxLimit = 0.5;
    protected boolean iLeftoverSpread = false;
    protected double iBalancingFactor = 0.005;
    protected double iNoTimeFactor = 0.01;
    protected double iOnlineFactor = 0.01;
    protected double iPastFactor = 0.0;
    protected double iReservationNotFollowedFactor = 0.1;
    protected double iAlternativeRequestFactor = 0.126;
    protected double iProjectedStudentWeight = 0.01;
    protected boolean iMPP = false;
    protected double iPerturbationFactor = 0.1;
    protected double iSelectionFactor = 0.1;
    protected double iSameChoiceWeight = 0.9;
    protected double iSameTimeWeight = 0.7;
    protected double iSameConfigWeight = 0.5;
    protected double iGroupFactor = 0.1;
    protected double iGroupBestRatio = 0.95;
    protected double iGroupFillRatio = 0.05;
    protected boolean iAdditiveWeights = false;
    protected boolean iMaximizeAssignment = false;
    protected boolean iPreciseComparison = false;
    protected double[] iQalityWeights;
    protected boolean iImprovedBound = true;
    protected double iCriticalBoost = 1.0;
    protected double iPriortyBoost = 1.0;

    public PriorityStudentWeights(DataProperties config) {
        this.iPriorityFactor = config.getPropertyDouble("StudentWeights.Priority", this.iPriorityFactor);
        this.iFirstAlternativeFactor = config.getPropertyDouble("StudentWeights.FirstAlternative", this.iFirstAlternativeFactor);
        this.iSecondAlternativeFactor = config.getPropertyDouble("StudentWeights.SecondAlternative", this.iSecondAlternativeFactor);
        this.iDistanceConflict = config.getPropertyDouble("StudentWeights.DistanceConflict", this.iDistanceConflict);
        this.iShortDistanceConflict = config.getPropertyDouble("StudentWeights.ShortDistanceConflict", this.iShortDistanceConflict);
        this.iTimeOverlapFactor = config.getPropertyDouble("StudentWeights.TimeOverlapFactor", this.iTimeOverlapFactor);
        this.iTimeOverlapMaxLimit = config.getPropertyDouble("StudentWeights.TimeOverlapMaxLimit", this.iTimeOverlapMaxLimit);
        this.iLeftoverSpread = config.getPropertyBoolean("StudentWeights.LeftoverSpread", this.iLeftoverSpread);
        this.iBalancingFactor = config.getPropertyDouble("StudentWeights.BalancingFactor", this.iBalancingFactor);
        this.iAlternativeRequestFactor = config.getPropertyDouble("StudentWeights.AlternativeRequestFactor", this.iAlternativeRequestFactor);
        this.iProjectedStudentWeight = config.getPropertyDouble("StudentWeights.ProjectedStudentWeight", this.iProjectedStudentWeight);
        this.iMPP = config.getPropertyBoolean("General.MPP", false);
        this.iPerturbationFactor = config.getPropertyDouble("StudentWeights.Perturbation", this.iPerturbationFactor);
        this.iSelectionFactor = config.getPropertyDouble("StudentWeights.Selection", this.iSelectionFactor);
        this.iSameChoiceWeight = config.getPropertyDouble("StudentWeights.SameChoice", this.iSameChoiceWeight);
        this.iSameTimeWeight = config.getPropertyDouble("StudentWeights.SameTime", this.iSameTimeWeight);
        this.iSameConfigWeight = config.getPropertyDouble("StudentWeights.SameConfig", this.iSameConfigWeight);
        this.iGroupFactor = config.getPropertyDouble("StudentWeights.SameGroup", this.iGroupFactor);
        this.iGroupBestRatio = config.getPropertyDouble("StudentWeights.GroupBestRatio", this.iGroupBestRatio);
        this.iGroupFillRatio = config.getPropertyDouble("StudentWeights.GroupFillRatio", this.iGroupFillRatio);
        this.iNoTimeFactor = config.getPropertyDouble("StudentWeights.NoTimeFactor", this.iNoTimeFactor);
        this.iOnlineFactor = config.getPropertyDouble("StudentWeights.OnlineFactor", this.iOnlineFactor);
        this.iPastFactor = config.getPropertyDouble("StudentWeights.PastFactor", this.iPastFactor);
        this.iReservationNotFollowedFactor = config.getPropertyDouble("StudentWeights.ReservationNotFollowedFactor", this.iReservationNotFollowedFactor);
        this.iAdditiveWeights = config.getPropertyBoolean("StudentWeights.AdditiveWeights", this.iAdditiveWeights);
        this.iMaximizeAssignment = config.getPropertyBoolean("StudentWeights.MaximizeAssignment", this.iMaximizeAssignment);
        this.iPreciseComparison = config.getPropertyBoolean("StudentWeights.PreciseComparison", this.iPreciseComparison);
        this.iQalityWeights = new double[StudentQuality.Type.values().length];
        for (StudentQuality.Type type : StudentQuality.Type.values()) {
            this.iQalityWeights[type.ordinal()] = config.getPropertyDouble(type.getWeightName(), type.getWeightDefault());
        }
        this.iImprovedBound = config.getPropertyBoolean("StudentWeights.ImprovedBound", this.iImprovedBound);
        this.iPriortyBoost = config.getPropertyDouble("StudentWeights.PriortyBoost", 1.0);
        this.iCriticalBoost = config.getPropertyDouble("StudentWeights.CriticalBoost", 1.0);
    }

    public double getWeight(Request request) {
        if (request.getStudent().isDummy() && this.iProjectedStudentWeight >= 0.0) {
            double weight = this.iProjectedStudentWeight;
            if (request.isAlternative()) {
                weight *= this.iAlternativeRequestFactor;
            }
            return weight;
        }
        double total = 1000000.0;
        int nrReq = request.getStudent().nrRequests();
        double remain = this.iLeftoverSpread ? Math.floor(1000000.0 * Math.pow(this.iPriorityFactor, nrReq) / (double)nrReq) : 0.0;
        for (int idx = 0; idx < request.getStudent().getRequests().size(); ++idx) {
            Request r = request.getStudent().getRequests().get(idx);
            boolean last = idx + 1 == request.getStudent().getRequests().size();
            boolean lastNotAlt = !r.isAlternative() && (last || request.getStudent().getRequests().get(1 + idx).isAlternative());
            double w = Math.ceil(this.iPriorityFactor * total) + remain;
            if (!this.iLeftoverSpread && lastNotAlt) {
                w = total;
            } else {
                total -= w;
            }
            if (!r.equals(request)) continue;
            return w / 1000000.0;
        }
        return 0.0;
    }

    public double getBoostedWeight(Request request) {
        Double boost;
        double weight = this.getWeight(request);
        if (this.iPriortyBoost != 1.0 && (boost = request.getStudent().getPriority().getBoost()) != null) {
            weight *= boost * this.iPriortyBoost;
        }
        if (this.iCriticalBoost != 1.0 && (boost = request.getRequestPriority().getBoost()) != null) {
            weight *= boost * this.iCriticalBoost;
        }
        return weight;
    }

    public double getCachedWeight(Request request) {
        double[] cache = (double[])request.getExtra();
        if (cache == null) {
            double base = this.getBoostedWeight(request);
            cache = new double[]{base, this.computeBound(base, request)};
            request.setExtra(cache);
        }
        return cache[0];
    }

    protected double getDifference(Enrollment enrollment) {
        if (enrollment.getStudent().isDummy() || !enrollment.isCourseRequest()) {
            return 1.0;
        }
        Enrollment other = (Enrollment)enrollment.getRequest().getInitialAssignment();
        if (other != null) {
            double similarSections = 0.0;
            if (enrollment.getConfig().equals(other.getConfig())) {
                block0: for (Section section : enrollment.getSections()) {
                    for (Section initial : other.getSections()) {
                        if (!section.getSubpart().equals(initial.getSubpart())) continue;
                        if (section.equals(initial)) {
                            similarSections += 1.0;
                            continue block0;
                        }
                        if (section.sameChoice(initial)) {
                            similarSections += this.iSameChoiceWeight;
                            continue block0;
                        }
                        if (!section.sameTime(initial)) continue block0;
                        similarSections += this.iSameTimeWeight;
                        continue block0;
                    }
                }
            } else {
                block2: for (Section section : enrollment.getSections()) {
                    for (Section initial : other.getSections()) {
                        if (section.sameChoice(initial)) {
                            similarSections += this.iSameChoiceWeight;
                            continue block2;
                        }
                        if (!section.sameInstructionalType(initial) || !section.sameTime(initial)) continue;
                        similarSections += this.iSameTimeWeight;
                        continue block2;
                    }
                }
            }
            return 1.0 - similarSections / (double)enrollment.getAssignments().size();
        }
        return 1.0;
    }

    public double getSelection(Enrollment enrollment) {
        if (enrollment.getStudent().isDummy()) {
            return 1.0;
        }
        if (enrollment.isCourseRequest()) {
            CourseRequest cr = (CourseRequest)enrollment.getRequest();
            if (!cr.getSelectedChoices().isEmpty()) {
                double similarSections = 0.0;
                for (Section section : enrollment.getSections()) {
                    double bestChoice = 0.0;
                    for (Choice ch : cr.getSelectedChoices()) {
                        if (bestChoice < 1.0 && ch.sameSection(section)) {
                            bestChoice = 1.0;
                            continue;
                        }
                        if (bestChoice < this.iSameChoiceWeight && ch.sameChoice(section)) {
                            bestChoice = this.iSameChoiceWeight;
                            continue;
                        }
                        if (bestChoice < this.iSameTimeWeight && ch.sameOffering(section) && ch.sameInstructionalType(section) && ch.sameTime(section)) {
                            bestChoice = this.iSameTimeWeight;
                            continue;
                        }
                        if (!(bestChoice < this.iSameConfigWeight) || !ch.sameConfiguration(section)) continue;
                        bestChoice = this.iSameConfigWeight;
                    }
                    similarSections += bestChoice;
                }
                return 1.0 - similarSections / (double)enrollment.getAssignments().size();
            }
            return 1.0;
        }
        return 1.0;
    }

    @Override
    public double getBound(Request request) {
        double[] cache = (double[])request.getExtra();
        if (cache == null) {
            double base = this.getBoostedWeight(request);
            cache = new double[]{base, this.computeBound(base, request)};
            request.setExtra(cache);
        }
        return cache[1];
    }

    protected double computeBound(double base, Request request) {
        if (!this.iImprovedBound) {
            return base;
        }
        if (this.iAdditiveWeights) {
            double weight = 0.0;
            if (request instanceof CourseRequest) {
                CourseRequest cr = (CourseRequest)request;
                if (this.iNoTimeFactor != 0.0 && !cr.getCourses().isEmpty()) {
                    weight += this.iNoTimeFactor * cr.getCourses().get(0).getArrHrsBound();
                }
                if (this.iOnlineFactor != 0.0 && !cr.getCourses().isEmpty()) {
                    weight += this.iOnlineFactor * cr.getCourses().get(0).getOnlineBound();
                }
                if (this.iPastFactor != 0.0 && !cr.getCourses().isEmpty()) {
                    weight += this.iPastFactor * cr.getCourses().get(0).getPastBound();
                }
                if (this.iMPP && cr.getInitialAssignment() == null) {
                    weight += this.iPerturbationFactor;
                }
                if (this.iSelectionFactor != 0.0 && cr.getSelectedChoices().isEmpty()) {
                    weight += this.iSelectionFactor;
                }
            }
            return this.round(base * (1.0 - weight));
        }
        double weight = base;
        if (request instanceof CourseRequest) {
            CourseRequest cr = (CourseRequest)request;
            if (this.iNoTimeFactor != 0.0 && !cr.getCourses().isEmpty()) {
                weight *= 1.0 - this.iNoTimeFactor * cr.getCourses().get(0).getArrHrsBound();
            }
            if (this.iOnlineFactor != 0.0 && !cr.getCourses().isEmpty()) {
                weight *= 1.0 - this.iOnlineFactor * cr.getCourses().get(0).getOnlineBound();
            }
            if (this.iPastFactor != 0.0 && !cr.getCourses().isEmpty()) {
                weight *= 1.0 - this.iPastFactor * cr.getCourses().get(0).getPastBound();
            }
            if (this.iMPP && cr.getInitialAssignment() == null) {
                weight *= 1.0 - this.iPerturbationFactor;
            }
            if (this.iSelectionFactor != 0.0 && cr.getSelectedChoices().isEmpty()) {
                weight *= 1.0 - this.iSelectionFactor;
            }
        }
        return this.round(weight);
    }

    protected double round(double value) {
        return Math.ceil(1000000.0 * value) / 1000000.0;
    }

    protected double getBaseWeight(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        double weight = this.getCachedWeight(enrollment.getRequest());
        switch (enrollment.getTruePriority()) {
            case 0: {
                break;
            }
            case 1: {
                weight *= this.iFirstAlternativeFactor;
                break;
            }
            case 2: {
                weight *= this.iSecondAlternativeFactor;
                break;
            }
            default: {
                weight *= Math.pow(this.iFirstAlternativeFactor, enrollment.getTruePriority());
            }
        }
        return weight;
    }

    @Override
    public double getWeight(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        if (this.iAdditiveWeights) {
            return this.getWeightAdditive(assignment, enrollment);
        }
        return this.getWeightMultiplicative(assignment, enrollment);
    }

    public double getWeightMultiplicative(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        double selection;
        double difference;
        int total;
        double weight = this.getBaseWeight(assignment, enrollment);
        if (enrollment.isCourseRequest() && this.iNoTimeFactor != 0.0) {
            int noTimeSections = 0;
            total = 0;
            for (Section section : enrollment.getSections()) {
                if (section.getTime() == null) {
                    ++noTimeSections;
                }
                ++total;
            }
            if (noTimeSections > 0) {
                weight *= 1.0 - this.iNoTimeFactor * (double)noTimeSections / (double)total;
            }
        }
        if (enrollment.isCourseRequest() && this.iOnlineFactor != 0.0) {
            int onlineSections = 0;
            total = 0;
            for (Section section : enrollment.getSections()) {
                if (section.isOnline()) {
                    ++onlineSections;
                }
                ++total;
            }
            if (onlineSections > 0) {
                weight *= 1.0 - this.iOnlineFactor * (double)onlineSections / (double)total;
            }
        }
        if (enrollment.isCourseRequest() && this.iPastFactor != 0.0) {
            int pastSections = 0;
            total = 0;
            for (Section section : enrollment.getSections()) {
                if (section.isPast()) {
                    ++pastSections;
                }
                ++total;
            }
            if (pastSections > 0) {
                weight *= 1.0 - this.iPastFactor * (double)pastSections / (double)total;
            }
        }
        if (enrollment.getTruePriority() < enrollment.getPriority()) {
            weight *= 1.0 - this.iReservationNotFollowedFactor;
        }
        if (enrollment.isCourseRequest() && this.iBalancingFactor != 0.0) {
            double configUsed = enrollment.getConfig().getEnrollmentTotalWeight(assignment, enrollment.getRequest()) + enrollment.getRequest().getWeight();
            double disbalanced = 0.0;
            double total2 = 0.0;
            for (Section section : enrollment.getSections()) {
                double desired;
                Subpart subpart = section.getSubpart();
                if (subpart.getSections().size() <= 1) continue;
                double used = section.getEnrollmentTotalWeight(assignment, enrollment.getRequest()) + enrollment.getRequest().getWeight();
                double d = desired = subpart.getLimit() > 0 ? (double)section.getLimit() * (configUsed / (double)subpart.getLimit()) : configUsed / (double)subpart.getSections().size();
                disbalanced = used > desired ? (disbalanced += Math.min(enrollment.getRequest().getWeight(), used - desired) / enrollment.getRequest().getWeight()) : (disbalanced -= Math.min(enrollment.getRequest().getWeight(), desired - used) / enrollment.getRequest().getWeight());
                total2 += 1.0;
            }
            if (disbalanced > 0.0) {
                weight *= 1.0 - disbalanced / total2 * this.iBalancingFactor;
            }
        }
        if (this.iMPP && (difference = this.getDifference(enrollment)) > 0.0) {
            weight *= 1.0 - difference * this.iPerturbationFactor;
        }
        if (this.iSelectionFactor != 0.0 && (selection = this.getSelection(enrollment)) > 0.0) {
            weight *= 1.0 - selection * this.iSelectionFactor;
        }
        if (enrollment.isCourseRequest() && this.iGroupFactor != 0.0) {
            double sameGroup = 0.0;
            int groupCount = 0;
            for (RequestGroup g : ((CourseRequest)enrollment.getRequest()).getRequestGroups()) {
                if (!g.getCourse().equals(enrollment.getCourse())) continue;
                sameGroup += g.getEnrollmentSpread(assignment, enrollment, this.iGroupBestRatio, this.iGroupFillRatio);
                ++groupCount;
            }
            if (groupCount > 0) {
                double d = 1.0 - sameGroup / (double)groupCount;
                weight *= 1.0 - d * this.iGroupFactor;
            }
        }
        return this.round(weight);
    }

    public double getWeightAdditive(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        double selection;
        double difference;
        int total;
        double base = this.getBaseWeight(assignment, enrollment);
        double weight = 0.0;
        if (enrollment.isCourseRequest() && this.iNoTimeFactor != 0.0) {
            int noTimeSections = 0;
            total = 0;
            for (Section section : enrollment.getSections()) {
                if (section.getTime() == null) {
                    ++noTimeSections;
                }
                ++total;
            }
            if (noTimeSections > 0) {
                weight += this.iNoTimeFactor * (double)noTimeSections / (double)total;
            }
        }
        if (enrollment.isCourseRequest() && this.iOnlineFactor != 0.0) {
            int onlineSections = 0;
            total = 0;
            for (Section section : enrollment.getSections()) {
                if (section.isOnline()) {
                    ++onlineSections;
                }
                ++total;
            }
            if (onlineSections > 0) {
                weight += this.iOnlineFactor * (double)onlineSections / (double)total;
            }
        }
        if (enrollment.isCourseRequest() && this.iPastFactor != 0.0) {
            int pastSections = 0;
            total = 0;
            for (Section section : enrollment.getSections()) {
                if (section.isPast()) {
                    ++pastSections;
                }
                ++total;
            }
            if (pastSections > 0) {
                weight += this.iPastFactor * (double)pastSections / (double)total;
            }
        }
        if (enrollment.getTruePriority() < enrollment.getPriority()) {
            weight += this.iReservationNotFollowedFactor;
        }
        if (enrollment.isCourseRequest() && this.iBalancingFactor != 0.0) {
            double configUsed = enrollment.getConfig().getEnrollmentTotalWeight(assignment, enrollment.getRequest()) + enrollment.getRequest().getWeight();
            double disbalanced = 0.0;
            double total2 = 0.0;
            for (Section section : enrollment.getSections()) {
                double desired;
                Subpart subpart = section.getSubpart();
                if (subpart.getSections().size() <= 1) continue;
                double used = section.getEnrollmentTotalWeight(assignment, enrollment.getRequest()) + enrollment.getRequest().getWeight();
                double d = desired = subpart.getLimit() > 0 ? (double)section.getLimit() * (configUsed / (double)subpart.getLimit()) : configUsed / (double)subpart.getSections().size();
                disbalanced = used > desired ? (disbalanced += Math.min(enrollment.getRequest().getWeight(), used - desired) / enrollment.getRequest().getWeight()) : (disbalanced -= Math.min(enrollment.getRequest().getWeight(), desired - used) / enrollment.getRequest().getWeight());
                total2 += 1.0;
            }
            if (disbalanced > 0.0) {
                weight += disbalanced / total2 * this.iBalancingFactor;
            }
        }
        if (this.iMPP && (difference = this.getDifference(enrollment)) > 0.0) {
            weight += difference * this.iPerturbationFactor;
        }
        if (this.iSelectionFactor != 0.0 && (selection = this.getSelection(enrollment)) > 0.0) {
            weight += selection * this.iSelectionFactor;
        }
        if (enrollment.isCourseRequest() && this.iGroupFactor != 0.0) {
            double sameGroup = 0.0;
            int groupCount = 0;
            for (RequestGroup g : ((CourseRequest)enrollment.getRequest()).getRequestGroups()) {
                if (!g.getCourse().equals(enrollment.getCourse())) continue;
                sameGroup += g.getEnrollmentSpread(assignment, enrollment, this.iGroupBestRatio, this.iGroupFillRatio);
                ++groupCount;
            }
            if (groupCount > 0) {
                double d = 1.0 - sameGroup / (double)groupCount;
                weight += d * this.iGroupFactor;
            }
        }
        return this.round(base * (1.0 - weight));
    }

    @Override
    public double getDistanceConflictWeight(Assignment<Request, Enrollment> assignment, DistanceConflict.Conflict c) {
        if (this.iAdditiveWeights) {
            if (c.getR1().getPriority() < c.getR2().getPriority()) {
                return this.round(this.getBaseWeight(assignment, c.getE2()) * (c.getStudent().isNeedShortDistances() ? this.iShortDistanceConflict : this.iDistanceConflict));
            }
            return this.round(this.getBaseWeight(assignment, c.getE1()) * (c.getStudent().isNeedShortDistances() ? this.iShortDistanceConflict : this.iDistanceConflict));
        }
        if (c.getR1().getPriority() < c.getR2().getPriority()) {
            return this.round(this.getWeightMultiplicative(assignment, c.getE2()) * (c.getStudent().isNeedShortDistances() ? this.iShortDistanceConflict : this.iDistanceConflict));
        }
        return this.round(this.getWeightMultiplicative(assignment, c.getE1()) * (c.getStudent().isNeedShortDistances() ? this.iShortDistanceConflict : this.iDistanceConflict));
    }

    @Override
    public double getTimeOverlapConflictWeight(Assignment<Request, Enrollment> assignment, Enrollment e, TimeOverlapsCounter.Conflict c) {
        if (e == null || e.getRequest() == null) {
            return 0.0;
        }
        double toc = Math.min(this.iTimeOverlapFactor * (double)c.getShare() / (double)e.getNrSlots(), this.iTimeOverlapMaxLimit);
        if (this.iAdditiveWeights) {
            return this.round(this.getBaseWeight(assignment, e) * toc);
        }
        return this.round(this.getWeightMultiplicative(assignment, e) * toc);
    }

    @Override
    public double getWeight(Assignment<Request, Enrollment> assignment, Enrollment enrollment, Set<DistanceConflict.Conflict> distanceConflicts, Set<TimeOverlapsCounter.Conflict> timeOverlappingConflicts) {
        if (this.iAdditiveWeights) {
            double base = this.getBaseWeight(assignment, enrollment);
            double dc = 0.0;
            if (distanceConflicts != null) {
                for (DistanceConflict.Conflict c : distanceConflicts) {
                    Object other;
                    Object object = other = c.getE1().equals(enrollment) ? c.getE2() : c.getE1();
                    if (((Enrollment)other).getRequest().getPriority() <= enrollment.getRequest().getPriority()) {
                        dc += base * (c.getStudent().isNeedShortDistances() ? this.iShortDistanceConflict : this.iDistanceConflict);
                        continue;
                    }
                    dc += this.getBaseWeight(assignment, (Enrollment)other) * (c.getStudent().isNeedShortDistances() ? this.iShortDistanceConflict : this.iDistanceConflict);
                }
            }
            double toc = 0.0;
            if (timeOverlappingConflicts != null) {
                for (TimeOverlapsCounter.Conflict c : timeOverlappingConflicts) {
                    toc += base * Math.min(this.iTimeOverlapFactor * (double)c.getShare() / (double)enrollment.getNrSlots(), this.iTimeOverlapMaxLimit);
                    Enrollment other = c.getE1().equals(enrollment) ? c.getE2() : c.getE1();
                    if (other.getRequest() == null) continue;
                    toc += this.getBaseWeight(assignment, other) * Math.min(this.iTimeOverlapFactor * (double)c.getShare() / (double)other.getNrSlots(), this.iTimeOverlapMaxLimit);
                }
            }
            return this.round(this.getWeight(assignment, enrollment) - dc - toc);
        }
        double base = this.getWeightMultiplicative(assignment, enrollment);
        double dc = 0.0;
        if (distanceConflicts != null) {
            for (DistanceConflict.Conflict c : distanceConflicts) {
                Enrollment other;
                Enrollment enrollment2 = other = c.getE1().equals(enrollment) ? c.getE2() : c.getE1();
                if (other.getRequest().getPriority() <= enrollment.getRequest().getPriority()) {
                    dc += base * (c.getStudent().isNeedShortDistances() ? this.iShortDistanceConflict : this.iDistanceConflict);
                    continue;
                }
                dc += this.getWeightMultiplicative(assignment, other) * (c.getStudent().isNeedShortDistances() ? this.iShortDistanceConflict : this.iDistanceConflict);
            }
        }
        double toc = 0.0;
        if (timeOverlappingConflicts != null) {
            for (TimeOverlapsCounter.Conflict c : timeOverlappingConflicts) {
                toc += base * Math.min(this.iTimeOverlapFactor * (double)c.getShare() / (double)enrollment.getNrSlots(), this.iTimeOverlapMaxLimit);
                Enrollment other = c.getE1().equals(enrollment) ? c.getE2() : c.getE1();
                if (other.getRequest() == null) continue;
                toc += this.getWeightMultiplicative(assignment, other) * Math.min(this.iTimeOverlapFactor * (double)c.getShare() / (double)other.getNrSlots(), this.iTimeOverlapMaxLimit);
            }
        }
        return this.round(base - dc - toc);
    }

    @Override
    public boolean isBetterThanBestSolution(Solution<Request, Enrollment> currentSolution) {
        long bcr;
        long acr;
        if (currentSolution.getBestInfo() == null) {
            return true;
        }
        if (this.iMaximizeAssignment && (acr = Math.round(((StudentSectioningModel.StudentSectioningModelContext)((StudentSectioningModel)currentSolution.getModel()).getContext((Assignment)currentSolution.getAssignment())).getAssignedCourseRequestWeight())) != (bcr = Math.round(((StudentSectioningModel)currentSolution.getModel()).getBestAssignedCourseRequestWeight()))) {
            return acr > bcr;
        }
        return ((StudentSectioningModel)currentSolution.getModel()).getTotalValue(currentSolution.getAssignment(), this.iPreciseComparison) < currentSolution.getBestValue();
    }

    @Override
    public boolean isFreeTimeAllowOverlaps() {
        return false;
    }

    public static void main(String[] args) {
        HashSet<Section> other;
        Enrollment e;
        HashSet<Section> sections;
        Config cfg;
        CourseRequest cr;
        HashSet<Section> other2;
        HashSet<DistanceConflict.Conflict> dc;
        Enrollment e2;
        HashSet<Section> sections2;
        Config cfg2;
        int i;
        double[] w;
        CourseRequest cr2;
        PriorityStudentWeights pw = new PriorityStudentWeights(new DataProperties());
        DecimalFormat df = new DecimalFormat("0.000000");
        Student s = new Student(0L);
        new CourseRequest(1L, 0, false, s, ToolBox.toList(new Course(1L, "A", "1", new Offering(0L, "A")), new Course(1L, "A", "2", new Offering(0L, "A")), new Course(1L, "A", "3", new Offering(0L, "A"))), false, null);
        new CourseRequest(2L, 1, false, s, ToolBox.toList(new Course(1L, "B", "1", new Offering(0L, "B")), new Course(1L, "B", "2", new Offering(0L, "B")), new Course(1L, "B", "3", new Offering(0L, "B"))), false, null);
        new CourseRequest(3L, 2, false, s, ToolBox.toList(new Course(1L, "C", "1", new Offering(0L, "C")), new Course(1L, "C", "2", new Offering(0L, "C")), new Course(1L, "C", "3", new Offering(0L, "C"))), false, null);
        new CourseRequest(4L, 3, false, s, ToolBox.toList(new Course(1L, "D", "1", new Offering(0L, "D")), new Course(1L, "D", "2", new Offering(0L, "D")), new Course(1L, "D", "3", new Offering(0L, "D"))), false, null);
        new CourseRequest(5L, 4, false, s, ToolBox.toList(new Course(1L, "E", "1", new Offering(0L, "E")), new Course(1L, "E", "2", new Offering(0L, "E")), new Course(1L, "E", "3", new Offering(0L, "E"))), false, null);
        new CourseRequest(6L, 5, true, s, ToolBox.toList(new Course(1L, "F", "1", new Offering(0L, "F")), new Course(1L, "F", "2", new Offering(0L, "F")), new Course(1L, "F", "3", new Offering(0L, "F"))), false, null);
        new CourseRequest(7L, 6, true, s, ToolBox.toList(new Course(1L, "G", "1", new Offering(0L, "G")), new Course(1L, "G", "2", new Offering(0L, "G")), new Course(1L, "G", "3", new Offering(0L, "G"))), false, null);
        DefaultSingleAssignment<Request, Enrollment> assignment = new DefaultSingleAssignment<Request, Enrollment>();
        Placement p = new Placement(null, new TimeLocation(1, 90, 12, 0, 0.0, null, null, new BitSet(), 10), new ArrayList<RoomLocation>());
        for (Request r : s.getRequests()) {
            cr2 = (CourseRequest)r;
            w = new double[]{0.0, 0.0, 0.0};
            for (i = 0; i < cr2.getCourses().size(); ++i) {
                cfg2 = new Config(0L, -1, "", cr2.getCourses().get(i).getOffering());
                sections2 = new HashSet<Section>();
                sections2.add(new Section(0L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg2, null), p, null, new Instructor[0]));
                e2 = new Enrollment(cr2, i, cfg2, sections2, assignment);
                w[i] = pw.getWeight(assignment, e2, null, null);
            }
            System.out.println(cr2 + ": " + df.format(w[0]) + "  " + df.format(w[1]) + "  " + df.format(w[2]));
        }
        System.out.println("With one distance conflict:");
        for (Request r : s.getRequests()) {
            cr2 = (CourseRequest)r;
            w = new double[]{0.0, 0.0, 0.0};
            for (i = 0; i < cr2.getCourses().size(); ++i) {
                cfg2 = new Config(0L, -1, "", cr2.getCourses().get(i).getOffering());
                sections2 = new HashSet();
                sections2.add(new Section(0L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg2, null), p, null, new Instructor[0]));
                e2 = new Enrollment(cr2, i, cfg2, sections2, assignment);
                dc = new HashSet<DistanceConflict.Conflict>();
                dc.add(new DistanceConflict.Conflict(s, e2, (Section)sections2.iterator().next(), e2, (Section)sections2.iterator().next()));
                w[i] = pw.getWeight(assignment, e2, dc, null);
            }
            System.out.println(cr2 + ": " + df.format(w[0]) + "  " + df.format(w[1]) + "  " + df.format(w[2]));
        }
        System.out.println("With two distance conflicts:");
        for (Request r : s.getRequests()) {
            cr2 = (CourseRequest)r;
            w = new double[]{0.0, 0.0, 0.0};
            for (i = 0; i < cr2.getCourses().size(); ++i) {
                cfg2 = new Config(0L, -1, "", cr2.getCourses().get(i).getOffering());
                sections2 = new HashSet();
                sections2.add(new Section(0L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg2, null), p, null, new Instructor[0]));
                e2 = new Enrollment(cr2, i, cfg2, sections2, assignment);
                dc = new HashSet();
                dc.add(new DistanceConflict.Conflict(s, e2, (Section)sections2.iterator().next(), e2, (Section)sections2.iterator().next()));
                dc.add(new DistanceConflict.Conflict(s, e2, (Section)sections2.iterator().next(), e2, new Section(1L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg2, null), p, null, new Instructor[0])));
                w[i] = pw.getWeight(assignment, e2, dc, null);
            }
            System.out.println(cr2 + ": " + df.format(w[0]) + "  " + df.format(w[1]) + "  " + df.format(w[2]));
        }
        System.out.println("With 25% time overlapping conflict:");
        for (Request r : s.getRequests()) {
            cr2 = (CourseRequest)r;
            w = new double[]{0.0, 0.0, 0.0};
            for (i = 0; i < cr2.getCourses().size(); ++i) {
                cfg2 = new Config(0L, -1, "", cr2.getCourses().get(i).getOffering());
                sections2 = new HashSet();
                sections2.add(new Section(0L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg2, null), p, null, new Instructor[0]));
                e2 = new Enrollment(cr2, i, cfg2, sections2, assignment);
                HashSet<TimeOverlapsCounter.Conflict> toc = new HashSet<TimeOverlapsCounter.Conflict>();
                toc.add(new TimeOverlapsCounter.Conflict(s, 3, e2, (SctAssignment)sections2.iterator().next(), e2, (SctAssignment)sections2.iterator().next()));
                w[i] = pw.getWeight(assignment, e2, null, toc);
            }
            System.out.println(cr2 + ": " + df.format(w[0]) + "  " + df.format(w[1]) + "  " + df.format(w[2]));
        }
        System.out.println("Disbalanced sections (by 2 / 10 students):");
        for (Request r : s.getRequests()) {
            cr2 = (CourseRequest)r;
            w = new double[]{0.0, 0.0, 0.0};
            for (i = 0; i < cr2.getCourses().size(); ++i) {
                cfg2 = new Config(0L, -1, "", cr2.getCourses().get(i).getOffering());
                sections2 = new HashSet();
                Subpart x = new Subpart(0L, "Lec", "Lec", cfg2, null);
                Section a = new Section(0L, 10, "x", x, p, null, new Instructor[0]);
                new Section(1L, 10, "y", x, p, null, new Instructor[0]);
                sections2.add(a);
                a.assigned(assignment, new Enrollment(s.getRequests().get(0), i, cfg2, sections2, assignment));
                a.assigned(assignment, new Enrollment(s.getRequests().get(0), i, cfg2, sections2, assignment));
                ((Config.ConfigContext)cfg2.getContext(assignment)).assigned((Assignment<Request, Enrollment>)assignment, new Enrollment(s.getRequests().get(0), i, cfg2, sections2, assignment));
                ((Config.ConfigContext)cfg2.getContext(assignment)).assigned((Assignment<Request, Enrollment>)assignment, new Enrollment(s.getRequests().get(0), i, cfg2, sections2, assignment));
                Enrollment e3 = new Enrollment(cr2, i, cfg2, sections2, assignment);
                w[i] = pw.getWeight(assignment, e3, null, null);
            }
            System.out.println(cr2 + ": " + df.format(w[0]) + "  " + df.format(w[1]) + "  " + df.format(w[2]));
        }
        System.out.println("Same choice sections:");
        pw.iMPP = true;
        for (Request r : s.getRequests()) {
            cr2 = (CourseRequest)r;
            w = new double[]{0.0, 0.0, 0.0};
            for (i = 0; i < cr2.getCourses().size(); ++i) {
                cfg2 = new Config(0L, -1, "", cr2.getCourses().get(i).getOffering());
                sections2 = new HashSet();
                sections2.add(new Section(0L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg2, null), p, null, new Instructor[0]));
                e2 = new Enrollment(cr2, i, cfg2, sections2, assignment);
                other2 = new HashSet<Section>();
                other2.add(new Section(1L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg2, null), p, null, new Instructor[0]));
                cr2.setInitialAssignment(new Enrollment(cr2, i, cfg2, other2, assignment));
                w[i] = pw.getWeight(assignment, e2, null, null);
            }
            System.out.println(cr2 + ": " + df.format(w[0]) + "  " + df.format(w[1]) + "  " + df.format(w[2]));
        }
        System.out.println("Same time sections:");
        for (Request r : s.getRequests()) {
            cr2 = (CourseRequest)r;
            w = new double[]{0.0, 0.0, 0.0};
            for (i = 0; i < cr2.getCourses().size(); ++i) {
                cfg2 = new Config(0L, -1, "", cr2.getCourses().get(i).getOffering());
                sections2 = new HashSet();
                sections2.add(new Section(0L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg2, null), p, null, new Instructor[0]));
                e2 = new Enrollment(cr2, i, cfg2, sections2, assignment);
                other2 = new HashSet();
                other2.add(new Section(1L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg2, null), p, null, new Instructor(1L, null, "Josef Novak", null)));
                cr2.setInitialAssignment(new Enrollment(cr2, i, cfg2, other2, assignment));
                w[i] = pw.getWeight(assignment, e2, null, null);
            }
            System.out.println(cr2 + ": " + df.format(w[0]) + "  " + df.format(w[1]) + "  " + df.format(w[2]));
        }
        System.out.println("Different time sections:");
        Placement q = new Placement(null, new TimeLocation(1, 102, 12, 0, 0.0, null, null, new BitSet(), 10), new ArrayList<RoomLocation>());
        for (Request r : s.getRequests()) {
            cr = (CourseRequest)r;
            double[] w2 = new double[]{0.0, 0.0, 0.0};
            for (int i2 = 0; i2 < cr.getCourses().size(); ++i2) {
                cfg = new Config(0L, -1, "", cr.getCourses().get(i2).getOffering());
                sections = new HashSet<Section>();
                sections.add(new Section(0L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg, null), p, null, new Instructor[0]));
                e = new Enrollment(cr, i2, cfg, sections, assignment);
                other = new HashSet<Section>();
                other.add(new Section(1L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg, null), q, null, new Instructor[0]));
                cr.setInitialAssignment(new Enrollment(cr, i2, cfg, other, assignment));
                w2[i2] = pw.getWeight(assignment, e, null, null);
            }
            System.out.println(cr + ": " + df.format(w2[0]) + "  " + df.format(w2[1]) + "  " + df.format(w2[2]));
        }
        System.out.println("Two sections, one same choice, one same time:");
        for (Request r : s.getRequests()) {
            cr = (CourseRequest)r;
            double[] w3 = new double[]{0.0, 0.0, 0.0};
            for (int i3 = 0; i3 < cr.getCourses().size(); ++i3) {
                cfg = new Config(0L, -1, "", cr.getCourses().get(i3).getOffering());
                sections = new HashSet();
                sections.add(new Section(0L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg, null), p, null, new Instructor[0]));
                sections.add(new Section(1L, 1, "y", new Subpart(1L, "Rec", "Rec", cfg, null), p, null, new Instructor[0]));
                e = new Enrollment(cr, i3, cfg, sections, assignment);
                other = new HashSet();
                other.add(new Section(2L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg, null), p, null, new Instructor[0]));
                other.add(new Section(3L, 1, "y", new Subpart(1L, "Rec", "Rec", cfg, null), p, null, new Instructor(1L, null, "Josef Novak", null)));
                cr.setInitialAssignment(new Enrollment(cr, i3, cfg, other, assignment));
                w3[i3] = pw.getWeight(assignment, e, null, null);
            }
            System.out.println(cr + ": " + df.format(w3[0]) + "  " + df.format(w3[1]) + "  " + df.format(w3[2]));
        }
    }

    @Override
    public double getWeight(Assignment<Request, Enrollment> assignment, Enrollment enrollment, Set<StudentQuality.Conflict> qualityConflicts) {
        if (this.iAdditiveWeights) {
            double base = this.getBaseWeight(assignment, enrollment);
            double penalty = 0.0;
            if (qualityConflicts != null) {
                for (StudentQuality.Conflict c : qualityConflicts) {
                    switch (c.getType().getType()) {
                        case REQUEST: {
                            if (!enrollment.isCourseRequest()) break;
                            penalty += base * this.iQalityWeights[c.getType().ordinal()] * c.getWeight(enrollment);
                            break;
                        }
                        case BOTH: {
                            Enrollment other = c.getOther(enrollment);
                            penalty += base * this.iQalityWeights[c.getType().ordinal()] * c.getWeight(enrollment);
                            penalty += this.getBaseWeight(assignment, other) * this.iQalityWeights[c.getType().ordinal()] * c.getWeight(other);
                            break;
                        }
                        case LOWER: {
                            Enrollment other = c.getOther(enrollment);
                            if (other.getRequest().getPriority() <= enrollment.getRequest().getPriority()) {
                                penalty += base * this.iQalityWeights[c.getType().ordinal()] * c.getWeight(enrollment);
                                break;
                            }
                            penalty += this.getBaseWeight(assignment, other) * this.iQalityWeights[c.getType().ordinal()] * c.getWeight(other);
                            break;
                        }
                        case HIGHER: {
                            Enrollment other = c.getOther(enrollment);
                            if (other.getRequest().getPriority() >= enrollment.getRequest().getPriority()) {
                                penalty += base * this.iQalityWeights[c.getType().ordinal()] * c.getWeight(enrollment);
                                break;
                            }
                            penalty += this.getBaseWeight(assignment, other) * this.iQalityWeights[c.getType().ordinal()] * c.getWeight(other);
                        }
                    }
                }
            }
            return this.round(this.getWeight(assignment, enrollment) - penalty);
        }
        double base = this.getWeightMultiplicative(assignment, enrollment);
        double penalty = 0.0;
        if (qualityConflicts != null) {
            for (StudentQuality.Conflict c : qualityConflicts) {
                Enrollment other = c.getOther(enrollment);
                switch (c.getType().getType()) {
                    case REQUEST: {
                        if (enrollment.isCourseRequest()) {
                            penalty += base * this.iQalityWeights[c.getType().ordinal()] * c.getWeight(enrollment);
                            break;
                        }
                        if (!other.isCourseRequest()) break;
                        penalty += this.getWeightMultiplicative(assignment, other) * this.iQalityWeights[c.getType().ordinal()] * c.getWeight(other);
                        break;
                    }
                    case BOTH: {
                        penalty += base * this.iQalityWeights[c.getType().ordinal()] * c.getWeight(enrollment);
                        if (other.getRequest() == null) break;
                        penalty += this.getWeightMultiplicative(assignment, other) * this.iQalityWeights[c.getType().ordinal()] * c.getWeight(other);
                        break;
                    }
                    case LOWER: {
                        other = c.getOther(enrollment);
                        if (other.getRequest().getPriority() <= enrollment.getRequest().getPriority()) {
                            penalty += base * this.iQalityWeights[c.getType().ordinal()] * c.getWeight(enrollment);
                            break;
                        }
                        if (other.getRequest() == null) break;
                        penalty += this.getWeightMultiplicative(assignment, other) * this.iQalityWeights[c.getType().ordinal()] * c.getWeight(other);
                        break;
                    }
                    case HIGHER: {
                        other = c.getOther(enrollment);
                        if (other.getRequest().getPriority() >= enrollment.getRequest().getPriority()) {
                            penalty += base * this.iQalityWeights[c.getType().ordinal()] * c.getWeight(enrollment);
                            break;
                        }
                        if (other.getRequest() == null) break;
                        penalty += this.getWeightMultiplicative(assignment, other) * this.iQalityWeights[c.getType().ordinal()] * c.getWeight(other);
                    }
                }
            }
        }
        return this.round(base - penalty);
    }

    @Override
    public double getStudentQualityConflictWeight(Assignment<Request, Enrollment> assignment, Enrollment enrollment, StudentQuality.Conflict conflict) {
        switch (conflict.getType().getType()) {
            case BOTH: {
                if (enrollment == null || enrollment.getRequest() == null) {
                    return 0.0;
                }
                if (this.iAdditiveWeights) {
                    return this.round(this.getBaseWeight(assignment, enrollment) * this.iQalityWeights[conflict.getType().ordinal()] * conflict.getWeight(enrollment));
                }
                return this.round(this.getWeightMultiplicative(assignment, enrollment) * this.iQalityWeights[conflict.getType().ordinal()] * conflict.getWeight(enrollment));
            }
            case REQUEST: {
                if (enrollment == null || enrollment.getRequest() == null || !enrollment.isCourseRequest()) {
                    return 0.0;
                }
                if (this.iAdditiveWeights) {
                    return this.round(this.getBaseWeight(assignment, enrollment) * this.iQalityWeights[conflict.getType().ordinal()] * conflict.getWeight(enrollment));
                }
                return this.round(this.getWeightMultiplicative(assignment, enrollment) * this.iQalityWeights[conflict.getType().ordinal()] * conflict.getWeight(enrollment));
            }
            case LOWER: {
                if (this.iAdditiveWeights) {
                    if (conflict.getR1().getPriority() < conflict.getR2().getPriority()) {
                        return this.round(this.getBaseWeight(assignment, conflict.getE2()) * this.iQalityWeights[conflict.getType().ordinal()] * conflict.getWeight(conflict.getE2()));
                    }
                    return this.round(this.getBaseWeight(assignment, conflict.getE1()) * this.iQalityWeights[conflict.getType().ordinal()] * conflict.getWeight(conflict.getE1()));
                }
                if (conflict.getR1().getPriority() < conflict.getR2().getPriority()) {
                    return this.round(this.getWeightMultiplicative(assignment, conflict.getE2()) * this.iQalityWeights[conflict.getType().ordinal()] * conflict.getWeight(conflict.getE2()));
                }
                return this.round(this.getWeightMultiplicative(assignment, conflict.getE1()) * this.iQalityWeights[conflict.getType().ordinal()] * conflict.getWeight(conflict.getE1()));
            }
            case HIGHER: {
                if (this.iAdditiveWeights) {
                    if (conflict.getR1().getPriority() > conflict.getR2().getPriority()) {
                        return this.round(this.getBaseWeight(assignment, conflict.getE2()) * this.iQalityWeights[conflict.getType().ordinal()] * conflict.getWeight(conflict.getE2()));
                    }
                    return this.round(this.getBaseWeight(assignment, conflict.getE1()) * this.iQalityWeights[conflict.getType().ordinal()] * conflict.getWeight(conflict.getE1()));
                }
                if (conflict.getR1().getPriority() < conflict.getR2().getPriority()) {
                    return this.round(this.getWeightMultiplicative(assignment, conflict.getE2()) * this.iQalityWeights[conflict.getType().ordinal()] * conflict.getWeight(conflict.getE2()));
                }
                return this.round(this.getWeightMultiplicative(assignment, conflict.getE1()) * this.iQalityWeights[conflict.getType().ordinal()] * conflict.getWeight(conflict.getE1()));
            }
        }
        return 0.0;
    }
}

