/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.log4j.BasicConfigurator;
import org.cpsolver.coursett.Test;
import org.cpsolver.coursett.TimetableXMLLoader;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.DefaultSingleAssignment;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class GetInfo {
    public static HashMap<String, String> getInfoOfASolution(File file) {
        try {
            DataProperties properties = new DataProperties();
            properties.setProperty("General.Input", file.getPath());
            TimetableXMLLoader loader = new TimetableXMLLoader(new TimetableModel(properties), (Assignment<Lecture, Placement>)new DefaultSingleAssignment<Lecture, Placement>());
            loader.load();
            File newOutputFile = new File(file.getParentFile(), "new-output.csv");
            Test.saveOutputCSV(new Solution<Lecture, Placement>((Model<Lecture, Placement>)loader.getModel(), loader.getAssignment()), newOutputFile);
            Progress.removeInstance(loader.getModel());
            System.out.println("  Reading " + newOutputFile + " ...");
            HashMap<String, String> info = GetInfo.getInfo(newOutputFile);
            File outputFile = new File(file.getParentFile(), "output.csv");
            if (outputFile.exists()) {
                System.out.println("  Reading " + outputFile + " ...");
                HashMap<String, String> info2 = GetInfo.getInfo(outputFile);
                if (info2.containsKey("000.002 Time [sec]")) {
                    info.put("000.002 Time [sec]", info2.get("000.002 Time [sec]"));
                }
            }
            return info;
        }
        catch (Exception e) {
            System.err.println("Error reading info, message: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static HashMap<String, String> getInfo(String comment) {
        try {
            BufferedReader reader = new BufferedReader(new StringReader(comment));
            String line = null;
            HashMap<String, String> info = new HashMap<String, String>();
            while ((line = reader.readLine()) != null) {
                int idx = line.indexOf(58);
                if (idx < 0) continue;
                String key = line.substring(0, idx).trim();
                String value = line.substring(idx + 1).trim();
                if (value.indexOf(40) >= 0 && value.indexOf(41) >= 0 && (value = value.substring(value.indexOf(40) + 1, value.indexOf(41))).indexOf(47) >= 0) {
                    String bound = value.substring(value.indexOf(47) + 1);
                    if (bound.indexOf("..") >= 0) {
                        String min = bound.substring(0, bound.indexOf(".."));
                        String max = bound.substring(bound.indexOf("..") + 2);
                        info.put(key + " Min", min);
                        info.put(key + " Max", max);
                    } else {
                        info.put(key + " Bound", bound);
                    }
                    value = value.substring(0, value.indexOf(47));
                }
                if (value.length() <= 0) continue;
                info.put(key, value);
            }
            reader.close();
            return info;
        }
        catch (Exception e) {
            System.err.println("Error reading info, message: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static HashMap<String, String> getInfo(File outputFile) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(outputFile));
            String line = null;
            HashMap<String, String> info = new HashMap<String, String>();
            while ((line = reader.readLine()) != null) {
                int idx = line.indexOf(44);
                if (idx < 0) continue;
                String key = line.substring(0, idx).trim();
                String value = line.substring(idx + 1).trim();
                if (value.indexOf(40) >= 0 && value.indexOf(41) >= 0 && (value = value.substring(value.indexOf(40) + 1, value.indexOf(41))).indexOf(47) >= 0) {
                    String bound = value.substring(value.indexOf(47) + 1);
                    if (bound.indexOf("..") >= 0) {
                        String min = bound.substring(0, bound.indexOf(".."));
                        String max = bound.substring(bound.indexOf("..") + 2);
                        info.put(key + " Min", min);
                        info.put(key + " Max", max);
                    } else {
                        info.put(key + " Bound", bound);
                    }
                    value = value.substring(0, value.indexOf(47));
                }
                if (value.length() <= 0) continue;
                info.put(key, value);
            }
            reader.close();
            return info;
        }
        catch (Exception e) {
            System.err.println("Error reading info, message: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static HashMap<String, String> getInfo(Element root) {
        try {
            HashMap<String, String> info = new HashMap<String, String>();
            Iterator<Element> i = root.elementIterator("property");
            while (i.hasNext()) {
                Element property = i.next();
                String key = property.attributeValue("name");
                String value = property.getText();
                if (key == null || value == null) continue;
                if (value.indexOf(40) >= 0 && value.indexOf(41) >= 0 && (value = value.substring(value.indexOf(40) + 1, value.indexOf(41))).indexOf(47) >= 0) {
                    String bound = value.substring(value.indexOf(47) + 1);
                    if (bound.indexOf("..") >= 0) {
                        String min = bound.substring(0, bound.indexOf(".."));
                        String max = bound.substring(bound.indexOf("..") + 2);
                        info.put(key + " Min", min);
                        info.put(key + " Max", max);
                    } else {
                        info.put(key + " Bound", bound);
                    }
                    value = value.substring(0, value.indexOf(47));
                }
                if (value.length() <= 0) continue;
                info.put(key, value);
            }
            return info;
        }
        catch (Exception e) {
            System.err.println("Error reading info, message: " + e.getMessage());
            return null;
        }
    }

    public static void getInfo(File folder, List<Info> infos, String prefix) {
        File outputFile;
        File solutionFile;
        HashMap<String, String> info;
        File infoFile = new File(folder, "info.xml");
        if (infoFile.exists()) {
            System.out.println("Reading " + infoFile + " ...");
            try {
                Document document = new SAXReader().read(infoFile);
                info = GetInfo.getInfo(document.getRootElement());
                if (info != null && !info.isEmpty()) {
                    infos.add(new Info(prefix, info));
                    return;
                }
            }
            catch (Exception e) {
                System.err.println("Error reading file " + infoFile + ", message: " + e.getMessage());
            }
        }
        if ((solutionFile = new File(folder, "solution.xml")).exists()) {
            System.out.println("Reading " + solutionFile + " ...");
            try {
                info = GetInfo.getInfoOfASolution(solutionFile);
                if (info != null && !info.isEmpty()) {
                    infos.add(new Info(prefix, info));
                    return;
                }
            }
            catch (Exception e) {
                System.err.println("Error reading file " + infoFile + ", message: " + e.getMessage());
            }
        }
        if ((outputFile = new File(folder, "output.csv")).exists()) {
            System.out.println("Reading " + outputFile + " ...");
            try {
                HashMap<String, String> info2 = GetInfo.getInfo(outputFile);
                if (info2 != null && !info2.isEmpty()) {
                    infos.add(new Info(prefix, info2));
                    return;
                }
            }
            catch (Exception e) {
                System.err.println("Error reading file " + infoFile + ", message: " + e.getMessage());
            }
        }
    }

    public static void getInfos(File folder, List<Info> infos, String prefix) {
        System.out.println("Checking " + folder + " ...");
        File[] files = folder.listFiles();
        GetInfo.getInfo(folder, infos, prefix == null ? "" : prefix);
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            GetInfo.getInfos(files[i], infos, (prefix == null ? "" : prefix + "/") + files[i].getName());
        }
    }

    public static void writeInfos(List<Info> infos, File file) {
        try {
            System.out.println("Writing " + file + " ...");
            TreeSet<String> keys = new TreeSet<String>();
            ArrayList<CSVFile.CSVField> headers = new ArrayList<CSVFile.CSVField>();
            headers.add(new CSVFile.CSVField(""));
            for (Info o : infos) {
                keys.addAll(o.getInfo().keySet());
                headers.add(new CSVFile.CSVField(o.getPrefix()));
            }
            CSVFile csvFile = new CSVFile();
            csvFile.setHeader(headers);
            for (String key : keys) {
                ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
                line.add(new CSVFile.CSVField(key));
                for (Info o : infos) {
                    Map<String, String> info = o.getInfo();
                    String value = info.get(key);
                    line.add(new CSVFile.CSVField(value == null ? "" : value));
                }
                csvFile.addLine(line);
            }
            csvFile.save(file);
        }
        catch (Exception e) {
            System.err.println("Error writing file " + file + ", message: " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        try {
            BasicConfigurator.configure();
            File folder = new File(args[0]);
            ArrayList<Info> infos = new ArrayList<Info>();
            GetInfo.getInfos(folder, infos, null);
            if (!infos.isEmpty()) {
                GetInfo.writeInfos(infos, new File(folder, "info.csv"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class Info {
        private String iPrefix;
        private HashMap<String, String> iInfo;

        public Info(String prefix, HashMap<String, String> info) {
            this.iPrefix = prefix;
            this.iInfo = info;
        }

        public String getPrefix() {
            return this.iPrefix;
        }

        public Map<String, String> getInfo() {
            return this.iInfo;
        }
    }
}

