/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.webutil.timegrid;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.preference.PreferenceCombination;
import org.hibernate.Query;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.unitime.commons.Debug;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.events.EventLookupBackend;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.CurriculumClassification;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.ExactTimeMins;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomSharingModel;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.SolutionDAO;
import org.unitime.timetable.solver.ui.AssignmentPreferenceInfo;
import org.unitime.timetable.solver.ui.GroupConstraintInfo;
import org.unitime.timetable.solver.ui.StudentGroupInfo;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.DateUtils;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.RoomAvailability;
import org.unitime.timetable.util.duration.DurationModel;
import org.unitime.timetable.webutil.timegrid.TimetableGridCell;
import org.unitime.timetable.webutil.timegrid.TimetableGridContext;
import org.unitime.timetable.webutil.timegrid.TimetableGridModel;

public class SolutionGridModel
extends TimetableGridModel {
    private static final long serialVersionUID = -3207641071203870684L;
    private transient Long iRoomId = null;
    private static DecimalFormat sDF = new DecimalFormat("0.0");

    public SolutionGridModel(String solutionIdsStr, Location room, org.hibernate.Session hibSession, TimetableGridContext context) {
        super(0, room.getUniqueId().intValue());
        this.setName(room.getLabel());
        this.setSize(room.getCapacity());
        this.setFirstDay(context.getFirstDay());
        this.iRoomId = room.getUniqueId();
        Solution firstSolution = null;
        String ownerIds = "";
        HashSet<Long> deptIds = new HashSet<Long>();
        StringTokenizer s = new StringTokenizer(solutionIdsStr, ",");
        while (s.hasMoreTokens()) {
            Long solutionId = Long.valueOf(s.nextToken());
            Solution solution = (Solution)new SolutionDAO().get(solutionId, hibSession);
            if (solution == null) continue;
            if (firstSolution == null) {
                firstSolution = solution;
            }
            if (ownerIds.length() > 0) {
                ownerIds = ownerIds + ",";
            }
            ownerIds = ownerIds + solution.getOwner().getUniqueId();
            for (Department d : solution.getOwner().getDepartments()) {
                deptIds.add(d.getUniqueId());
            }
        }
        Query q = hibSession.createQuery("select distinct a from Assignment as a inner join a.rooms as r where a.solution.uniqueId in (" + solutionIdsStr + ") and r.uniqueId=:resourceId");
        q.setLong("resourceId", room.getUniqueId().longValue());
        q.setCacheable(true);
        this.init(q.list(), hibSession, context);
        q = hibSession.createQuery("select distinct a from Room r inner join r.assignments as a where r.uniqueId=:roomId and a.solution.commited=true and a.solution.owner.session.uniqueId=:sessionId and a.solution.owner.uniqueId not in (" + ownerIds + ")");
        q.setLong("roomId", room.getUniqueId().longValue());
        q.setLong("sessionId", room.getSession().getUniqueId().longValue());
        q.setCacheable(true);
        List commitedAssignments = q.list();
        for (Assignment a : commitedAssignments) {
            this.init(a, hibSession, context.getFirstDay(), -1);
        }
        this.setUtilization(this.getUtilization() + this.countUtilization(context, commitedAssignments));
        RoomSharingModel sharing = room.getRoomSharingModel();
        if (sharing != null) {
            for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
                for (int j = 0; j < 288; ++j) {
                    if (sharing.isFreeForAll(i, j)) continue;
                    if (sharing.isNotAvailable(i, j)) {
                        this.setAvailable(i, j, false);
                        continue;
                    }
                    Long dept = sharing.getDepartmentId(i, j);
                    if (dept == null || deptIds.contains(dept)) continue;
                    this.setAvailable(i, j, false);
                }
            }
        }
        if (context.isShowEvents() && RoomAvailability.getInstance() != null) {
            Calendar startDateCal = Calendar.getInstance(Locale.US);
            startDateCal.setTime(DateUtils.getDate(1, room.getSession().getStartMonth(), room.getSession().getSessionStartYear()));
            startDateCal.set(11, 0);
            startDateCal.set(12, 0);
            startDateCal.set(13, 0);
            Calendar endDateCal = Calendar.getInstance(Locale.US);
            endDateCal.setTime(DateUtils.getDate(0, room.getSession().getEndMonth() + 1, room.getSession().getSessionStartYear()));
            endDateCal.set(11, 23);
            endDateCal.set(12, 59);
            endDateCal.set(13, 59);
            Collection<RoomAvailabilityInterface.TimeBlock> times = RoomAvailability.getInstance().getRoomAvailability(room.getUniqueId(), startDateCal.getTime(), endDateCal.getTime(), RoomAvailabilityInterface.sClassType);
            if (times != null) {
                int sessionYear = room.getSession().getSessionStartYear();
                int firstDOY = room.getSession().getDayOfYear(1, room.getSession().getPatternStartMonth());
                int lastDOY = room.getSession().getDayOfYear(0, room.getSession().getPatternEndMonth() + 1);
                Calendar c = Calendar.getInstance(Locale.US);
                Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT);
                for (RoomAvailabilityInterface.TimeBlock time : times) {
                    if (time.getEndTime().before(startDateCal.getTime()) || time.getStartTime().after(endDateCal.getTime())) continue;
                    int dayCode = 0;
                    c.setTime(time.getStartTime());
                    int m = c.get(2);
                    int d = c.get(5);
                    if (c.get(1) < sessionYear) {
                        m -= 12 * (sessionYear - c.get(1));
                    }
                    if (c.get(1) > sessionYear) {
                        m += 12 * (c.get(1) - sessionYear);
                    }
                    BitSet weekCode = new BitSet(lastDOY - firstDOY);
                    int offset = room.getSession().getDayOfYear(d, m) - firstDOY;
                    weekCode.set(offset);
                    switch (c.get(7)) {
                        case 2: {
                            dayCode = Constants.DAY_CODES[0];
                            break;
                        }
                        case 3: {
                            dayCode = Constants.DAY_CODES[1];
                            break;
                        }
                        case 4: {
                            dayCode = Constants.DAY_CODES[2];
                            break;
                        }
                        case 5: {
                            dayCode = Constants.DAY_CODES[3];
                            break;
                        }
                        case 6: {
                            dayCode = Constants.DAY_CODES[4];
                            break;
                        }
                        case 7: {
                            dayCode = Constants.DAY_CODES[5];
                            break;
                        }
                        case 1: {
                            dayCode = Constants.DAY_CODES[6];
                        }
                    }
                    int startSlot = (c.get(11) * 60 + c.get(12) - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
                    c.setTime(time.getEndTime());
                    int endSlot = (c.get(11) * 60 + c.get(12) - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
                    int length = endSlot - startSlot;
                    if (length <= 0) continue;
                    TimeLocation timeLocation = new TimeLocation(dayCode, startSlot, length, 0, 0.0, null, df.format(time.getStartTime()), weekCode, 0);
                    TimetableGridCell cell = null;
                    TimeLocation.IntEnumeration f = timeLocation.getStartSlots();
                    while (f.hasMoreElements()) {
                        int slot = (Integer)f.nextElement();
                        if (context.getFirstDay() >= 0 && !timeLocation.getWeekCode().get(context.getFirstDay() + slot / 288)) continue;
                        cell = cell == null ? new TimetableGridCell(slot / 288, slot % 288, -1L, room.getUniqueId(), room.getLabel(), time.getEventName(), null, null, null, time.getEventName() + " (" + time.getEventType() + ")", TimetableGridCell.sBgColorNotAvailable, length, 0, 1, df.format(time.getStartTime()), weekCode, null, Constants.toTime(Constants.SLOT_LENGTH_MIN * startSlot + Constants.FIRST_SLOT_TIME_MIN) + " - " + Constants.toTime(Constants.SLOT_LENGTH_MIN * endSlot + Constants.FIRST_SLOT_TIME_MIN)) : cell.copyCell(slot / 288, cell.getMeetingNumber() + 1);
                        this.addCell(slot, cell);
                    }
                }
            }
        }
        this.setType(room instanceof Room ? ((Room)room).getRoomType().getUniqueId() : null);
    }

    public SolutionGridModel(String solutionIdsStr, DepartmentalInstructor instructor, org.hibernate.Session hibSession, TimetableGridContext context) {
        super(1, instructor.getUniqueId().intValue());
        Query q;
        this.setName(instructor.getLastName() + ", " + instructor.getFirstName() + (instructor.getMiddleName() == null ? "" : " " + instructor.getMiddleName()));
        this.setFirstDay(context.getFirstDay());
        Solution firstSolution = null;
        String ownerIds = "";
        StringTokenizer s = new StringTokenizer(solutionIdsStr, ",");
        while (s.hasMoreTokens()) {
            Long solutionId = Long.valueOf(s.nextToken());
            Solution solution = (Solution)new SolutionDAO().get(solutionId, hibSession);
            if (solution == null) continue;
            if (firstSolution == null) {
                firstSolution = solution;
            }
            if (ownerIds.length() > 0) {
                ownerIds = ownerIds + ",";
            }
            ownerIds = ownerIds + solution.getOwner().getUniqueId();
        }
        List commitedAssignments = null;
        if (ApplicationProperty.TimetableGridUseClassInstructors.isTrue()) {
            Query q2;
            String check = "";
            if (ApplicationProperty.TimetableGridUseClassInstructorsCheckLead.isTrue()) {
                check = check + " and i.lead = true";
            }
            if (ApplicationProperty.TimetableGridUseClassInstructorsCheckClassDisplayInstructors.isTrue()) {
                check = check + " and i.classInstructing.displayInstructor = true";
            }
            if (instructor.getExternalUniqueId() != null && !instructor.getExternalUniqueId().isEmpty()) {
                q2 = hibSession.createQuery("select distinct a from Assignment as a inner join a.clazz.classInstructors as i where a.solution.uniqueId in (" + solutionIdsStr + ") and i.instructor.externalUniqueId = :extId" + check);
                q2.setString("extId", instructor.getExternalUniqueId());
                q2.setCacheable(true);
                this.init(q2.list(), hibSession, context);
                q2 = hibSession.createQuery("select distinct a from ClassInstructor i inner join i.classInstructing.assignments as a where i.instructor.externalUniqueId = :extId and a.solution.commited = true and a.solution.owner.session.uniqueId = :sessionId and a.solution.owner.uniqueId not in (" + ownerIds + ")" + check);
                q2.setString("extId", instructor.getExternalUniqueId());
                q2.setLong("sessionId", instructor.getDepartment().getSession().getUniqueId().longValue());
                q2.setCacheable(true);
                commitedAssignments = q2.list();
            } else {
                q2 = hibSession.createQuery("select distinct a from Assignment as a inner join a.clazz.classInstructors as i where a.solution.uniqueId in (" + solutionIdsStr + ") and i.instructor.uniqueId = :instructorId" + check);
                q2.setLong("instructorId", instructor.getUniqueId().longValue());
                q2.setCacheable(true);
                this.init(q2.list(), hibSession, context);
                q2 = hibSession.createQuery("select distinct a from ClassInstructor i inner join i.classInstructing.assignments as a where i.instructor.uniqueId = :instructorId and a.solution.commited = true and a.solution.owner.session.uniqueId = :sessionId and a.solution.owner.uniqueId not in (" + ownerIds + ")" + check);
                q2.setLong("instructorId", instructor.getUniqueId().longValue());
                q2.setLong("sessionId", instructor.getDepartment().getSession().getUniqueId().longValue());
                q2.setCacheable(true);
                commitedAssignments = q2.list();
            }
        } else if (instructor.getExternalUniqueId() != null && instructor.getExternalUniqueId().length() > 0) {
            q = hibSession.createQuery("select distinct a from Assignment as a inner join a.instructors as i where a.solution.uniqueId in (" + solutionIdsStr + ") and i.externalUniqueId=:puid");
            q.setString("puid", instructor.getExternalUniqueId());
            q.setCacheable(true);
            this.init(q.list(), hibSession, context);
            q = hibSession.createQuery("select distinct a from DepartmentalInstructor i inner join i.assignments as a where i.externalUniqueId=:puid and a.solution.commited=true and a.solution.owner.session.uniqueId=:sessionId and a.solution.owner.uniqueId not in (" + ownerIds + ")");
            q.setString("puid", instructor.getExternalUniqueId());
            q.setLong("sessionId", instructor.getDepartment().getSession().getUniqueId().longValue());
            q.setCacheable(true);
            commitedAssignments = q.list();
        } else {
            q = hibSession.createQuery("select distinct a from Assignment as a inner join a.instructors as i where a.solution.uniqueId in (" + solutionIdsStr + ") and i.uniqueId=:resourceId");
            q.setLong("resourceId", instructor.getUniqueId().longValue());
            q.setCacheable(true);
            this.init(q.list(), hibSession, context);
            q = hibSession.createQuery("select distinct a from DepartmentalInstructor i inner join i.assignments as a where i.uniqueId=:instructorId and a.solution.commited=true and a.solution.owner.session.uniqueId=:sessionId and a.solution.owner.uniqueId not in (" + ownerIds + ")");
            q.setLong("instructorId", instructor.getUniqueId().longValue());
            q.setLong("sessionId", instructor.getDepartment().getSession().getUniqueId().longValue());
            q.setCacheable(true);
            commitedAssignments = q.list();
        }
        this.setUtilization(this.getUtilization() + this.countUtilization(context, commitedAssignments));
        for (Assignment a : commitedAssignments) {
            this.init(a, hibSession, context.getFirstDay(), -1);
        }
        if (context.isShowEvents() && RoomAvailability.getInstance() != null) {
            Calendar startDateCal = Calendar.getInstance(Locale.US);
            Session session = instructor.getDepartment().getSession();
            startDateCal.setTime(DateUtils.getDate(1, session.getStartMonth(), session.getSessionStartYear()));
            startDateCal.set(11, 0);
            startDateCal.set(12, 0);
            startDateCal.set(13, 0);
            Calendar endDateCal = Calendar.getInstance(Locale.US);
            endDateCal.setTime(DateUtils.getDate(0, session.getEndMonth() + 1, session.getSessionStartYear()));
            endDateCal.set(11, 23);
            endDateCal.set(12, 59);
            endDateCal.set(13, 59);
            Collection<RoomAvailabilityInterface.TimeBlock> times = RoomAvailability.getInstance().getInstructorAvailability(instructor.getUniqueId(), startDateCal.getTime(), endDateCal.getTime(), RoomAvailabilityInterface.sClassType);
            if (times != null) {
                int sessionYear = session.getSessionStartYear();
                int firstDOY = session.getDayOfYear(1, session.getPatternStartMonth());
                int lastDOY = session.getDayOfYear(0, session.getPatternEndMonth() + 1);
                Calendar c = Calendar.getInstance(Locale.US);
                Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT);
                for (RoomAvailabilityInterface.TimeBlock time : times) {
                    if (time.getEndTime().before(startDateCal.getTime()) || time.getStartTime().after(endDateCal.getTime())) continue;
                    int dayCode = 0;
                    c.setTime(time.getStartTime());
                    int m = c.get(2);
                    int d = c.get(5);
                    if (c.get(1) < sessionYear) {
                        m -= 12 * (sessionYear - c.get(1));
                    }
                    if (c.get(1) > sessionYear) {
                        m += 12 * (c.get(1) - sessionYear);
                    }
                    BitSet weekCode = new BitSet(lastDOY - firstDOY);
                    int offset = session.getDayOfYear(d, m) - firstDOY;
                    weekCode.set(offset);
                    switch (c.get(7)) {
                        case 2: {
                            dayCode = Constants.DAY_CODES[0];
                            break;
                        }
                        case 3: {
                            dayCode = Constants.DAY_CODES[1];
                            break;
                        }
                        case 4: {
                            dayCode = Constants.DAY_CODES[2];
                            break;
                        }
                        case 5: {
                            dayCode = Constants.DAY_CODES[3];
                            break;
                        }
                        case 6: {
                            dayCode = Constants.DAY_CODES[4];
                            break;
                        }
                        case 7: {
                            dayCode = Constants.DAY_CODES[5];
                            break;
                        }
                        case 1: {
                            dayCode = Constants.DAY_CODES[6];
                        }
                    }
                    int startSlot = (c.get(11) * 60 + c.get(12) - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
                    c.setTime(time.getEndTime());
                    int endSlot = (c.get(11) * 60 + c.get(12) - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
                    int length = endSlot - startSlot;
                    if (length <= 0) continue;
                    TimeLocation timeLocation = new TimeLocation(dayCode, startSlot, length, 0, 0.0, null, df.format(time.getStartTime()), weekCode, 0);
                    TimetableGridCell cell = null;
                    TimeLocation.IntEnumeration f = timeLocation.getStartSlots();
                    while (f.hasMoreElements()) {
                        int slot = (Integer)f.nextElement();
                        if (context.getFirstDay() >= 0 && !timeLocation.getWeekCode().get(context.getFirstDay() + slot / 288)) continue;
                        cell = cell == null ? new TimetableGridCell(slot / 288, slot % 288, -1L, -1L, null, time.getEventName(), null, null, null, time.getEventName() + " (" + time.getEventType() + ")", TimetableGridCell.sBgColorNotAvailable, length, 0, 1, df.format(time.getStartTime()), weekCode, null, Constants.toTime(Constants.SLOT_LENGTH_MIN * startSlot + Constants.FIRST_SLOT_TIME_MIN) + " - " + Constants.toTime(Constants.SLOT_LENGTH_MIN * endSlot + Constants.FIRST_SLOT_TIME_MIN)) : cell.copyCell(slot / 288, cell.getMeetingNumber() + 1);
                        this.addCell(slot, cell);
                    }
                }
            }
        }
        if (instructor.getPositionType() != null) {
            this.setType(new Long(instructor.getPositionType().getSortOrder().intValue()));
        }
    }

    public SolutionGridModel(String solutionIdsStr, Department dept, org.hibernate.Session hibSession, TimetableGridContext context) {
        super(2, dept.getUniqueId());
        this.setName(dept.getShortLabel());
        this.setFirstDay(context.getFirstDay());
        Query q = hibSession.createQuery("select distinct a from Assignment as a inner join a.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings as o inner join o.subjectArea.department as d where a.solution.uniqueId in (" + solutionIdsStr + ") and d.uniqueId=:resourceId and o.isControl=true");
        q.setCacheable(true);
        q.setLong("resourceId", dept.getUniqueId().longValue());
        List a = q.list();
        this.setSize(a.size());
        this.init(a, hibSession, context);
    }

    public SolutionGridModel(String solutionIdsStr, SubjectArea sa, org.hibernate.Session hibSession, TimetableGridContext context) {
        super(4, sa.getUniqueId());
        this.setName(sa.getSubjectAreaAbbreviation());
        this.setFirstDay(context.getFirstDay());
        Query q = hibSession.createQuery("select distinct a from Assignment as a inner join a.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings as o inner join o.subjectArea as sa where a.solution.uniqueId in (" + solutionIdsStr + ") and sa.uniqueId=:resourceId and o.isControl=true");
        q.setCacheable(true);
        q.setLong("resourceId", sa.getUniqueId().longValue());
        List a = q.list();
        this.setSize(a.size());
        this.init(a, hibSession, context);
    }

    public SolutionGridModel(String solutionIdsStr, CurriculumClassification cc, org.hibernate.Session hibSession, TimetableGridContext context) {
        super(3, cc.getUniqueId());
        this.setName(cc.getCurriculum().getAbbv() + " " + cc.getName());
        this.setFirstDay(context.getFirstDay());
        Query q = hibSession.createQuery("select distinct a from CurriculumClassification cc inner join cc.courses cx, Assignment a inner join a.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where a.solution.uniqueId in (" + solutionIdsStr + ") and cc.uniqueId=:resourceId and cx.course = co");
        q.setCacheable(true);
        q.setLong("resourceId", cc.getUniqueId().longValue());
        List a = q.list();
        Hashtable<Long, Set[]> restrictions = new Hashtable<Long, Set[]>();
        for (Object[] o : hibSession.createQuery("select distinct cc.course.instructionalOffering.uniqueId, (case when g.uniqueId is null then x.uniqueId else g.uniqueId end), z.uniqueId from CurriculumReservation r inner join r.areas ra left outer join r.configurations g left outer join r.classes z left outer join z.schedulingSubpart.instrOfferingConfig x left outer join r.majors rm left outer join r.classifications rc, CurriculumCourse cc inner join cc.classification.curriculum.majors cm where cc.classification.uniqueId = :resourceId and cc.course.instructionalOffering = r.instructionalOffering and ra = cc.classification.curriculum.academicArea and (rm is null or rm = cm) and (rc is null or rc = cc.classification.academicClassification)").setLong("resourceId", cc.getUniqueId().longValue()).setCacheable(true).list()) {
            Long offeringId = (Long)o[0];
            Long configId = (Long)o[1];
            Long clazzId = (Long)o[2];
            Set[] r = (Set[])restrictions.get(offeringId);
            if (r == null) {
                r = new Set[]{new HashSet(), new HashSet()};
                restrictions.put(offeringId, r);
            }
            if (configId != null) {
                r[0].add(configId);
            }
            if (clazzId == null) continue;
            r[1].add(clazzId);
        }
        if (!restrictions.isEmpty()) {
            Iterator i = a.iterator();
            while (i.hasNext()) {
                Assignment asgn = (Assignment)i.next();
                Set[] r = restrictions == null ? null : (Set[])restrictions.get(asgn.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getUniqueId());
                if (r == null || !EventLookupBackend.hide(r, asgn.getClazz())) continue;
                i.remove();
            }
        }
        this.setSize(a.size());
        this.init(a, hibSession, context);
    }

    public SolutionGridModel(String solutionIdsStr, StudentGroup g, org.hibernate.Session hibSession, TimetableGridContext context) {
        super(5, g.getUniqueId());
        this.setName(g.getGroupAbbreviation());
        this.setFirstDay(context.getFirstDay());
        Query q = hibSession.createQuery("select distinct a from StudentGroupReservation r, Assignment a inner join a.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering as io where a.solution.uniqueId in (" + solutionIdsStr + ") and io = r.instructionalOffering and r.group.uniqueId=:resourceId");
        q.setCacheable(true);
        q.setLong("resourceId", g.getUniqueId().longValue());
        List a = q.list();
        Hashtable<Long, Set[]> restrictions = new Hashtable<Long, Set[]>();
        for (Object[] o : hibSession.createQuery("select distinct r.instructionalOffering.uniqueId, (case when g.uniqueId is null then x.uniqueId else g.uniqueId end), z.uniqueId from StudentGroupReservation r left outer join r.configurations g left outer join r.classes z left outer join z.schedulingSubpart.instrOfferingConfig x where r.group.uniqueId = :resourceId").setLong("resourceId", g.getUniqueId().longValue()).setCacheable(true).list()) {
            Long offeringId = (Long)o[0];
            Long configId = (Long)o[1];
            Long clazzId = (Long)o[2];
            Set[] r = (Set[])restrictions.get(offeringId);
            if (r == null) {
                r = new Set[]{new HashSet(), new HashSet()};
                restrictions.put(offeringId, r);
            }
            if (configId != null) {
                r[0].add(configId);
            }
            if (clazzId == null) continue;
            r[1].add(clazzId);
        }
        if (!restrictions.isEmpty()) {
            Iterator i = a.iterator();
            while (i.hasNext()) {
                Assignment asgn = (Assignment)i.next();
                Set[] r = restrictions == null ? null : (Set[])restrictions.get(asgn.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getUniqueId());
                if (r == null || !EventLookupBackend.hide(r, asgn.getClazz())) continue;
                i.remove();
            }
        }
        this.setSize(a.size());
        this.init(a, hibSession, context);
    }

    public SolutionGridModel(String solutionIdsStr, StudentGroupInfo g, org.hibernate.Session hibSession, TimetableGridContext context) {
        super(5, g.getGroupId());
        this.setName(g.getGroupName());
        this.setFirstDay(context.getFirstDay());
        ArrayList<Long> classIds = new ArrayList<Long>();
        for (StudentGroupInfo.ClassInfo clazz : g.getGroupAssignments()) {
            classIds.add(clazz.getClassId());
        }
        if (classIds.isEmpty()) {
            return;
        }
        Query q = hibSession.createQuery("select distinct a from Assignment a where a.solution.uniqueId in (" + solutionIdsStr + ") and a.classId in (:classIds)");
        q.setParameterList("classIds", classIds, (Type)new LongType());
        q.setCacheable(true);
        List a = q.list();
        this.setSize((int)Math.round(g.countStudentWeights()));
        for (Assignment assignment : a) {
            StudentGroupInfo.ClassInfo ci = g.getGroupAssignment(assignment.getClassId());
            if (ci == null) continue;
            int total = g.countStudentsOfOffering(assignment.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getUniqueId());
            for (TimetableGridCell cell = this.init(assignment, hibSession, context.getFirstDay(), context.getBgMode()); cell != null; cell = cell.getParent()) {
                int maxLimit;
                cell.setRoomName(cell.getRoomName() + " (" + Math.round(ci.countStudentsWeight()) + ")");
                if (ci.getStudents() == null || ci.getStudents().isEmpty() || total <= 1) continue;
                int assigned = ci.getStudents().size();
                int minLimit = assignment.getClazz().getExpectedCapacity();
                int limit = maxLimit = assignment.getClazz().getMaxExpectedCapacity().intValue();
                if (minLimit < maxLimit) {
                    int roomLimit = (int)Math.floor((float)assignment.getPlacement().getRoomSize() / (assignment.getClazz().getRoomRatio() == null ? 1.0f : assignment.getClazz().getRoomRatio().floatValue()));
                    limit = Math.min(Math.max(minLimit, roomLimit), maxLimit);
                }
                if (assignment.getClazz().getSchedulingSubpart().getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue() || limit >= 9999) {
                    limit = Integer.MAX_VALUE;
                }
                int p = 100 * assigned / Math.min(limit, total);
                cell.setBackground(TimetableGridCell.percentage2color(p));
                cell.setShortComment("<span style='color:rgb(200,200,200)'>" + assigned + " of " + total + "</span>");
                cell.setShortCommentNoColors(assigned + " of " + total);
            }
        }
        this.setUtilization(g.getGroupValue());
    }

    private void init(List assignments, org.hibernate.Session hibSession, TimetableGridContext context) {
        for (Assignment assignment : assignments) {
            this.init(assignment, hibSession, context.getFirstDay(), context.getBgMode());
        }
        this.setUtilization(this.countUtilization(context, assignments));
    }

    public TimetableGridCell init(Assignment assignment, org.hibernate.Session hibSession, int firstDay, int bgMode) {
        TimetableGridCell cell = null;
        int days = assignment.getDays();
        int start = assignment.getStartSlot();
        BitSet weekCode = assignment.getDatePattern() == null ? null : assignment.getDatePattern().getPatternBitSet();
        for (int j = 0; j < Constants.DAY_CODES.length; ++j) {
            int day;
            if ((Constants.DAY_CODES[j] & days) == 0 || firstDay >= 0 && !weekCode.get(day = firstDay + j)) continue;
            if (cell == null) {
                cell = this.createCell(j, start, hibSession, assignment, bgMode);
            } else {
                cell = cell.copyCell(j, cell.getMeetingNumber() + 1);
                cell.setDays(TimetableGridCell.formatDatePattern(assignment.getDatePattern(), Constants.DAY_CODES[j]));
            }
            this.addCell(j, start, cell);
        }
        return cell;
    }

    public static String hardConflicts2pref(AssignmentPreferenceInfo assignmentInfo) {
        if (assignmentInfo == null) {
            return PreferenceLevel.sNeutral;
        }
        String pref = PreferenceLevel.sNeutral;
        pref = assignmentInfo.getNrRoomLocations() == 1 && assignmentInfo.getNrTimeLocations() == 1 ? PreferenceLevel.sRequired : (assignmentInfo.getNrSameTimePlacementsNoConf() > 0 ? PreferenceLevel.sStronglyPreferred : (assignmentInfo.getNrTimeLocations() > 1 && assignmentInfo.getNrSameRoomPlacementsNoConf() > 0 ? PreferenceLevel.sProhibited : (assignmentInfo.getNrTimeLocations() > 1 ? PreferenceLevel.sNeutral : (assignmentInfo.getNrSameRoomPlacementsNoConf() > 0 ? PreferenceLevel.sDiscouraged : (assignmentInfo.getNrRoomLocations() > 1 ? PreferenceLevel.sStronglyDiscouraged : PreferenceLevel.sRequired)))));
        return pref;
    }

    private TimetableGridCell createCell(int day, int slot, org.hibernate.Session hibSession, Assignment assignment, int bgMode) {
        String name = assignment.getClassName();
        String title = "";
        int length = assignment.getTimePattern().getSlotsPerMtg();
        int nrMeetings = assignment.getTimePattern().getNrMeetings();
        if (assignment.getTimePattern().getType() == 5) {
            DurationModel dm = assignment.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getDurationModel();
            int minsPerMeeting = dm.getExactTimeMinutesPerMeeting(assignment.getClazz().getSchedulingSubpart().getMinutesPerWk(), assignment.getDatePattern(), assignment.getDays());
            length = ExactTimeMins.getNrSlotsPerMtg(minsPerMeeting);
            nrMeetings = DayCode.nrDays(assignment.getDays());
        }
        String shortComment = null;
        String shortCommentNoColor = null;
        String onClick = "showGwtDialog('Suggestions', 'suggestions.do?id=" + assignment.getClassId() + "&op=Reset','900','90%');";
        String background = null;
        StringBuffer roomName = new StringBuffer();
        for (Location r : assignment.getRooms()) {
            if (roomName.length() > 0) {
                roomName.append(",");
            }
            roomName.append(r.getLabel());
        }
        if (bgMode == 0) {
            background = TimetableGridCell.sBgColorNeutral;
        }
        if (bgMode == -1) {
            background = TimetableGridCell.sBgColorNotAvailable;
        }
        AssignmentPreferenceInfo assignmentInfo = null;
        if (bgMode != -1) {
            try {
                assignmentInfo = (AssignmentPreferenceInfo)assignment.getAssignmentInfo("AssignmentInfo");
            }
            catch (Exception e) {
                Debug.error(e);
            }
        }
        if (assignmentInfo != null) {
            int roomPref;
            int n = roomPref = this.iRoomId == null ? assignmentInfo.combineRoomPreference() : assignmentInfo.getRoomPreference(this.iRoomId);
            if (bgMode == 1) {
                background = TimetableGridCell.pref2color(assignmentInfo.getTimePreference());
            } else if (bgMode == 2) {
                background = TimetableGridCell.pref2color(roomPref);
            } else if (bgMode == 3) {
                background = TimetableGridCell.conflicts2color(assignmentInfo.getNrStudentConflicts());
            } else if (bgMode == 4) {
                background = TimetableGridCell.pref2color(assignmentInfo.getBtbInstructorPreference());
            } else if (bgMode == 6) {
                String pref = PreferenceLevel.sNeutral;
                if (assignmentInfo.getInitialAssignment() != null) {
                    pref = assignmentInfo.getIsInitial() ? PreferenceLevel.sStronglyPreferred : (assignmentInfo.getHasInitialSameTime() ? PreferenceLevel.sDiscouraged : (assignmentInfo.getHasInitialSameRoom() ? PreferenceLevel.sStronglyDiscouraged : PreferenceLevel.sProhibited));
                }
                background = TimetableGridCell.pref2color(pref);
            } else if (bgMode == 7) {
                background = TimetableGridCell.conflicts2color((int)Math.ceil(assignmentInfo.getPerturbationPenalty()));
            } else if (bgMode == 8) {
                background = TimetableGridCell.pref2color(SolutionGridModel.hardConflicts2pref(assignmentInfo));
            } else if (bgMode == 9) {
                background = TimetableGridCell.conflicts2colorFast(assignmentInfo.getMaxDeptBalancPenalty());
            } else if (bgMode == 10) {
                int roomCap = assignment.getClazz().getMinRoomLimit();
                long minRoomSize = assignmentInfo.getMinRoomSize();
                int roomSize = 0;
                for (Location r : assignment.getRooms()) {
                    roomSize += r.getCapacity().intValue();
                }
                background = roomSize < roomCap ? TimetableGridCell.pref2color(PreferenceLevel.sRequired) : TimetableGridCell.pref2color(assignmentInfo.getTooBigRoomPreference());
                if (!assignment.getRooms().isEmpty()) {
                    shortComment = "<span style='color:rgb(200,200,200)'>" + (assignmentInfo.getNrRoomLocations() == 1 ? "<u>" : "") + roomCap + " / " + (minRoomSize == Integer.MAX_VALUE ? "-" : String.valueOf(minRoomSize)) + " / " + roomSize + (assignmentInfo.getNrRoomLocations() == 1 ? "</u>" : "") + "</span>";
                    shortCommentNoColor = roomCap + " / " + (minRoomSize == Integer.MAX_VALUE ? "-" : String.valueOf(minRoomSize)) + " / " + roomSize;
                }
            } else if (bgMode == 11) {
                if (assignmentInfo.getStudentGroupPercent() != null) {
                    background = TimetableGridCell.percentage2color(assignmentInfo.getStudentGroupPercent());
                }
                if (assignmentInfo.getStudentGroupComment() != null) {
                    shortCommentNoColor = assignmentInfo.getStudentGroupComment();
                    shortComment = "<span style='color:rgb(200,200,200)'>" + shortCommentNoColor + "</span>";
                }
            }
            if (shortComment == null) {
                shortComment = "<span style='color:rgb(200,200,200)'>" + (assignmentInfo.getBestNormalizedTimePreference() < assignmentInfo.getNormalizedTimePreference() ? "<span style='color:red'>" + (int)(assignmentInfo.getNormalizedTimePreference() - assignmentInfo.getBestNormalizedTimePreference()) + "</span>" : "" + (int)(assignmentInfo.getNormalizedTimePreference() - assignmentInfo.getBestNormalizedTimePreference())) + ", " + (assignmentInfo.getNrStudentConflicts() > 0 ? "<span style='color:rgb(20,130,10)'>" + assignmentInfo.getNrStudentConflicts() + "</span>" : "" + assignmentInfo.getNrStudentConflicts()) + ", " + (assignmentInfo.getBestRoomPreference() < roomPref ? "<span style='color:blue'>" + (roomPref - assignmentInfo.getBestRoomPreference()) + "</span>" : "" + (roomPref - assignmentInfo.getBestRoomPreference())) + "</span>";
            }
            if (shortCommentNoColor == null) {
                shortCommentNoColor = (int)(assignmentInfo.getNormalizedTimePreference() - assignmentInfo.getBestNormalizedTimePreference()) + ", " + assignmentInfo.getNrStudentConflicts() + ", " + (roomPref - assignmentInfo.getBestRoomPreference());
            }
            title = "Time preference: " + (int)assignmentInfo.getNormalizedTimePreference() + "<br>Student conflicts: " + assignmentInfo.getNrStudentConflicts() + " [committed:" + assignmentInfo.getNrCommitedStudentConflicts() + ", distance:" + assignmentInfo.getNrDistanceStudentConflicts() + ", hard:" + assignmentInfo.getNrHardStudentConflicts() + "]<br>Room preference: " + roomPref + "<br>Back-to-back instructor pref.: " + assignmentInfo.getBtbInstructorPreference() + "<br>" + (assignmentInfo.getInitialAssignment() != null ? "Initial assignment: " + (assignmentInfo.getIsInitial() ? "<i>current assignment</i>" : assignmentInfo.getInitialAssignment()) + "<br>" : "") + (assignmentInfo.getInitialAssignment() != null ? "Perturbation penalty: " + sDF.format(assignmentInfo.getPerturbationPenalty()) + "<br>" : "") + "Non-conflicting placements: " + assignmentInfo.getNrPlacementsNoConf() + "<br>Department balance: " + assignmentInfo.getDeptBalancPenalty();
        } else {
            title = assignment.getClassName() + " (" + assignment.getSolution().getOwner().getName() + ")";
        }
        if (bgMode == 5) {
            Vector constraintInfos = new Vector();
            try {
                constraintInfos = assignment.getConstraintInfos("DistributionInfo");
            }
            catch (Exception e) {
                Debug.error(e);
            }
            if (constraintInfos != null) {
                PreferenceCombination pref = PreferenceCombination.getDefault();
                Enumeration e = constraintInfos.elements();
                while (e.hasMoreElements()) {
                    GroupConstraintInfo gcInfo = (GroupConstraintInfo)e.nextElement();
                    if (gcInfo.isSatisfied()) continue;
                    if (PreferenceLevel.sRequired.equals(gcInfo.getPreference()) || PreferenceLevel.sProhibited.equals(gcInfo.getPreference())) {
                        pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                    }
                    pref.addPreferenceInt(Math.abs(PreferenceLevel.prolog2int(gcInfo.getPreference())));
                }
                title = title + "<br>Distribution preference: " + pref.getPreferenceProlog();
                background = TimetableGridCell.pref2color(pref.getPreferenceProlog());
            }
        }
        String instructors = null;
        if (ApplicationProperty.TimetableGridUseClassInstructors.isTrue()) {
            if (!ApplicationProperty.TimetableGridUseClassInstructorsCheckClassDisplayInstructors.isTrue() || assignment.getClazz().isDisplayInstructor().booleanValue()) {
                for (ClassInstructor instructor : assignment.getClazz().getClassInstructors()) {
                    if (!instructor.isLead().booleanValue() && ApplicationProperty.TimetableGridUseClassInstructorsCheckLead.isTrue()) continue;
                    instructors = instructors == null ? "" : instructors + ", ";
                    instructors = instructors + instructor.getInstructor().getName(DepartmentalInstructor.sNameFormatShort);
                }
            }
        } else {
            for (DepartmentalInstructor instructor : assignment.getInstructors()) {
                instructors = instructors == null ? "" : instructors + ", ";
                instructors = instructors + instructor.getName(DepartmentalInstructor.sNameFormatShort);
            }
        }
        String time = Constants.toTime(assignment.getStartSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN) + " - " + Constants.toTime((assignment.getStartSlot() + assignment.getSlotPerMtg()) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN - assignment.getBreakTime());
        return new TimetableGridCell(day, slot, assignment.getUniqueId().intValue(), this.iRoomId == null ? 0 : this.iRoomId.intValue(), roomName.toString(), name, shortComment, shortCommentNoColor, bgMode == -1 ? null : onClick, title, background, length, 0, nrMeetings, TimetableGridCell.formatDatePattern(assignment.getDatePattern(), Constants.DAY_CODES[day]), assignment.getDatePattern().getPatternBitSet(), instructors, time);
    }

    private double countUtilization(TimetableGridContext context, List assignments) {
        HashSet<Integer> slots = new HashSet<Integer>();
        for (Assignment assignment : assignments) {
            int slot;
            int dow;
            int idx;
            int stop;
            int start;
            TimeLocation t = assignment == null ? null : assignment.getTimeLocation();
            if (t == null || (start = Math.max(context.getFirstSlot(), t.getStartSlot())) > (stop = Math.min(context.getLastSlot(), t.getStartSlot() + t.getLength() - 1))) continue;
            if (context.getFirstDay() >= 0) {
                for (idx = context.getFirstDay(); idx < 7 + context.getFirstDay(); ++idx) {
                    dow = (idx + context.getStartDayDayOfWeek()) % 7;
                    if (!t.getWeekCode().get(idx) || (t.getDayCode() & Constants.DAY_CODES[dow]) == 0 || (context.getDayCode() & Constants.DAY_CODES[dow]) == 0) continue;
                    for (slot = start; slot <= stop; ++slot) {
                        slots.add(288 * idx + slot);
                    }
                }
                continue;
            }
            idx = -1;
            while ((idx = t.getWeekCode().nextSetBit(1 + idx)) >= 0) {
                dow = (idx + context.getStartDayDayOfWeek()) % 7;
                if (!context.getDefaultDatePattern().get(idx) || (t.getDayCode() & Constants.DAY_CODES[dow]) == 0 || (context.getDayCode() & Constants.DAY_CODES[dow]) == 0) continue;
                for (slot = start; slot <= stop; ++slot) {
                    slots.add(288 * idx + slot);
                }
            }
        }
        return (float)slots.size() / context.getNumberOfWeeks();
    }
}

