/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.solver;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.CourseTimetablingSolverInterface;
import org.unitime.timetable.gwt.shared.SolverInterface;
import org.unitime.timetable.gwt.shared.TableInterface;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.SolutionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.solver.SolverPageBackend;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.TimetableSolver;
import org.unitime.timetable.solver.interactive.ClassAssignmentDetails;
import org.unitime.timetable.solver.interactive.SuggestionsModel;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.ui.AssignmentPreferenceInfo;
import org.unitime.timetable.webutil.BackTracker;

@GwtRpcImplements(value=CourseTimetablingSolverInterface.SolutionChangesRequest.class)
public class SolutionChangesBackend
implements GwtRpcImplementation<CourseTimetablingSolverInterface.SolutionChangesRequest, CourseTimetablingSolverInterface.SolutionChangesResponse> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    protected static DecimalFormat sDF = new DecimalFormat("0.###", new DecimalFormatSymbols(Locale.US));
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;

    @Override
    public CourseTimetablingSolverInterface.SolutionChangesResponse execute(CourseTimetablingSolverInterface.SolutionChangesRequest request, SessionContext context) {
        context.checkPermission(Right.SolutionChanges);
        CourseTimetablingSolverInterface.SolutionChangesResponse response = new CourseTimetablingSolverInterface.SolutionChangesResponse();
        context.getUser().setProperty("SuggestionsModel.simpleMode", request.getFilter().getParameterValue("simpleMode"));
        boolean simple = "1".equals(request.getFilter().getParameterValue("simpleMode"));
        SuggestionsModel model = (SuggestionsModel)context.getAttribute(SessionAttribute.SuggestionsModel);
        if (model != null) {
            model.setSimpleMode(simple);
        }
        context.getUser().setProperty("SolutionChanges.reference", request.getFilter().getParameterValue("reference"));
        int reference = Integer.valueOf(request.getFilter().getParameterValue("reference"));
        context.getUser().setProperty("SolutionChanges.reversedMode", request.getFilter().getParameterValue("reversedMode"));
        boolean reversed = "1".equals(request.getFilter().getParameterValue("reversedMode"));
        SolverProxy solver = this.courseTimetablingSolverService.getSolver();
        List<TimetableSolver.RecordedAssignment> changes = null;
        if (solver == null) {
            response.setMessage(MESSAGES.errorNoSolverLoaded());
        } else if (reference == 0) {
            if (solver.bestSolutionInfo() == null) {
                response.setMessage(MESSAGES.errorNoBestSolutionSaved());
            } else {
                changes = solver.getChangesToBest();
            }
        } else if (reference == 1) {
            changes = solver.getChangesToInitial();
        } else if (reference == 2) {
            String solutionIdsStr = (String)context.getAttribute(SessionAttribute.SelectedSolution);
            if (solutionIdsStr == null || solutionIdsStr.isEmpty()) {
                response.setMessage(MESSAGES.errorNoSolutionSelected());
            } else {
                changes = new ArrayList<TimetableSolver.RecordedAssignment>();
                StringTokenizer s = new StringTokenizer(solutionIdsStr, ",");
                while (s.hasMoreTokens()) {
                    Long solutionId = Long.valueOf(s.nextToken());
                    List<TimetableSolver.RecordedAssignment> ch = solver.getChangesToSolution(solutionId);
                    if (ch == null) continue;
                    changes.addAll(ch);
                }
            }
        } else {
            changes = new ArrayList<TimetableSolver.RecordedAssignment>();
            boolean hasCommittedSolution = false;
            for (Long ownerId : solver.getProperties().getPropertyLongArry("General.SolverGroupId", null)) {
                Long solutionId = (Long)SolutionDAO.getInstance().getSession().createQuery("select uniqueId from Solution where owner.uniqueId = :ownerId and commited = true").setLong("ownerId", ownerId.longValue()).setMaxResults(1).uniqueResult();
                if (solutionId == null) continue;
                hasCommittedSolution = true;
                List<TimetableSolver.RecordedAssignment> ch = solver.getChangesToSolution(solutionId);
                if (ch == null) continue;
                changes.addAll(ch);
            }
            if (!hasCommittedSolution) {
                response.setMessage(MESSAGES.errorListSolutionsNoCommitted());
            }
        }
        if (changes != null) {
            for (TimetableSolver.RecordedAssignment assignment : changes) {
                AssignmentPreferenceInfo aInf;
                ClassAssignmentDetails after;
                ClassAssignmentDetails before = assignment.getBefore() == null ? null : assignment.getBefore().getDetails(context, solver, false);
                ClassAssignmentDetails classAssignmentDetails = after = assignment.getAfter() == null ? null : assignment.getAfter().getDetails(context, solver, false);
                if (reversed) {
                    ClassAssignmentDetails x = after;
                    after = before;
                    before = x;
                }
                ClassAssignmentDetails ca = after == null ? before : after;
                TableInterface.TableCellChange date = new TableInterface.TableCellChange(before == null || before.getTime() == null ? null : new TableInterface.TableCellInterface<String>(before.getTime().getDatePatternName()).setColor(PreferenceLevel.int2color(before.getTime().getDatePatternPreference())), after == null || after.getTime() == null ? null : new TableInterface.TableCellInterface<String>(after.getTime().getDatePatternName()).setColor(PreferenceLevel.int2color(after.getTime().getDatePatternPreference())));
                TableInterface.TableCellChange time = new TableInterface.TableCellChange(before == null || before.getTime() == null ? null : new TableInterface.TableCellTime(before.getTime().getDaysName() + " " + before.getTime().getStartTime() + " - " + before.getTime().getEndTime()).setId(before.getClazz().getClassId() + "," + before.getTime().getDays() + "," + before.getTime().getStartSlot()).setColor(PreferenceLevel.int2color(before.getTime().getPref())), after == null || after.getTime() == null ? null : new TableInterface.TableCellTime(after.getTime().getDaysName() + " " + after.getTime().getStartTime() + " - " + after.getTime().getEndTime()).setId(after.getClazz().getClassId() + "," + after.getTime().getDays() + "," + after.getTime().getStartSlot()).setColor(PreferenceLevel.int2color(after.getTime().getPref())));
                String link = "id=" + ca.getClazz().getClassId();
                if (before != null) {
                    link = link + "&days=" + before.getTime().getDays() + "&slot=" + before.getTime().getStartSlot() + "&pid=" + before.getTime().getPatternId() + "&did=" + before.getTime().getDatePatternId();
                }
                TableInterface.TableCellChange room = new TableInterface.TableCellChange();
                if (before != null && before.getRoom() != null) {
                    TableInterface.TableCellRooms beforeRooms = new TableInterface.TableCellRooms();
                    String rid = "";
                    for (int i = 0; i < before.getRoom().length; ++i) {
                        rid = rid + (i > 0 ? "," : "") + before.getRoom()[i].getId();
                        beforeRooms.add(before.getRoom()[i].getName(), before.getRoom()[i].getColor(), before.getRoom()[i].getId(), PreferenceLevel.int2string(before.getRoom()[i].getPref()));
                    }
                    room.setFirst(beforeRooms);
                    link = link + "&room=" + rid;
                    if (before.getRoom().length == 0 && after == null) {
                        room.setSecond(new TableInterface.TableCellRooms());
                    }
                }
                if (after != null && after.getRoom() != null) {
                    TableInterface.TableCellRooms afterRooms = new TableInterface.TableCellRooms();
                    for (int i = 0; i < after.getRoom().length; ++i) {
                        afterRooms.add(after.getRoom()[i].getName(), after.getRoom()[i].getColor(), after.getRoom()[i].getId(), PreferenceLevel.int2string(after.getRoom()[i].getPref()));
                    }
                    room.setSecond(afterRooms);
                    if (after.getRoom().length == 0 && before == null) {
                        room.setFirst(new TableInterface.TableCellRooms());
                    }
                }
                TableInterface.TableCellItems instructor = new TableInterface.TableCellItems();
                if (ca.getInstructor() != null) {
                    for (int i = 0; i < ca.getInstructor().length; ++i) {
                        instructor.add(ca.getInstructor()[i].getName(), ca.getInstructor()[i].getColor(), ca.getInstructor()[i].getId());
                    }
                }
                AssignmentPreferenceInfo bInf = before == null ? null : before.getInfo();
                AssignmentPreferenceInfo assignmentPreferenceInfo = aInf = after == null ? null : after.getInfo();
                if (aInf == null) {
                    aInf = new AssignmentPreferenceInfo();
                }
                if (bInf == null) {
                    bInf = new AssignmentPreferenceInfo();
                }
                TableInterface.TableCellMulti studentConfs = new TableInterface.TableCellMulti();
                studentConfs.add(this.dispNumber(aInf.getNrStudentConflicts() - bInf.getNrStudentConflicts()));
                if (aInf.getNrCommitedStudentConflicts() - bInf.getNrCommitedStudentConflicts() != 0) {
                    if (studentConfs.getNrChunks() <= 1) {
                        studentConfs.add(" (");
                    } else {
                        studentConfs.add(",");
                    }
                    studentConfs.add(this.dispNumber(aInf.getNrCommitedStudentConflicts() - bInf.getNrCommitedStudentConflicts()).setFormattedValue("c" + (aInf.getNrCommitedStudentConflicts() - bInf.getNrCommitedStudentConflicts())));
                }
                if (aInf.getNrDistanceStudentConflicts() - bInf.getNrDistanceStudentConflicts() != 0) {
                    if (studentConfs.getNrChunks() <= 1) {
                        studentConfs.add(" (");
                    } else {
                        studentConfs.add(",");
                    }
                    studentConfs.add(this.dispNumber(aInf.getNrDistanceStudentConflicts() - bInf.getNrDistanceStudentConflicts()).setFormattedValue("d" + (aInf.getNrDistanceStudentConflicts() - bInf.getNrDistanceStudentConflicts())));
                }
                if (aInf.getNrHardStudentConflicts() - bInf.getNrHardStudentConflicts() != 0) {
                    if (studentConfs.getNrChunks() <= 1) {
                        studentConfs.add(" (");
                    } else {
                        studentConfs.add(",");
                    }
                    studentConfs.add(this.dispNumber(aInf.getNrHardStudentConflicts() - bInf.getNrHardStudentConflicts()).setFormattedValue("h" + (aInf.getNrHardStudentConflicts() - bInf.getNrHardStudentConflicts())));
                }
                if (studentConfs.getNrChunks() > 1) {
                    studentConfs.add(")");
                }
                if (simple) {
                    response.addRow(new TableInterface.TableRowInterface(ca.getClazz().getClassId(), "gwt.jsp?page=suggestions&menu=hide&" + link, MESSAGES.dialogSuggestions(), new TableInterface.TableCellClassName(ca.getClazz().getName()).setColor(PreferenceLevel.prolog2color(ca.getClazz().getPref())), date, time, room, instructor, studentConfs));
                    continue;
                }
                response.addRow(new TableInterface.TableRowInterface(ca.getClazz().getClassId(), "gwt.jsp?page=suggestions&menu=hide&" + link, MESSAGES.dialogSuggestions(), new TableInterface.TableCellClassName(ca.getClazz().getName()).setColor(PreferenceLevel.prolog2color(ca.getClazz().getPref())), date, time, room, instructor, studentConfs, this.dispNumber(aInf.getTimePreference() - bInf.getTimePreference()), this.dispNumber(aInf.sumRoomPreference() - bInf.sumRoomPreference()), this.dispNumber(aInf.getGroupConstraintPref() - bInf.getGroupConstraintPref()), this.dispNumber(aInf.getBtbInstructorPreference() - bInf.getBtbInstructorPreference()), this.dispNumber(aInf.getUselessHalfHours() - bInf.getUselessHalfHours()), this.dispNumber(aInf.getTooBigRoomPreference() - bInf.getTooBigRoomPreference()), this.dispNumber(aInf.getDeptBalancPenalty() - bInf.getDeptBalancPenalty()), this.dispNumber(aInf.getSpreadPenalty() - bInf.getSpreadPenalty()), this.dispNumber(aInf.getPerturbationPenalty() - bInf.getPerturbationPenalty())));
            }
        }
        if (simple) {
            response.setHeader(new TableInterface.TableHeaderIterface(MESSAGES.colClass()), new TableInterface.TableHeaderIterface(MESSAGES.colDate()), new TableInterface.TableHeaderIterface(MESSAGES.colTime()), new TableInterface.TableHeaderIterface(MESSAGES.colRoom()), new TableInterface.TableHeaderIterface(MESSAGES.colInstructor()), new TableInterface.TableHeaderIterface(MESSAGES.colNrStudentConflicts()));
        } else {
            response.setHeader(new TableInterface.TableHeaderIterface(MESSAGES.colClass()), new TableInterface.TableHeaderIterface(MESSAGES.colDate()), new TableInterface.TableHeaderIterface(MESSAGES.colTime()), new TableInterface.TableHeaderIterface(MESSAGES.colRoom()), new TableInterface.TableHeaderIterface(MESSAGES.colInstructor()), new TableInterface.TableHeaderIterface(MESSAGES.colShortStudentConflicts()), new TableInterface.TableHeaderIterface(MESSAGES.colShortTimePref()), new TableInterface.TableHeaderIterface(MESSAGES.colShortRoomPref()), new TableInterface.TableHeaderIterface(MESSAGES.colShortDistPref()), new TableInterface.TableHeaderIterface(MESSAGES.colShortInstructorBtbPref()), new TableInterface.TableHeaderIterface(MESSAGES.colShortUselessHalfHours()), new TableInterface.TableHeaderIterface(MESSAGES.colShortTooBigRooms()), new TableInterface.TableHeaderIterface(MESSAGES.colShortDepartmentBalance()), new TableInterface.TableHeaderIterface(MESSAGES.colShortSameSubpartBalance()), new TableInterface.TableHeaderIterface(MESSAGES.colShortPerturbations()));
        }
        SolverPageBackend.fillSolverWarnings(context, solver, SolverInterface.SolverType.COURSE, response);
        BackTracker.markForBack(context, "gwt.jsp?page=solutionChanges", MESSAGES.pageSolutionChanges(), true, true);
        if (ApplicationProperty.TimeGridShowCrosslists.isTrue()) {
            SolutionChangesBackend.addCrosslistedNames(response, ApplicationProperty.SolverShowClassSufix.isTrue(), ApplicationProperty.SolverShowConfiguratioName.isTrue());
        }
        return response;
    }

    public TableInterface.TableCellInterface dispNumber(int value) {
        return new TableInterface.TableCellInterface<Integer>(value, value == 0 ? "" : (value <= 0 ? String.valueOf(value) : "+" + String.valueOf(value))).setColor(value < 0 ? "green" : (value > 0 ? "red" : null));
    }

    public TableInterface.TableCellInterface dispNumber(double value) {
        return new TableInterface.TableCellInterface<Double>(value, (double)Math.round(1000.0 * value) == 0.0 ? "" : (value >= 5.0E-4 ? "+" : "") + sDF.format(value)).setColor(value < 0.0 ? "green" : (value > 0.0 ? "red" : null));
    }

    public static void addCrosslistedNames(TableInterface table, boolean showClassSuffix, boolean showConfigNames) {
        block7: {
            HashMap<Long, TableInterface.TableRowInterface> id2row;
            block6: {
                id2row = new HashMap<Long, TableInterface.TableRowInterface>();
                for (TableInterface.TableRowInterface row : table.getRows()) {
                    if (!row.hasId()) continue;
                    id2row.put(row.getId(), row);
                }
                if (id2row.isEmpty()) {
                    return;
                }
                if (id2row.size() > 1000) break block6;
                for (Object[] o : Class_DAO.getInstance().getSession().createQuery("select c, co from Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where co.isControl = false and c.uniqueId in :classIds order by co.subjectAreaAbbv, co.courseNbr").setParameterList("classIds", id2row.keySet(), (Type)LongType.INSTANCE).setCacheable(true).list()) {
                    Class_ clazz = (Class_)o[0];
                    CourseOffering course = (CourseOffering)o[1];
                    TableInterface.TableRowInterface row = (TableInterface.TableRowInterface)id2row.get(clazz.getUniqueId());
                    if (row == null) continue;
                    ((TableInterface.TableCellClassName)row.getCell(0)).addAlternative(clazz.getClassLabel(course, showClassSuffix, showConfigNames));
                }
                break block7;
            }
            ArrayList<Long> ids = new ArrayList<Long>(1000);
            for (Long id : id2row.keySet()) {
                ids.add(id);
                if (ids.size() != 1000) continue;
                for (Object[] o : Class_DAO.getInstance().getSession().createQuery("select c, co from Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where co.isControl = false and c.uniqueId in :classIds order by co.subjectAreaAbbv, co.courseNbr").setParameterList("classIds", ids, (Type)LongType.INSTANCE).setCacheable(true).list()) {
                    Class_ clazz = (Class_)o[0];
                    CourseOffering course = (CourseOffering)o[1];
                    TableInterface.TableRowInterface row = (TableInterface.TableRowInterface)id2row.get(clazz.getUniqueId());
                    if (row == null) continue;
                    ((TableInterface.TableCellClassName)row.getCell(0)).addAlternative(clazz.getClassLabel(course, showClassSuffix, showConfigNames));
                }
                ids.clear();
            }
            if (ids.isEmpty()) break block7;
            for (Object[] o : Class_DAO.getInstance().getSession().createQuery("select c, co from Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where co.isControl = false and c.uniqueId in :classIds order by co.subjectAreaAbbv, co.courseNbr").setParameterList("classIds", ids, (Type)LongType.INSTANCE).setCacheable(true).list()) {
                Class_ clazz = (Class_)o[0];
                CourseOffering course = (CourseOffering)o[1];
                TableInterface.TableRowInterface row = (TableInterface.TableRowInterface)id2row.get(clazz.getUniqueId());
                if (row == null) continue;
                ((TableInterface.TableCellClassName)row.getCell(0)).addAlternative(clazz.getClassLabel(course, showClassSuffix, showConfigNames));
            }
        }
    }
}

