/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.hibernate.Session;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Roles;
import org.unitime.timetable.model.dao.RolesDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=permissions]")
public class Permissions
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pagePermission(), MESSAGES.pagePermissions());
    }

    protected List<Roles> getRoles(SessionContext context, Session hibSession, boolean read) {
        if (read) {
            ArrayList<Roles> roles = new ArrayList<Roles>(Roles.findAll(false));
            ArrayList<Long> roleIds = new ArrayList<Long>();
            for (Roles role : roles) {
                roleIds.add(role.getRoleId());
            }
            context.setAttribute(SessionAttribute.PermissionRoles, roleIds);
            return roles;
        }
        List roleIds = (List)context.getAttribute(SessionAttribute.PermissionRoles);
        if (roleIds == null) {
            return this.getRoles(context, hibSession, true);
        }
        ArrayList<Roles> roles = new ArrayList<Roles>(roleIds.size());
        for (Long roleId : roleIds) {
            roles.add((Roles)RolesDAO.getInstance().get(roleId, hibSession));
        }
        return roles;
    }

    @Override
    @PreAuthorize(value="checkPermission('Permissions')")
    public SimpleEditInterface load(SessionContext context, Session hibSession) {
        List<Roles> roles = this.getRoles(context, hibSession, true);
        SimpleEditInterface.Field[] fields = new SimpleEditInterface.Field[2 + roles.size()];
        fields[0] = new SimpleEditInterface.Field(MESSAGES.fieldName(), SimpleEditInterface.FieldType.text, 160, 200, SimpleEditInterface.Flag.READ_ONLY);
        fields[1] = new SimpleEditInterface.Field(MESSAGES.fieldLevel(), SimpleEditInterface.FieldType.text, 160, 200, SimpleEditInterface.Flag.READ_ONLY);
        for (int i = 0; i < roles.size(); ++i) {
            fields[2 + i] = new SimpleEditInterface.Field(roles.get(i).getReference(), SimpleEditInterface.FieldType.toggle, 40, roles.get(i).isEnabled() != false ? null : SimpleEditInterface.Flag.HIDDEN);
        }
        SimpleEditInterface data = new SimpleEditInterface(fields);
        data.setSortBy(-1);
        data.setAddable(false);
        for (Right right : Right.values()) {
            SimpleEditInterface.Record r = data.addRecord(Long.valueOf(right.ordinal()), false);
            r.setField(0, right.toString(), false);
            r.setField(1, right.hasType() ? right.type().getSimpleName().replaceAll("(\\p{Ll})(\\p{Lu})", "$1 $2").replace("_", " ") : MESSAGES.levelGlobal(), false);
            for (int i = 0; i < roles.size(); ++i) {
                r.setField(2 + i, roles.get(i).getRights().contains(right.name()) ? "true" : "false");
            }
        }
        data.setEditable(context.hasPermission(Right.PermissionEdit));
        return data;
    }

    @Override
    @PreAuthorize(value="checkPermission('PermissionEdit')")
    public void save(SimpleEditInterface data, SessionContext context, Session hibSession) {
        List<Roles> roles = this.getRoles(context, hibSession, false);
        HashSet<Roles> changed = new HashSet<Roles>();
        for (SimpleEditInterface.Record r : data.getRecords()) {
            Right right = Right.values()[(int)r.getUniqueId().longValue()];
            for (int i = 0; i < roles.size(); ++i) {
                boolean oldValue;
                boolean newValue;
                Roles role = roles.get(i);
                if (role == null || (newValue = "true".equals(r.getField(2 + i))) == (oldValue = role.getRights().contains(right.name()))) continue;
                changed.add(role);
                if (newValue) {
                    role.getRights().add(right.name());
                    continue;
                }
                role.getRights().remove(right.name());
            }
        }
        for (Roles role : changed) {
            hibSession.saveOrUpdate((Object)role);
            ChangeLog.addChange(hibSession, context, role, role.getAbbv() + " permissions", ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('PermissionEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        throw new GwtRpcException(MESSAGES.errorOperationNotSupported());
    }

    @Override
    @PreAuthorize(value="checkPermission('PermissionEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        List<Roles> roles = this.getRoles(context, hibSession, false);
        HashSet<Roles> changed = new HashSet<Roles>();
        Right right = Right.values()[(int)record.getUniqueId().longValue()];
        for (int i = 0; i < roles.size(); ++i) {
            boolean oldValue;
            boolean newValue;
            Roles role = roles.get(i);
            if (role == null || (newValue = "true".equals(record.getField(2 + i))) == (oldValue = role.getRights().contains(right.name()))) continue;
            changed.add(role);
            if (newValue) {
                role.getRights().add(right.name());
                continue;
            }
            role.getRights().remove(right.name());
        }
        for (Roles role : changed) {
            hibSession.saveOrUpdate((Object)role);
            ChangeLog.addChange(hibSession, context, role, role.getAbbv() + " permissions", ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('PermissionEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        throw new GwtRpcException(MESSAGES.errorOperationNotSupported());
    }
}

