/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import java.util.Set;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XStudent;

public abstract class WaitlistedOnlineSectioningAction<T>
implements OnlineSectioningAction<T> {
    private static final long serialVersionUID = 1L;
    private Set<String> iWaitlistStatuses = null;

    public boolean isWaitListed(XStudent student, XCourseRequest request, OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (request == null || !request.isWaitlist()) {
            return false;
        }
        String status = student.getStatus();
        if (status == null) {
            status = server.getAcademicSession().getDefaultSectioningStatus();
        }
        if (status != null) {
            if (this.iWaitlistStatuses == null) {
                this.iWaitlistStatuses = StudentSectioningStatus.getMatchingStatuses(StudentSectioningStatus.Option.waitlist, server.getAcademicSession().getUniqueId());
            }
            if (!this.iWaitlistStatuses.contains(status)) {
                return false;
            }
        }
        return true;
    }
}

