/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.status;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Advisor;
import org.unitime.timetable.model.OnlineSectioningLog;
import org.unitime.timetable.model.StudentGroupType;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao.StudentGroupTypeDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CustomCourseLookupHolder;
import org.unitime.timetable.onlinesectioning.model.XAreaClassificationMajor;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.util.Constants;

public class FindOnlineSectioningLogAction
implements OnlineSectioningAction<List<ClassAssignmentInterface.SectioningAction>> {
    private static final long serialVersionUID = 1L;
    protected static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    protected static StudentSectioningConstants CONST = Localization.create(StudentSectioningConstants.class);
    private Query iQuery;
    private Integer iLimit = 100;
    protected boolean iCanShowExtIds = false;

    public FindOnlineSectioningLogAction forQuery(String query, boolean canShowExtIds) {
        this.iQuery = new Query(query.isEmpty() ? "limit:100" : query);
        Matcher m = Pattern.compile("limit:[ ]?([0-9]*)", 2).matcher(query);
        if (m.find()) {
            this.iLimit = Integer.parseInt(m.group(1));
        }
        this.iCanShowExtIds = canShowExtIds;
        return this;
    }

    public Query getQuery() {
        return this.iQuery;
    }

    public Integer getLimit() {
        return this.iLimit;
    }

    @Override
    public List<ClassAssignmentInterface.SectioningAction> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        helper.beginTransaction();
        try {
            ArrayList<ClassAssignmentInterface.SectioningAction> ret = new ArrayList<ClassAssignmentInterface.SectioningAction>();
            AcademicSessionInfo session = server.getAcademicSession();
            SectioningLogQueryFormatter formatter = new SectioningLogQueryFormatter(session, helper);
            String join = "";
            for (String t : formatter.getGroupTypes()) {
                if (!this.getQuery().hasAttribute(t)) continue;
                join = join + "left outer join s.groups G_" + t + " ";
            }
            org.hibernate.Query q = helper.getHibSession().createQuery("select l, s.uniqueId from OnlineSectioningLog l, Student s " + (this.getQuery().hasAttribute("area", "clasf", "classification", "major", "concentration") ? "left outer join s.areaClasfMajors m " : "") + (this.getQuery().hasAttribute("minor") ? "left outer join s.areaClasfMinors n " : "") + (this.getQuery().hasAttribute("group") ? "left outer join s.groups g " : "") + (this.getQuery().hasAttribute("accommodation") ? "left outer join s.accomodations a " : "") + (this.getQuery().hasAttribute("course") || this.getQuery().hasAttribute("lookup") || this.getQuery().hasAttribute("im") ? "left outer join s.courseDemands cd left outer join cd.courseRequests cr " : "") + (this.getQuery().hasAttribute("im") ? "left outer join cr.courseOffering.instructionalOffering.instrOfferingConfigs cfg left outer join cfg.instructionalMethod im " : "") + join + "where l.session.uniqueId = :sessionId and l.session = s.session and l.student = s.externalUniqueId and (" + this.getQuery().toString(formatter) + ") " + (this.getQuery().hasAttribute("operation") ? "" : "and (l.result is not null or l.operation not in ('reload-offering', 'check-offering', 'reload-student')) and (l.result != 3 or l.operation not in ('validate-overrides', 'critical-courses', 'banner-update')) ") + "order by l.uniqueId desc");
            q.setLong("sessionId", session.getUniqueId().longValue());
            if (this.getLimit() != null) {
                q.setMaxResults(this.getLimit().intValue());
            }
            HashSet<Long> processedLogIds = new HashSet<Long>();
            for (Object[] o : q.list()) {
                OnlineSectioningLog.Action.ResultType res;
                OnlineSectioningLog log = (OnlineSectioningLog)o[0];
                XStudent student = server.getStudent((Long)o[1]);
                if (student == null || !processedLogIds.add(log.getUniqueId())) continue;
                ClassAssignmentInterface.Student st = new ClassAssignmentInterface.Student();
                st.setId(student.getStudentId());
                st.setSessionId(session.getUniqueId());
                st.setExternalId(student.getExternalId());
                st.setCanShowExternalId(this.iCanShowExtIds);
                st.setName(student.getName());
                for (XAreaClassificationMajor acm : student.getMajors()) {
                    st.addArea(acm.getArea(), acm.getAreaLabel());
                    st.addClassification(acm.getClassification(), acm.getClassificationLabel());
                    st.addMajor(acm.getMajor(), acm.getMajorLabel());
                    st.addConcentration(acm.getConcentration(), acm.getConcentrationLabel());
                    st.addDegree(acm.getDegree(), acm.getDegreeLabel());
                }
                for (XAreaClassificationMajor acm : student.getMinors()) {
                    st.addMinor(acm.getMajor(), acm.getMajorLabel());
                }
                for (XStudent.XGroup gr : student.getGroups()) {
                    st.addGroup(gr.getType(), gr.getAbbreviation(), gr.getTitle());
                }
                for (XStudent.XGroup acc : student.getAccomodations()) {
                    st.addAccommodation(acc.getAbbreviation(), acc.getTitle());
                }
                for (XStudent.XAdvisor a : student.getAdvisors()) {
                    if (a.getName() == null) continue;
                    st.addAdvisor(a.getName());
                }
                ClassAssignmentInterface.SectioningAction a = new ClassAssignmentInterface.SectioningAction();
                a.setLogId(log.getUniqueId());
                a.setStudent(st);
                a.setTimeStamp(log.getTimeStamp());
                a.setOperation(Constants.toInitialCase(log.getOperation().replace('-', ' ')));
                if (log.getUser() != null && log.getUser().equals(st.getExternalId())) {
                    a.setUser(student.getName());
                } else if (log.getUser() != null) {
                    Advisor advisor = Advisor.findByExternalId(log.getUser(), server.getAcademicSession().getUniqueId());
                    if (advisor != null) {
                        a.setUser(helper.getInstructorNameFormat().format(advisor));
                    } else {
                        TimetableManager mgr = TimetableManager.findByExternalId(log.getUser());
                        if (mgr != null) {
                            a.setUser(helper.getInstructorNameFormat().format(mgr));
                        } else {
                            a.setUser(log.getUser());
                        }
                    }
                }
                if (log.getResult() != null && (res = OnlineSectioningLog.Action.ResultType.valueOf(log.getResult())) != null) {
                    a.setResult(Constants.toInitialCase(res.name()));
                }
                a.setMessage(log.getMessage());
                a.setCpuTime(log.getCpuTime());
                a.setWallTime(log.getWallTime());
                ret.add(a);
            }
            helper.commitTransaction();
            Collections.sort(ret);
            return ret;
        }
        catch (Exception e) {
            helper.rollbackTransaction();
            if (e instanceof SectioningException) {
                throw (SectioningException)e;
            }
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    public static String getHTML(OnlineSectioningLog.Action action) {
        DateFormat df = Localization.getDateFormat(CONST.timeStampFormat());
        NumberFormat nf = Localization.getNumberFormat(CONST.executionTimeFormat());
        String html = "<table class='unitime-ChangeLog'>";
        html = html + "<tr><td class='unitime-MainTableHeader' colspan='2'>General</td></tr>";
        html = html + "<tr><td><b>" + MSG.colOperation() + ":</b></td><td>" + Constants.toInitialCase(action.getOperation().replace('-', ' ')) + "</td></tr>";
        if (action.hasResult()) {
            html = html + "<tr><td><b>" + MSG.colResult() + ":</b></td><td>" + Constants.toInitialCase(action.getResult().name()) + "</td></tr>";
        }
        if (action.hasStudent() && action.getStudent().hasName()) {
            html = html + "<tr><td><b>" + MSG.colStudent() + ":</b></td><td>" + action.getStudent().getName() + "</td></tr>";
        }
        for (OnlineSectioningLog.Entity other : action.getOtherList()) {
            html = html + "<tr><td><b>" + Constants.toInitialCase(other.getType().name()) + ":</b></td><td>" + other.getName() + "</td></tr>";
        }
        html = html + "<tr><td><b>Time Stamp:</b></td><td>" + df.format(action.getStartTime()) + "</td></tr>";
        for (OnlineSectioningLog.Property p : action.getOptionList()) {
            if ("student-email".equals(action.getOperation()) && p.getKey().equalsIgnoreCase("email")) continue;
            html = html + "<tr><td><b>" + Constants.toInitialCase(p.getKey()) + ":</b></td><td><div class='property' onclick='gwtPropertyClick(this);' title='" + MSG.changeLogClickToCopyToClipboard() + "'>" + (p.hasValue() ? StringEscapeUtils.escapeHtml((String)p.getValue()) : "") + "</div></td></tr>";
        }
        if (action.hasCpuTime()) {
            html = html + "<tr><td><b>" + MSG.colCpuTime() + ":</b></td><td>" + nf.format(1.0E-9 * (double)action.getCpuTime()) + "</td></tr>";
        }
        if (action.hasStartTime() && action.hasEndTime()) {
            html = html + "<tr><td nowrap><b>" + MSG.colWallTime() + ":</b></td><td>" + nf.format(0.001 * (double)(action.getEndTime() - action.getStartTime())) + "</td></tr>";
        }
        if (action.hasApiGetTime()) {
            html = html + "<tr><td nowrap><b>" + MSG.colApiGetTime() + ":</b></td><td>" + nf.format(0.001 * (double)action.getApiGetTime()) + "</td></tr>";
        }
        if (action.hasApiPostTime()) {
            html = html + "<tr><td nowrap><b>" + MSG.colApiPostTime() + ":</b></td><td>" + nf.format(0.001 * (double)action.getApiPostTime()) + "</td></tr>";
        }
        if (action.hasApiException()) {
            html = html + "<tr><td nowrap><b>" + MSG.colApiException() + ":</b></td><td>" + action.getApiException() + "</td></tr>";
        }
        if ("student-email".equals(action.getOperation())) {
            for (OnlineSectioningLog.Property p : action.getOptionList()) {
                if (!"email".equals(p.getKey()) || !p.hasValue()) continue;
                html = html + "<tr><td class='unitime-MainTableHeader' colspan='2'>Email</td></tr>";
                html = html + "<tr><td colspan='2'>" + p.getValue() + "</td></tr>";
            }
        }
        if (!action.getRequestList().isEmpty()) {
            html = html + "<tr><td class='unitime-MainTableHeader' colspan='2'>" + MSG.courseRequestsCourses() + "</td></tr>";
            html = html + "<tr><td colspan='2'><table cellspacing='0' cellpadding='2'><td class='unitime-TableHeader'>" + MSG.colPriority() + "</td><td class='unitime-TableHeader'>" + MSG.colCourse() + "</td><td class='unitime-TableHeader'>" + MSG.colPreferences() + "</td></tr>";
        }
        int notAlt = 0;
        int lastFT = -1;
        for (OnlineSectioningLog.Request r : action.getRequestList()) {
            if (!r.getAlternative()) {
                notAlt = r.getPriority() + 1;
            }
            int idx = 0;
            for (OnlineSectioningLog.Time f : r.getFreeTimeList()) {
                if (idx == 0) {
                    html = html + (r.getPriority() > 0 && lastFT != r.getPriority() ? "<tr><td class='top-border-dashed'>" : "<tr><td>") + (lastFT == r.getPriority() ? "" : (!r.getAlternative() ? MSG.courseRequestsPriority(1 + r.getPriority()) : MSG.courseRequestsAlternate(1 + r.getPriority() - notAlt))) + "</td>";
                    html = html + (r.getPriority() > 0 && lastFT != r.getPriority() ? "<td class='top-border-dashed' colspan='2'>" : "<td colspan='2'>") + CONST.freePrefix() + " ";
                } else {
                    html = html + ", ";
                }
                ++idx;
                html = html + DayCode.toString(f.getDays()) + " " + FindOnlineSectioningLogAction.time(f.getStart()) + " - " + FindOnlineSectioningLogAction.time(f.getStart() + f.getLength());
                html = html + "</td></tr>";
                lastFT = r.getPriority();
            }
            if (!r.getFreeTimeList().isEmpty()) continue;
            for (OnlineSectioningLog.Entity e : r.getCourseList()) {
                if (idx == 0) {
                    html = html + (r.getPriority() > 0 ? "<tr><td class='top-border-dashed'>" : "<tr><td>") + (!r.getAlternative() ? MSG.courseRequestsPriority(1 + r.getPriority()) : MSG.courseRequestsAlternate(1 + r.getPriority() - notAlt)) + "</td>";
                    html = html + (r.getPriority() > 0 ? "<td class='top-border-dashed'>" : "<td>");
                } else {
                    html = html + "<tr><td></td><td>";
                }
                html = html + e.getName();
                html = html + (r.getPriority() > 0 && ++idx == 1 ? "</td><td class='top-border-dashed'>" : "</td><td>");
                for (int i = 0; i < e.getParameterCount(); ++i) {
                    html = html + (i > 0 ? ", " : "") + e.getParameter(i).getValue();
                }
                html = html + "</td></tr>";
            }
        }
        if (!action.getRequestList().isEmpty()) {
            html = html + "</table></td></tr>";
        }
        for (OnlineSectioningLog.Enrollment e : action.getEnrollmentList()) {
            html = html + "<tr><td class='unitime-MainTableHeader' colspan='2'>" + (e.hasType() ? Constants.toInitialCase(e.getType().name()) + " " : "") + MSG.enrollmentsTable() + "</td></tr>";
            html = html + "<tr><td colspan='2'><table cellspacing='0' cellpadding='2'><td class='unitime-TableHeader'>" + MSG.colCourse() + "</td><td class='unitime-TableHeader'>" + MSG.colSubject() + "</td><td class='unitime-TableHeader'>" + MSG.colClass() + "</td><td class='unitime-TableHeader'>" + MSG.colDays() + "</td><td class='unitime-TableHeader'>" + MSG.colStart() + "</td><td class='unitime-TableHeader'>" + MSG.colEnd() + "</td><td class='unitime-TableHeader'>" + MSG.colDate() + "</td><td class='unitime-TableHeader'>" + MSG.colRoom() + "</td><td class='unitime-TableHeader'>" + MSG.colInstructor() + "</td></tr>";
            for (OnlineSectioningLog.Section s : e.getSectionList()) {
                if (!s.hasCourse()) continue;
                String loc = "";
                for (OnlineSectioningLog.Entity r : s.getLocationList()) {
                    if (!loc.isEmpty()) {
                        loc = loc + ", ";
                    }
                    loc = loc + r.getName();
                }
                String instr = "";
                for (OnlineSectioningLog.Entity r : s.getInstructorList()) {
                    if (!instr.isEmpty()) {
                        instr = instr + ", ";
                    }
                    instr = instr + r.getName();
                }
                html = html + "<tr><td>" + s.getCourse().getName() + "</td><td>" + s.getSubpart().getName() + "</td><td>" + s.getClazz().getName() + "</td><td>" + (s.hasTime() ? DayCode.toString(s.getTime().getDays()) : "") + "</td><td>" + (s.hasTime() ? FindOnlineSectioningLogAction.time(s.getTime().getStart()) : "") + "</td><td>" + (s.hasTime() ? FindOnlineSectioningLogAction.time(s.getTime().getStart() + s.getTime().getLength()) : "") + "</td><td>" + (s.hasTime() && s.getTime().hasPattern() ? s.getTime().getPattern() : "") + "</td><td>" + loc + "</td><td>" + instr + "</td></tr>";
            }
            html = html + "</table></td></tr>";
        }
        if (!action.getMessageList().isEmpty()) {
            html = html + "<tr><td class='unitime-MainTableHeader' colspan='2'>" + MSG.tableMessages() + "</td></tr>";
            for (OnlineSectioningLog.Message m : action.getMessageList()) {
                if (m.hasText()) {
                    html = html + "<tr><td><b>" + m.getLevel().name() + ":</b></td><td>" + m.getText() + "</td></tr>";
                }
                if (!m.hasException()) continue;
                html = html + "<tr><td><b>Exception:</b></td><td>" + m.getException() + "</td></tr>";
            }
        }
        html = html + "<tr><td class='unitime-MainTableHeader' colspan='2'>" + MSG.tableProto() + "</td></tr>";
        html = html + "<tr><td colspan='2' class='proto'>" + action.toString().replace("<", "&lt;").replace(">", "&gt;").replace(" ", "&nbsp;").replace("\n", "<br>") + "</td></tr>";
        html = html + "</table>";
        return html;
    }

    protected static String getRequestMessage(OnlineSectioningLog.Action action) {
        String request = "";
        int notAlt = 0;
        int lastFT = -1;
        for (OnlineSectioningLog.Request r : action.getRequestList()) {
            if (!r.getAlternative()) {
                notAlt = r.getPriority() + 1;
            }
            int idx = 0;
            for (OnlineSectioningLog.Time f : r.getFreeTimeList()) {
                request = idx == 0 ? request + (lastFT == r.getPriority() ? ", " : (request.isEmpty() ? "" : "\n") + (r.getAlternative() ? "A" + (1 + r.getPriority() - notAlt) : String.valueOf(1 + r.getPriority())) + ". " + CONST.freePrefix() + " ") : request + ", ";
                ++idx;
                request = request + DayCode.toString(f.getDays()) + " " + FindOnlineSectioningLogAction.time(f.getStart()) + " - " + FindOnlineSectioningLogAction.time(f.getStart() + f.getLength());
                lastFT = r.getPriority();
            }
            if (!r.getFreeTimeList().isEmpty()) continue;
            for (OnlineSectioningLog.Entity e : r.getCourseList()) {
                request = idx == 0 ? request + (request.isEmpty() ? "" : "\n") + (r.getAlternative() ? "A" + (1 + r.getPriority() - notAlt) : String.valueOf(1 + r.getPriority())) + ". " : request + ", ";
                ++idx;
                request = request + e.getName();
            }
        }
        return request;
    }

    protected static String getSelectedMessage(OnlineSectioningLog.Action action) {
        String selected = "";
        for (OnlineSectioningLog.Request r : action.getRequestList()) {
            for (OnlineSectioningLog.Section s : r.getSectionList()) {
                if (s.getPreference() != OnlineSectioningLog.Section.Preference.SELECTED) continue;
                if (!selected.isEmpty()) {
                    selected = selected + "\n";
                }
                String loc = "";
                for (OnlineSectioningLog.Entity e : s.getLocationList()) {
                    if (!loc.isEmpty()) {
                        loc = loc + ", ";
                    }
                    loc = loc + e.getName();
                }
                String instr = "";
                for (OnlineSectioningLog.Entity e : s.getInstructorList()) {
                    if (!instr.isEmpty()) {
                        instr = instr + ", ";
                    }
                    instr = instr + e.getName();
                }
                selected = selected + s.getCourse().getName() + " " + s.getSubpart().getName() + " " + s.getClazz().getName() + " " + (s.hasTime() ? DayCode.toString(s.getTime().getDays()) + " " + FindOnlineSectioningLogAction.time(s.getTime().getStart()) + " - " + FindOnlineSectioningLogAction.time(s.getTime().getStart() + s.getTime().getLength()) : "") + " " + loc;
            }
        }
        return selected;
    }

    protected static String getEnrollmentMessage(OnlineSectioningLog.Action action) {
        OnlineSectioningLog.Enrollment enrl = null;
        Iterator<OnlineSectioningLog.Enrollment> iterator = action.getEnrollmentList().iterator();
        while (iterator.hasNext()) {
            OnlineSectioningLog.Enrollment e;
            enrl = e = iterator.next();
            if (e.getType() != OnlineSectioningLog.Enrollment.EnrollmentType.REQUESTED) continue;
            break;
        }
        String enrollment = "";
        if (enrl != null) {
            for (OnlineSectioningLog.Section s : enrl.getSectionList()) {
                if (!s.hasCourse()) continue;
                if (!enrollment.isEmpty()) {
                    enrollment = enrollment + "\n";
                }
                String loc = "";
                for (OnlineSectioningLog.Entity r : s.getLocationList()) {
                    if (!loc.isEmpty()) {
                        loc = loc + ", ";
                    }
                    loc = loc + r.getName();
                }
                String instr = "";
                for (OnlineSectioningLog.Entity r : s.getInstructorList()) {
                    if (!instr.isEmpty()) {
                        instr = instr + ", ";
                    }
                    instr = instr + r.getName();
                }
                enrollment = enrollment + s.getCourse().getName() + " " + s.getSubpart().getName() + " " + s.getClazz().getName() + " " + (s.hasTime() ? DayCode.toString(s.getTime().getDays()) + " " + FindOnlineSectioningLogAction.time(s.getTime().getStart()) : "") + " " + loc;
            }
        }
        return enrollment;
    }

    public static String getMessage(OnlineSectioningLog.Action action) {
        String message = "";
        int level = 1;
        for (OnlineSectioningLog.Message m : action.getMessageList()) {
            if (!m.hasLevel() || !message.isEmpty() && level > m.getLevel().getNumber()) continue;
            if (m.hasText()) {
                message = (level != m.getLevel().getNumber() ? "" : message + "\n") + m.getText();
                level = m.getLevel().getNumber();
                continue;
            }
            if (!m.hasException()) continue;
            message = (level != m.getLevel().getNumber() ? "" : message + "\n") + m.getException();
            level = m.getLevel().getNumber();
        }
        if (action.hasResult() && OnlineSectioningLog.Action.ResultType.FAILURE.equals((Object)action.getResult()) && !message.isEmpty()) {
            return message;
        }
        if ("suggestions".equals(action.getOperation())) {
            String selected = FindOnlineSectioningLogAction.getSelectedMessage(action);
            return selected.isEmpty() ? message : selected;
        }
        if ("section".equals(action.getOperation())) {
            String request = FindOnlineSectioningLogAction.getRequestMessage(action);
            return request.isEmpty() ? message : request;
        }
        String enrollment = FindOnlineSectioningLogAction.getEnrollmentMessage(action);
        if (!enrollment.isEmpty()) {
            return enrollment;
        }
        String request = FindOnlineSectioningLogAction.getRequestMessage(action);
        return request.isEmpty() ? message : request;
    }

    protected static String time(int slot) {
        int h = slot / 12;
        int m = 5 * (slot % 12);
        if (CONST.useAmPm()) {
            return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h == 24 ? "a" : (h >= 12 ? "p" : "a"));
        }
        return h + ":" + (m < 10 ? "0" : "") + m;
    }

    @Override
    public String name() {
        return "sectioning-log";
    }

    public static class SectioningLogQueryFormatter
    implements Query.QueryFormatter {
        Set<String> iGroupTypes = new HashSet<String>();
        AcademicSessionInfo iSession = null;
        OnlineSectioningHelper iHelper = null;

        public SectioningLogQueryFormatter(AcademicSessionInfo session, OnlineSectioningHelper helper) {
            this.iSession = session;
            this.iHelper = helper;
            for (StudentGroupType type : StudentGroupTypeDAO.getInstance().findAll(helper.getHibSession())) {
                this.iGroupTypes.add(type.getReference().replace(' ', '_').toLowerCase());
            }
        }

        @Override
        public String format(String attr, String body) {
            if (body != null && !body.isEmpty()) {
                body = StringEscapeUtils.escapeSql((String)body);
            }
            if ("id".equalsIgnoreCase(attr) || "student".equalsIgnoreCase(attr)) {
                if (ApplicationProperty.DataExchangeTrimLeadingZerosFromExternalIds.isTrue() && body.startsWith("0")) {
                    return "s.externalUniqueId = '" + body.replaceFirst("^0+(?!$)", "") + "'";
                }
                return "s.externalUniqueId = '" + body + "'";
            }
            if ("advisor".equalsIgnoreCase(attr)) {
                if (ApplicationProperty.DataExchangeTrimLeadingZerosFromExternalIds.isTrue() && body.startsWith("0")) {
                    return "s.uniqueId in (select ads.uniqueId from Advisor adv inner join adv.students ads where adv.externalUniqueId = '" + body.replaceFirst("^0+(?!$)", "") + "' and adv.session.uniqueId = s.session.uniqueId)";
                }
                return "s.uniqueId in (select ads.uniqueId from Advisor adv inner join adv.students ads where adv.externalUniqueId = '" + body + "' and adv.session.uniqueId = s.session.uniqueId)";
            }
            if ("operation".equalsIgnoreCase(attr) || "op".equalsIgnoreCase(attr)) {
                return "lower(l.operation) = '" + body.toLowerCase() + "'";
            }
            if ("max-age".equalsIgnoreCase(attr) || "age".equalsIgnoreCase(attr)) {
                return HibernateUtil.addDate("l.timeStamp", body) + " > current_date()";
            }
            if ("limit".equalsIgnoreCase(attr)) {
                return "1 = 1";
            }
            if ("area".equalsIgnoreCase(attr)) {
                return "lower(m.academicArea.academicAreaAbbreviation) = '" + body.toLowerCase() + "'";
            }
            if ("clasf".equalsIgnoreCase(attr) || "classification".equalsIgnoreCase(attr)) {
                return "lower(m.academicClassification.code) = '" + body.toLowerCase() + "'";
            }
            if ("major".equalsIgnoreCase(attr)) {
                return "lower(m.major.code) = '" + body.toLowerCase() + "'";
            }
            if ("concentration".equalsIgnoreCase(attr)) {
                return "lower(m.concentration.code) = '" + body.toLowerCase() + "'";
            }
            if ("minor".equalsIgnoreCase(attr)) {
                return "lower(n.minor.code) = '" + body.toLowerCase() + "'";
            }
            if ("group".equalsIgnoreCase(attr)) {
                return "lower(g.groupAbbreviation) = '" + body.toLowerCase() + "'";
            }
            if (attr != null && this.iGroupTypes.contains(attr.toLowerCase())) {
                return "lower(G_" + attr + ".groupAbbreviation) = '" + body.toLowerCase() + "'";
            }
            if ("accommodation".equalsIgnoreCase(attr)) {
                return "lower(a.abbreviation) = '" + body.toLowerCase() + "'";
            }
            if ("user".equalsIgnoreCase(attr)) {
                return "none".equalsIgnoreCase(body) ? "l.user is null" : "l.user = '" + body + "'";
            }
            if ("result".equalsIgnoreCase(attr)) {
                for (OnlineSectioningLog.Action.ResultType t : OnlineSectioningLog.Action.ResultType.values()) {
                    if (!t.name().equalsIgnoreCase(body)) continue;
                    return "l.result = " + t.getNumber();
                }
                if ("none".equalsIgnoreCase(body) || "unknown".equalsIgnoreCase(body)) {
                    return "l.result is null";
                }
                return "1 = 1";
            }
            if ("status".equalsIgnoreCase(attr)) {
                if ("Not Set".equalsIgnoreCase(body)) {
                    return "s.sectioningStatus is null";
                }
                return "lower(s.sectioningStatus.reference) = '" + body.toLowerCase() + "'";
            }
            if ("over".equalsIgnoreCase(attr)) {
                try {
                    return "l.wallTime >= " + 1000 * Integer.parseInt(body.trim());
                }
                catch (Exception e) {
                    return "1 = 1";
                }
            }
            if ("under".equalsIgnoreCase(attr)) {
                try {
                    return "l.wallTime <= " + 1000 * Integer.parseInt(body.trim());
                }
                catch (Exception e) {
                    return "1 = 1";
                }
            }
            if ("api".equalsIgnoreCase(attr)) {
                try {
                    return "l.apiGetTime >= " + 1000 * Integer.parseInt(body.trim()) + "or l.apiPostTime >= " + 1000 * Integer.parseInt(body.trim()) + " or (l.apiGetTime + l.apiPostTime) >= " + 1000 * Integer.parseInt(body.trim());
                }
                catch (Exception e) {
                    return "l.apiException like '%" + body + "%'";
                }
            }
            if ("message".equalsIgnoreCase(attr)) {
                return "l.message like '%" + body + "%' or l.apiException like '%" + body + "%'";
            }
            if ("get".equalsIgnoreCase(attr)) {
                try {
                    return "l.apiGetTime >= " + 1000 * Integer.parseInt(body.trim());
                }
                catch (Exception e) {
                    return "1 = 1";
                }
            }
            if ("post".equalsIgnoreCase(attr)) {
                try {
                    return "l.apiPostTime >= " + 1000 * Integer.parseInt(body.trim());
                }
                catch (Exception e) {
                    return "1 = 1";
                }
            }
            if ("course".equalsIgnoreCase(attr)) {
                return "cr.courseOffering.subjectAreaAbbv = '" + body + "' or (cr.courseOffering.subjectAreaAbbv || ' ' || cr.courseOffering.courseNbr) = '" + body + "'";
            }
            if ("lookup".equalsIgnoreCase(attr)) {
                Set<Long> courseIds;
                if (CustomCourseLookupHolder.hasProvider() && (courseIds = CustomCourseLookupHolder.getProvider().getCourseIds(this.iSession, this.iHelper.getHibSession(), body, true)) != null && !courseIds.isEmpty()) {
                    String ret = "";
                    for (Long courseId : courseIds) {
                        ret = ret + (ret.isEmpty() ? "" : ",") + courseId;
                    }
                    return "cr.courseOffering.uniqueId in (" + ret + ")";
                }
                return "1 = 1";
            }
            if ("im".equalsIgnoreCase(attr)) {
                if (body != null && body.equals(this.iSession.getDefaultInstructionalMethod())) {
                    return "im is null or im.reference = '" + body + "'";
                }
                return "im.reference = '" + body + "'";
            }
            if (attr == null && !body.isEmpty()) {
                return "lower(s.firstName || ' ' || s.middleName || ' ' || s.lastName) like '%" + body.toLowerCase() + "%'";
            }
            return "1 = 1";
        }

        public Collection<String> getGroupTypes() {
            return this.iGroupTypes;
        }
    }
}

