/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.Subpart;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.model.XInstructionalMethod;
import org.unitime.timetable.onlinesectioning.model.XSubpart;

@SerializeWith(value=XConfigSerializer.class)
public class XConfig
implements Serializable,
Comparable<XConfig>,
Externalizable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId = null;
    private String iName = null;
    private Long iOfferingId = null;
    private int iLimit = -1;
    private List<XSubpart> iSubparts = new ArrayList<XSubpart>();
    private XInstructionalMethod iInstructionalMethod = null;

    public XConfig() {
    }

    public XConfig(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XConfig(InstrOfferingConfig config, OnlineSectioningHelper helper) {
        this.iUniqueId = config.getUniqueId();
        this.iName = config.getName();
        this.iOfferingId = config.getInstructionalOffering().getUniqueId();
        int n = this.iLimit = config.isUnlimitedEnrollment() != false ? -1 : config.getLimit();
        if (this.iLimit >= 9999) {
            this.iLimit = -1;
        }
        TreeSet<SchedulingSubpart> subparts = new TreeSet<SchedulingSubpart>(new SchedulingSubpartComparator());
        subparts.addAll(config.getSchedulingSubparts());
        boolean credit = false;
        for (CourseOffering co : config.getInstructionalOffering().getCourseOfferings()) {
            if (co.getCredit() == null) continue;
            credit = true;
            break;
        }
        for (SchedulingSubpart subpart : subparts) {
            this.iSubparts.add(new XSubpart(subpart, credit, helper));
            credit = false;
        }
        Collections.sort(this.iSubparts, new XSubpartComparator());
        if (config.getEffectiveInstructionalMethod() != null) {
            this.iInstructionalMethod = new XInstructionalMethod(config.getEffectiveInstructionalMethod());
        }
    }

    public XConfig(Config config) {
        this.iUniqueId = config.getId();
        this.iName = config.getName();
        this.iOfferingId = config.getOffering().getId();
        this.iLimit = config.getLimit();
        boolean credit = false;
        for (Course course : config.getOffering().getCourses()) {
            if (course.getCredit() == null) continue;
            credit = true;
            break;
        }
        for (Subpart subpart : config.getSubparts()) {
            this.iSubparts.add(new XSubpart(subpart, credit));
            credit = false;
        }
        if (config.getInstructionalMethodId() != null) {
            this.iInstructionalMethod = new XInstructionalMethod(config.getInstructionalMethodId(), config.getInstructionalMethodName(), config.getInstructionalMethodReference());
        }
    }

    public Long getConfigId() {
        return this.iUniqueId;
    }

    public XSubpart getSubpart(Long subpartId) {
        for (XSubpart subpart : this.iSubparts) {
            if (!subpart.getSubpartId().equals(subpartId)) continue;
            return subpart;
        }
        return null;
    }

    public int getLimit() {
        return this.iLimit;
    }

    public void setLimit(int limit) {
        this.iLimit = limit;
    }

    public String getName() {
        return this.iName;
    }

    public Long getOfferingId() {
        return this.iOfferingId;
    }

    public List<XSubpart> getSubparts() {
        return this.iSubparts;
    }

    public XInstructionalMethod getInstructionalMethod() {
        return this.iInstructionalMethod;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof XConfig)) {
            return false;
        }
        return this.getConfigId().equals(((XConfig)o).getConfigId());
    }

    public int hashCode() {
        return new Long(this.getConfigId()).hashCode();
    }

    @Override
    public int compareTo(XConfig config) {
        return this.getName().equals(config.getName()) ? this.getConfigId().compareTo(config.getConfigId()) : this.getName().compareTo(config.getName());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.iUniqueId = in.readLong();
        this.iName = (String)in.readObject();
        this.iOfferingId = in.readLong();
        this.iLimit = in.readInt();
        int nrSubparts = in.readInt();
        this.iSubparts.clear();
        for (int i = 0; i < nrSubparts; ++i) {
            this.iSubparts.add(new XSubpart(in));
        }
        if (in.readBoolean()) {
            this.iInstructionalMethod = new XInstructionalMethod(in);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.iUniqueId);
        out.writeObject(this.iName);
        out.writeLong(this.iOfferingId);
        out.writeInt(this.iLimit);
        out.writeInt(this.iSubparts.size());
        for (XSubpart subpart : this.iSubparts) {
            subpart.writeExternal(out);
        }
        out.writeBoolean(this.iInstructionalMethod != null);
        if (this.iInstructionalMethod != null) {
            this.iInstructionalMethod.writeExternal(out);
        }
    }

    public static class XConfigSerializer
    implements Externalizer<XConfig> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, XConfig object) throws IOException {
            object.writeExternal(output);
        }

        public XConfig readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new XConfig(input);
        }
    }

    private class XSubpartComparator
    implements Serializable,
    Comparator<XSubpart> {
        private static final long serialVersionUID = 1L;

        private XSubpartComparator() {
        }

        public boolean isParent(XSubpart s1, XSubpart s2) {
            Long p1 = s1.getParentId();
            if (p1 == null) {
                return false;
            }
            if (p1.equals(s2.getSubpartId())) {
                return true;
            }
            return this.isParent(XConfig.this.getSubpart(p1), s2);
        }

        @Override
        public int compare(XSubpart a, XSubpart b) {
            if (this.isParent(a, b)) {
                return 1;
            }
            if (this.isParent(b, a)) {
                return -1;
            }
            int cmp = a.getInstructionalType().compareToIgnoreCase(b.getInstructionalType());
            if (cmp != 0) {
                return cmp;
            }
            return Double.compare(a.getSubpartId().longValue(), b.getSubpartId().longValue());
        }
    }
}

