/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class XEInterface {

    public static class CreditHours {
        public Float creditHourHigh;
        public Float creditHourLow;
        public String creditHourIndicator;
        public Float[] creditHourList;
    }

    public static class RegistrationGradingMode {
        public String gradingMode;
        public String description;
    }

    public static class Error {
        public String code;
        public String message;
        public String description;
        public String type;
        public String errorMessage;
    }

    public static class ErrorResponse {
        public List<Error> errors;

        public Error getError() {
            return this.errors == null || this.errors.isEmpty() ? null : this.errors.get(0);
        }
    }

    public static class PlaceHolder {
        public String id;
        public CodeDescription placeholderType;
        public String placeholderValue;
    }

    public static class Course {
        public String id;
        public String title;
        public String courseNumber;
        public String courseDiscipline;
        public boolean isGroupSelection;
        public Boolean isCritical;
    }

    public static class Group {
        public String id;
        public CodeDescription groupType;
        public List<Course> plannedClasses;
        public List<Group> groups;
        public List<PlaceHolder> plannedPlaceholders;
        public String summaryDescription;
        public boolean isGroupSelection;
        public Boolean isCritical;
    }

    public static class Term {
        public String id;
        public CodeDescription term;
        public Group group;
    }

    public static class Year
    extends CodeDescription {
        public List<Term> terms;
    }

    public static class ValueDescription {
        public boolean value;
        public String description;
    }

    public static class CodeDescription {
        public String code;
        public String description;
    }

    public static class Person {
        public String id;
        public String name;
    }

    public static class DegreePlan {
        public static final Type TYPE_LIST = new TypeToken<ArrayList<DegreePlan>>(){}.getType();
        public String id;
        public ValueDescription isActive;
        public ValueDescription isLocked;
        public String description;
        public Person student;
        public CodeDescription degree;
        public CodeDescription school;
        public CodeDescription officialTrackingStatus;
        public Date createDate;
        public Date modifyDate;
        public Person createdWho;
        public Person modifyWho;
        public List<Year> years;
    }

    public static class RegisterRequest {
        public String bannerId;
        public String term;
        public String altPin;
        public String systemIn;
        public String registrationDate;
        public String conditionalAddDrop;
        public List<CourseReferenceNumber> courseReferenceNumbers;
        public List<RegisterAction> actionsAndOptions;
        public String holdPassword;

        public RegisterRequest(String term, String bannerId, String pin, boolean admin) {
            this.term = term;
            this.bannerId = bannerId;
            this.altPin = pin;
            this.systemIn = admin ? "SB" : "WA";
        }

        public RegisterRequest drop(String crn, Map<String, String> actions) {
            String action;
            if (this.actionsAndOptions == null) {
                this.actionsAndOptions = new ArrayList<RegisterAction>();
            }
            if (actions != null && (action = actions.get(crn)) != null && action.startsWith("D")) {
                this.actionsAndOptions.add(new RegisterAction(action, crn));
                return this;
            }
            this.actionsAndOptions.add(new RegisterAction("SB".equals(this.systemIn) ? "DDD" : "DW", crn));
            return this;
        }

        public RegisterRequest keep(String crn) {
            if (this.courseReferenceNumbers == null) {
                this.courseReferenceNumbers = new ArrayList<CourseReferenceNumber>();
            }
            this.courseReferenceNumbers.add(new CourseReferenceNumber(crn));
            return this;
        }

        public RegisterRequest add(String crn, boolean changeStatus) {
            if (changeStatus) {
                if (this.actionsAndOptions == null) {
                    this.actionsAndOptions = new ArrayList<RegisterAction>();
                }
                this.actionsAndOptions.add(new RegisterAction("SB".equals(this.systemIn) ? "RE" : "RW", crn));
            } else {
                if (this.courseReferenceNumbers == null) {
                    this.courseReferenceNumbers = new ArrayList<CourseReferenceNumber>();
                }
                this.courseReferenceNumbers.add(new CourseReferenceNumber(crn));
            }
            return this;
        }

        public RegisterRequest empty() {
            if (this.courseReferenceNumbers == null) {
                this.courseReferenceNumbers = new ArrayList<CourseReferenceNumber>();
            }
            this.courseReferenceNumbers.add(new CourseReferenceNumber());
            return this;
        }

        public boolean isEmpty() {
            return !(this.actionsAndOptions != null && !this.actionsAndOptions.isEmpty() || this.courseReferenceNumbers != null && !this.courseReferenceNumbers.isEmpty());
        }

        public void setConditionalAddDrop(boolean cond) {
            this.conditionalAddDrop = cond ? "Y" : "N";
        }

        public void setRegistrationDate(DateTime date) {
            this.registrationDate = date.toString("yyyy-MM-dd");
        }
    }

    public static class RegisterAction {
        public String courseReferenceNumber;
        public String selectedAction;
        public String selectedLevel;
        public String selectedGradingMode;
        public String selectedStudyPath;
        public String selectedCreditHour;
        public Boolean remove;

        public RegisterAction(String action, String crn) {
            this.selectedAction = action;
            this.courseReferenceNumber = crn;
        }

        public RegisterAction(String crn) {
            this.courseReferenceNumber = crn;
        }
    }

    public static class CourseReferenceNumber {
        public String courseReferenceNumber;
        public String courseRegistrationStatus;
        public String courseOverride;

        public CourseReferenceNumber() {
        }

        public CourseReferenceNumber(String crn) {
            this.courseReferenceNumber = crn;
        }

        public CourseReferenceNumber(String crn, String status) {
            this.courseReferenceNumber = crn;
            this.courseRegistrationStatus = status;
        }
    }

    public static class RegisterResponse {
        public static final Type TYPE_LIST = new TypeToken<ArrayList<RegisterResponse>>(){}.getType();
        public List<FailedRegistration> failedRegistrations;
        public List<String> failureReasons;
        public List<Registration> registrations;
        public List<TimeTicket> timeTickets;
        public Boolean validStudent;
        public String registrationException;
        public Float minHours;
        public Float maxHours;
    }

    public static class FailedRegistration {
        public String failedCRN;
        public String failure;
        public Registration registration;
    }

    public static class TimeTicket {
        public DateTime beginDate;
        public DateTime endDate;
        public String startTime;
        public String endTime;
    }

    public static class RegistrationAction {
        public String courseRegistrationStatus;
        public String description;
        public Boolean remove;
        public String voiceType;
    }

    public static class CrnError {
        public String errorFlag;
        public String message;
        public String messageType;
    }

    public static class Registration {
        public String subject;
        public String subjectDescription;
        public String courseNumber;
        public String courseReferenceNumber;
        public String courseTitle;
        public String courseRegistrationStatus;
        public String courseRegistrationStatusDescription;
        public Float creditHour;
        public CreditHours creditHours;
        public String gradingMode;
        public String gradingModeDescription;
        public List<RegistrationGradingMode> registrationGradingModes;
        public String level;
        public String levelDescription;
        public DateTime registrationStatusDate;
        public String scheduleDescription;
        public String scheduleType;
        public String sequenceNumber;
        public String statusDescription;
        public String statusIndicator;
        public List<CrnError> crnErrors;
        public String term;
        public String campus;
        public List<RegistrationAction> registrationActions;

        public boolean can(String status) {
            if (this.registrationActions != null) {
                for (RegistrationAction action : this.registrationActions) {
                    if (!status.equals(action.courseRegistrationStatus)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean canDrop(boolean admin, Map<String, String> actions) {
            if (this.can(admin ? "DDD" : "DW")) {
                return true;
            }
            if (this.registrationActions != null) {
                for (RegistrationAction action : this.registrationActions) {
                    if (action.courseRegistrationStatus == null || !action.courseRegistrationStatus.startsWith("D")) continue;
                    actions.put(this.courseReferenceNumber, action.courseRegistrationStatus);
                    return true;
                }
            }
            return false;
        }

        public boolean canAdd(boolean admin) {
            return this.can(admin ? "RE" : "RW");
        }

        public boolean isRegistered() {
            return "R".equals(this.statusIndicator);
        }
    }
}

