/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import java.io.UnsupportedEncodingException;
import javax.mail.MessagingException;
import org.unitime.commons.Email;
import org.unitime.commons.JavaMailWrapper;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.StudentEmailProvider;

public class BoilerConnectEmailAddress
implements StudentEmailProvider {
    @Override
    public Email createEmail(OnlineSectioningServer server, OnlineSectioningHelper helper, Boolean optional) {
        if (optional == null) {
            if (this.isAlwaysUse()) {
                return new BoilerConnectEmail(helper.getAction());
            }
            return new JavaMailWrapper();
        }
        if (optional.booleanValue()) {
            return new BoilerConnectEmail(helper.getAction());
        }
        return new JavaMailWrapper();
    }

    @Override
    public String getToggleCaptionIfOptional() {
        if (this.isAlwaysUse()) {
            return null;
        }
        return ApplicationProperties.getProperty("purdue.boilerconnect.toggleCaption", "Send via BoilerConnect (<i>user@boilerconnect.purdue.edu</i> email address)");
    }

    @Override
    public boolean isOptionCheckedByDefault() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.boilerconnect.toggleDefault", "true"));
    }

    public boolean isAlwaysUse() {
        return "true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.boilerconnect.isAlwaysUse", "false"));
    }

    static class BoilerConnectEmail
    extends JavaMailWrapper {
        String iReplyToEmail = null;
        String iReplyToName = null;
        String iRecipientEmail = null;
        String iRecipientName = null;
        String iSuffix = ApplicationProperties.getProperty("purdue.boilerconnect.oldSuffix", "@purdue.edu");
        OnlineSectioningLog.Action.Builder iAction;

        BoilerConnectEmail(OnlineSectioningLog.Action.Builder action) {
            this.iAction = action;
        }

        @Override
        public void setReplyTo(String email, String name) throws UnsupportedEncodingException, MessagingException {
            if (email.endsWith(this.iSuffix)) {
                this.iReplyToEmail = email;
                this.iReplyToName = name;
            }
            super.setReplyTo(email, name);
        }

        @Override
        public void addRecipient(String email, String name) throws UnsupportedEncodingException, MessagingException {
            if (this.iRecipientEmail == null && email.endsWith(this.iSuffix)) {
                this.iRecipientEmail = email;
                this.iRecipientName = name;
            } else {
                super.addRecipient(email, name);
            }
        }

        @Override
        public void send() throws MessagingException, UnsupportedEncodingException {
            if (this.iRecipientEmail != null && this.iReplyToEmail != null) {
                String email = this.iRecipientEmail.replace(this.iSuffix, ApplicationProperties.getProperty("purdue.boilerconnect.newSuffix", "@boilerconnect.purdue.edu"));
                super.addRecipient(email, this.iRecipientName);
                this.setFrom(this.iReplyToEmail, this.iReplyToName);
                if (this.iAction != null) {
                    this.iAction.addOptionBuilder().setKey("bc-email").setValue(email);
                    this.iAction.addOptionBuilder().setKey("bc-sender").setValue(this.iReplyToEmail);
                }
            } else if (this.iRecipientEmail != null) {
                super.addRecipient(this.iRecipientEmail, this.iRecipientName);
            }
            super.send();
        }
    }
}

