/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.advisors;

import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.AdvisorCourseRequestsValidationProvider;
import org.unitime.timetable.onlinesectioning.custom.Customization;

public class AdvisorCourseRequestsValidate
implements OnlineSectioningAction<CourseRequestInterface.CheckCoursesResponse> {
    private static final long serialVersionUID = 1L;
    protected static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    protected static StudentSectioningConstants CONST = Localization.create(StudentSectioningConstants.class);
    private OnlineSectioningInterface.AdvisingStudentDetails iDetails;

    public AdvisorCourseRequestsValidate withDetails(OnlineSectioningInterface.AdvisingStudentDetails details) {
        this.iDetails = details;
        return this;
    }

    public OnlineSectioningInterface.AdvisingStudentDetails getDetails() {
        return this.iDetails;
    }

    @Override
    public CourseRequestInterface.CheckCoursesResponse execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        try {
            AdvisorCourseRequestsValidationProvider provider;
            OnlineSectioningLog.Action.Builder action = helper.getAction();
            action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.getDetails().getStudentId()).setExternalId(this.getDetails().getStudentExternalId()).setName(this.getDetails().getStudentName()));
            if (this.getDetails().getStatus() != null && this.getDetails().getStatus().getUniqueId() != null) {
                action.addOther(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.getDetails().getStatus().getUniqueId()).setName(this.getDetails().getStatus().getLabel()).setExternalId(this.getDetails().getStatus().getReference()).setType(OnlineSectioningLog.Entity.EntityType.OTHER));
            }
            if (this.getDetails().getRequest() != null) {
                for (OnlineSectioningLog.Request r : OnlineSectioningHelper.toProto(this.getDetails().getRequest())) {
                    action.addRequest(r);
                }
            }
            if ((provider = (AdvisorCourseRequestsValidationProvider)Customization.AdvisorCourseRequestsValidationProvider.getProvider()) == null) {
                return null;
            }
            CourseRequestInterface.CheckCoursesResponse ret = new CourseRequestInterface.CheckCoursesResponse();
            provider.validateAdvisorRecommendations(server, helper, this.getDetails(), ret);
            if (ret.hasMessages()) {
                for (CourseRequestInterface.CourseMessage m : ret.getMessages()) {
                    if (!m.hasCourse()) continue;
                    action.addMessageBuilder().setText(m.toString()).setLevel(m.isError() ? OnlineSectioningLog.Message.Level.ERROR : (m.isConfirm() ? OnlineSectioningLog.Message.Level.WARN : OnlineSectioningLog.Message.Level.INFO));
                }
            }
            if (ret.hasCreditNote()) {
                action.addMessageBuilder().setText(ret.getCreditNote()).setLevel(OnlineSectioningLog.Message.Level.INFO);
            }
            if (ret.hasCreditWarning()) {
                action.addMessageBuilder().setText(ret.getCreditWarning()).setLevel(OnlineSectioningLog.Message.Level.WARN);
            }
            if (ret.hasErrorMessage()) {
                action.addMessageBuilder().setText(ret.getErrorMessage()).setLevel(OnlineSectioningLog.Message.Level.ERROR);
            }
            if (ret.isError()) {
                action.setResult(OnlineSectioningLog.Action.ResultType.FAILURE);
            } else if (ret.isConfirm()) {
                action.setResult(OnlineSectioningLog.Action.ResultType.FALSE);
            } else {
                action.setResult(OnlineSectioningLog.Action.ResultType.TRUE);
            }
            return ret;
        }
        catch (Exception e) {
            helper.error("Failed to validate: " + e.getMessage(), e);
            throw new SectioningException(e.getMessage(), e);
        }
    }

    @Override
    public String name() {
        return "advisor-validate";
    }
}

