/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Session;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseRequestOption;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentClassPref;
import org.unitime.timetable.model.StudentInstrMthPref;
import org.unitime.timetable.model.StudentSectioningPref;
import org.unitime.timetable.model.base.BaseCourseRequest;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.InstructionalMethodDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;

public class CourseRequest
extends BaseCourseRequest
implements Comparable {
    private static final long serialVersionUID = 1L;

    public CourseRequest() {
    }

    public CourseRequest(Long uniqueId) {
        super(uniqueId);
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof CourseRequest)) {
            return -1;
        }
        CourseRequest cr = (CourseRequest)o;
        int cmp = this.getOrder().compareTo(cr.getOrder());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? new Long(-1L) : this.getUniqueId()).compareTo(cr.getUniqueId() == null ? -1L : cr.getUniqueId());
    }

    public List<StudentClassEnrollment> getClassEnrollments() {
        ArrayList<StudentClassEnrollment> ret = new ArrayList<StudentClassEnrollment>();
        for (StudentClassEnrollment e : this.getCourseDemand().getStudent().getClassEnrollments()) {
            if (!this.getCourseOffering().equals(e.getCourseOffering())) continue;
            ret.add(e);
        }
        return ret;
    }

    public CourseRequestOption getCourseRequestOption(OnlineSectioningLog.CourseRequestOption.OptionType type) {
        if (this.getCourseRequestOptions() == null) {
            return null;
        }
        for (CourseRequestOption option : this.getCourseRequestOptions()) {
            if (!type.equals((Object)option.getType())) continue;
            return option;
        }
        return null;
    }

    public void setCourseRequestOption(OnlineSectioningLog.CourseRequestOption option) {
        CourseRequestOption o;
        if (this.getCourseRequestOptions() == null) {
            this.setCourseRequestOptions(new HashSet<CourseRequestOption>());
        }
        if ((o = this.getCourseRequestOption(option.getType())) == null) {
            o = new CourseRequestOption();
            o.setCourseRequest(this);
            o.setOption(option);
            this.getCourseRequestOptions().add(o);
        } else {
            o.setOption(option);
        }
    }

    public void clearCourseRequestOption(OnlineSectioningLog.CourseRequestOption.OptionType type) {
        if (this.getCourseRequestOptions() == null) {
            return;
        }
        Iterator<CourseRequestOption> i = this.getCourseRequestOptions().iterator();
        while (i.hasNext()) {
            CourseRequestOption option = i.next();
            if (type != null && !type.equals((Object)option.getType())) continue;
            i.remove();
        }
    }

    public void updateCourseRequestOption(OnlineSectioningLog.CourseRequestOption.OptionType type, OnlineSectioningLog.CourseRequestOption.Builder option) {
        if (this.getCourseRequestOptions() == null) {
            this.setCourseRequestOptions(new HashSet<CourseRequestOption>());
        }
        Iterator<CourseRequestOption> i = this.getCourseRequestOptions().iterator();
        while (i.hasNext()) {
            CourseRequestOption o = i.next();
            if (!type.equals((Object)o.getType())) continue;
            if (option == null) {
                i.remove();
            } else {
                o.setOption(option.build());
            }
            return;
        }
        if (option != null) {
            CourseRequestOption o = new CourseRequestOption();
            o.setCourseRequest(this);
            o.setOption(option.build());
            this.getCourseRequestOptions().add(o);
        }
    }

    public CourseRequestOverrideStatus getCourseRequestOverrideStatus() {
        if (this.getOverrideStatus() == null) {
            return CourseRequestOverrideStatus.APPROVED;
        }
        return CourseRequestOverrideStatus.values()[this.getOverrideStatus()];
    }

    public void setCourseRequestOverrideStatus(CourseRequestOverrideStatus status) {
        this.setOverrideStatus(status == null ? null : new Integer(status.ordinal()));
    }

    public void setCourseRequestOverrideIntent(CourseRequestOverrideIntent intent) {
        if (intent == null) {
            this.setOverrideIntent(null);
        } else {
            this.setOverrideIntent(intent.ordinal());
        }
    }

    public CourseRequestOverrideIntent getCourseRequestOverrideIntent() {
        return this.getOverrideIntent() == null ? null : CourseRequestOverrideIntent.values()[this.getOverrideIntent()];
    }

    public boolean isRequestApproved() {
        return this.getOverrideStatus() == null || this.getOverrideStatus().intValue() == CourseRequestOverrideStatus.APPROVED.ordinal();
    }

    public boolean isRequestPending() {
        return this.getOverrideStatus() != null && this.getOverrideStatus().intValue() == CourseRequestOverrideStatus.PENDING.ordinal();
    }

    public boolean isRequestCancelled() {
        return this.getOverrideStatus() != null && this.getOverrideStatus().intValue() == CourseRequestOverrideStatus.CANCELLED.ordinal();
    }

    public boolean isRequestRejected() {
        return this.getOverrideStatus() != null && this.getOverrideStatus().intValue() == CourseRequestOverrideStatus.REJECTED.ordinal();
    }

    public boolean updatePreferences(CourseRequestInterface.RequestedCourse rc, Session hibSession) {
        StudentSectioningPref r;
        Iterator i;
        ArrayList<StudentSectioningPref> remain = null;
        boolean changed = false;
        if (this.getPreferences() == null) {
            this.setPreferences(new HashSet<StudentSectioningPref>());
        } else {
            remain = new ArrayList<StudentSectioningPref>(this.getPreferences());
        }
        if (rc != null && rc.hasSelectedClasses()) {
            block0: for (CourseRequestInterface.Preference preference : rc.getSelectedClasses()) {
                Class_ clazz = (Class_)Class_DAO.getInstance().get(preference.getId(), hibSession);
                if (clazz == null) continue;
                if (remain != null) {
                    i = remain.iterator();
                    while (i.hasNext()) {
                        r = (StudentSectioningPref)i.next();
                        if (!(r instanceof StudentClassPref) || !((StudentClassPref)r).getClazz().equals(clazz)) continue;
                        i.remove();
                        if (r.getRequired().booleanValue() == preference.isRequired()) continue block0;
                        r.setRequired(preference.isRequired());
                        hibSession.update((Object)r);
                        changed = true;
                        continue block0;
                    }
                }
                StudentClassPref scp = new StudentClassPref();
                scp.setCourseRequest(this);
                scp.setRequired(preference.isRequired());
                scp.setClazz(clazz);
                scp.setLabel(clazz.getClassPrefLabel(this.getCourseOffering()));
                this.getPreferences().add(scp);
                changed = true;
            }
        }
        if (rc != null && rc.hasSelectedIntructionalMethods()) {
            block2: for (CourseRequestInterface.Preference preference : rc.getSelectedIntructionalMethods()) {
                InstructionalMethod im = (InstructionalMethod)InstructionalMethodDAO.getInstance().get(preference.getId(), hibSession);
                if (im == null) continue;
                if (remain != null) {
                    i = remain.iterator();
                    while (i.hasNext()) {
                        r = (StudentSectioningPref)i.next();
                        if (!(r instanceof StudentInstrMthPref) || !((StudentInstrMthPref)r).getInstructionalMethod().equals(im)) continue;
                        i.remove();
                        if (r.getRequired().booleanValue() == preference.isRequired()) continue block2;
                        r.setRequired(preference.isRequired());
                        hibSession.update((Object)r);
                        changed = true;
                        continue block2;
                    }
                }
                StudentInstrMthPref imp = new StudentInstrMthPref();
                imp.setCourseRequest(this);
                imp.setRequired(preference.isRequired());
                imp.setInstructionalMethod(im);
                imp.setLabel(im.getLabel());
                this.getPreferences().add(imp);
                changed = true;
            }
        }
        if (remain != null) {
            for (StudentSectioningPref studentSectioningPref : remain) {
                hibSession.delete((Object)studentSectioningPref);
                this.getPreferences().remove(studentSectioningPref);
                changed = true;
            }
        }
        return changed;
    }

    public static enum CourseRequestOverrideIntent {
        REGISTER,
        ADD,
        DROP,
        CHANGE,
        EX_ADD,
        EX_DROP,
        EX_CHANGE;

    }

    public static enum CourseRequestOverrideStatus {
        PENDING,
        APPROVED,
        REJECTED,
        CANCELLED;

    }
}

