/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.ScriptInterface;

public class TaskInterface
implements GwtRpcResponse,
Comparable<TaskInterface> {
    private Long iId;
    private String iName;
    private String iEmail;
    private ScriptInterface iScript;
    private boolean iCanEdit = false;
    private boolean iCanView = false;
    private Date iLastExecuted;
    private ExecutionStatus iLastStatus;
    private Map<String, String> iParameters = new HashMap<String, String>();
    private EventInterface.ContactInterface iOwner;
    private TreeSet<TaskExecutionInterface> iExecutions;

    public TaskInterface() {
    }

    public TaskInterface(TaskInterface t) {
        this.iId = t.getId();
        this.iName = t.getName();
        this.iEmail = t.getEmail();
        this.iScript = t.getScript();
        this.iCanEdit = t.canEdit();
        this.iCanView = t.canView();
        this.iLastExecuted = t.getLastExecuted();
        this.iLastStatus = t.getLastStatus();
        this.iParameters = t.getParameters() == null ? null : new HashMap<String, String>(t.getParameters());
        this.iOwner = t.getOwner();
        if (t.getExecutions() != null) {
            for (TaskExecutionInterface e : t.getExecutions()) {
                this.addExecution(new TaskExecutionInterface(e));
            }
        }
    }

    public Long getId() {
        return this.iId;
    }

    public void setId(Long id) {
        this.iId = id;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public String getEmail() {
        return this.iEmail;
    }

    public void setEmail(String email) {
        this.iEmail = email;
    }

    public ScriptInterface getScript() {
        return this.iScript;
    }

    public void setScript(ScriptInterface script) {
        this.iScript = script;
    }

    public boolean canEdit() {
        return this.iCanEdit;
    }

    public void setCanEdit(boolean canEdit) {
        this.iCanEdit = canEdit;
    }

    public boolean canView() {
        return this.iCanView;
    }

    public void setCanView(boolean canView) {
        this.iCanView = canView;
    }

    public Date getLastExecuted() {
        return this.iLastExecuted;
    }

    public void setLastExecuted(Date lastExecuted) {
        this.iLastExecuted = lastExecuted;
    }

    public ExecutionStatus getLastStatus() {
        return this.iLastStatus;
    }

    public void setLastStatus(ExecutionStatus lastStatus) {
        this.iLastStatus = lastStatus;
    }

    public void setParameter(String name, String value) {
        this.iParameters.put(name, value);
    }

    public String getParameter(String name) {
        return this.iParameters.get(name);
    }

    public Map<String, String> getParameters() {
        return this.iParameters;
    }

    public void clearParameters() {
        if (this.iParameters != null) {
            this.iParameters.clear();
        }
    }

    public EventInterface.ContactInterface getOwner() {
        return this.iOwner;
    }

    public void setOwner(EventInterface.ContactInterface owner) {
        this.iOwner = owner;
    }

    public boolean hasExecutions() {
        return this.iExecutions != null && !this.iExecutions.isEmpty();
    }

    public void addExecution(TaskExecutionInterface execution) {
        if (this.iExecutions == null) {
            this.iExecutions = new TreeSet();
        }
        this.iExecutions.add(execution);
    }

    public TreeSet<TaskExecutionInterface> getExecutions() {
        return this.iExecutions;
    }

    public void setExecutions(TreeSet<TaskExecutionInterface> Executions) {
        this.iExecutions = Executions;
    }

    public boolean hasExecutionsOfStatus(ExecutionStatus status) {
        if (this.iExecutions == null) {
            return false;
        }
        for (TaskExecutionInterface execution : this.iExecutions) {
            if (status != execution.getStatus()) continue;
            return true;
        }
        return false;
    }

    public void clearExecutions() {
        if (this.iExecutions != null) {
            this.iExecutions.clear();
        }
    }

    @Override
    public int compareTo(TaskInterface o) {
        int cmp = this.getName().compareTo(o.getName());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getId() == null ? new Long(0L) : this.getId()).compareTo(o.getId() == null ? 0L : o.getId());
    }

    public String toString() {
        return this.getName();
    }

    public static TreeSet<MultiExecutionInterface> getMultiExecutions(Collection<TaskExecutionInterface> executions, boolean checkPast) {
        HashSet executionSet;
        TreeSet<MultiExecutionInterface> ret = new TreeSet<MultiExecutionInterface>();
        HashSet<Object> hashSet = executionSet = executions == null ? new HashSet() : new HashSet<TaskExecutionInterface>(executions);
        while (!executionSet.isEmpty()) {
            TaskExecutionInterface execution = null;
            for (TaskExecutionInterface t : executionSet) {
                if (execution != null && execution.compareTo(t) <= 0) continue;
                execution = t;
            }
            executionSet.remove(execution);
            HashMap<Integer, TaskExecutionInterface> similar = new HashMap<Integer, TaskExecutionInterface>();
            TreeSet<Integer> dow = new TreeSet<Integer>();
            dow.add(execution.getDayOfWeek());
            for (TaskExecutionInterface m : executionSet) {
                if (!m.getExecutionTime(null).equals(execution.getExecutionTime(null)) || checkPast && m.isPast() != execution.isPast() || m.getStatus() != execution.getStatus()) continue;
                if (m.getDayOfYear() - execution.getDayOfYear() < 7) {
                    dow.add(m.getDayOfWeek());
                }
                similar.put(m.getDayOfYear(), m);
            }
            TreeSet<TaskExecutionInterface> multi = new TreeSet<TaskExecutionInterface>();
            multi.add(execution);
            if (!similar.isEmpty()) {
                int w = execution.getDayOfWeek();
                int y = execution.getDayOfYear();
                while (true) {
                    ++y;
                    if (!dow.contains(w = (w + 1) % 7)) continue;
                    TaskExecutionInterface m = (TaskExecutionInterface)similar.get(y);
                    if (m == null) break;
                    multi.add(m);
                    executionSet.remove(m);
                }
            }
            ret.add(new MultiExecutionInterface(multi, execution.isPast()));
        }
        return ret;
    }

    public static class GetTaskOptionsRpcRequest
    implements GwtRpcRequest<TaskOptionsInterface> {
    }

    public static class DeleteTaskDetailsRpcRequest
    implements GwtRpcRequest<TaskInterface> {
        private Long iTaskId;

        public DeleteTaskDetailsRpcRequest() {
        }

        public DeleteTaskDetailsRpcRequest(Long taskId) {
            this.iTaskId = taskId;
        }

        public Long getTaskId() {
            return this.iTaskId;
        }

        public void setTaskId(Long id) {
            this.iTaskId = id;
        }
    }

    public static class SaveTaskDetailsRpcRequest
    implements GwtRpcRequest<TaskInterface> {
        private TaskInterface iTask;

        public SaveTaskDetailsRpcRequest() {
        }

        public SaveTaskDetailsRpcRequest(TaskInterface task) {
            this.iTask = task;
        }

        public TaskInterface getTask() {
            return this.iTask;
        }

        public void setTask(TaskInterface task) {
            this.iTask = task;
        }
    }

    public static class TaskExecutionLogInterface
    implements GwtRpcResponse {
        String iLog;

        public TaskExecutionLogInterface() {
        }

        public TaskExecutionLogInterface(String log) {
            this.iLog = log;
        }

        public boolean hasLog() {
            return this.iLog != null && !this.iLog.isEmpty();
        }

        public String getLog() {
            return this.iLog;
        }

        public void setLog(String log) {
            this.iLog = log;
        }
    }

    public static class GetTaskExecutionLogRpcRequest
    implements GwtRpcRequest<TaskExecutionLogInterface> {
        private Long iTaskExecutionId;

        public GetTaskExecutionLogRpcRequest() {
        }

        public GetTaskExecutionLogRpcRequest(Long execId) {
            this.iTaskExecutionId = execId;
        }

        public Long getTaskExecutionId() {
            return this.iTaskExecutionId;
        }

        public void setTaskExecutionId(Long id) {
            this.iTaskExecutionId = id;
        }
    }

    public static class GetTasksRpcRequest
    implements GwtRpcRequest<GwtRpcResponseList<TaskInterface>> {
    }

    public static class TaskOptionsInterface
    implements GwtRpcResponse {
        private boolean iCanAdd;
        private EventInterface.ContactInterface iManager;
        private List<ScriptInterface> iScripts = new ArrayList<ScriptInterface>();
        private AcademicSessionProvider.AcademicSessionInfo iSession;
        private List<EventInterface.SessionMonth> iMonths = new ArrayList<EventInterface.SessionMonth>();
        private int iFirstDayOfWeek = 0;

        public void addScript(ScriptInterface script) {
            this.iScripts.add(script);
        }

        public List<ScriptInterface> getScripts() {
            return this.iScripts;
        }

        public void setSession(AcademicSessionProvider.AcademicSessionInfo session) {
            this.iSession = session;
        }

        public AcademicSessionProvider.AcademicSessionInfo getSession() {
            return this.iSession;
        }

        public boolean canAdd() {
            return this.iCanAdd;
        }

        public void setCanAdd(boolean canAdd) {
            this.iCanAdd = canAdd;
        }

        public EventInterface.ContactInterface getManager() {
            return this.iManager;
        }

        public void setManager(EventInterface.ContactInterface manager) {
            this.iManager = manager;
        }

        public void setSessionMonth(List<EventInterface.SessionMonth> months) {
            this.iMonths = months;
        }

        public List<EventInterface.SessionMonth> getSessionMonths() {
            return this.iMonths;
        }

        public int getFirstDayOfWeek() {
            return this.iFirstDayOfWeek;
        }

        public void setFirstDayOfWeek(int firstDayOfWeek) {
            this.iFirstDayOfWeek = firstDayOfWeek;
        }
    }

    public static class MultiExecutionInterface
    implements Comparable<MultiExecutionInterface>,
    IsSerializable {
        private TreeSet<TaskExecutionInterface> iExecutions;
        private boolean iPast = false;

        public MultiExecutionInterface(TreeSet<TaskExecutionInterface> executions, boolean past) {
            this.iExecutions = executions;
            this.iPast = past;
        }

        public boolean isPast() {
            return this.iPast;
        }

        public TreeSet<TaskExecutionInterface> getExecutions() {
            return this.iExecutions;
        }

        @Override
        public int compareTo(MultiExecutionInterface m) {
            return this.getExecutions().first().compareTo(m.getExecutions().first());
        }

        public String getDays() {
            return this.getDays(0, new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"}, new String[]{"M", "T", "W", "Th", "F", "S", "Su"}, "Daily");
        }

        public String getDays(int firstDayOfWeek, GwtConstants constants) {
            return this.getDays(firstDayOfWeek, constants.days(), constants.shortDays(), constants.daily());
        }

        public String getDays(int firstDayOfWeek, String[] dayNames, String[] shortDyNames, String daily) {
            int nrDays = 0;
            int dayCode = 0;
            for (TaskExecutionInterface meeting : this.getExecutions()) {
                int dc = 1 << meeting.getDayOfWeek();
                if ((dayCode & dc) == 0) {
                    ++nrDays;
                }
                dayCode |= dc;
            }
            if (nrDays == 7) {
                return daily;
            }
            String ret = "";
            for (int i = 0; i < 7; ++i) {
                int d = (i + firstDayOfWeek) % 7;
                if ((dayCode & 1 << d) == 0) continue;
                ret = ret + (nrDays == 1 ? dayNames : shortDyNames)[d];
            }
            return ret;
        }

        public Date getFirstExecutionDate() {
            return this.iExecutions.first().getExecutionDate();
        }

        public Date getLastExecutionDate() {
            return this.iExecutions.last().getExecutionDate();
        }

        public String getExecutionTime(GwtConstants constants) {
            return this.iExecutions.first().getExecutionTime(constants);
        }

        public int getNrMeetings() {
            return this.iExecutions.size();
        }

        public ExecutionStatus getStatus() {
            return this.iExecutions.first().getStatus();
        }
    }

    public static class TaskExecutionInterface
    implements IsSerializable,
    Comparable<TaskExecutionInterface> {
        private Long iId;
        private Integer iDayOfYear;
        private Integer iSlot;
        private ExecutionStatus iStatus;
        private Date iCreated;
        private Date iQueued;
        private Date iStarted;
        private Date iFinished;
        private String iOutput;
        private Date iExecutionDate;
        private int iDayOfWeek;
        private String iStatusMessage;

        public TaskExecutionInterface() {
        }

        public TaskExecutionInterface(TaskExecutionInterface e) {
            this.iId = e.getId();
            this.iDayOfYear = e.getDayOfYear();
            this.iSlot = e.getSlot();
            this.iStatus = e.getStatus();
            this.iCreated = e.getCreated();
            this.iQueued = e.getQueued();
            this.iStarted = e.getStarted();
            this.iFinished = e.getFinished();
            this.iOutput = e.getOutput();
            this.iExecutionDate = e.getExecutionDate();
            this.iDayOfWeek = e.getDayOfWeek();
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public Integer getDayOfYear() {
            return this.iDayOfYear;
        }

        public boolean hasDayOfYear() {
            return this.iDayOfYear != null;
        }

        public void setDayOfYear(Integer dayOfYear) {
            this.iDayOfYear = dayOfYear;
        }

        public Integer getSlot() {
            return this.iSlot;
        }

        public boolean hasSlot() {
            return this.iSlot != null;
        }

        public void setSlot(Integer slot) {
            this.iSlot = slot;
        }

        public boolean hasStatus() {
            return this.iStatus != null;
        }

        public ExecutionStatus getStatus() {
            return this.iStatus;
        }

        public void setStatus(ExecutionStatus status) {
            this.iStatus = status;
        }

        public boolean hasCreated() {
            return this.iCreated != null;
        }

        public Date getCreated() {
            return this.iCreated;
        }

        public void setCreated(Date date) {
            this.iCreated = date;
        }

        public boolean hasQueued() {
            return this.iQueued != null;
        }

        public Date getQueued() {
            return this.iQueued;
        }

        public void setQueued(Date date) {
            this.iQueued = date;
        }

        public boolean hasStarted() {
            return this.iStarted != null;
        }

        public Date getStarted() {
            return this.iStarted;
        }

        public void setStarted(Date date) {
            this.iStarted = date;
        }

        public boolean hasFinished() {
            return this.iFinished != null;
        }

        public Date getFinished() {
            return this.iFinished;
        }

        public void setFinished(Date date) {
            this.iFinished = date;
        }

        public boolean hasOutput() {
            return this.iOutput != null && !this.iOutput.isEmpty();
        }

        public String getOutput() {
            return this.iOutput;
        }

        public void setOutput(String output) {
            this.iOutput = output;
        }

        public Date getExecutionDate() {
            return this.iExecutionDate;
        }

        public void setExecutionDate(Date date) {
            this.iExecutionDate = date;
        }

        public int getDayOfWeek() {
            return this.iDayOfWeek;
        }

        public void setDayOfWeek(int dayOfWeek) {
            this.iDayOfWeek = dayOfWeek;
        }

        public boolean hasStatusMessage() {
            return this.iStatusMessage != null && !this.iStatusMessage.isEmpty();
        }

        public void setStatusMessage(String statusMessage) {
            this.iStatusMessage = statusMessage;
        }

        public String getStatusMessage() {
            return this.iStatusMessage;
        }

        public boolean isPast() {
            return this.hasFinished();
        }

        public String getExecutionTime(GwtConstants constants) {
            int min = 5 * this.iSlot;
            int h = min / 60;
            int m = min % 60;
            if (constants != null && min == 0) {
                return constants.timeMidnight();
            }
            if (constants != null && min == 720) {
                return constants.timeNoon();
            }
            if (constants == null || constants.useAmPm()) {
                return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h == 24 ? "a" : (h >= 12 ? "p" : "a"));
            }
            return h + ":" + (m < 10 ? "0" : "") + m;
        }

        @Override
        public int compareTo(TaskExecutionInterface exec) {
            int cmp = this.getDayOfYear().compareTo(exec.getDayOfYear());
            if (cmp != 0) {
                return cmp;
            }
            cmp = new Integer(this.getSlot()).compareTo(exec.getSlot());
            if (cmp != 0) {
                return cmp;
            }
            return this.getId() == null ? (exec.getId() == null ? 0 : -1) : (exec.getId() == null ? 1 : this.getId().compareTo(exec.getId()));
        }
    }

    public static enum ExecutionStatus {
        CREATED,
        QUEUED,
        RUNNING,
        FINISHED,
        FAILED;

    }
}

