/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;

public class SpecialRegistrationInterface
implements IsSerializable,
Serializable {
    private static final long serialVersionUID = 1L;

    public static class UpdateSpecialRegistrationResponse
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private boolean iSuccess;
        private String iMessage;

        public boolean isSuccess() {
            return this.iSuccess;
        }

        public boolean isFailure() {
            return !this.iSuccess;
        }

        public void setSuccess(boolean success) {
            this.iSuccess = success;
        }

        public boolean hasMessage() {
            return this.iMessage != null && !this.iMessage.isEmpty();
        }

        public String getMessage() {
            return this.iMessage;
        }

        public void setMessage(String message) {
            this.iMessage = message;
        }
    }

    public static class UpdateSpecialRegistrationRequest
    extends OnlineSectioningInterface.StudentSectioningContext
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String iRequestId;
        private String iNote;
        private boolean iPreReg = false;

        public UpdateSpecialRegistrationRequest() {
        }

        public UpdateSpecialRegistrationRequest(OnlineSectioningInterface.StudentSectioningContext cx, String requestId, String note, boolean preReg) {
            super(cx);
            this.iRequestId = requestId;
            this.iNote = note;
            this.iPreReg = preReg;
        }

        public String getRequestId() {
            return this.iRequestId;
        }

        public void setRequestId(String requestId) {
            this.iRequestId = requestId;
        }

        public String getNote() {
            return this.iNote;
        }

        public void setNote(String note) {
            this.iNote = note;
        }

        public boolean isPreReg() {
            return this.iPreReg;
        }

        public void setPreReg(boolean preReg) {
            this.iPreReg = preReg;
        }
    }

    public static interface ChangeRequestorNoteInterface {
        public boolean changeRequestorNote(CourseRequestInterface.RequestedCourse var1);

        public boolean changeRequestorCreditNote(CourseRequestInterface var1);

        public boolean changeRequestorNote(RetrieveSpecialRegistrationResponse var1);
    }

    public static class ChangeGradeModesResponse
    implements GwtRpcResponse,
    Serializable {
        private static final long serialVersionUID = 1L;
        private OnlineSectioningInterface.GradeModes iGradeModes = null;
        private List<RetrieveSpecialRegistrationResponse> iRequests = null;
        private Set<String> iCancelRequestIds = null;

        public boolean hasGradeModes() {
            return this.iGradeModes != null && this.iGradeModes.hasGradeModes();
        }

        public void addGradeMode(String sectionId, String code, String label, boolean honors) {
            if (this.iGradeModes == null) {
                this.iGradeModes = new OnlineSectioningInterface.GradeModes();
            }
            this.iGradeModes.addGradeMode(sectionId, new OnlineSectioningInterface.GradeMode(code, label, honors));
        }

        public OnlineSectioningInterface.GradeMode getGradeMode(ClassAssignmentInterface.ClassAssignment section) {
            if (this.iGradeModes == null) {
                return null;
            }
            return this.iGradeModes.getGradeMode(section);
        }

        public OnlineSectioningInterface.GradeModes getGradeModes() {
            return this.iGradeModes;
        }

        public boolean hasCreditHours() {
            return this.iGradeModes != null && this.iGradeModes.hasCreditHours();
        }

        public void addCreditHour(String sectionId, Float creditHour) {
            if (this.iGradeModes == null) {
                this.iGradeModes = new OnlineSectioningInterface.GradeModes();
            }
            this.iGradeModes.addCreditHour(sectionId, creditHour);
        }

        public Float getCreditHour(ClassAssignmentInterface.ClassAssignment section) {
            if (this.iGradeModes == null) {
                return null;
            }
            return this.iGradeModes.getCreditHour(section);
        }

        public boolean hasRequests() {
            return this.iRequests != null && !this.iRequests.isEmpty();
        }

        public void addRequest(RetrieveSpecialRegistrationResponse request) {
            if (this.iRequests == null) {
                this.iRequests = new ArrayList<RetrieveSpecialRegistrationResponse>();
            }
            this.iRequests.add(request);
        }

        public List<RetrieveSpecialRegistrationResponse> getRequests() {
            return this.iRequests;
        }

        public boolean hasRequest(String requestId) {
            if (this.iRequests == null) {
                return false;
            }
            for (RetrieveSpecialRegistrationResponse r : this.iRequests) {
                if (!r.getRequestId().equals(requestId)) continue;
                return true;
            }
            return false;
        }

        public void addCancelRequestId(String id) {
            if (this.iCancelRequestIds == null) {
                this.iCancelRequestIds = new HashSet<String>();
            }
            this.iCancelRequestIds.add(id);
        }

        public boolean hasCancelRequestIds() {
            return this.iCancelRequestIds != null && !this.iCancelRequestIds.isEmpty();
        }

        public Set<String> getCancelRequestIds() {
            return this.iCancelRequestIds;
        }

        public boolean isToBeCancelled(String requestId) {
            return this.iCancelRequestIds != null && this.iCancelRequestIds.contains(requestId);
        }
    }

    public static class ChangeGradeModesRequest
    extends OnlineSectioningInterface.StudentSectioningContext
    implements GwtRpcRequest<ChangeGradeModesResponse>,
    Serializable {
        private static final long serialVersionUID = 1L;
        List<SpecialRegistrationGradeModeChange> iChanges = new ArrayList<SpecialRegistrationGradeModeChange>();
        List<SpecialRegistrationCreditChange> iCreditChanges = new ArrayList<SpecialRegistrationCreditChange>();
        private String iNote;
        private Float iMaxCredit;
        private Float iCurrentCredit;

        public ChangeGradeModesRequest() {
        }

        public ChangeGradeModesRequest(OnlineSectioningInterface.StudentSectioningContext cx) {
            super(cx);
        }

        public boolean hasGradeModeChanges() {
            return !this.iChanges.isEmpty();
        }

        public void addChange(SpecialRegistrationGradeModeChange change) {
            this.iChanges.add(change);
        }

        public SpecialRegistrationGradeModeChange getChange(String sectionId) {
            for (SpecialRegistrationGradeModeChange ch : this.iChanges) {
                if (!ch.hasCRN(sectionId)) continue;
                return ch;
            }
            return null;
        }

        public List<SpecialRegistrationGradeModeChange> getChanges() {
            return this.iChanges;
        }

        public boolean hasGradeModeChanges(boolean approval) {
            for (SpecialRegistrationGradeModeChange change : this.iChanges) {
                if (approval && change.hasApprovals()) {
                    return true;
                }
                if (approval || change.hasApprovals()) continue;
                return true;
            }
            return false;
        }

        public boolean hasCreditChanges() {
            return !this.iCreditChanges.isEmpty();
        }

        public void addChange(SpecialRegistrationCreditChange change) {
            this.iCreditChanges.add(change);
        }

        public SpecialRegistrationCreditChange getCreditChange(String sectionId) {
            for (SpecialRegistrationCreditChange ch : this.iCreditChanges) {
                if (!ch.getCrn().equals(sectionId)) continue;
                return ch;
            }
            return null;
        }

        public List<SpecialRegistrationCreditChange> getCreditChanges() {
            return this.iCreditChanges;
        }

        public boolean hasCreditChanges(boolean approval) {
            for (SpecialRegistrationCreditChange change : this.iCreditChanges) {
                if (approval && change.hasApprovals()) {
                    return true;
                }
                if (approval || change.hasApprovals()) continue;
                return true;
            }
            return false;
        }

        public void setNote(String note) {
            this.iNote = note;
        }

        public String getNote() {
            return this.iNote;
        }

        public boolean hasNote() {
            return this.iNote != null && !this.iNote.isEmpty();
        }

        public Float getMaxCredit() {
            return this.iMaxCredit;
        }

        public void setMaxCredit(Float credit) {
            this.iMaxCredit = credit;
        }

        public Float getCurrentCredit() {
            return this.iCurrentCredit;
        }

        public void setCurrentCredit(Float credit) {
            this.iCurrentCredit = credit;
        }
    }

    public static class SpecialRegistrationVariableCreditChange
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Set<String> iApprovals = null;
        private Set<Float> iAvailableCredits = null;

        public boolean hasApprovals() {
            return this.iApprovals != null && !this.iApprovals.isEmpty();
        }

        public void addApproval(String app) {
            if (this.iApprovals == null) {
                this.iApprovals = new TreeSet<String>();
            }
            this.iApprovals.add(app);
        }

        public Set<String> getApprovals() {
            return this.iApprovals;
        }

        public boolean hasAvailableCredits() {
            return this.iAvailableCredits != null && !this.iAvailableCredits.isEmpty();
        }

        public void addAvailableCredit(Float credit) {
            if (this.iAvailableCredits == null) {
                this.iAvailableCredits = new TreeSet<Float>();
            }
            this.iAvailableCredits.add(credit);
        }

        public Set<Float> getAvailableCredits() {
            return this.iAvailableCredits;
        }
    }

    public static class SpecialRegistrationCreditChange
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String iSubject;
        private String iCourse;
        private String iCrn;
        private Float iCredit;
        private Float iOriginalCredit;
        private Set<String> iApprovals = null;

        public String getSubject() {
            return this.iSubject;
        }

        public void setSubject(String subject) {
            this.iSubject = subject;
        }

        public String getCourse() {
            return this.iCourse;
        }

        public void setCourse(String course) {
            this.iCourse = course;
        }

        public String getCrn() {
            return this.iCrn;
        }

        public void setCrn(String crn) {
            this.iCrn = crn;
        }

        public Float getOriginalCredit() {
            return this.iOriginalCredit;
        }

        public void setOriginalCredit(Float credit) {
            this.iOriginalCredit = credit;
        }

        public Float getCredit() {
            return this.iCredit;
        }

        public void setCredit(Float credit) {
            this.iCredit = credit;
        }

        public boolean hasApprovals() {
            return this.iApprovals != null && !this.iApprovals.isEmpty();
        }

        public void addApproval(String app) {
            if (this.iApprovals == null) {
                this.iApprovals = new TreeSet<String>();
            }
            this.iApprovals.add(app);
        }

        public Set<String> getApprovals() {
            return this.iApprovals;
        }
    }

    public static class SpecialRegistrationGradeModeChange
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String iSubject;
        private String iCourse;
        private String iCredit;
        private Set<String> iCrn;
        private Set<String> iApprovals = null;
        private String iOriginalGradeMode = null;
        private String iSelectedGradeMode = null;
        private String iSelectedGradeModeDescription = null;

        public String getSubject() {
            return this.iSubject;
        }

        public void setSubject(String subject) {
            this.iSubject = subject;
        }

        public String getCourse() {
            return this.iCourse;
        }

        public void setCourse(String course) {
            this.iCourse = course;
        }

        public String getCredit() {
            return this.iCredit;
        }

        public void setCredit(String credit) {
            this.iCredit = credit;
        }

        public String getOriginalGradeMode() {
            return this.iOriginalGradeMode;
        }

        public void setOriginalGradeMode(String gm) {
            this.iOriginalGradeMode = gm;
        }

        public String getSelectedGradeMode() {
            return this.iSelectedGradeMode;
        }

        public void setSelectedGradeMode(String gm) {
            this.iSelectedGradeMode = gm;
        }

        public String getSelectedGradeModeDescription() {
            return this.iSelectedGradeModeDescription;
        }

        public void setSelectedGradeModeDescription(String desc) {
            this.iSelectedGradeModeDescription = desc;
        }

        public boolean hasCRNs() {
            return this.iCrn != null && this.iCrn.isEmpty();
        }

        public void addCrn(String crn) {
            if (this.iCrn == null) {
                this.iCrn = new TreeSet<String>();
            }
            this.iCrn.add(crn);
        }

        public Set<String> getCRNs() {
            return this.iCrn;
        }

        public boolean hasCRN(String extId) {
            return this.iCrn != null && this.iCrn.contains(extId);
        }

        public boolean hasApprovals() {
            return this.iApprovals != null && !this.iApprovals.isEmpty();
        }

        public void addApproval(String app) {
            if (this.iApprovals == null) {
                this.iApprovals = new TreeSet<String>();
            }
            this.iApprovals.add(app);
        }

        public Set<String> getApprovals() {
            return this.iApprovals;
        }
    }

    public static class SpecialRegistrationGradeModeChanges
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private SpecialRegistrationGradeMode iCurrentGradeMode;
        private Set<SpecialRegistrationGradeMode> iAvailableChanges;

        public SpecialRegistrationGradeMode getCurrentGradeMode() {
            return this.iCurrentGradeMode;
        }

        public void setCurrentGradeMode(SpecialRegistrationGradeMode mode) {
            this.iCurrentGradeMode = mode;
        }

        public boolean isCurrentGradeMode(String code) {
            return this.iCurrentGradeMode != null && this.iCurrentGradeMode.getCode().equals(code);
        }

        public void addAvailableChange(SpecialRegistrationGradeMode mode) {
            if (this.iAvailableChanges == null) {
                this.iAvailableChanges = new TreeSet<SpecialRegistrationGradeMode>();
            }
            this.iAvailableChanges.add(mode);
        }

        public boolean hasAvailableChanges() {
            return this.iAvailableChanges != null && !this.iAvailableChanges.isEmpty();
        }

        public Set<SpecialRegistrationGradeMode> getAvailableChanges() {
            return this.iAvailableChanges;
        }

        public SpecialRegistrationGradeMode getAvailableChange(String code) {
            if (this.iAvailableChanges == null) {
                return null;
            }
            for (SpecialRegistrationGradeMode m : this.iAvailableChanges) {
                if (!m.getCode().equals(code)) continue;
                return m;
            }
            return null;
        }
    }

    public static class SpecialRegistrationVariableCredit
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private List<String> iApprovals = null;
        private Float iCredit = null;
        private Float iOriginalCredit = null;

        public SpecialRegistrationVariableCredit() {
        }

        public SpecialRegistrationVariableCredit(SpecialRegistrationVariableCreditChange change) {
            if (change.hasApprovals()) {
                this.iApprovals = new ArrayList<String>(change.getApprovals());
            }
        }

        public boolean hasApprovals() {
            return this.iApprovals != null && !this.iApprovals.isEmpty();
        }

        public List<String> getApprovals() {
            return this.iApprovals;
        }

        public void addApproval(String approval) {
            if (this.iApprovals == null) {
                this.iApprovals = new ArrayList<String>();
            }
            this.iApprovals.add(approval);
        }

        public Float getOriginalCredit() {
            return this.iOriginalCredit;
        }

        public void setOriginalCredit(Float credit) {
            this.iOriginalCredit = credit;
        }

        public Float getCredit() {
            return this.iCredit;
        }

        public void setCredit(Float credit) {
            this.iCredit = credit;
        }

        public float getCreditChange() {
            return (this.iCredit == null ? 0.0f : this.iCredit.floatValue()) - (this.iOriginalCredit == null ? 0.0f : this.iOriginalCredit.floatValue());
        }
    }

    public static class SpecialRegistrationGradeMode
    extends OnlineSectioningInterface.GradeMode {
        private static final long serialVersionUID = 1L;
        private List<String> iApprovals = null;
        private String iDisclaimer = null;
        private String iOriginalGradeMode = null;

        public SpecialRegistrationGradeMode() {
        }

        public SpecialRegistrationGradeMode(String code, String label, boolean honors) {
            super(code, label, honors);
        }

        public boolean hasApprovals() {
            return this.iApprovals != null && !this.iApprovals.isEmpty();
        }

        public List<String> getApprovals() {
            return this.iApprovals;
        }

        public void addApproval(String approval) {
            if (this.iApprovals == null) {
                this.iApprovals = new ArrayList<String>();
            }
            this.iApprovals.add(approval);
        }

        public boolean hasDisclaimer() {
            return this.iDisclaimer != null && !this.iDisclaimer.isEmpty();
        }

        public String getDisclaimer() {
            return this.iDisclaimer;
        }

        public void setDisclaimer(String disclaimer) {
            this.iDisclaimer = disclaimer;
        }

        public String getOriginalGradeMode() {
            return this.iOriginalGradeMode;
        }

        public void setOriginalGradeMode(String mode) {
            this.iOriginalGradeMode = mode;
        }
    }

    public static class RetrieveAvailableGradeModesResponse
    implements GwtRpcResponse,
    Serializable {
        private static final long serialVersionUID = 1L;
        Map<String, SpecialRegistrationGradeModeChanges> iModes = new HashMap<String, SpecialRegistrationGradeModeChanges>();
        Map<String, SpecialRegistrationVariableCreditChange> iVarCreds = new HashMap<String, SpecialRegistrationVariableCreditChange>();
        private Float iMaxCredit;
        private Float iCurrentCredit;

        public boolean hasGradeModes() {
            return !this.iModes.isEmpty();
        }

        public void add(String sectionId, SpecialRegistrationGradeModeChanges modes) {
            this.iModes.put(sectionId, modes);
        }

        public boolean hasVariableCredits() {
            return !this.iVarCreds.isEmpty();
        }

        public void add(String sectionId, SpecialRegistrationVariableCreditChange var) {
            this.iVarCreds.put(sectionId, var);
        }

        public SpecialRegistrationGradeModeChanges get(ClassAssignmentInterface.ClassAssignment a) {
            if (a.getExternalId() == null) {
                return null;
            }
            if (a.getParentSection() != null && a.getParentSection().equals(a.getSection())) {
                return null;
            }
            return this.iModes.get(a.getExternalId());
        }

        public SpecialRegistrationVariableCreditChange getVariableCredits(ClassAssignmentInterface.ClassAssignment a) {
            if (a.getExternalId() == null) {
                return null;
            }
            if (a.getParentSection() != null && a.getParentSection().equals(a.getSection())) {
                return null;
            }
            return this.iVarCreds.get(a.getExternalId());
        }

        public Float getMaxCredit() {
            return this.iMaxCredit;
        }

        public void setMaxCredit(Float credit) {
            this.iMaxCredit = credit;
        }

        public Float getCurrentCredit() {
            return this.iCurrentCredit;
        }

        public void setCurrentCredit(Float credit) {
            this.iCurrentCredit = credit;
        }
    }

    public static class RetrieveAvailableGradeModesRequest
    extends OnlineSectioningInterface.StudentSectioningContext
    implements GwtRpcRequest<RetrieveAvailableGradeModesResponse>,
    Serializable {
        private static final long serialVersionUID = 1L;

        public RetrieveAvailableGradeModesRequest() {
        }

        public RetrieveAvailableGradeModesRequest(OnlineSectioningInterface.StudentSectioningContext cx) {
            super(cx);
        }
    }

    public static class CancelSpecialRegistrationResponse
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private boolean iSuccess;
        private String iMessage;

        public boolean isSuccess() {
            return this.iSuccess;
        }

        public boolean isFailure() {
            return !this.iSuccess;
        }

        public void setSuccess(boolean success) {
            this.iSuccess = success;
        }

        public boolean hasMessage() {
            return this.iMessage != null && !this.iMessage.isEmpty();
        }

        public String getMessage() {
            return this.iMessage;
        }

        public void setMessage(String message) {
            this.iMessage = message;
        }
    }

    public static class CancelSpecialRegistrationRequest
    extends OnlineSectioningInterface.StudentSectioningContext
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String iRequestId;

        public CancelSpecialRegistrationRequest() {
        }

        public CancelSpecialRegistrationRequest(OnlineSectioningInterface.StudentSectioningContext cx) {
            super(cx);
        }

        public String getRequestId() {
            return this.iRequestId;
        }

        public void setRequestId(String requestId) {
            this.iRequestId = requestId;
        }
    }

    public static class RetrieveAllSpecialRegistrationsRequest
    extends OnlineSectioningInterface.StudentSectioningContext
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;

        public RetrieveAllSpecialRegistrationsRequest() {
        }

        public RetrieveAllSpecialRegistrationsRequest(OnlineSectioningInterface.StudentSectioningContext cx) {
            super(cx);
        }
    }

    public static class SubmitSpecialRegistrationResponse
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String iRequestId;
        private String iMessage;
        private boolean iSuccess;
        private SpecialRegistrationStatus iStatus = null;
        private List<RetrieveSpecialRegistrationResponse> iRequests = null;
        private Set<String> iCancelledRequestIds;

        public String getRequestId() {
            return this.iRequestId;
        }

        public void setRequestId(String requestId) {
            this.iRequestId = requestId;
        }

        public boolean hasMessage() {
            return this.iMessage != null && !this.iMessage.isEmpty();
        }

        public String getMessage() {
            return this.iMessage;
        }

        public void setMessage(String message) {
            this.iMessage = message;
        }

        public boolean isSuccess() {
            return this.iSuccess;
        }

        public boolean isFailure() {
            return !this.iSuccess;
        }

        public void setSuccess(boolean success) {
            this.iSuccess = success;
        }

        public SpecialRegistrationStatus getStatus() {
            return this.iStatus;
        }

        public void setStatus(SpecialRegistrationStatus status) {
            this.iStatus = status;
        }

        public List<RetrieveSpecialRegistrationResponse> getRequests() {
            return this.iRequests;
        }

        public void addRequest(RetrieveSpecialRegistrationResponse request) {
            if (this.iRequests == null) {
                this.iRequests = new ArrayList<RetrieveSpecialRegistrationResponse>();
            }
            this.iRequests.add(request);
        }

        public boolean hasRequests() {
            return this.iRequests != null && !this.iRequests.isEmpty();
        }

        public boolean hasRequest(String requestId) {
            if (this.iRequests == null) {
                return false;
            }
            for (RetrieveSpecialRegistrationResponse r : this.iRequests) {
                if (!requestId.equals(r.getRequestId())) continue;
                return true;
            }
            return false;
        }

        public void addCancelledRequest(String requestId) {
            if (this.iCancelledRequestIds == null) {
                this.iCancelledRequestIds = new HashSet<String>();
            }
            this.iCancelledRequestIds.add(requestId);
        }

        public boolean hasCancelledRequestIds() {
            return this.iCancelledRequestIds != null && !this.iCancelledRequestIds.isEmpty();
        }

        public Set<String> getCancelledRequestIds() {
            return this.iCancelledRequestIds;
        }

        public boolean isCancelledRequest(String requestId) {
            return this.iCancelledRequestIds != null && this.iCancelledRequestIds.contains(requestId);
        }
    }

    public static class SubmitSpecialRegistrationRequest
    extends OnlineSectioningInterface.StudentSectioningContext
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String iRequestId;
        private CourseRequestInterface iCourses;
        private Collection<ClassAssignmentInterface.ClassAssignment> iClassAssignments;
        private ArrayList<ClassAssignmentInterface.ErrorMessage> iErrors = null;
        private String iNote;
        private Float iCredit;

        public SubmitSpecialRegistrationRequest() {
        }

        public SubmitSpecialRegistrationRequest(OnlineSectioningInterface.StudentSectioningContext cx, String requestId, CourseRequestInterface courses, Collection<ClassAssignmentInterface.ClassAssignment> assignments, Collection<ClassAssignmentInterface.ErrorMessage> errors, String note, Float credit) {
            super(cx);
            this.iRequestId = requestId;
            this.iCourses = courses;
            this.iClassAssignments = assignments;
            if (errors != null) {
                this.iErrors = new ArrayList<ClassAssignmentInterface.ErrorMessage>(errors);
            }
            this.iNote = note;
            this.iCredit = credit;
        }

        public Collection<ClassAssignmentInterface.ClassAssignment> getClassAssignments() {
            return this.iClassAssignments;
        }

        public void setClassAssignments(Collection<ClassAssignmentInterface.ClassAssignment> assignments) {
            this.iClassAssignments = assignments;
        }

        public CourseRequestInterface getCourses() {
            return this.iCourses;
        }

        public void setCourses(CourseRequestInterface courses) {
            this.iCourses = courses;
        }

        public String getRequestId() {
            return this.iRequestId;
        }

        public void setRequestId(String requestId) {
            this.iRequestId = requestId;
        }

        public void addError(ClassAssignmentInterface.ErrorMessage error) {
            if (this.iErrors == null) {
                this.iErrors = new ArrayList();
            }
            this.iErrors.add(error);
        }

        public boolean hasErrors() {
            return this.iErrors != null && !this.iErrors.isEmpty();
        }

        public ArrayList<ClassAssignmentInterface.ErrorMessage> getErrors() {
            return this.iErrors;
        }

        public String getNote() {
            return this.iNote;
        }

        public void setNote(String note) {
            this.iNote = note;
        }

        public void setCredit(Float credit) {
            this.iCredit = credit;
        }

        public boolean hasCredit() {
            return this.iCredit != null;
        }

        public Float getCredit() {
            return this.iCredit;
        }
    }

    public static class RetrieveSpecialRegistrationResponse
    implements IsSerializable,
    Serializable,
    Comparable<RetrieveSpecialRegistrationResponse> {
        private static final long serialVersionUID = 1L;
        private SpecialRegistrationStatus iStatus;
        private Date iSubmitDate;
        private String iRequestId;
        private String iDescription;
        private String iNote;
        private List<ClassAssignmentInterface.ClassAssignment> iChanges;
        private boolean iCanCancel = false;
        private boolean iHasTimeConflict;
        private boolean iHasSpaceConflict;
        private boolean iExtended;
        private boolean iHasLinkedConflict;
        private ArrayList<ClassAssignmentInterface.ErrorMessage> iErrors = null;
        private Float iMaxCredit = null;

        public Date getSubmitDate() {
            return this.iSubmitDate;
        }

        public void setSubmitDate(Date date) {
            this.iSubmitDate = date;
        }

        public String getRequestId() {
            return this.iRequestId;
        }

        public void setRequestId(String requestId) {
            this.iRequestId = requestId;
        }

        public String getDescription() {
            return this.iDescription;
        }

        public void setDescription(String description) {
            this.iDescription = description;
        }

        public String getNote() {
            return this.iNote;
        }

        public void setNote(String note) {
            this.iNote = note;
        }

        public SpecialRegistrationStatus getStatus() {
            return this.iStatus;
        }

        public void setStatus(SpecialRegistrationStatus status) {
            this.iStatus = status;
        }

        public boolean hasChanges() {
            return this.iChanges != null && !this.iChanges.isEmpty();
        }

        public List<ClassAssignmentInterface.ClassAssignment> getChanges() {
            return this.iChanges;
        }

        public void addChange(ClassAssignmentInterface.ClassAssignment ca) {
            if (this.iChanges == null) {
                this.iChanges = new ArrayList<ClassAssignmentInterface.ClassAssignment>();
            }
            this.iChanges.add(ca);
        }

        public boolean isGradeModeChange() {
            if (this.iChanges == null) {
                return false;
            }
            for (ClassAssignmentInterface.ClassAssignment ca : this.iChanges) {
                if (ca.getGradeMode() == null) continue;
                return true;
            }
            return false;
        }

        public boolean isCreditChange() {
            if (this.iChanges == null) {
                return false;
            }
            for (ClassAssignmentInterface.ClassAssignment ca : this.iChanges) {
                if (ca.getCreditHour() == null) continue;
                return true;
            }
            return false;
        }

        public boolean isAdd(Long courseId) {
            boolean hasDrop = false;
            boolean hasAdd = false;
            for (ClassAssignmentInterface.ClassAssignment ca : this.iChanges) {
                if (!courseId.equals(ca.getCourseId())) continue;
                switch (ca.getSpecRegOperation()) {
                    case Add: {
                        hasAdd = true;
                        break;
                    }
                    case Drop: {
                        hasDrop = true;
                    }
                }
            }
            return hasAdd && !hasDrop;
        }

        public boolean isDrop(Long courseId) {
            boolean hasDrop = false;
            boolean hasAdd = false;
            for (ClassAssignmentInterface.ClassAssignment ca : this.iChanges) {
                if (!courseId.equals(ca.getCourseId())) continue;
                switch (ca.getSpecRegOperation()) {
                    case Add: {
                        hasAdd = true;
                        break;
                    }
                    case Drop: {
                        hasDrop = true;
                    }
                }
            }
            return hasDrop && !hasAdd;
        }

        public boolean isChange(Long courseId) {
            boolean hasDrop = false;
            boolean hasAdd = false;
            boolean hasKeep = false;
            for (ClassAssignmentInterface.ClassAssignment ca : this.iChanges) {
                if (!courseId.equals(ca.getCourseId())) continue;
                switch (ca.getSpecRegOperation()) {
                    case Add: {
                        hasAdd = true;
                        break;
                    }
                    case Drop: {
                        hasDrop = true;
                        break;
                    }
                    case Keep: {
                        hasKeep = true;
                    }
                }
            }
            return hasKeep || hasDrop && hasAdd;
        }

        public boolean hasErrors(Long courseId) {
            for (ClassAssignmentInterface.ClassAssignment ca : this.iChanges) {
                if (!courseId.equals(ca.getCourseId()) || !ca.hasError()) continue;
                return true;
            }
            return false;
        }

        public boolean isApproved(Long courseId) {
            boolean approved = false;
            for (ClassAssignmentInterface.ClassAssignment ca : this.iChanges) {
                if (ca.hasError()) continue;
                if (ca.getSpecRegStatus() == SpecialRegistrationStatus.Approved) {
                    approved = true;
                    continue;
                }
                return false;
            }
            return approved;
        }

        public boolean isHonorsGradeModeNotFullyMatching(ClassAssignmentInterface saved) {
            if (!this.hasChanges()) {
                return false;
            }
            for (ClassAssignmentInterface.ClassAssignment ch : this.iChanges) {
                if (ch.getGradeMode() == null || !ch.getGradeMode().isHonor()) continue;
                boolean found = false;
                for (ClassAssignmentInterface.ClassAssignment ca : saved.getClassAssignments()) {
                    if (!ca.isSaved() || !ch.getClassId().equals(ca.getClassId())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return true;
            }
            return false;
        }

        public boolean isFullyApplied(ClassAssignmentInterface saved) {
            if (!this.hasChanges() || this.isGradeModeChange() || this.isCreditChange() || this.isExtended()) {
                return this.getStatus() == SpecialRegistrationStatus.Approved;
            }
            if (saved == null) {
                return false;
            }
            HashSet<Long> courseIds = new HashSet<Long>();
            boolean enrolled = true;
            boolean gmChange = false;
            block4: for (ClassAssignmentInterface.ClassAssignment ch : this.iChanges) {
                if (ch.getSpecRegOperation() == SpecialRegistrationOperation.Keep) {
                    if (ch.getGradeMode() != null) {
                        if (ch.getGradeMode().isHonor()) {
                            boolean found = false;
                            for (ClassAssignmentInterface.ClassAssignment ca : saved.getClassAssignments()) {
                                if (!ca.isSaved() || !ch.getClassId().equals(ca.getClassId())) continue;
                                found = true;
                                break;
                            }
                            if (!found) {
                                enrolled = false;
                            }
                        }
                        for (ClassAssignmentInterface.ClassAssignment ca : saved.getClassAssignments()) {
                            if (!ca.isSaved() || !ch.getCourseId().equals(ca.getCourseId()) || ch.getGradeMode().equals(ca.getGradeMode())) continue;
                            gmChange = true;
                            break;
                        }
                    }
                    if (ch.getCreditHour() == null) continue;
                    for (ClassAssignmentInterface.ClassAssignment ca : saved.getClassAssignments()) {
                        if (!ca.isSaved() || !ch.getCourseId().equals(ca.getCourseId()) || ca.getCreditHour() == null || !ca.getCreditHour().equals(ch.getCreditHour())) continue;
                        return false;
                    }
                    continue;
                }
                Long courseId = ch.getCourseId();
                if (!courseIds.add(courseId)) continue;
                boolean hasDrop = false;
                boolean hasAdd = false;
                for (ClassAssignmentInterface.ClassAssignment ca : this.iChanges) {
                    if (!courseId.equals(ca.getCourseId())) continue;
                    switch (ca.getSpecRegOperation()) {
                        case Add: {
                            hasAdd = true;
                            break;
                        }
                        case Drop: {
                            hasDrop = true;
                        }
                    }
                }
                if (hasAdd && !hasDrop) {
                    for (ClassAssignmentInterface.ClassAssignment ca : saved.getClassAssignments()) {
                        if (!ca.isSaved() || !courseId.equals(ca.getCourseId())) continue;
                        continue block4;
                    }
                    return false;
                }
                if (hasDrop && !hasAdd) {
                    for (ClassAssignmentInterface.ClassAssignment ca : saved.getClassAssignments()) {
                        if (!ca.isSaved() || !courseId.equals(ca.getCourseId())) continue;
                        return false;
                    }
                    continue;
                }
                for (ClassAssignmentInterface.ClassAssignment ca : this.iChanges) {
                    if (!courseId.equals(ca.getCourseId()) || !ca.hasError()) continue;
                    boolean match = false;
                    for (ClassAssignmentInterface.ClassAssignment x : saved.getClassAssignments()) {
                        if (!x.isSaved() || !ca.getClassId().equals(x.getClassId())) continue;
                        match = true;
                        break;
                    }
                    if (match && ca.getSpecRegOperation() == SpecialRegistrationOperation.Drop) {
                        return false;
                    }
                    if (match || ca.getSpecRegOperation() != SpecialRegistrationOperation.Add) continue;
                    return false;
                }
            }
            return !gmChange || !enrolled;
        }

        public boolean isApplied(Long courseId, ClassAssignmentInterface saved) {
            if (courseId == null || saved == null) {
                return false;
            }
            boolean hasDrop = false;
            boolean hasAdd = false;
            boolean hasKeep = false;
            OnlineSectioningInterface.GradeMode gm = null;
            Float vc = null;
            for (ClassAssignmentInterface.ClassAssignment ca : this.iChanges) {
                if (!courseId.equals(ca.getCourseId())) continue;
                switch (ca.getSpecRegOperation()) {
                    case Add: {
                        hasAdd = true;
                        break;
                    }
                    case Drop: {
                        hasDrop = true;
                        break;
                    }
                    case Keep: {
                        if (ca.getGradeMode() != null) {
                            gm = ca.getGradeMode();
                        }
                        if (ca.getCreditHour() != null) {
                            vc = ca.getCreditHour();
                        }
                        if (ca.getGradeMode() != null || ca.getCreditHour() != null) break;
                        hasKeep = true;
                    }
                }
            }
            if (gm != null) {
                for (ClassAssignmentInterface.ClassAssignment ca : saved.getClassAssignments()) {
                    if (!ca.isSaved() || !courseId.equals(ca.getCourseId())) continue;
                    if (ca.getGradeMode() != null && !ca.getGradeMode().equals(gm)) {
                        return false;
                    }
                    if (vc == null || ca.getCreditHour() == null || ca.getCreditHour().equals(vc)) continue;
                    return false;
                }
                return true;
            }
            if (vc != null) {
                for (ClassAssignmentInterface.ClassAssignment ca : saved.getClassAssignments()) {
                    if (!ca.isSaved() || !courseId.equals(ca.getCourseId()) || ca.getCreditHour() == null || ca.getCreditHour().equals(vc)) continue;
                    return false;
                }
                return true;
            }
            if (hasKeep) {
                return false;
            }
            if (hasAdd && !hasDrop) {
                for (ClassAssignmentInterface.ClassAssignment ca : saved.getClassAssignments()) {
                    if (!ca.isSaved() || !courseId.equals(ca.getCourseId())) continue;
                    return true;
                }
                return false;
            }
            if (hasDrop && !hasAdd) {
                for (ClassAssignmentInterface.ClassAssignment ca : saved.getClassAssignments()) {
                    if (!ca.isSaved() || !courseId.equals(ca.getCourseId())) continue;
                    return false;
                }
                return true;
            }
            for (ClassAssignmentInterface.ClassAssignment ca : this.iChanges) {
                if (!courseId.equals(ca.getCourseId()) || !ca.hasError()) continue;
                boolean match = false;
                for (ClassAssignmentInterface.ClassAssignment x : saved.getClassAssignments()) {
                    if (!x.isSaved() || !ca.getClassId().equals(x.getClassId())) continue;
                    match = true;
                    break;
                }
                if (match && ca.getSpecRegOperation() == SpecialRegistrationOperation.Drop) {
                    return false;
                }
                if (match || ca.getSpecRegOperation() != SpecialRegistrationOperation.Add) continue;
                return false;
            }
            return true;
        }

        public boolean canCancel() {
            return this.iCanCancel;
        }

        public void setCanCancel(boolean canCancel) {
            this.iCanCancel = canCancel;
        }

        public boolean hasTimeConflict() {
            return this.iHasTimeConflict;
        }

        public void setHasTimeConflict(boolean hasTimeConflict) {
            this.iHasTimeConflict = hasTimeConflict;
        }

        public boolean hasSpaceConflict() {
            return this.iHasSpaceConflict;
        }

        public void setHasSpaceConflict(boolean hasSpaceConflict) {
            this.iHasSpaceConflict = hasSpaceConflict;
        }

        public boolean hasLinkedConflict() {
            return this.iHasLinkedConflict;
        }

        public void setHasLinkedConflict(boolean hasLinkedConflict) {
            this.iHasLinkedConflict = hasLinkedConflict;
        }

        public boolean isExtended() {
            return this.iExtended;
        }

        public void setExtended(boolean extended) {
            this.iExtended = extended;
        }

        public void addError(ClassAssignmentInterface.ErrorMessage error) {
            if (this.iErrors == null) {
                this.iErrors = new ArrayList();
            }
            this.iErrors.add(error);
        }

        public boolean hasErrors() {
            return this.iErrors != null && !this.iErrors.isEmpty();
        }

        public ArrayList<ClassAssignmentInterface.ErrorMessage> getErrors() {
            return this.iErrors;
        }

        public void setMaxCredit(Float maxCredit) {
            this.iMaxCredit = maxCredit;
        }

        public Float getMaxCredit() {
            return this.iMaxCredit;
        }

        public boolean hasMaxCredit() {
            return this.iMaxCredit != null;
        }

        @Override
        public int compareTo(RetrieveSpecialRegistrationResponse o) {
            int cmp = this.getSubmitDate().compareTo(o.getSubmitDate());
            if (cmp != 0) {
                return -cmp;
            }
            return this.getRequestId().compareTo(o.getRequestId());
        }

        public int hashCode() {
            return this.getRequestId().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof RetrieveSpecialRegistrationResponse)) {
                return false;
            }
            return this.getRequestId().equals(((RetrieveSpecialRegistrationResponse)o).getRequestId());
        }
    }

    public static enum SpecialRegistrationOperation implements IsSerializable,
    Serializable
    {
        Add,
        Drop,
        Keep;

    }

    public static enum SpecialRegistrationStatus implements IsSerializable,
    Serializable
    {
        Draft,
        Pending,
        Approved,
        Rejected,
        Cancelled;

    }

    public static class SpecialRegistrationEligibilityResponse
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String iMessage;
        private boolean iCanSubmit;
        private List<ClassAssignmentInterface.ErrorMessage> iErrors = null;
        private List<ClassAssignmentInterface.ErrorMessage> iDeniedErrors = null;
        private List<ClassAssignmentInterface.ErrorMessage> iCancelErrors = null;
        private Set<String> iCancelRequestIds = null;
        private Float iCredit = null;

        public SpecialRegistrationEligibilityResponse() {
        }

        public SpecialRegistrationEligibilityResponse(boolean canSubmit, String message) {
            this.iCanSubmit = canSubmit;
            this.iMessage = message;
        }

        public boolean isCanSubmit() {
            return this.iCanSubmit;
        }

        public void setCanSubmit(boolean canSubmit) {
            this.iCanSubmit = canSubmit;
        }

        public boolean hasMessage() {
            return this.iMessage != null && !this.iMessage.isEmpty();
        }

        public String getMessage() {
            return this.iMessage;
        }

        public void setMessage(String message) {
            this.iMessage = message;
        }

        public void addError(ClassAssignmentInterface.ErrorMessage error) {
            if (this.iErrors == null) {
                this.iErrors = new ArrayList<ClassAssignmentInterface.ErrorMessage>();
            }
            this.iErrors.add(error);
        }

        public boolean hasErrors() {
            return this.iErrors != null && !this.iErrors.isEmpty();
        }

        public List<ClassAssignmentInterface.ErrorMessage> getErrors() {
            return this.iErrors;
        }

        public void setErrors(Collection<ClassAssignmentInterface.ErrorMessage> messages) {
            this.iErrors = messages == null ? null : new ArrayList<ClassAssignmentInterface.ErrorMessage>(messages);
        }

        public void addCancelError(ClassAssignmentInterface.ErrorMessage error) {
            if (this.iCancelErrors == null) {
                this.iCancelErrors = new ArrayList<ClassAssignmentInterface.ErrorMessage>();
            }
            this.iCancelErrors.add(error);
        }

        public boolean hasCancelErrors() {
            return this.iCancelErrors != null && !this.iCancelErrors.isEmpty();
        }

        public List<ClassAssignmentInterface.ErrorMessage> getCancelErrors() {
            return this.iCancelErrors;
        }

        public void setCancelErrors(Collection<ClassAssignmentInterface.ErrorMessage> messages) {
            this.iCancelErrors = messages == null ? null : new ArrayList<ClassAssignmentInterface.ErrorMessage>(messages);
        }

        public void addCancelRequestId(String id) {
            if (this.iCancelRequestIds == null) {
                this.iCancelRequestIds = new HashSet<String>();
            }
            this.iCancelRequestIds.add(id);
        }

        public boolean hasCancelRequestIds() {
            return this.iCancelRequestIds != null && !this.iCancelRequestIds.isEmpty();
        }

        public Set<String> getCancelRequestIds() {
            return this.iCancelRequestIds;
        }

        public boolean isToBeCancelled(String requestId) {
            return this.iCancelRequestIds != null && this.iCancelRequestIds.contains(requestId);
        }

        public void addDeniedError(ClassAssignmentInterface.ErrorMessage error) {
            if (this.iDeniedErrors == null) {
                this.iDeniedErrors = new ArrayList<ClassAssignmentInterface.ErrorMessage>();
            }
            this.iDeniedErrors.add(error);
        }

        public boolean hasDeniedErrors() {
            return this.iDeniedErrors != null && !this.iDeniedErrors.isEmpty();
        }

        public List<ClassAssignmentInterface.ErrorMessage> getDeniedErrors() {
            return this.iDeniedErrors;
        }

        public void setDeniedErrors(Collection<ClassAssignmentInterface.ErrorMessage> messages) {
            this.iDeniedErrors = messages == null ? null : new ArrayList<ClassAssignmentInterface.ErrorMessage>(messages);
        }

        public void setCredit(Float credit) {
            this.iCredit = credit;
        }

        public boolean hasCredit() {
            return this.iCredit != null;
        }

        public Float getCredit() {
            return this.iCredit;
        }
    }

    public static class SpecialRegistrationEligibilityRequest
    extends OnlineSectioningInterface.StudentSectioningContext
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String iRequestId;
        private Collection<ClassAssignmentInterface.ClassAssignment> iClassAssignments;
        private ArrayList<ClassAssignmentInterface.ErrorMessage> iErrors = null;

        public SpecialRegistrationEligibilityRequest() {
        }

        public SpecialRegistrationEligibilityRequest(OnlineSectioningInterface.StudentSectioningContext cx, String requestId, Collection<ClassAssignmentInterface.ClassAssignment> assignments, Collection<ClassAssignmentInterface.ErrorMessage> errors) {
            super(cx);
            this.iClassAssignments = assignments;
            this.iRequestId = requestId;
            if (errors != null) {
                this.iErrors = new ArrayList<ClassAssignmentInterface.ErrorMessage>(errors);
            }
        }

        public String getRequestId() {
            return this.iRequestId;
        }

        public boolean hasRequestId() {
            return this.iRequestId != null && !this.iRequestId.isEmpty();
        }

        public void setRequestId(String requestId) {
            this.iRequestId = requestId;
        }

        public Collection<ClassAssignmentInterface.ClassAssignment> getClassAssignments() {
            return this.iClassAssignments;
        }

        public void setClassAssignments(Collection<ClassAssignmentInterface.ClassAssignment> assignments) {
            this.iClassAssignments = assignments;
        }

        public void addError(ClassAssignmentInterface.ErrorMessage error) {
            if (this.iErrors == null) {
                this.iErrors = new ArrayList();
            }
            this.iErrors.add(error);
        }

        public boolean hasErrors() {
            return this.iErrors != null && !this.iErrors.isEmpty();
        }

        public ArrayList<ClassAssignmentInterface.ErrorMessage> getErrors() {
            return this.iErrors;
        }
    }

    public static class SpecialRegistrationContext
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private boolean iSpecReg = false;
        private String iSpecRegRequestId = null;
        private boolean iSpecRegDisclaimerAccepted = false;
        private boolean iSpecRegTimeConfs = false;
        private boolean iSpecRegSpaceConfs = false;
        private boolean iSpecRegLinkedConfs = false;
        private boolean iSpecRegDeadlineConfs = false;
        private boolean iSpecRegChangeRequestNote = false;
        private SpecialRegistrationStatus iSpecRegStatus = null;
        private String iNote;
        private String iDisclaimer;
        private boolean iCanRequire = true;
        private ChangeRequestorNoteInterface iChangeRequestorNote = null;

        public SpecialRegistrationContext() {
        }

        public SpecialRegistrationContext(SpecialRegistrationContext cx) {
            this.copy(cx);
        }

        public void copy(SpecialRegistrationContext cx) {
            this.iSpecReg = cx.iSpecReg;
            this.iSpecRegRequestId = cx.iSpecRegRequestId;
            this.iSpecRegDisclaimerAccepted = cx.iSpecRegDisclaimerAccepted;
            this.iSpecRegTimeConfs = cx.iSpecRegTimeConfs;
            this.iSpecRegSpaceConfs = cx.iSpecRegSpaceConfs;
            this.iSpecRegLinkedConfs = cx.iSpecRegLinkedConfs;
            this.iSpecRegDeadlineConfs = cx.iSpecRegDeadlineConfs;
            this.iSpecRegStatus = cx.iSpecRegStatus;
            this.iNote = cx.iNote;
            this.iCanRequire = cx.iCanRequire;
            this.iSpecRegChangeRequestNote = cx.iSpecRegChangeRequestNote;
        }

        public boolean isEnabled() {
            return this.iSpecReg;
        }

        public void setEnabled(boolean specReg) {
            this.iSpecReg = specReg;
        }

        public boolean hasRequestId() {
            return this.iSpecRegRequestId != null;
        }

        public String getRequestId() {
            return this.iSpecRegRequestId;
        }

        public void setRequestId(String id) {
            this.iSpecRegRequestId = id;
        }

        public boolean isCanSubmit() {
            return true;
        }

        public boolean isDisclaimerAccepted() {
            return this.iSpecRegDisclaimerAccepted;
        }

        public void setDisclaimerAccepted(boolean accepted) {
            this.iSpecRegDisclaimerAccepted = accepted;
        }

        public boolean areTimeConflictsAllowed() {
            return this.iSpecRegTimeConfs;
        }

        public void setTimeConflictsAllowed(boolean allow) {
            this.iSpecRegTimeConfs = allow;
        }

        public boolean areSpaceConflictsAllowed() {
            return this.iSpecRegSpaceConfs;
        }

        public void setSpaceConflictsAllowed(boolean allow) {
            this.iSpecRegSpaceConfs = allow;
        }

        public boolean areLinkedConflictsAllowed() {
            return this.iSpecRegLinkedConfs;
        }

        public void setLinkedConflictsAllowed(boolean allow) {
            this.iSpecRegLinkedConfs = allow;
        }

        public boolean areDeadlineConflictsAllowed() {
            return this.iSpecRegDeadlineConfs;
        }

        public void setDeadlineConflictsAllowed(boolean allow) {
            this.iSpecRegDeadlineConfs = allow;
        }

        public SpecialRegistrationStatus getStatus() {
            return this.iSpecRegStatus;
        }

        public void setStatus(SpecialRegistrationStatus status) {
            this.iSpecRegStatus = status;
        }

        public String getNote() {
            return this.iNote;
        }

        public void setNote(String note) {
            this.iNote = note;
        }

        public String getDisclaimer() {
            return this.iDisclaimer;
        }

        public void setDisclaimer(String disclaimer) {
            this.iDisclaimer = disclaimer;
        }

        public boolean hasDisclaimer() {
            return this.iDisclaimer != null && !this.iDisclaimer.isEmpty();
        }

        public boolean isCanRequire() {
            return this.iCanRequire;
        }

        public void setCanRequire(boolean canRequire) {
            this.iCanRequire = canRequire;
        }

        public boolean isAllowChangeRequestNote() {
            return this.iSpecRegChangeRequestNote;
        }

        public void setAllowChangeRequestNote(boolean changeRequestNote) {
            this.iSpecRegChangeRequestNote = changeRequestNote;
        }

        public void update(OnlineSectioningInterface.EligibilityCheck check) {
            this.iSpecRegTimeConfs = check != null && check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.SR_TIME_CONF);
            this.iSpecRegSpaceConfs = check != null && check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.SR_LIMIT_CONF);
            this.iSpecRegLinkedConfs = check != null && check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.SR_LINK_CONF);
            this.iSpecRegDeadlineConfs = check != null && check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.SR_EXTENDED);
            this.iSpecReg = check != null && check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_SPECREG);
            this.iDisclaimer = check != null ? check.getOverrideRequestDisclaimer() : null;
            this.iCanRequire = check == null || check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REQUIRE);
            this.iSpecRegChangeRequestNote = check != null && check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.SR_CHANGE_NOTE);
        }

        public void reset() {
            this.iNote = null;
            this.iSpecReg = false;
            this.iSpecRegRequestId = null;
            this.iSpecRegDisclaimerAccepted = false;
            this.iSpecRegTimeConfs = false;
            this.iSpecRegSpaceConfs = false;
            this.iSpecRegLinkedConfs = false;
            this.iSpecRegDeadlineConfs = false;
            this.iSpecRegStatus = null;
            this.iDisclaimer = null;
            this.iCanRequire = true;
            this.iSpecRegChangeRequestNote = false;
        }

        public void reset(OnlineSectioningInterface.EligibilityCheck check) {
            this.reset();
            if (check != null) {
                this.update(check);
            }
        }

        public void setChangeRequestorNote(ChangeRequestorNoteInterface changeRequestorNote) {
            this.iChangeRequestorNote = changeRequestorNote;
        }

        public ChangeRequestorNoteInterface getChangeRequestorNoteInterface() {
            return this.iChangeRequestorNote;
        }
    }
}

